-- MySQL dump 10.13  Distrib 8.0.30, for Win64 (x86_64)
--
-- Host: localhost    Database: notregrandbleu
-- ------------------------------------------------------
-- Server version	8.0.30

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `batch`
--

DROP TABLE IF EXISTS `batch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `batch` (
  `bid` int unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',
  `token` varchar(64) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'A string token generated against the current user''s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',
  `timestamp` int NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',
  `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',
  PRIMARY KEY (`bid`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Stores details about batches (processes that run in…';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `batch`
--

LOCK TABLES `batch` WRITE;
/*!40000 ALTER TABLE `batch` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `batch` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content`
--

DROP TABLE IF EXISTS `block_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `revision_id` int unsigned DEFAULT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `uuid` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `block_content_field__uuid__value` (`uuid`),
  UNIQUE KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='The base table for block_content entities.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content`
--

LOCK TABLES `block_content` WRITE;
/*!40000 ALTER TABLE `block_content` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content` VALUES (1,1,'reseau_sociaux','bdccbeeb-1706-4265-887c-5d75a02a04d8','fr'),(2,2,'banner','72662bc6-e2d2-46b0-a5b5-bd73ff536165','fr'),(3,3,'block_content','6ee433a9-fdd6-4d88-b9be-b911c51c2791','fr');
/*!40000 ALTER TABLE `block_content` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content__body`
--

DROP TABLE IF EXISTS `block_content__body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content__body` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Data storage for block_content field body.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content__body`
--

LOCK TABLES `block_content__body` WRITE;
/*!40000 ALTER TABLE `block_content__body` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content__body` VALUES ('banner',0,2,2,'fr',0,'<h2>Soyons l’œil de Sauvegarde de <em>Notre Grand Bleu</em></h2>','','basic_html');
/*!40000 ALTER TABLE `block_content__body` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content__field_content`
--

DROP TABLE IF EXISTS `block_content__field_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content__field_content` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_content_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_content_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_content_target_id` (`field_content_target_id`),
  KEY `field_content_target_revision_id` (`field_content_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Data storage for block_content field field_content.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content__field_content`
--

LOCK TABLES `block_content__field_content` WRITE;
/*!40000 ALTER TABLE `block_content__field_content` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content__field_content` VALUES ('block_content',0,3,3,'fr',0,17,21),('block_content',0,3,3,'fr',1,15,19);
/*!40000 ALTER TABLE `block_content__field_content` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content__field_image`
--

DROP TABLE IF EXISTS `block_content__field_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content__field_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the file entity.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image''s ''alt'' attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image''s ''title'' attribute.',
  `field_image_width` int unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_image_target_id` (`field_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Data storage for block_content field field_image.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content__field_image`
--

LOCK TABLES `block_content__field_image` WRITE;
/*!40000 ALTER TABLE `block_content__field_image` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content__field_image` VALUES ('banner',0,2,2,'fr',0,1,'','',570,615);
/*!40000 ALTER TABLE `block_content__field_image` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content__field_link`
--

DROP TABLE IF EXISTS `block_content__field_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content__field_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_link_uri` (`field_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Data storage for block_content field field_link.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content__field_link`
--

LOCK TABLES `block_content__field_link` WRITE;
/*!40000 ALTER TABLE `block_content__field_link` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content__field_link` VALUES ('banner',0,2,2,'fr',0,'internal:/','Contact',_binary 'a:0:{}');
/*!40000 ALTER TABLE `block_content__field_link` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content__field_reseau_sociaux`
--

DROP TABLE IF EXISTS `block_content__field_reseau_sociaux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content__field_reseau_sociaux` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_reseau_sociaux_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_reseau_sociaux_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_reseau_sociaux_target_id` (`field_reseau_sociaux_target_id`),
  KEY `field_reseau_sociaux_target_revision_id` (`field_reseau_sociaux_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Data storage for block_content field field_reseau_sociaux.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content__field_reseau_sociaux`
--

LOCK TABLES `block_content__field_reseau_sociaux` WRITE;
/*!40000 ALTER TABLE `block_content__field_reseau_sociaux` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content__field_reseau_sociaux` VALUES ('reseau_sociaux',0,1,1,'fr',0,1,1),('reseau_sociaux',0,1,1,'fr',1,2,2);
/*!40000 ALTER TABLE `block_content__field_reseau_sociaux` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content_field_data`
--

DROP TABLE IF EXISTS `block_content_field_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content_field_data` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `type` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The ID of the target entity.',
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `status` tinyint NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `reusable` tinyint DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),
  KEY `block_content__revision_id` (`revision_id`),
  KEY `block_content_field__type__target_id` (`type`),
  KEY `block_content__status_type` (`status`,`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='The data table for block_content entities.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_field_data`
--

LOCK TABLES `block_content_field_data` WRITE;
/*!40000 ALTER TABLE `block_content_field_data` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content_field_data` VALUES (1,1,'reseau_sociaux','fr',1,'Reseau Sociaux',1678952909,1,1,1),(2,2,'banner','fr',1,'Banner Accueil',1679162752,1,1,1),(3,3,'block_content','fr',1,'Block Content accueil',1679857407,1,1,1);
/*!40000 ALTER TABLE `block_content_field_data` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content_field_revision`
--

DROP TABLE IF EXISTS `block_content_field_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content_field_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `status` tinyint NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `changed` int DEFAULT NULL,
  `default_langcode` tinyint NOT NULL,
  `revision_translation_affected` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`,`langcode`),
  KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='The revision data table for block_content entities.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_field_revision`
--

LOCK TABLES `block_content_field_revision` WRITE;
/*!40000 ALTER TABLE `block_content_field_revision` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content_field_revision` VALUES (1,1,'fr',1,'Reseau Sociaux',1678952909,1,1),(2,2,'fr',1,'Banner Accueil',1679162752,1,1),(3,3,'fr',1,'Block Content accueil',1679857407,1,1);
/*!40000 ALTER TABLE `block_content_field_revision` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content_revision`
--

DROP TABLE IF EXISTS `block_content_revision`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content_revision` (
  `id` int unsigned NOT NULL,
  `revision_id` int unsigned NOT NULL AUTO_INCREMENT,
  `langcode` varchar(12) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL,
  `revision_user` int unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',
  `revision_created` int DEFAULT NULL,
  `revision_log` longtext,
  `revision_default` tinyint DEFAULT NULL,
  PRIMARY KEY (`revision_id`),
  KEY `block_content__id` (`id`),
  KEY `block_content_field__revision_user__target_id` (`revision_user`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='The revision table for block_content entities.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_revision`
--

LOCK TABLES `block_content_revision` WRITE;
/*!40000 ALTER TABLE `block_content_revision` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content_revision` VALUES (1,1,'fr',NULL,1678952900,NULL,1),(2,2,'fr',NULL,1678957618,NULL,1),(3,3,'fr',NULL,1679763101,NULL,1);
/*!40000 ALTER TABLE `block_content_revision` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content_revision__body`
--

DROP TABLE IF EXISTS `block_content_revision__body`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content_revision__body` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `body_value` longtext NOT NULL,
  `body_summary` longtext,
  `body_format` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci DEFAULT NULL,
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `body_format` (`body_format`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Revision archive storage for block_content field body.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_revision__body`
--

LOCK TABLES `block_content_revision__body` WRITE;
/*!40000 ALTER TABLE `block_content_revision__body` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content_revision__body` VALUES ('banner',0,2,2,'fr',0,'<h2>Soyons l’œil de Sauvegarde de <em>Notre Grand Bleu</em></h2>','','basic_html');
/*!40000 ALTER TABLE `block_content_revision__body` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content_revision__field_content`
--

DROP TABLE IF EXISTS `block_content_revision__field_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content_revision__field_content` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_content_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_content_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_content_target_id` (`field_content_target_id`),
  KEY `field_content_target_revision_id` (`field_content_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Revision archive storage for block_content field field…';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_revision__field_content`
--

LOCK TABLES `block_content_revision__field_content` WRITE;
/*!40000 ALTER TABLE `block_content_revision__field_content` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content_revision__field_content` VALUES ('block_content',0,3,3,'fr',0,17,21),('block_content',0,3,3,'fr',1,15,19);
/*!40000 ALTER TABLE `block_content_revision__field_content` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content_revision__field_image`
--

DROP TABLE IF EXISTS `block_content_revision__field_image`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content_revision__field_image` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_image_target_id` int unsigned NOT NULL COMMENT 'The ID of the file entity.',
  `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image''s ''alt'' attribute.',
  `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image''s ''title'' attribute.',
  `field_image_width` int unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',
  `field_image_height` int unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_image_target_id` (`field_image_target_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Revision archive storage for block_content field field…';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_revision__field_image`
--

LOCK TABLES `block_content_revision__field_image` WRITE;
/*!40000 ALTER TABLE `block_content_revision__field_image` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content_revision__field_image` VALUES ('banner',0,2,2,'fr',0,1,'','',570,615);
/*!40000 ALTER TABLE `block_content_revision__field_image` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content_revision__field_link`
--

DROP TABLE IF EXISTS `block_content_revision__field_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content_revision__field_link` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_link_uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',
  `field_link_title` varchar(255) DEFAULT NULL COMMENT 'The link text.',
  `field_link_options` longblob COMMENT 'Serialized array of options for the link.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_link_uri` (`field_link_uri`(30))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Revision archive storage for block_content field field_link.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_revision__field_link`
--

LOCK TABLES `block_content_revision__field_link` WRITE;
/*!40000 ALTER TABLE `block_content_revision__field_link` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content_revision__field_link` VALUES ('banner',0,2,2,'fr',0,'internal:/','Contact',_binary 'a:0:{}');
/*!40000 ALTER TABLE `block_content_revision__field_link` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `block_content_revision__field_reseau_sociaux`
--

DROP TABLE IF EXISTS `block_content_revision__field_reseau_sociaux`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `block_content_revision__field_reseau_sociaux` (
  `bundle` varchar(128) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',
  `deleted` tinyint NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',
  `entity_id` int unsigned NOT NULL COMMENT 'The entity id this data is attached to',
  `revision_id` int unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',
  `langcode` varchar(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',
  `delta` int unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',
  `field_reseau_sociaux_target_id` int unsigned NOT NULL COMMENT 'The ID of the target entity.',
  `field_reseau_sociaux_target_revision_id` int unsigned NOT NULL COMMENT 'The revision ID of the target entity.',
  PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),
  KEY `bundle` (`bundle`),
  KEY `revision_id` (`revision_id`),
  KEY `field_reseau_sociaux_target_id` (`field_reseau_sociaux_target_id`),
  KEY `field_reseau_sociaux_target_revision_id` (`field_reseau_sociaux_target_revision_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Revision archive storage for block_content field field…';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `block_content_revision__field_reseau_sociaux`
--

LOCK TABLES `block_content_revision__field_reseau_sociaux` WRITE;
/*!40000 ALTER TABLE `block_content_revision__field_reseau_sociaux` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `block_content_revision__field_reseau_sociaux` VALUES ('reseau_sociaux',0,1,1,'fr',0,1,1),('reseau_sociaux',0,1,1,'fr',1,2,2);
/*!40000 ALTER TABLE `block_content_revision__field_reseau_sociaux` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_bootstrap`
--

DROP TABLE IF EXISTS `cache_bootstrap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_bootstrap` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Storage for the cache API.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_bootstrap`
--

LOCK TABLES `cache_bootstrap` WRITE;
/*!40000 ALTER TABLE `cache_bootstrap` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `cache_bootstrap` VALUES ('block_content_uuid',_binary 'a:3:{s:36:\"bdccbeeb-1706-4265-887c-5d75a02a04d8\";s:1:\"1\";s:36:\"72662bc6-e2d2-46b0-a5b5-bd73ff536165\";s:1:\"2\";s:36:\"6ee433a9-fdd6-4d88-b9be-b911c51c2791\";s:1:\"3\";}',-1,1680009081.719,1,'','0'),('hook_info',_binary 'a:42:{s:10:\"token_info\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:16:\"token_info_alter\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:6:\"tokens\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:12:\"tokens_alter\";a:1:{s:5:\"group\";s:6:\"tokens\";}s:22:\"pathauto_pattern_alter\";a:1:{s:5:\"group\";s:8:\"pathauto\";}s:20:\"pathauto_alias_alter\";a:1:{s:5:\"group\";s:8:\"pathauto\";}s:26:\"pathauto_is_alias_reserved\";a:1:{s:5:\"group\";s:8:\"pathauto\";}s:10:\"views_data\";a:1:{s:5:\"group\";s:5:\"views\";}s:16:\"views_data_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:13:\"views_analyze\";a:1:{s:5:\"group\";s:5:\"views\";}s:22:\"views_invalidate_cache\";a:1:{s:5:\"group\";s:5:\"views\";}s:26:\"views_plugins_access_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:24:\"views_plugins_area_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:28:\"views_plugins_argument_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:36:\"views_plugins_argument_default_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:38:\"views_plugins_argument_validator_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_cache_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:36:\"views_plugins_display_extender_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:27:\"views_plugins_display_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:32:\"views_plugins_exposed_form_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_field_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:26:\"views_plugins_filter_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:24:\"views_plugins_join_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_pager_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_query_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:32:\"views_plugins_relationship_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:23:\"views_plugins_row_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:24:\"views_plugins_sort_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_plugins_style_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:26:\"views_plugins_wizard_alter\";a:1:{s:5:\"group\";s:5:\"views\";}s:25:\"views_query_substitutions\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:24:\"views_form_substitutions\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:14:\"views_pre_view\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:15:\"views_pre_build\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:16:\"views_post_build\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:17:\"views_pre_execute\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:18:\"views_post_execute\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:16:\"views_pre_render\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:17:\"views_post_render\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:17:\"views_query_alter\";a:1:{s:5:\"group\";s:15:\"views_execution\";}s:16:\"field_views_data\";a:1:{s:5:\"group\";s:5:\"views\";}s:22:\"field_views_data_alter\";a:1:{s:5:\"group\";s:5:\"views\";}}',-1,1680008714.507,1,'','0'),('module_implements',_binary 'a:326:{s:23:\"module_implements_alter\";a:5:{s:9:\"ckeditor5\";b:0;s:7:\"metatag\";b:0;s:5:\"token\";b:0;s:7:\"webform\";b:0;s:10:\"paragraphs\";b:0;}s:7:\"rebuild\";a:2:{s:5:\"block\";b:0;s:7:\"webform\";b:0;}s:17:\"system_info_alter\";a:1:{s:6:\"system\";b:0;}s:17:\"entity_type_build\";a:5:{s:8:\"field_ui\";b:0;s:7:\"menu_ui\";b:0;s:16:\"quick_node_clone\";b:0;s:6:\"system\";b:0;s:8:\"views_ui\";b:0;}s:17:\"entity_type_alter\";a:9:{s:13:\"block_content\";b:0;s:7:\"contact\";b:0;s:17:\"menu_link_content\";b:0;s:4:\"path\";b:0;s:5:\"token\";b:0;s:12:\"webform_node\";b:0;s:13:\"webform_share\";b:0;s:10:\"webform_ui\";b:0;s:10:\"paragraphs\";b:0;}s:11:\"entity_load\";a:0:{}s:10:\"block_load\";a:0:{}s:16:\"search_page_load\";a:0:{}s:19:\"search_plugin_alter\";a:0:{}s:27:\"views_plugins_display_alter\";a:1:{s:8:\"views_ui\";b:0;}s:9:\"view_load\";a:0:{}s:26:\"views_plugins_access_alter\";a:0:{}s:16:\"field_info_alter\";a:3:{s:8:\"language\";b:0;s:5:\"token\";b:0;s:8:\"pathauto\";b:0;}s:18:\"entity_bundle_info\";a:0:{}s:23:\"block_content_type_load\";a:0:{}s:17:\"comment_type_load\";a:0:{}s:17:\"contact_form_load\";a:0:{}s:14:\"node_type_load\";a:0:{}s:17:\"shortcut_set_load\";a:0:{}s:24:\"taxonomy_vocabulary_load\";a:0:{}s:12:\"webform_load\";a:0:{}s:20:\"paragraphs_type_load\";a:0:{}s:24:\"entity_bundle_info_alter\";a:0:{}s:20:\"data_type_info_alter\";a:0:{}s:22:\"entity_base_field_info\";a:4:{s:7:\"metatag\";b:0;s:4:\"path\";b:0;s:5:\"token\";b:0;s:8:\"pathauto\";b:0;}s:28:\"entity_base_field_info_alter\";a:3:{s:8:\"language\";b:0;s:4:\"path\";b:0;s:10:\"paragraphs\";b:0;}s:25:\"entity_field_storage_info\";a:1:{s:5:\"field\";b:0;}s:31:\"entity_field_storage_info_alter\";a:0:{}s:14:\"user_role_load\";a:0:{}s:9:\"menu_load\";a:0:{}s:11:\"query_alter\";a:0:{}s:24:\"query_entity_query_alter\";a:0:{}s:42:\"query_entity_query_menu_link_content_alter\";a:0:{}s:14:\"entity_preload\";a:0:{}s:43:\"query_menu_link_content_load_multiple_alter\";a:0:{}s:24:\"entity_bundle_field_info\";a:1:{s:5:\"field\";b:0;}s:30:\"entity_bundle_field_info_alter\";a:0:{}s:19:\"entity_storage_load\";a:1:{s:7:\"comment\";b:0;}s:30:\"menu_link_content_storage_load\";a:0:{}s:22:\"menu_link_content_load\";a:0:{}s:27:\"menu_links_discovered_alter\";a:3:{s:5:\"dblog\";b:0;s:6:\"editor\";b:0;s:7:\"webform\";b:0;}s:21:\"entity_form_mode_load\";a:0:{}s:27:\"entity_form_mode_info_alter\";a:0:{}s:21:\"entity_view_mode_load\";a:0:{}s:27:\"entity_view_mode_info_alter\";a:0:{}s:17:\"local_tasks_alter\";a:5:{s:8:\"field_ui\";b:0;s:7:\"webform\";b:0;s:13:\"webform_share\";b:0;s:32:\"webform_submission_export_import\";b:0;s:5:\"views\";b:0;}s:30:\"query_user_load_multiple_alter\";a:0:{}s:17:\"user_storage_load\";a:0:{}s:9:\"user_load\";a:0:{}s:16:\"date_format_load\";a:0:{}s:18:\"element_info_alter\";a:6:{s:6:\"editor\";b:0;s:8:\"language\";b:0;s:6:\"system\";b:0;s:4:\"user\";b:0;s:7:\"webform\";b:0;s:13:\"webform_share\";b:0;}s:10:\"form_alter\";a:5:{s:9:\"gin_login\";b:0;s:8:\"language\";b:0;s:14:\"simple_sitemap\";b:0;s:6:\"system\";b:0;s:7:\"webform\";b:0;}s:38:\"form_system_performance_settings_alter\";a:0:{}s:23:\"gin_content_form_routes\";a:0:{}s:29:\"gin_content_form_routes_alter\";a:0:{}s:20:\"theme_registry_alter\";a:2:{s:6:\"system\";b:0;s:7:\"webform\";b:0;}s:36:\"theme_suggestions_system_config_form\";a:0:{}s:23:\"theme_suggestions_alter\";a:0:{}s:42:\"theme_suggestions_system_config_form_alter\";a:0:{}s:43:\"template_preprocess_default_variables_alter\";a:1:{s:4:\"user\";b:0;}s:23:\"theme_suggestions_input\";a:0:{}s:29:\"theme_suggestions_input_alter\";a:0:{}s:25:\"theme_suggestions_details\";a:0:{}s:31:\"theme_suggestions_details_alter\";a:0:{}s:14:\"file_url_alter\";a:0:{}s:24:\"theme_suggestions_select\";a:0:{}s:30:\"theme_suggestions_select_alter\";a:0:{}s:30:\"theme_suggestions_form_element\";a:1:{s:7:\"webform\";b:0;}s:36:\"theme_suggestions_form_element_alter\";a:0:{}s:36:\"theme_suggestions_form_element_label\";a:0:{}s:42:\"theme_suggestions_form_element_label_alter\";a:0:{}s:27:\"theme_suggestions_container\";a:0:{}s:33:\"theme_suggestions_container_alter\";a:1:{s:5:\"views\";b:0;}s:22:\"theme_suggestions_form\";a:0:{}s:28:\"theme_suggestions_form_alter\";a:0:{}s:13:\"entity_access\";a:0:{}s:12:\"block_access\";a:1:{s:13:\"webform_share\";b:0;}s:38:\"query_entity_query_block_content_alter\";a:0:{}s:18:\"block_content_load\";a:0:{}s:19:\"language_types_info\";a:0:{}s:25:\"language_types_info_alter\";a:1:{s:8:\"language\";b:0;}s:11:\"block_alter\";a:0:{}s:17:\"block_build_alter\";a:0:{}s:34:\"block_build_page_title_block_alter\";a:0:{}s:16:\"block_view_alter\";a:1:{s:5:\"token\";b:0;}s:33:\"block_view_page_title_block_alter\";a:0:{}s:35:\"block_build_local_tasks_block_alter\";a:0:{}s:41:\"block_build_system_breadcrumb_block_alter\";a:0:{}s:39:\"block_build_system_messages_block_alter\";a:0:{}s:28:\"block_build_help_block_alter\";a:0:{}s:37:\"block_build_local_actions_block_alter\";a:0:{}s:35:\"block_build_system_main_block_alter\";a:0:{}s:34:\"block_view_system_main_block_alter\";a:1:{s:6:\"system\";b:0;}s:16:\"page_attachments\";a:6:{s:8:\"addtoany\";b:0;s:8:\"big_pipe\";b:0;s:10:\"contextual\";b:0;s:7:\"metatag\";b:0;s:6:\"system\";b:0;s:7:\"webform\";b:0;}s:22:\"page_attachments_alter\";a:3:{s:9:\"gin_login\";b:0;s:14:\"simple_sitemap\";b:0;s:7:\"metatag\";b:0;}s:8:\"page_top\";a:6:{s:5:\"block\";b:0;s:4:\"node\";b:0;s:6:\"system\";b:0;s:7:\"toolbar\";b:0;s:6:\"update\";b:0;s:13:\"webform_share\";b:0;}s:10:\"link_alter\";a:0:{}s:11:\"page_bottom\";a:1:{s:4:\"tour\";b:0;}s:22:\"theme_suggestions_html\";a:2:{s:6:\"system\";b:0;s:13:\"webform_share\";b:0;}s:28:\"theme_suggestions_html_alter\";a:0:{}s:17:\"breakpoints_alter\";a:0:{}s:7:\"toolbar\";a:6:{s:19:\"admin_toolbar_tools\";b:0;s:10:\"contextual\";b:0;s:8:\"shortcut\";b:0;s:7:\"toolbar\";b:0;s:4:\"tour\";b:0;s:4:\"user\";b:0;}s:20:\"shortcut_default_set\";a:0:{}s:22:\"theme_suggestions_menu\";a:0:{}s:28:\"theme_suggestions_menu_alter\";a:0:{}s:22:\"user_format_name_alter\";a:0:{}s:13:\"toolbar_alter\";a:3:{s:13:\"admin_toolbar\";b:0;s:20:\"admin_toolbar_search\";b:0;s:7:\"webform\";b:0;}s:25:\"theme_suggestions_toolbar\";a:0:{}s:31:\"theme_suggestions_toolbar_alter\";a:0:{}s:22:\"theme_suggestions_page\";a:2:{s:6:\"system\";b:0;s:13:\"webform_share\";b:0;}s:28:\"theme_suggestions_page_alter\";a:0:{}s:40:\"block_view_system_breadcrumb_block_alter\";a:0:{}s:23:\"system_breadcrumb_alter\";a:1:{s:7:\"menu_ui\";b:0;}s:23:\"theme_suggestions_block\";a:1:{s:5:\"block\";b:0;}s:29:\"theme_suggestions_block_alter\";a:0:{}s:28:\"theme_suggestions_breadcrumb\";a:0:{}s:34:\"theme_suggestions_breadcrumb_alter\";a:0:{}s:24:\"theme_suggestions_region\";a:1:{s:6:\"system\";b:0;}s:30:\"theme_suggestions_region_alter\";a:0:{}s:28:\"theme_suggestions_page_title\";a:0:{}s:34:\"theme_suggestions_page_title_alter\";a:0:{}s:33:\"query_entity_query_shortcut_alter\";a:0:{}s:34:\"query_shortcut_load_multiple_alter\";a:0:{}s:21:\"shortcut_storage_load\";a:0:{}s:13:\"shortcut_load\";a:0:{}s:36:\"block_view_local_actions_block_alter\";a:0:{}s:34:\"block_view_local_tasks_block_alter\";a:0:{}s:22:\"menu_local_tasks_alter\";a:5:{s:7:\"contact\";b:0;s:7:\"webform\";b:0;s:14:\"webform_access\";b:0;s:20:\"webform_image_select\";b:0;s:13:\"webform_share\";b:0;}s:38:\"block_view_system_messages_block_alter\";a:0:{}s:27:\"block_view_help_block_alter\";a:1:{s:4:\"help\";b:0;}s:4:\"help\";a:57:{s:8:\"addtoany\";b:0;s:13:\"admin_toolbar\";b:0;s:33:\"admin_toolbar_links_access_filter\";b:0;s:20:\"admin_toolbar_search\";b:0;s:19:\"admin_toolbar_tools\";b:0;s:14:\"automated_cron\";b:0;s:8:\"big_pipe\";b:0;s:5:\"block\";b:0;s:13:\"block_content\";b:0;s:10:\"breakpoint\";b:0;s:9:\"ckeditor5\";b:0;s:7:\"comment\";b:0;s:6:\"config\";b:0;s:7:\"contact\";b:0;s:10:\"contextual\";b:0;s:8:\"datetime\";b:0;s:5:\"dblog\";b:0;s:18:\"dynamic_page_cache\";b:0;s:6:\"editor\";b:0;s:26:\"entity_reference_revisions\";b:0;s:5:\"field\";b:0;s:8:\"field_ui\";b:0;s:4:\"file\";b:0;s:6:\"filter\";b:0;s:4:\"help\";b:0;s:7:\"history\";b:0;s:5:\"image\";b:0;s:8:\"language\";b:0;s:4:\"link\";b:0;s:6:\"locale\";b:0;s:17:\"menu_link_content\";b:0;s:7:\"menu_ui\";b:0;s:7:\"metatag\";b:0;s:5:\"mysql\";b:0;s:4:\"node\";b:0;s:7:\"options\";b:0;s:10:\"page_cache\";b:0;s:18:\"paragraphs_browser\";b:0;s:4:\"path\";b:0;s:16:\"quick_node_clone\";b:0;s:16:\"responsive_image\";b:0;s:6:\"search\";b:0;s:8:\"shortcut\";b:0;s:14:\"simple_sitemap\";b:0;s:6:\"system\";b:0;s:8:\"taxonomy\";b:0;s:4:\"text\";b:0;s:5:\"token\";b:0;s:7:\"toolbar\";b:0;s:4:\"tour\";b:0;s:6:\"update\";b:0;s:4:\"user\";b:0;s:8:\"views_ui\";b:0;s:7:\"webform\";b:0;s:8:\"pathauto\";b:0;s:5:\"views\";b:0;s:10:\"paragraphs\";b:0;}s:41:\"theme_suggestions_off_canvas_page_wrapper\";a:0:{}s:47:\"theme_suggestions_off_canvas_page_wrapper_alter\";a:0:{}s:18:\"library_info_build\";a:1:{s:7:\"webform\";b:0;}s:18:\"library_info_alter\";a:5:{s:9:\"ckeditor5\";b:0;s:6:\"locale\";b:0;s:16:\"responsive_image\";b:0;s:6:\"system\";b:0;s:7:\"webform\";b:0;}s:22:\"webform_libraries_info\";a:1:{s:20:\"webform_image_select\";b:0;}s:9:\"css_alter\";a:1:{s:7:\"webform\";b:0;}s:8:\"js_alter\";a:3:{s:9:\"ckeditor5\";b:0;s:6:\"locale\";b:0;s:7:\"webform\";b:0;}s:17:\"js_settings_build\";a:1:{s:6:\"system\";b:0;}s:17:\"js_settings_alter\";a:2:{s:6:\"system\";b:0;s:4:\"user\";b:0;}s:20:\"entity_create_access\";a:0:{}s:23:\"node_type_create_access\";a:0:{}s:23:\"theme_suggestions_links\";a:0:{}s:29:\"theme_suggestions_links_alter\";a:0:{}s:17:\"ajax_render_alter\";a:0:{}s:16:\"image_style_load\";a:0:{}s:33:\"theme_suggestions_status_messages\";a:0:{}s:39:\"theme_suggestions_status_messages_alter\";a:0:{}s:20:\"block_content_access\";a:0:{}s:14:\"webform_access\";a:1:{s:14:\"webform_access\";b:0;}s:20:\"webform_access_rules\";a:1:{s:7:\"webform\";b:0;}s:26:\"webform_access_rules_alter\";a:0:{}s:39:\"block_build_system_branding_block_alter\";a:0:{}s:35:\"block_build_system_menu_block_alter\";a:0:{}s:29:\"block_build_views_block_alter\";a:0:{}s:31:\"block_build_webform_block_alter\";a:0:{}s:31:\"block_build_block_content_alter\";a:0:{}s:35:\"block_build_search_form_block_alter\";a:0:{}s:38:\"block_build_node_syndicate_block_alter\";a:0:{}s:41:\"block_build_system_powered_by_block_alter\";a:0:{}s:21:\"metatag_defaults_load\";a:0:{}s:20:\"metatag_route_entity\";a:0:{}s:14:\"metatags_alter\";a:0:{}s:6:\"tokens\";a:16:{s:5:\"token\";s:6:\"tokens\";s:7:\"comment\";s:6:\"tokens\";s:5:\"field\";b:1;s:4:\"file\";b:0;s:7:\"menu_ui\";b:1;s:7:\"metatag\";s:6:\"tokens\";s:4:\"node\";s:6:\"tokens\";s:6:\"system\";s:6:\"tokens\";s:8:\"taxonomy\";s:6:\"tokens\";s:4:\"user\";s:6:\"tokens\";s:7:\"webform\";s:6:\"tokens\";s:14:\"webform_access\";s:6:\"tokens\";s:12:\"webform_node\";s:6:\"tokens\";s:7:\"youtube\";b:0;s:8:\"pathauto\";s:6:\"tokens\";s:5:\"views\";s:6:\"tokens\";}s:26:\"token_entity_mapping_alter\";a:0:{}s:12:\"tokens_alter\";a:0:{}s:26:\"metatags_attachments_alter\";a:0:{}s:11:\"node_grants\";a:0:{}s:30:\"block_view_webform_block_alter\";a:0:{}s:20:\"filter_format_access\";a:0:{}s:40:\"webform_element_default_properties_alter\";a:0:{}s:36:\"webform_submission_field_values_init\";a:0:{}s:24:\"entity_field_values_init\";a:0:{}s:25:\"webform_submission_create\";a:0:{}s:13:\"entity_create\";a:0:{}s:22:\"entity_form_mode_alter\";a:0:{}s:26:\"entity_form_display_create\";a:0:{}s:25:\"entity_form_display_alter\";a:0:{}s:19:\"entity_prepare_form\";a:0:{}s:31:\"webform_submission_prepare_form\";a:0:{}s:22:\"webform_element_access\";a:0:{}s:21:\"webform_element_alter\";a:0:{}s:36:\"webform_element_processed_text_alter\";a:0:{}s:27:\"webform_element_email_alter\";a:0:{}s:37:\"webform_element_webform_actions_alter\";a:0:{}s:29:\"webform_submission_form_alter\";a:0:{}s:45:\"form_webform_submission_newsletter_form_alter\";a:0:{}s:49:\"form_webform_submission_newsletter_add_form_alter\";a:0:{}s:41:\"theme_suggestions_webform_submission_form\";a:1:{s:7:\"webform\";b:0;}s:47:\"theme_suggestions_webform_submission_form_alter\";a:0:{}s:18:\"filter_format_load\";a:0:{}s:33:\"theme_suggestions_webform_actions\";a:0:{}s:39:\"theme_suggestions_webform_actions_alter\";a:0:{}s:25:\"theme_suggestions_webform\";a:1:{s:7:\"webform\";b:0;}s:31:\"theme_suggestions_webform_alter\";a:0:{}s:30:\"block_view_block_content_alter\";a:0:{}s:22:\"entity_view_mode_alter\";a:0:{}s:34:\"block_content_build_defaults_alter\";a:0:{}s:27:\"entity_build_defaults_alter\";a:0:{}s:23:\"entity_extra_field_info\";a:6:{s:8:\"addtoany\";b:0;s:7:\"comment\";b:0;s:7:\"contact\";b:0;s:4:\"node\";b:0;s:14:\"simple_sitemap\";b:0;s:4:\"user\";b:0;}s:27:\"addtoany_entity_types_alter\";a:0:{}s:29:\"entity_extra_field_info_alter\";a:0:{}s:24:\"entity_view_display_load\";a:0:{}s:25:\"entity_view_display_alter\";a:1:{s:4:\"node\";b:0;}s:19:\"entity_prepare_view\";a:0:{}s:19:\"entity_field_access\";a:1:{s:8:\"language\";b:0;}s:25:\"entity_field_access_alter\";a:0:{}s:30:\"query_file_load_multiple_alter\";a:0:{}s:17:\"file_storage_load\";a:0:{}s:9:\"file_load\";a:0:{}s:26:\"entity_display_build_alter\";a:0:{}s:18:\"block_content_view\";a:0:{}s:11:\"entity_view\";a:2:{s:8:\"addtoany\";b:0;s:7:\"comment\";b:0;}s:24:\"block_content_view_alter\";a:0:{}s:17:\"entity_view_alter\";a:1:{s:7:\"metatag\";b:0;}s:33:\"theme_suggestions_image_formatter\";a:0:{}s:39:\"theme_suggestions_image_formatter_alter\";a:0:{}s:23:\"theme_suggestions_image\";a:0:{}s:29:\"theme_suggestions_image_alter\";a:0:{}s:28:\"block_view_views_block_alter\";a:0:{}s:14:\"views_pre_view\";a:0:{}s:15:\"views_pre_build\";a:0:{}s:17:\"views_query_alter\";a:0:{}s:25:\"views_query_substitutions\";a:3:{s:4:\"node\";s:15:\"views_execution\";s:4:\"user\";s:15:\"views_execution\";s:5:\"views\";s:15:\"views_execution\";}s:16:\"views_post_build\";a:0:{}s:17:\"views_pre_execute\";a:0:{}s:17:\"query_views_alter\";a:1:{s:5:\"views\";b:0;}s:28:\"query_views_temoignage_alter\";a:0:{}s:23:\"query_node_access_alter\";a:1:{s:4:\"node\";b:0;}s:30:\"query_node_load_multiple_alter\";a:0:{}s:17:\"node_storage_load\";a:0:{}s:9:\"node_load\";a:0:{}s:18:\"views_post_execute\";a:0:{}s:16:\"views_pre_render\";a:2:{s:5:\"dblog\";b:0;s:5:\"views\";s:15:\"views_execution\";}s:34:\"theme_suggestions_views_view_field\";a:0:{}s:40:\"theme_suggestions_views_view_field_alter\";a:0:{}s:26:\"entity_view_display_create\";a:0:{}s:21:\"field_info_max_weight\";a:0:{}s:17:\"views_post_render\";a:0:{}s:28:\"theme_suggestions_views_view\";a:0:{}s:34:\"theme_suggestions_views_view_alter\";a:0:{}s:40:\"theme_suggestions_views_view_unformatted\";a:0:{}s:46:\"theme_suggestions_views_view_unformatted_alter\";a:0:{}s:35:\"theme_suggestions_views_view_fields\";a:0:{}s:41:\"theme_suggestions_views_view_fields_alter\";a:0:{}s:35:\"query_paragraph_load_multiple_alter\";a:0:{}s:22:\"paragraph_storage_load\";a:0:{}s:14:\"paragraph_load\";a:0:{}s:16:\"paragraph_access\";a:0:{}s:30:\"paragraph_build_defaults_alter\";a:0:{}s:23:\"theme_suggestions_field\";a:1:{s:6:\"system\";b:0;}s:29:\"theme_suggestions_field_alter\";a:0:{}s:14:\"paragraph_view\";a:0:{}s:20:\"paragraph_view_alter\";a:0:{}s:27:\"theme_suggestions_paragraph\";a:1:{s:10:\"paragraphs\";b:0;}s:33:\"theme_suggestions_paragraph_alter\";a:0:{}s:26:\"query_views_articles_alter\";a:0:{}s:11:\"node_access\";a:2:{s:4:\"node\";b:0;s:12:\"webform_node\";b:0;}s:24:\"views_plugins_join_alter\";a:0:{}s:28:\"query_views_evenements_alter\";a:0:{}s:25:\"node_build_defaults_alter\";a:0:{}s:11:\"user_access\";a:0:{}s:9:\"node_view\";a:0:{}s:15:\"node_view_alter\";a:2:{s:7:\"comment\";b:0;s:7:\"history\";b:0;}s:10:\"token_info\";a:14:{s:5:\"token\";s:6:\"tokens\";s:7:\"comment\";s:6:\"tokens\";s:4:\"file\";b:0;s:7:\"menu_ui\";b:1;s:7:\"metatag\";s:6:\"tokens\";s:4:\"node\";s:6:\"tokens\";s:6:\"system\";s:6:\"tokens\";s:8:\"taxonomy\";s:6:\"tokens\";s:4:\"user\";s:6:\"tokens\";s:7:\"webform\";s:6:\"tokens\";s:14:\"webform_access\";s:6:\"tokens\";s:12:\"webform_node\";s:6:\"tokens\";s:8:\"pathauto\";s:6:\"tokens\";s:5:\"views\";s:6:\"tokens\";}s:20:\"metatag_groups_alter\";a:0:{}s:38:\"theme_suggestions_webform_element_more\";a:0:{}s:44:\"theme_suggestions_webform_element_more_alter\";a:0:{}s:16:\"token_info_alter\";a:5:{s:5:\"token\";s:6:\"tokens\";s:5:\"field\";b:1;s:7:\"metatag\";s:6:\"tokens\";s:7:\"webform\";s:6:\"tokens\";s:7:\"youtube\";b:0;}s:25:\"field_storage_config_load\";a:0:{}s:17:\"field_config_load\";a:0:{}s:22:\"theme_suggestions_node\";a:1:{s:4:\"node\";b:0;}s:28:\"theme_suggestions_node_alter\";a:1:{s:5:\"views\";b:0;}s:26:\"theme_suggestions_username\";a:0:{}s:32:\"theme_suggestions_username_alter\";a:0:{}s:16:\"node_links_alter\";a:1:{s:7:\"comment\";b:0;}s:34:\"block_view_system_menu_block_alter\";a:1:{s:7:\"menu_ui\";b:0;}s:56:\"form_webform_submission_newsletter_node_3_add_form_alter\";a:0:{}s:56:\"form_webform_submission_newsletter_node_4_add_form_alter\";a:0:{}s:57:\"form_webform_submission_newsletter_node_31_add_form_alter\";a:0:{}s:39:\"query_taxonomy_term_load_multiple_alter\";a:0:{}s:26:\"taxonomy_term_storage_load\";a:0:{}s:18:\"taxonomy_term_load\";a:0:{}s:20:\"taxonomy_term_access\";a:0:{}s:35:\"theme_suggestions_addtoany_standard\";a:1:{s:8:\"addtoany\";b:0;}s:41:\"theme_suggestions_addtoany_standard_alter\";a:0:{}s:27:\"theme_suggestions_file_link\";a:0:{}s:33:\"theme_suggestions_file_link_alter\";a:0:{}s:31:\"theme_suggestions_youtube_video\";a:0:{}s:37:\"theme_suggestions_youtube_video_alter\";a:0:{}s:57:\"form_webform_submission_newsletter_node_26_add_form_alter\";a:0:{}s:26:\"query_views_rapports_alter\";a:0:{}s:34:\"theme_suggestions_views_mini_pager\";a:0:{}s:40:\"theme_suggestions_views_mini_pager_alter\";a:0:{}s:29:\"theme_suggestions_image_style\";a:0:{}s:35:\"theme_suggestions_image_style_alter\";a:0:{}s:23:\"theme_suggestions_pager\";a:0:{}s:29:\"theme_suggestions_pager_alter\";a:0:{}s:28:\"query_views_partenaire_alter\";a:0:{}s:28:\"webform_handler_invoke_alter\";a:0:{}s:39:\"webform_handler_invoke_pre_create_alter\";a:0:{}s:43:\"webform_handler_invoke_alter_elements_alter\";a:0:{}s:40:\"webform_handler_invoke_post_create_alter\";a:0:{}s:46:\"webform_handler_invoke_override_settings_alter\";a:0:{}s:41:\"webform_handler_invoke_prepare_form_alter\";a:0:{}s:43:\"webform_handler_invoke_access_element_alter\";a:0:{}s:31:\"webform_element_textfield_alter\";a:0:{}s:42:\"webform_handler_invoke_alter_element_alter\";a:0:{}s:25:\"webform_element_tel_alter\";a:0:{}s:30:\"webform_element_textarea_alter\";a:0:{}s:39:\"webform_handler_invoke_alter_form_alter\";a:0:{}s:43:\"form_webform_submission_adhesion_form_alter\";a:0:{}s:55:\"form_webform_submission_adhesion_node_25_add_form_alter\";a:0:{}s:26:\"theme_suggestions_textarea\";a:0:{}s:32:\"theme_suggestions_textarea_alter\";a:0:{}s:57:\"form_webform_submission_newsletter_node_25_add_form_alter\";a:0:{}s:33:\"query_views_offres_d_emploi_alter\";a:0:{}s:43:\"webform_element_webform_document_file_alter\";a:0:{}s:49:\"form_webform_submission_offre_d_emploi_form_alter\";a:0:{}s:61:\"form_webform_submission_offre_d_emploi_node_19_add_form_alter\";a:0:{}s:35:\"theme_suggestions_file_managed_file\";a:0:{}s:41:\"theme_suggestions_file_managed_file_alter\";a:0:{}s:57:\"form_webform_submission_newsletter_node_19_add_form_alter\";a:0:{}s:42:\"form_webform_submission_contact_form_alter\";a:0:{}s:53:\"form_webform_submission_contact_node_5_add_form_alter\";a:0:{}s:56:\"form_webform_submission_newsletter_node_5_add_form_alter\";a:0:{}}',-1,1680009186.956,1,'','0'),('path_alias_whitelist',_binary 'a:46:{s:5:\"admin\";b:0;s:8:\"run-cron\";b:0;s:8:\"big_pipe\";b:0;s:14:\"block-category\";N;s:5:\"block\";b:0;s:9:\"ckeditor5\";N;s:7:\"comment\";N;s:8:\"comments\";N;s:7:\"contact\";N;s:4:\"user\";b:0;s:10:\"contextual\";N;s:6:\"editor\";N;s:4:\"file\";N;s:6:\"filter\";N;s:7:\"history\";N;s:5:\"sites\";N;s:6:\"system\";N;s:4:\"node\";b:1;s:18:\"paragraphs_browser\";N;s:5:\"clone\";N;s:6:\"search\";N;s:11:\"sitemap.xml\";N;s:8:\"sitemaps\";N;s:17:\"sitemap_generator\";N;s:4:\"cron\";N;s:12:\"machine_name\";N;s:0:\"\";N;s:9:\"<current>\";N;s:5:\"batch\";N;s:10:\"update.php\";N;s:29:\"entity_reference_autocomplete\";N;s:7:\"session\";N;s:8:\"taxonomy\";N;s:5:\"token\";N;s:7:\"toolbar\";N;s:11:\".well-known\";N;s:7:\"webform\";N;s:8:\"articles\";b:0;s:10:\"evenements\";b:0;s:7:\"rss.xml\";N;s:13:\"offres-emploi\";b:0;s:11:\"partenaires\";b:0;s:8:\"rapports\";b:0;s:10:\"temoignage\";N;s:5:\"views\";N;s:7:\"accueil\";b:0;}',-1,1680009081.766,1,'','0'),('routing.non_admin_routes',_binary 'a:152:{i:0;s:22:\"admin_toolbar.run.cron\";i:1;s:13:\"big_pipe.nojs\";i:2;s:27:\"block.category_autocomplete\";i:3;s:22:\"block_content.add_page\";i:4;s:22:\"block_content.add_form\";i:5;s:30:\"entity.block_content.canonical\";i:6;s:30:\"entity.block_content.edit_form\";i:7;s:32:\"entity.block_content.delete_form\";i:8;s:31:\"ckeditor5.media_entity_metadata\";i:9;s:24:\"entity.comment.edit_form\";i:10;s:15:\"comment.approve\";i:11;s:24:\"entity.comment.canonical\";i:12;s:26:\"entity.comment.delete_form\";i:13;s:13:\"comment.reply\";i:14;s:31:\"comment.new_comments_node_links\";i:15;s:21:\"comment.node_redirect\";i:16;s:17:\"contact.site_page\";i:17;s:29:\"entity.contact_form.canonical\";i:18;s:24:\"entity.user.contact_form\";i:19;s:17:\"contextual.render\";i:20;s:17:\"editor.filter_xss\";i:21;s:19:\"editor.image_dialog\";i:22;s:18:\"editor.link_dialog\";i:23;s:18:\"file.ajax_progress\";i:24;s:15:\"filter.tips_all\";i:25;s:11:\"filter.tips\";i:26;s:26:\"history.get_last_node_view\";i:27;s:17:\"history.read_node\";i:28;s:18:\"image.style_public\";i:29;s:19:\"image.style_private\";i:30;s:13:\"node.add_page\";i:31;s:8:\"node.add\";i:32;s:19:\"entity.node.preview\";i:33;s:27:\"entity.node.version_history\";i:34;s:20:\"entity.node.revision\";i:35;s:28:\"node.revision_revert_confirm\";i:36;s:40:\"node.revision_revert_translation_confirm\";i:37;s:28:\"node.revision_delete_confirm\";i:38;s:48:\"paragraphs_browser.paragraphs_browser_controller\";i:39;s:33:\"quick_node_clone.node.quick_clone\";i:40;s:11:\"search.view\";i:41;s:23:\"search.view_node_search\";i:42;s:23:\"search.help_node_search\";i:43;s:23:\"search.view_user_search\";i:44;s:23:\"search.help_user_search\";i:45;s:19:\"shortcut.set_switch\";i:46;s:30:\"simple_sitemap.sitemap_default\";i:47;s:30:\"simple_sitemap.sitemap_variant\";i:48;s:26:\"simple_sitemap.sitemap_xsl\";i:49;s:10:\"system.401\";i:50;s:10:\"system.403\";i:51;s:10:\"system.404\";i:52;s:10:\"system.4xx\";i:53;s:11:\"system.cron\";i:54;s:33:\"system.machine_name_transliterate\";i:55;s:12:\"system.files\";i:56;s:28:\"system.private_file_download\";i:57;s:16:\"system.temporary\";i:58;s:7:\"<front>\";i:59;s:6:\"<none>\";i:60;s:8:\"<nolink>\";i:61;s:8:\"<button>\";i:62;s:9:\"<current>\";i:63;s:15:\"system.timezone\";i:64;s:22:\"system.batch_page.html\";i:65;s:16:\"system.db_update\";i:66;s:26:\"system.entity_autocomplete\";i:67;s:16:\"system.csrftoken\";i:68;s:30:\"entity.taxonomy_term.edit_form\";i:69;s:32:\"entity.taxonomy_term.delete_form\";i:70;s:10:\"token.tree\";i:71;s:16:\"toolbar.subtrees\";i:72;s:13:\"user.register\";i:73;s:11:\"user.logout\";i:74;s:9:\"user.pass\";i:75;s:9:\"user.page\";i:76;s:9:\"user.edit\";i:77;s:10:\"user.login\";i:78;s:19:\"user.cancel_confirm\";i:79;s:16:\"user.reset.login\";i:80;s:10:\"user.reset\";i:81;s:15:\"user.reset.form\";i:82;s:31:\"user.well-known.change_password\";i:83;s:24:\"entity.webform.canonical\";i:84;s:28:\"entity.webform.access_denied\";i:85;s:32:\"entity.webform.assets.javascript\";i:86;s:25:\"entity.webform.assets.css\";i:87;s:27:\"entity.webform.confirmation\";i:88;s:31:\"entity.webform.user.submissions\";i:89;s:26:\"entity.webform.user.drafts\";i:90;s:30:\"entity.webform.user.submission\";i:91;s:35:\"entity.webform.user.submission.edit\";i:92;s:37:\"entity.webform.user.submission.delete\";i:93;s:40:\"entity.webform.user.submission.duplicate\";i:94;s:24:\"entity.webform.test_form\";i:95;s:30:\"entity.webform_submission.user\";i:96;s:28:\"webform.element.autocomplete\";i:97;s:29:\"webform.element.message.close\";i:98;s:41:\"entity.webform.user.submission.attachment\";i:99;s:32:\"entity.node.webform.confirmation\";i:100;s:36:\"entity.node.webform.user.submissions\";i:101;s:31:\"entity.node.webform.user.drafts\";i:102;s:35:\"entity.node.webform.user.submission\";i:103;s:40:\"entity.node.webform.user.submission.edit\";i:104;s:42:\"entity.node.webform.user.submission.delete\";i:105;s:45:\"entity.node.webform.user.submission.duplicate\";i:106;s:29:\"entity.node.webform.test_form\";i:107;s:39:\"entity.node.webform.results_submissions\";i:108;s:46:\"entity.node.webform.results_submissions.custom\";i:109;s:51:\"entity.node.webform.results_submissions.custom.user\";i:110;s:34:\"entity.node.webform.results_export\";i:111;s:39:\"entity.node.webform.results_export_file\";i:112;s:33:\"entity.node.webform.results_clear\";i:113;s:40:\"entity.node.webform_submission.canonical\";i:114;s:36:\"entity.node.webform_submission.table\";i:115;s:35:\"entity.node.webform_submission.text\";i:116;s:35:\"entity.node.webform_submission.yaml\";i:117;s:40:\"entity.node.webform_submission.edit_form\";i:118;s:44:\"entity.node.webform_submission.edit_form.all\";i:119;s:41:\"entity.node.webform_submission.notes_form\";i:120;s:42:\"entity.node.webform_submission.resend_form\";i:121;s:45:\"entity.node.webform_submission.duplicate_form\";i:122;s:42:\"entity.node.webform_submission.delete_form\";i:123;s:40:\"entity.node.webform.entity_reference.set\";i:124;s:25:\"entity.webform.share_page\";i:125;s:36:\"entity.webform.share_page.javascript\";i:126;s:27:\"entity.webform.share_script\";i:127;s:31:\"entity.node.webform.share_embed\";i:128;s:33:\"entity.node.webform.share_preview\";i:129;s:30:\"entity.node.webform.share_test\";i:130;s:59:\"entity.node.webform_submission_export_import.results_import\";i:131;s:76:\"entity.node.webform_submission_export_import.results_import.example.download\";i:132;s:72:\"entity.node.webform_submission_export_import.results_import.example.view\";i:133;s:20:\"view.articles.page_1\";i:134;s:22:\"view.evenements.page_1\";i:135;s:21:\"view.frontpage.feed_1\";i:136;s:21:\"view.frontpage.page_1\";i:137;s:27:\"view.offres_d_emploi.page_1\";i:138;s:22:\"view.partenaire.page_1\";i:139;s:20:\"view.rapports.page_1\";i:140;s:25:\"view.taxonomy_term.feed_1\";i:141;s:25:\"view.taxonomy_term.page_1\";i:142;s:22:\"view.temoignage.page_1\";i:143;s:10:\"views.ajax\";i:144;s:17:\"empty_page.page_1\";i:145;s:21:\"entity.node.canonical\";i:146;s:23:\"entity.node.delete_form\";i:147;s:21:\"entity.node.edit_form\";i:148;s:21:\"entity.user.canonical\";i:149;s:21:\"entity.user.edit_form\";i:150;s:23:\"entity.user.cancel_form\";i:151;s:30:\"entity.taxonomy_term.canonical\";}',-1,1680008719.418,1,'routes','424'),('theme.active_theme.gin',_binary 'O:29:\"Drupal\\Core\\Theme\\ActiveTheme\":12:{s:7:\"\0*\0name\";s:3:\"gin\";s:7:\"\0*\0logo\";s:19:\"themes/gin/logo.svg\";s:7:\"\0*\0path\";s:10:\"themes/gin\";s:9:\"\0*\0engine\";s:4:\"twig\";s:8:\"\0*\0owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:22:\"\0*\0baseThemeExtensions\";a:1:{s:5:\"claro\";O:31:\"Drupal\\Core\\Extension\\Extension\":16:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:32:\"core/themes/claro/claro.info.yml\";s:11:\"\0*\0filename\";s:11:\"claro.theme\";s:7:\"subpath\";s:12:\"themes/claro\";s:6:\"origin\";s:4:\"core\";s:4:\"info\";a:25:{s:4:\"name\";s:5:\"Claro\";s:4:\"type\";s:5:\"theme\";s:11:\"description\";s:62:\"A clean, accessible, and powerful Drupal administration theme.\";s:8:\"alt text\";s:49:\"Screenshot of Claro, Drupal administration theme.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:5:\"9.5.7\";s:9:\"libraries\";a:3:{i:0;s:19:\"core/drupal.message\";i:1;s:14:\"core/normalize\";i:2;s:20:\"claro/global-styling\";}s:18:\"libraries-override\";a:15:{s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:6:{s:39:\"css/components/ajax-progress.module.css\";s:39:\"css/components/ajax-progress.module.css\";s:46:\"css/components/autocomplete-loading.module.css\";s:46:\"css/components/autocomplete-loading.module.css\";s:40:\"css/components/system-status-counter.css\";s:40:\"css/components/system-status-counter.css\";s:48:\"css/components/system-status-report-counters.css\";s:48:\"css/components/system-status-report-counters.css\";s:52:\"css/components/system-status-report-general-info.css\";s:52:\"css/components/system-status-report-general-info.css\";s:35:\"css/components/tabledrag.module.css\";s:28:\"css/components/tabledrag.css\";}}}s:12:\"system/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/system.admin.css\";b:0;}}}s:29:\"core/drupal.dialog.off_canvas\";a:1:{s:3:\"css\";a:1:{s:4:\"base\";a:1:{s:32:\"misc/dialog/off-canvas.theme.css\";s:29:\"css/base/off-canvas.theme.css\";}}}s:22:\"core/drupal.dropbutton\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:30:\"misc/dropbutton/dropbutton.css\";s:29:\"css/components/dropbutton.css\";}}}s:25:\"core/drupal.vertical-tabs\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"misc/vertical-tabs.css\";b:0;}}}s:24:\"core/drupal.autocomplete\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:45:\"assets/vendor/jquery.ui/themes/base/theme.css\";b:0;}}}s:26:\"core/drupal.tabbingmanager\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:45:\"assets/vendor/jquery.ui/themes/base/theme.css\";b:0;}}}s:18:\"core/drupal.dialog\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:46:\"assets/vendor/jquery.ui/themes/base/dialog.css\";b:0;}s:5:\"theme\";a:1:{s:45:\"assets/vendor/jquery.ui/themes/base/theme.css\";b:0;}}}s:16:\"user/drupal.user\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/user.module.css\";b:0;}}}s:24:\"field_ui/drupal.field_ui\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/field_ui.admin.css\";s:28:\"css/theme/field-ui.admin.css\";}}}s:16:\"node/drupal.node\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";b:0;}}}s:9:\"node/form\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";b:0;}}}s:15:\"toolbar/toolbar\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/toolbar.module.css\";s:33:\"css/components/toolbar.module.css\";}s:5:\"theme\";a:2:{s:21:\"css/toolbar.theme.css\";s:27:\"css/theme/toolbar.theme.css\";s:27:\"css/toolbar.icons.theme.css\";s:33:\"css/theme/toolbar.icons.theme.css\";}}}s:20:\"toolbar/toolbar.menu\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:20:\"css/toolbar.menu.css\";s:26:\"css/state/toolbar.menu.css\";}}}s:22:\"views_ui/admin.styling\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/views_ui.admin.css\";s:33:\"css/components/views_ui.admin.css\";}s:5:\"theme\";a:1:{s:28:\"css/views_ui.admin.theme.css\";s:34:\"css/theme/views_ui.admin.theme.css\";}}}}s:16:\"libraries-extend\";a:26:{s:24:\"ckeditor/drupal.ckeditor\";a:1:{i:0;s:21:\"claro/ckeditor-editor\";}s:30:\"ckeditor/drupal.ckeditor.admin\";a:1:{i:0;s:20:\"claro/ckeditor-admin\";}s:13:\"core/ckeditor\";a:1:{i:0;s:21:\"claro/ckeditor-dialog\";}s:20:\"core/drupal.collapse\";a:1:{i:0;s:19:\"claro/details-focus\";}s:18:\"core/drupal.dialog\";a:2:{i:0;s:25:\"claro/claro.drupal.dialog\";i:1;s:21:\"claro/claro.jquery.ui\";}s:22:\"core/drupal.dropbutton\";a:1:{i:0;s:16:\"claro/dropbutton\";}s:20:\"core/drupal.checkbox\";a:1:{i:0;s:14:\"claro/checkbox\";}s:19:\"core/drupal.message\";a:1:{i:0;s:14:\"claro/messages\";}s:20:\"core/drupal.progress\";a:1:{i:0;s:14:\"claro/progress\";}s:26:\"core/drupal.tabbingmanager\";a:1:{i:0;s:21:\"claro/claro.jquery.ui\";}s:21:\"core/drupal.tabledrag\";a:1:{i:0;s:21:\"claro/claro.tabledrag\";}s:25:\"core/drupal.vertical-tabs\";a:1:{i:0;s:19:\"claro/vertical-tabs\";}s:16:\"file/drupal.file\";a:1:{i:0;s:10:\"claro/file\";}s:26:\"filter/drupal.filter.admin\";a:1:{i:0;s:12:\"claro/filter\";}s:20:\"filter/drupal.filter\";a:1:{i:0;s:12:\"claro/filter\";}s:12:\"system/admin\";a:1:{i:0;s:18:\"claro/system.admin\";}s:24:\"core/drupal.autocomplete\";a:2:{i:0;s:18:\"claro/autocomplete\";i:1;s:21:\"claro/claro.jquery.ui\";}s:17:\"tour/tour-styling\";a:1:{i:0;s:18:\"claro/tour-styling\";}s:24:\"shortcut/drupal.shortcut\";a:1:{i:0;s:21:\"claro/drupal.shortcut\";}s:16:\"core/drupal.ajax\";a:1:{i:0;s:10:\"claro/ajax\";}s:16:\"user/drupal.user\";a:1:{i:0;s:27:\"claro/form.password-confirm\";}s:18:\"views/views.module\";a:1:{i:0;s:11:\"claro/views\";}s:32:\"media/media_embed_ckeditor_theme\";a:1:{i:0;s:39:\"claro/classy.media_embed_ckeditor_theme\";}s:16:\"media_library/ui\";a:1:{i:0;s:22:\"claro/media_library.ui\";}s:18:\"media_library/view\";a:1:{i:0;s:25:\"claro/media_library.theme\";}s:20:\"media_library/widget\";a:1:{i:0;s:25:\"claro/media_library.theme\";}}s:21:\"quickedit_stylesheets\";a:1:{i:0;s:28:\"css/components/quickedit.css\";}s:20:\"ckeditor_stylesheets\";a:4:{i:0;s:21:\"css/base/elements.css\";i:1;s:23:\"css/base/typography.css\";i:2;s:28:\"css/theme/ckeditor-frame.css\";i:3;s:43:\"css/classy/components/media-embed-error.css\";}s:21:\"ckeditor5-stylesheets\";b:0;s:7:\"regions\";a:9:{s:6:\"header\";s:6:\"Header\";s:11:\"pre_content\";s:11:\"Pre-content\";s:10:\"breadcrumb\";s:10:\"Breadcrumb\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:13:\"sidebar_first\";s:13:\"First sidebar\";}s:14:\"regions_hidden\";a:3:{i:0;s:13:\"sidebar_first\";i:1;s:8:\"page_top\";i:2;s:11:\"page_bottom\";}s:24:\"core_version_requirement\";s:5:\"9.5.7\";s:17:\"core_incompatible\";b:0;s:9:\"lifecycle\";s:6:\"stable\";s:5:\"mtime\";i:1679676878;s:6:\"engine\";s:4:\"twig\";s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:32:\"core/themes/claro/screenshot.png\";s:3:\"php\";s:5:\"7.3.0\";s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:12:\"dependencies\";a:0:{}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:1:{s:3:\"gin\";O:32:\"Drupal\\Core\\Extension\\Dependency\":3:{s:7:\"\0*\0name\";s:5:\"claro\";s:10:\"\0*\0project\";s:0:\"\";s:19:\"\0*\0constraintString\";s:0:\"\";}}s:8:\"requires\";a:0:{}s:4:\"sort\";i:0;s:10:\"sub_themes\";a:1:{s:3:\"gin\";s:3:\"Gin\";}s:19:\"module_dependencies\";a:0:{}s:9:\"libraries\";a:3:{i:0;s:19:\"core/drupal.message\";i:1;s:14:\"core/normalize\";i:2;s:20:\"claro/global-styling\";}s:6:\"engine\";s:4:\"twig\";}}s:12:\"\0*\0extension\";O:31:\"Drupal\\Core\\Extension\\Extension\":17:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:23:\"themes/gin/gin.info.yml\";s:11:\"\0*\0filename\";s:9:\"gin.theme\";s:7:\"subpath\";s:10:\"themes/gin\";s:6:\"origin\";s:0:\"\";s:4:\"info\";a:25:{s:4:\"name\";s:3:\"Gin\";s:4:\"type\";s:5:\"theme\";s:10:\"base theme\";s:5:\"claro\";s:11:\"description\";s:69:\"Admin theme with a strong focus on improving the Editorial Experience\";s:24:\"core_version_requirement\";s:9:\"^9 || ^10\";s:9:\"libraries\";a:2:{i:0;s:20:\"claro/global-styling\";i:1;s:7:\"gin/gin\";}s:18:\"libraries-override\";a:7:{s:23:\"core/drupal.tableselect\";a:1:{s:2:\"js\";a:1:{s:19:\"misc/tableselect.js\";s:27:\"js/overrides/tableselect.js\";}}s:23:\"core/drupal.tableheader\";a:1:{s:2:\"js\";a:1:{s:19:\"misc/tableheader.js\";s:27:\"js/overrides/tableheader.js\";}}s:18:\"media_library/view\";a:1:{s:2:\"js\";a:1:{s:24:\"js/media_library.view.js\";s:34:\"js/overrides/media_library.view.js\";}}s:25:\"claro/claro.drupal.dialog\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:25:\"css/components/dialog.css\";b:0;}}}s:29:\"core/drupal.dialog.off_canvas\";a:1:{s:3:\"css\";a:1:{s:4:\"base\";a:3:{s:31:\"misc/dialog/off-canvas.base.css\";b:0;s:26:\"misc/dialog/off-canvas.css\";b:0;s:32:\"misc/dialog/off-canvas.theme.css\";b:0;}}}s:38:\"paragraphs_ee/paragraphs_ee.off_canvas\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:32:\"css/paragraphs_ee.off_canvas.css\";b:0;}}}s:20:\"claro/global-styling\";a:1:{s:3:\"css\";a:2:{s:6:\"layout\";a:1:{s:28:\"css/layout/local-actions.css\";b:0;}s:5:\"theme\";a:1:{s:20:\"css/theme/colors.css\";b:0;}}}}s:16:\"libraries-extend\";a:33:{s:24:\"core/drupal.autocomplete\";a:1:{i:0;s:16:\"gin/autocomplete\";}s:13:\"core/ckeditor\";a:1:{i:0;s:12:\"gin/ckeditor\";}s:17:\"ckeditor/ckeditor\";a:1:{i:0;s:12:\"gin/ckeditor\";}s:14:\"core/ckeditor5\";a:1:{i:0;s:13:\"gin/ckeditor5\";}s:18:\"core/drupal.dialog\";a:1:{i:0;s:10:\"gin/dialog\";}s:16:\"core/drupal.ajax\";a:1:{i:0;s:8:\"gin/ajax\";}s:32:\"media/media_embed_ckeditor_theme\";a:1:{i:0;s:34:\"gin/gin_media_embed_ckeditor_theme\";}s:18:\"media_library/view\";a:1:{i:0;s:17:\"gin/media_library\";}s:20:\"media_library/widget\";a:1:{i:0;s:17:\"gin/media_library\";}s:34:\"contextual/drupal.contextual-links\";a:1:{i:0;s:20:\"gin/contextual_links\";}s:34:\"autosave_form/drupal.autosave_form\";a:1:{i:0;s:12:\"gin/autosave\";}s:20:\"chosen/drupal.chosen\";a:1:{i:0;s:10:\"gin/chosen\";}s:17:\"dropzonejs/widget\";a:1:{i:0;s:14:\"gin/dropzonejs\";}s:29:\"entity_browser/entity_browser\";a:1:{i:0;s:18:\"gin/entity_browser\";}s:19:\"entity_browser/tabs\";a:1:{i:0;s:18:\"gin/entity_browser\";}s:26:\"entity_browser/entity_list\";a:1:{i:0;s:18:\"gin/entity_browser\";}s:31:\"entity_browser/entity_reference\";a:1:{i:0;s:18:\"gin/entity_browser\";}s:19:\"linkit/linkit.admin\";a:1:{i:0;s:10:\"gin/linkit\";}s:26:\"module_filter/modules.tabs\";a:1:{i:0;s:17:\"gin/module_filter\";}s:27:\"module_filter/update.status\";a:1:{i:0;s:17:\"gin/module_filter\";}s:21:\"module_filter/modules\";a:1:{i:0;s:17:\"gin/module_filter\";}s:35:\"upgrade_status/upgrade_status.admin\";a:1:{i:0;s:18:\"gin/upgrade_status\";}s:22:\"webform/webform.filter\";a:1:{i:0;s:11:\"gin/webform\";}s:21:\"webform_ui/webform_ui\";a:1:{i:0;s:11:\"gin/webform\";}s:28:\"webform/webform.element.help\";a:1:{i:0;s:11:\"gin/webform\";}s:38:\"webform/webform.element.details.toggle\";a:1:{i:0;s:11:\"gin/webform\";}s:25:\"webform/webform.form.tabs\";a:1:{i:0;s:11:\"gin/webform\";}s:27:\"workbench/workbench.toolbar\";a:1:{i:0;s:13:\"gin/workbench\";}s:35:\"paragraphs/drupal.paragraphs.widget\";a:1:{i:0;s:14:\"gin/paragraphs\";}s:38:\"paragraphs_ee/paragraphs_ee.paragraphs\";a:1:{i:0;s:17:\"gin/paragraphs_ee\";}s:34:\"entity_reference_layout/erl_widget\";a:2:{i:0;s:27:\"gin/entity_reference_layout\";i:1;s:21:\"gin/layout_paragraphs\";}s:42:\"layout_paragraphs/layout_paragraphs_widget\";a:1:{i:0;s:21:\"gin/layout_paragraphs\";}s:44:\"responsive_preview/drupal.responsive-preview\";a:1:{i:0;s:22:\"gin/responsive_preview\";}}s:20:\"ckeditor_stylesheets\";a:3:{i:0;s:25:\"dist/css/theme/accent.css\";i:1;s:28:\"dist/css/theme/variables.css\";i:2;s:27:\"dist/css/theme/ckeditor.css\";}s:21:\"ckeditor5-stylesheets\";b:0;s:7:\"regions\";a:9:{s:6:\"header\";s:6:\"Header\";s:11:\"pre_content\";s:11:\"Pre-content\";s:10:\"breadcrumb\";s:10:\"Breadcrumb\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:13:\"sidebar_first\";s:13:\"First sidebar\";}s:14:\"regions_hidden\";a:3:{i:0;s:13:\"sidebar_first\";i:1;s:8:\"page_top\";i:2;s:11:\"page_bottom\";}s:7:\"version\";s:11:\"8.x-3.0-rc2\";s:7:\"project\";s:3:\"gin\";s:9:\"datestamp\";i:1678627671;s:17:\"core_incompatible\";b:0;s:9:\"lifecycle\";s:6:\"stable\";s:5:\"mtime\";i:1678945534;s:6:\"engine\";s:4:\"twig\";s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:25:\"themes/gin/screenshot.png\";s:3:\"php\";s:5:\"7.3.0\";s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:5:\"claro\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:0:{}s:8:\"requires\";a:1:{s:5:\"claro\";r:195;}s:4:\"sort\";i:-1;s:11:\"base_themes\";a:1:{s:5:\"claro\";s:5:\"Claro\";}s:19:\"module_dependencies\";a:0:{}s:9:\"libraries\";a:2:{i:0;s:20:\"claro/global-styling\";i:1;s:7:\"gin/gin\";}s:6:\"engine\";s:4:\"twig\";s:10:\"base_theme\";s:5:\"claro\";}s:20:\"\0*\0styleSheetsRemove\";a:0:{}s:12:\"\0*\0libraries\";a:5:{i:0;s:19:\"core/drupal.message\";i:1;s:14:\"core/normalize\";i:2;s:20:\"claro/global-styling\";i:3;s:20:\"claro/global-styling\";i:4;s:7:\"gin/gin\";}s:10:\"\0*\0regions\";a:9:{s:6:\"header\";s:6:\"Header\";s:11:\"pre_content\";s:11:\"Pre-content\";s:10:\"breadcrumb\";s:10:\"Breadcrumb\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:7:\"content\";s:7:\"Content\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:13:\"sidebar_first\";s:13:\"First sidebar\";}s:20:\"\0*\0librariesOverride\";a:2:{s:17:\"core/themes/claro\";a:15:{s:11:\"system/base\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:6:{s:39:\"css/components/ajax-progress.module.css\";s:39:\"css/components/ajax-progress.module.css\";s:46:\"css/components/autocomplete-loading.module.css\";s:46:\"css/components/autocomplete-loading.module.css\";s:40:\"css/components/system-status-counter.css\";s:40:\"css/components/system-status-counter.css\";s:48:\"css/components/system-status-report-counters.css\";s:48:\"css/components/system-status-report-counters.css\";s:52:\"css/components/system-status-report-general-info.css\";s:52:\"css/components/system-status-report-general-info.css\";s:35:\"css/components/tabledrag.module.css\";s:28:\"css/components/tabledrag.css\";}}}s:12:\"system/admin\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:20:\"css/system.admin.css\";b:0;}}}s:29:\"core/drupal.dialog.off_canvas\";a:1:{s:3:\"css\";a:1:{s:4:\"base\";a:1:{s:32:\"misc/dialog/off-canvas.theme.css\";s:29:\"css/base/off-canvas.theme.css\";}}}s:22:\"core/drupal.dropbutton\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:30:\"misc/dropbutton/dropbutton.css\";s:29:\"css/components/dropbutton.css\";}}}s:25:\"core/drupal.vertical-tabs\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:22:\"misc/vertical-tabs.css\";b:0;}}}s:24:\"core/drupal.autocomplete\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:45:\"assets/vendor/jquery.ui/themes/base/theme.css\";b:0;}}}s:26:\"core/drupal.tabbingmanager\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:45:\"assets/vendor/jquery.ui/themes/base/theme.css\";b:0;}}}s:18:\"core/drupal.dialog\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:46:\"assets/vendor/jquery.ui/themes/base/dialog.css\";b:0;}s:5:\"theme\";a:1:{s:45:\"assets/vendor/jquery.ui/themes/base/theme.css\";b:0;}}}s:16:\"user/drupal.user\";a:1:{s:3:\"css\";a:1:{s:9:\"component\";a:1:{s:19:\"css/user.module.css\";b:0;}}}s:24:\"field_ui/drupal.field_ui\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:22:\"css/field_ui.admin.css\";s:28:\"css/theme/field-ui.admin.css\";}}}s:16:\"node/drupal.node\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";b:0;}}}s:9:\"node/form\";a:1:{s:3:\"css\";a:1:{s:6:\"layout\";a:1:{s:19:\"css/node.module.css\";b:0;}}}s:15:\"toolbar/toolbar\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/toolbar.module.css\";s:33:\"css/components/toolbar.module.css\";}s:5:\"theme\";a:2:{s:21:\"css/toolbar.theme.css\";s:27:\"css/theme/toolbar.theme.css\";s:27:\"css/toolbar.icons.theme.css\";s:33:\"css/theme/toolbar.icons.theme.css\";}}}s:20:\"toolbar/toolbar.menu\";a:1:{s:3:\"css\";a:1:{s:5:\"state\";a:1:{s:20:\"css/toolbar.menu.css\";s:26:\"css/state/toolbar.menu.css\";}}}s:22:\"views_ui/admin.styling\";a:1:{s:3:\"css\";a:2:{s:9:\"component\";a:1:{s:22:\"css/views_ui.admin.css\";s:33:\"css/components/views_ui.admin.css\";}s:5:\"theme\";a:1:{s:28:\"css/views_ui.admin.theme.css\";s:34:\"css/theme/views_ui.admin.theme.css\";}}}}s:10:\"themes/gin\";a:7:{s:23:\"core/drupal.tableselect\";a:1:{s:2:\"js\";a:1:{s:19:\"misc/tableselect.js\";s:27:\"js/overrides/tableselect.js\";}}s:23:\"core/drupal.tableheader\";a:1:{s:2:\"js\";a:1:{s:19:\"misc/tableheader.js\";s:27:\"js/overrides/tableheader.js\";}}s:18:\"media_library/view\";a:1:{s:2:\"js\";a:1:{s:24:\"js/media_library.view.js\";s:34:\"js/overrides/media_library.view.js\";}}s:25:\"claro/claro.drupal.dialog\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:25:\"css/components/dialog.css\";b:0;}}}s:29:\"core/drupal.dialog.off_canvas\";a:1:{s:3:\"css\";a:1:{s:4:\"base\";a:3:{s:31:\"misc/dialog/off-canvas.base.css\";b:0;s:26:\"misc/dialog/off-canvas.css\";b:0;s:32:\"misc/dialog/off-canvas.theme.css\";b:0;}}}s:38:\"paragraphs_ee/paragraphs_ee.off_canvas\";a:1:{s:3:\"css\";a:1:{s:5:\"theme\";a:1:{s:32:\"css/paragraphs_ee.off_canvas.css\";b:0;}}}s:20:\"claro/global-styling\";a:1:{s:3:\"css\";a:2:{s:6:\"layout\";a:1:{s:28:\"css/layout/local-actions.css\";b:0;}s:5:\"theme\";a:1:{s:20:\"css/theme/colors.css\";b:0;}}}}}s:18:\"\0*\0librariesExtend\";a:52:{s:24:\"ckeditor/drupal.ckeditor\";a:1:{i:0;s:21:\"claro/ckeditor-editor\";}s:30:\"ckeditor/drupal.ckeditor.admin\";a:1:{i:0;s:20:\"claro/ckeditor-admin\";}s:13:\"core/ckeditor\";a:2:{i:0;s:21:\"claro/ckeditor-dialog\";i:1;s:12:\"gin/ckeditor\";}s:20:\"core/drupal.collapse\";a:1:{i:0;s:19:\"claro/details-focus\";}s:18:\"core/drupal.dialog\";a:3:{i:0;s:25:\"claro/claro.drupal.dialog\";i:1;s:21:\"claro/claro.jquery.ui\";i:2;s:10:\"gin/dialog\";}s:22:\"core/drupal.dropbutton\";a:1:{i:0;s:16:\"claro/dropbutton\";}s:20:\"core/drupal.checkbox\";a:1:{i:0;s:14:\"claro/checkbox\";}s:19:\"core/drupal.message\";a:1:{i:0;s:14:\"claro/messages\";}s:20:\"core/drupal.progress\";a:1:{i:0;s:14:\"claro/progress\";}s:26:\"core/drupal.tabbingmanager\";a:1:{i:0;s:21:\"claro/claro.jquery.ui\";}s:21:\"core/drupal.tabledrag\";a:1:{i:0;s:21:\"claro/claro.tabledrag\";}s:25:\"core/drupal.vertical-tabs\";a:1:{i:0;s:19:\"claro/vertical-tabs\";}s:16:\"file/drupal.file\";a:1:{i:0;s:10:\"claro/file\";}s:26:\"filter/drupal.filter.admin\";a:1:{i:0;s:12:\"claro/filter\";}s:20:\"filter/drupal.filter\";a:1:{i:0;s:12:\"claro/filter\";}s:12:\"system/admin\";a:1:{i:0;s:18:\"claro/system.admin\";}s:24:\"core/drupal.autocomplete\";a:3:{i:0;s:18:\"claro/autocomplete\";i:1;s:21:\"claro/claro.jquery.ui\";i:2;s:16:\"gin/autocomplete\";}s:17:\"tour/tour-styling\";a:1:{i:0;s:18:\"claro/tour-styling\";}s:24:\"shortcut/drupal.shortcut\";a:1:{i:0;s:21:\"claro/drupal.shortcut\";}s:16:\"core/drupal.ajax\";a:2:{i:0;s:10:\"claro/ajax\";i:1;s:8:\"gin/ajax\";}s:16:\"user/drupal.user\";a:1:{i:0;s:27:\"claro/form.password-confirm\";}s:18:\"views/views.module\";a:1:{i:0;s:11:\"claro/views\";}s:32:\"media/media_embed_ckeditor_theme\";a:2:{i:0;s:39:\"claro/classy.media_embed_ckeditor_theme\";i:1;s:34:\"gin/gin_media_embed_ckeditor_theme\";}s:16:\"media_library/ui\";a:1:{i:0;s:22:\"claro/media_library.ui\";}s:18:\"media_library/view\";a:2:{i:0;s:25:\"claro/media_library.theme\";i:1;s:17:\"gin/media_library\";}s:20:\"media_library/widget\";a:2:{i:0;s:25:\"claro/media_library.theme\";i:1;s:17:\"gin/media_library\";}s:17:\"ckeditor/ckeditor\";a:1:{i:0;s:12:\"gin/ckeditor\";}s:14:\"core/ckeditor5\";a:1:{i:0;s:13:\"gin/ckeditor5\";}s:34:\"contextual/drupal.contextual-links\";a:1:{i:0;s:20:\"gin/contextual_links\";}s:34:\"autosave_form/drupal.autosave_form\";a:1:{i:0;s:12:\"gin/autosave\";}s:20:\"chosen/drupal.chosen\";a:1:{i:0;s:10:\"gin/chosen\";}s:17:\"dropzonejs/widget\";a:1:{i:0;s:14:\"gin/dropzonejs\";}s:29:\"entity_browser/entity_browser\";a:1:{i:0;s:18:\"gin/entity_browser\";}s:19:\"entity_browser/tabs\";a:1:{i:0;s:18:\"gin/entity_browser\";}s:26:\"entity_browser/entity_list\";a:1:{i:0;s:18:\"gin/entity_browser\";}s:31:\"entity_browser/entity_reference\";a:1:{i:0;s:18:\"gin/entity_browser\";}s:19:\"linkit/linkit.admin\";a:1:{i:0;s:10:\"gin/linkit\";}s:26:\"module_filter/modules.tabs\";a:1:{i:0;s:17:\"gin/module_filter\";}s:27:\"module_filter/update.status\";a:1:{i:0;s:17:\"gin/module_filter\";}s:21:\"module_filter/modules\";a:1:{i:0;s:17:\"gin/module_filter\";}s:35:\"upgrade_status/upgrade_status.admin\";a:1:{i:0;s:18:\"gin/upgrade_status\";}s:22:\"webform/webform.filter\";a:1:{i:0;s:11:\"gin/webform\";}s:21:\"webform_ui/webform_ui\";a:1:{i:0;s:11:\"gin/webform\";}s:28:\"webform/webform.element.help\";a:1:{i:0;s:11:\"gin/webform\";}s:38:\"webform/webform.element.details.toggle\";a:1:{i:0;s:11:\"gin/webform\";}s:25:\"webform/webform.form.tabs\";a:1:{i:0;s:11:\"gin/webform\";}s:27:\"workbench/workbench.toolbar\";a:1:{i:0;s:13:\"gin/workbench\";}s:35:\"paragraphs/drupal.paragraphs.widget\";a:1:{i:0;s:14:\"gin/paragraphs\";}s:38:\"paragraphs_ee/paragraphs_ee.paragraphs\";a:1:{i:0;s:17:\"gin/paragraphs_ee\";}s:34:\"entity_reference_layout/erl_widget\";a:2:{i:0;s:27:\"gin/entity_reference_layout\";i:1;s:21:\"gin/layout_paragraphs\";}s:42:\"layout_paragraphs/layout_paragraphs_widget\";a:1:{i:0;s:21:\"gin/layout_paragraphs\";}s:44:\"responsive_preview/drupal.responsive-preview\";a:1:{i:0;s:22:\"gin/responsive_preview\";}}}',-1,1680008719.579,1,'','0'),('theme.active_theme.notregrandblue',_binary 'O:29:\"Drupal\\Core\\Theme\\ActiveTheme\":12:{s:7:\"\0*\0name\";s:14:\"notregrandblue\";s:7:\"\0*\0logo\";s:37:\"themes/custom/notregrandblue/logo.svg\";s:7:\"\0*\0path\";s:28:\"themes/custom/notregrandblue\";s:9:\"\0*\0engine\";s:4:\"twig\";s:8:\"\0*\0owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:22:\"\0*\0baseThemeExtensions\";a:0:{}s:12:\"\0*\0extension\";O:31:\"Drupal\\Core\\Extension\\Extension\":15:{s:7:\"\0*\0type\";s:5:\"theme\";s:11:\"\0*\0pathname\";s:52:\"themes/custom/notregrandblue/notregrandblue.info.yml\";s:11:\"\0*\0filename\";s:20:\"notregrandblue.theme\";s:7:\"subpath\";s:28:\"themes/custom/notregrandblue\";s:6:\"origin\";s:0:\"\";s:4:\"info\";a:18:{s:4:\"name\";s:16:\"notre grand blue\";s:4:\"type\";s:5:\"theme\";s:11:\"description\";s:38:\"Custom theme notre grand blue  drupal.\";s:24:\"core_version_requirement\";s:9:\"^9 || ^10\";s:9:\"libraries\";a:2:{i:0;s:25:\"notregrandblue/global-css\";i:1;s:24:\"notregrandblue/global-js\";}s:7:\"regions\";a:10:{s:15:\"system_branding\";s:15:\"System Branding\";s:9:\"main_menu\";s:9:\"Main Menu\";s:6:\"banner\";s:6:\"Banner\";s:14:\"status_message\";s:14:\"Status Message\";s:11:\"content_top\";s:11:\"Content top\";s:7:\"content\";s:7:\"Content\";s:14:\"content_bottom\";s:14:\"Content bottom\";s:6:\"footer\";s:6:\"Footer\";s:16:\"footer_copyright\";s:16:\"Footer Copyright\";s:8:\"disabled\";s:8:\"Disabled\";}s:17:\"core_incompatible\";b:0;s:9:\"lifecycle\";s:6:\"stable\";s:5:\"mtime\";i:1678953499;s:6:\"engine\";s:4:\"twig\";s:8:\"features\";a:5:{i:0;s:7:\"favicon\";i:1;s:4:\"logo\";i:2;s:17:\"node_user_picture\";i:3;s:20:\"comment_user_picture\";i:4;s:25:\"comment_user_verification\";}s:10:\"screenshot\";s:43:\"themes/custom/notregrandblue/screenshot.png\";s:7:\"version\";N;s:3:\"php\";s:5:\"7.3.0\";s:16:\"libraries_extend\";a:0:{}s:18:\"libraries_override\";a:0:{}s:12:\"dependencies\";a:0:{}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}}s:5:\"owner\";s:36:\"core/themes/engines/twig/twig.engine\";s:6:\"prefix\";s:4:\"twig\";s:6:\"status\";i:1;s:11:\"required_by\";a:0:{}s:8:\"requires\";a:0:{}s:4:\"sort\";i:0;s:19:\"module_dependencies\";a:0:{}s:9:\"libraries\";a:2:{i:0;s:25:\"notregrandblue/global-css\";i:1;s:24:\"notregrandblue/global-js\";}s:6:\"engine\";s:4:\"twig\";}s:20:\"\0*\0styleSheetsRemove\";a:0:{}s:12:\"\0*\0libraries\";a:2:{i:0;s:25:\"notregrandblue/global-css\";i:1;s:24:\"notregrandblue/global-js\";}s:10:\"\0*\0regions\";a:10:{s:15:\"system_branding\";s:15:\"System Branding\";s:9:\"main_menu\";s:9:\"Main Menu\";s:6:\"banner\";s:6:\"Banner\";s:14:\"status_message\";s:14:\"Status Message\";s:11:\"content_top\";s:11:\"Content top\";s:7:\"content\";s:7:\"Content\";s:14:\"content_bottom\";s:14:\"Content bottom\";s:6:\"footer\";s:6:\"Footer\";s:16:\"footer_copyright\";s:16:\"Footer Copyright\";s:8:\"disabled\";s:8:\"Disabled\";}s:20:\"\0*\0librariesOverride\";a:0:{}s:18:\"\0*\0librariesExtend\";a:0:{}}',-1,1680008715.876,1,'','0'),('theme_registry:runtime:gin',_binary 'a:255:{s:17:\"addtoany_standard\";N;s:15:\"addtoany_follow\";N;s:5:\"block\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/claro\";s:8:\"template\";s:5:\"block\";s:4:\"path\";s:40:\"core/themes/claro/templates/classy/block\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";i:24;s:22:\"claro_preprocess_block\";}}s:22:\"block_content_add_list\";N;s:26:\"ckeditor5_settings_toolbar\";N;s:7:\"comment\";N;s:14:\"field__comment\";N;s:14:\"field_ui_table\";N;s:9:\"file_link\";N;s:17:\"file_managed_file\";N;s:10:\"file_audio\";N;s:10:\"file_video\";N;s:20:\"file_widget_multiple\";N;s:16:\"file_upload_help\";N;s:11:\"filter_tips\";N;s:19:\"text_format_wrapper\";N;s:17:\"filter_guidelines\";N;s:14:\"filter_caption\";N;s:17:\"page__user__login\";N;s:20:\"page__user__password\";N;s:20:\"page__user__register\";N;s:12:\"help_section\";N;s:11:\"image_style\";N;s:19:\"image_style_preview\";N;s:12:\"image_anchor\";N;s:20:\"image_resize_summary\";N;s:19:\"image_scale_summary\";N;s:18:\"image_crop_summary\";N;s:28:\"image_scale_and_crop_summary\";N;s:20:\"image_rotate_summary\";N;s:12:\"image_widget\";N;s:15:\"image_formatter\";N;s:35:\"language_negotiation_configure_form\";N;s:31:\"language_content_settings_table\";N;s:28:\"link_formatter_link_separate\";N;s:29:\"locale_translation_last_check\";N;s:30:\"locale_translation_update_info\";N;s:4:\"node\";N;s:13:\"node_add_list\";N;s:14:\"node_edit_form\";N;s:18:\"field__node__title\";N;s:16:\"field__node__uid\";N;s:20:\"field__node__created\";N;s:26:\"paragraphs_browser_wrapper\";N;s:33:\"paragraphs_browser_paragraph_type\";N;s:16:\"responsive_image\";N;s:26:\"responsive_image_formatter\";N;s:13:\"search_result\";N;s:4:\"html\";a:6:{s:14:\"render element\";s:4:\"html\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:4:\"html\";s:4:\"path\";s:20:\"themes/gin/templates\";s:20:\"preprocess functions\";a:9:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_html\";i:2;s:35:\"admin_toolbar_tools_preprocess_html\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"gin_login_preprocess_html\";i:5;s:23:\"metatag_preprocess_html\";i:6;s:20:\"node_preprocess_html\";i:7;s:23:\"toolbar_preprocess_html\";i:32;s:19:\"gin_preprocess_html\";}}s:4:\"page\";a:6:{s:14:\"render element\";s:4:\"page\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:4:\"page\";s:4:\"path\";s:25:\"themes/gin/templates/page\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_page\";i:2;s:21:\"contextual_preprocess\";i:12;s:19:\"gin_preprocess_page\";}}s:10:\"page_title\";a:6:{s:9:\"variables\";a:1:{s:5:\"title\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:10:\"page-title\";s:4:\"path\";s:42:\"core/themes/claro/templates/classy/content\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:30:\"shortcut_preprocess_page_title\";i:3;s:34:\"webform_node_preprocess_page_title\";i:4;s:35:\"webform_share_preprocess_page_title\";i:10;s:25:\"gin_preprocess_page_title\";}}s:6:\"region\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:6:\"region\";s:4:\"path\";s:28:\"themes/gin/templates/regions\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";}}s:4:\"time\";N;s:13:\"datetime_form\";N;s:16:\"datetime_wrapper\";N;s:15:\"status_messages\";a:6:{s:9:\"variables\";a:3:{s:15:\"status_headings\";a:0:{}s:12:\"message_list\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:15:\"status-messages\";s:4:\"path\";s:25:\"themes/gin/templates/misc\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:34:\"webform_preprocess_status_messages\";i:6;s:32:\"claro_preprocess_status_messages\";}}s:5:\"links\";a:6:{s:9:\"variables\";a:4:{s:5:\"links\";a:0:{}s:10:\"attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:5:\"links\";}}s:7:\"heading\";a:0:{}s:16:\"set_active_class\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/themes/claro\";s:8:\"template\";s:5:\"links\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_links\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"claro_preprocess_links\";}}s:18:\"dropbutton_wrapper\";N;s:5:\"image\";N;s:10:\"breadcrumb\";a:6:{s:9:\"variables\";a:1:{s:5:\"links\";a:0:{}}s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:10:\"breadcrumb\";s:4:\"path\";s:31:\"themes/gin/templates/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_breadcrumb\";i:2;s:21:\"contextual_preprocess\";i:12;s:25:\"gin_preprocess_breadcrumb\";}}s:5:\"table\";N;s:19:\"tablesort_indicator\";N;s:4:\"mark\";N;s:9:\"item_list\";N;s:9:\"feed_icon\";N;s:12:\"progress_bar\";N;s:11:\"indentation\";N;s:16:\"maintenance_page\";N;s:12:\"install_page\";N;s:21:\"maintenance_task_list\";N;s:16:\"authorize_report\";N;s:5:\"pager\";N;s:4:\"menu\";a:6:{s:9:\"variables\";a:3:{s:9:\"menu_name\";N;s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:4:\"menu\";s:4:\"path\";s:45:\"core/themes/claro/templates/classy/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";i:6;s:19:\"gin_preprocess_menu\";}}s:15:\"menu_local_task\";N;s:17:\"menu_local_action\";N;s:16:\"menu_local_tasks\";N;s:5:\"input\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/claro\";s:8:\"template\";s:5:\"input\";s:4:\"path\";s:32:\"core/themes/claro/templates/form\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";i:6;s:22:\"claro_preprocess_input\";}}s:6:\"select\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:6:\"select\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_select\";i:2;s:21:\"contextual_preprocess\";i:3;s:25:\"webform_preprocess_select\";i:4;s:23:\"claro_preprocess_select\";i:5;s:21:\"gin_preprocess_select\";}}s:8:\"fieldset\";N;s:7:\"details\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:7:\"details\";s:4:\"path\";s:25:\"themes/gin/templates/form\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_details\";i:2;s:21:\"contextual_preprocess\";i:3;s:26:\"webform_preprocess_details\";i:8;s:24:\"claro_preprocess_details\";i:20;s:22:\"gin_preprocess_details\";}}s:6:\"radios\";N;s:10:\"checkboxes\";N;s:4:\"form\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:4:\"form\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_form\";i:2;s:21:\"contextual_preprocess\";}}s:8:\"textarea\";N;s:12:\"form_element\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:12:\"form-element\";s:4:\"path\";s:25:\"themes/gin/templates/form\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_form_element\";i:2;s:21:\"contextual_preprocess\";i:3;s:31:\"webform_preprocess_form_element\";i:8;s:29:\"claro_preprocess_form_element\";i:20;s:27:\"gin_preprocess_form_element\";}}s:18:\"form_element_label\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/claro\";s:8:\"template\";s:18:\"form-element-label\";s:4:\"path\";s:27:\"core/themes/claro/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:38:\"template_preprocess_form_element_label\";i:2;s:21:\"contextual_preprocess\";i:3;s:37:\"webform_preprocess_form_element_label\";}}s:13:\"vertical_tabs\";N;s:9:\"container\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:9:\"container\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_container\";i:2;s:21:\"contextual_preprocess\";}}s:5:\"field\";N;s:25:\"field_multiple_value_form\";N;s:28:\"block__system_branding_block\";N;s:28:\"block__system_messages_block\";a:7:{s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:28:\"block--system-messages-block\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:13:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";i:12;s:22:\"claro_preprocess_block\";}s:14:\"render element\";s:8:\"elements\";}s:24:\"block__system_menu_block\";N;s:18:\"system_themes_page\";N;s:18:\"system_config_form\";a:6:{s:14:\"render element\";s:4:\"form\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:18:\"system-config-form\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:12:\"confirm_form\";N;s:22:\"system_modules_details\";N;s:24:\"system_modules_uninstall\";N;s:18:\"status_report_page\";N;s:13:\"status_report\";N;s:21:\"status_report_grouped\";N;s:21:\"status_report_counter\";N;s:26:\"status_report_general_info\";N;s:10:\"admin_page\";N;s:11:\"admin_block\";N;s:19:\"admin_block_content\";N;s:18:\"system_admin_index\";N;s:15:\"entity_add_list\";N;s:23:\"off_canvas_page_wrapper\";a:6:{s:9:\"variables\";a:1:{s:8:\"children\";N;}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/claro\";s:8:\"template\";s:23:\"off-canvas-page-wrapper\";s:4:\"path\";s:27:\"core/themes/claro/templates\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:46:\"system_security_advisories_fetch_error_message\";N;s:17:\"entity_page_title\";N;s:13:\"taxonomy_term\";N;s:15:\"token_tree_link\";N;s:7:\"toolbar\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:8:\"template\";s:7:\"toolbar\";s:4:\"path\";s:45:\"core/themes/claro/templates/classy/navigation\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_toolbar\";i:2;s:21:\"contextual_preprocess\";i:3;s:25:\"system_preprocess_toolbar\";i:8;s:24:\"claro_preprocess_toolbar\";i:10;s:22:\"gin_preprocess_toolbar\";}}s:13:\"menu__toolbar\";a:7:{s:9:\"base hook\";s:4:\"menu\";s:9:\"variables\";a:3:{s:9:\"menu_name\";N;s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}}s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/claro\";s:8:\"template\";s:13:\"menu--toolbar\";s:4:\"path\";s:38:\"core/themes/claro/templates/navigation\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";i:3;s:19:\"gin_preprocess_menu\";}}s:17:\"update_last_check\";N;s:13:\"update_report\";N;s:21:\"update_project_status\";N;s:14:\"update_version\";N;s:26:\"update_fetch_error_message\";N;s:4:\"user\";N;s:8:\"username\";N;s:28:\"views_ui_display_tab_setting\";N;s:27:\"views_ui_display_tab_bucket\";N;s:30:\"views_ui_rearrange_filter_form\";N;s:27:\"views_ui_expose_filter_form\";N;s:18:\"views_ui_view_info\";N;s:28:\"views_ui_views_listing_table\";N;s:27:\"views_ui_view_displays_list\";N;s:32:\"views_ui_build_group_filter_form\";N;s:27:\"views_ui_style_plugin_table\";N;s:29:\"views_ui_view_preview_section\";N;s:18:\"views_ui_container\";N;s:12:\"webform_help\";N;s:26:\"webform_help_video_youtube\";N;s:20:\"webform_help_support\";N;s:7:\"webform\";N;s:15:\"webform_actions\";N;s:21:\"webform_access_denied\";N;s:30:\"webform_handler_action_summary\";N;s:29:\"webform_handler_debug_summary\";N;s:29:\"webform_handler_email_summary\";N;s:35:\"webform_handler_remote_post_summary\";N;s:32:\"webform_handler_settings_summary\";N;s:32:\"webform_variant_override_summary\";N;s:20:\"webform_confirmation\";N;s:16:\"webform_required\";N;s:18:\"webform_submission\";N;s:23:\"webform_submission_form\";N;s:29:\"webform_submission_navigation\";N;s:30:\"webform_submission_information\";N;s:23:\"webform_submission_data\";N;s:25:\"webform_element_base_html\";N;s:25:\"webform_element_base_text\";N;s:27:\"webform_container_base_html\";N;s:27:\"webform_container_base_text\";N;s:20:\"webform_element_help\";N;s:20:\"webform_element_more\";N;s:28:\"webform_element_managed_file\";N;s:26:\"webform_element_audio_file\";N;s:29:\"webform_element_document_file\";N;s:26:\"webform_element_image_file\";N;s:26:\"webform_element_video_file\";N;s:18:\"webform_email_html\";N;s:26:\"webform_email_message_html\";N;s:26:\"webform_email_message_text\";N;s:26:\"webform_html_editor_markup\";N;s:23:\"webform_horizontal_rule\";N;s:15:\"webform_message\";N;s:15:\"webform_section\";N;s:25:\"webform_composite_address\";N;s:25:\"webform_composite_contact\";N;s:26:\"webform_composite_location\";N;s:22:\"webform_composite_link\";N;s:22:\"webform_composite_name\";N;s:27:\"webform_composite_telephone\";N;s:18:\"webform_codemirror\";N;s:16:\"webform_progress\";N;s:20:\"webform_progress_bar\";N;s:24:\"webform_progress_tracker\";N;s:39:\"webform_handler_scheduled_email_summary\";N;s:19:\"html__webform_share\";N;s:19:\"page__webform_share\";N;s:20:\"webform_share_iframe\";N;s:20:\"webform_share_script\";N;s:17:\"youtube_thumbnail\";N;s:13:\"youtube_video\";N;s:16:\"views_mini_pager\";N;s:16:\"views_view_field\";N;s:19:\"views_view_grouping\";N;s:10:\"views_view\";N;s:17:\"views_view_fields\";N;s:19:\"views_view_row_opml\";N;s:18:\"views_view_row_rss\";N;s:22:\"views_view_unformatted\";N;s:18:\"views_view_summary\";N;s:15:\"views_view_grid\";N;s:15:\"views_view_list\";N;s:15:\"views_view_opml\";N;s:14:\"views_view_rss\";N;s:16:\"views_view_table\";N;s:30:\"views_view_summary_unformatted\";N;s:21:\"views_form_views_form\";N;s:18:\"views_exposed_form\";N;s:9:\"paragraph\";N;s:29:\"paragraphs_dropbutton_wrapper\";N;s:20:\"paragraphs_info_icon\";N;s:21:\"paragraphs_add_dialog\";N;s:18:\"paragraphs_actions\";N;s:18:\"paragraphs_summary\";N;s:24:\"block__search_form_block\";N;s:24:\"block__local_tasks_block\";N;s:26:\"block__local_actions_block\";N;s:18:\"region__breadcrumb\";a:7:{s:8:\"template\";s:18:\"region--breadcrumb\";s:4:\"path\";s:27:\"core/themes/claro/templates\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:6:\"region\";s:4:\"type\";s:17:\"base_theme_engine\";s:10:\"theme path\";s:17:\"core/themes/claro\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";}}s:25:\"links__media_library_menu\";N;s:11:\"links__node\";N;s:44:\"item_list__media_library_add_form_media_list\";N;s:25:\"item_list__search_results\";N;s:25:\"menu_local_task__views_ui\";N;s:30:\"fieldset__media_library_widget\";N;s:22:\"details__vertical_tabs\";N;s:46:\"details__media_library_add_form_selected_media\";N;s:40:\"container__text_format_filter_guidelines\";N;s:34:\"container__text_format_filter_help\";N;s:37:\"container__text_format_filter_wrapper\";N;s:32:\"container__media_library_content\";N;s:41:\"container__media_library_widget_selection\";N;s:16:\"field__text_long\";N;s:24:\"field__text_with_summary\";N;s:11:\"field__text\";N;s:38:\"views_ui_view_preview_section__exposed\";N;s:25:\"views_view__media_library\";N;s:37:\"views_view_unformatted__media_library\";N;s:11:\"page__clone\";N;s:11:\"page__group\";N;s:20:\"page__layout_builder\";N;s:14:\"page__node_add\";N;s:10:\"page__node\";N;s:28:\"page__entity_browser__iframe\";N;s:17:\"links__dropbutton\";N;s:18:\"menu__toolbar__gin\";a:7:{s:8:\"template\";s:18:\"menu--toolbar--gin\";s:4:\"path\";s:31:\"themes/gin/templates/navigation\";s:9:\"variables\";a:3:{s:9:\"menu_name\";N;s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}}s:9:\"base hook\";s:4:\"menu\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";i:3;s:19:\"gin_preprocess_menu\";i:4;s:33:\"gin_preprocess_menu__toolbar__gin\";}}s:23:\"input__checkbox__toggle\";a:7:{s:8:\"template\";s:23:\"input--checkbox--toggle\";s:4:\"path\";s:25:\"themes/gin/templates/form\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:5:\"input\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"claro_preprocess_input\";}}s:15:\"input__checkbox\";a:7:{s:8:\"template\";s:15:\"input--checkbox\";s:4:\"path\";s:25:\"themes/gin/templates/form\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:5:\"input\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"claro_preprocess_input\";}}s:31:\"input__submit__paragraph_action\";N;s:30:\"container__administration_menu\";N;s:23:\"toolbar__gin__secondary\";a:7:{s:8:\"template\";s:23:\"toolbar--gin--secondary\";s:4:\"path\";s:31:\"themes/gin/templates/navigation\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:7:\"toolbar\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:20:\"preprocess functions\";a:7:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_toolbar\";i:2;s:21:\"contextual_preprocess\";i:3;s:25:\"system_preprocess_toolbar\";i:4;s:24:\"claro_preprocess_toolbar\";i:5;s:22:\"gin_preprocess_toolbar\";i:6;s:38:\"gin_preprocess_toolbar__gin__secondary\";}}s:12:\"toolbar__gin\";a:7:{s:8:\"template\";s:12:\"toolbar--gin\";s:4:\"path\";s:31:\"themes/gin/templates/navigation\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:7:\"toolbar\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:10:\"themes/gin\";s:20:\"preprocess functions\";a:6:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_toolbar\";i:2;s:21:\"contextual_preprocess\";i:3;s:25:\"system_preprocess_toolbar\";i:4;s:24:\"claro_preprocess_toolbar\";i:5;s:22:\"gin_preprocess_toolbar\";}}s:11:\"field__node\";N;s:30:\"form_element__password_confirm\";N;s:22:\"form_element__password\";N;s:19:\"links__action_links\";N;s:32:\"views_view_fields__media_library\";N;s:27:\"html__entity_browser__modal\";N;s:21:\"page__node__revisions\";N;s:41:\"links__dropbutton__operations__paragraphs\";N;}',-1,1680008725.654,1,'theme_registry','36'),('theme_registry:runtime:notregrandblue',_binary 'a:243:{s:17:\"addtoany_standard\";a:6:{s:9:\"variables\";a:9:{s:13:\"addtoany_html\";b:0;s:8:\"link_url\";b:0;s:10:\"link_title\";b:0;s:12:\"buttons_size\";b:0;s:14:\"button_setting\";b:0;s:12:\"button_image\";b:0;s:26:\"universal_button_placement\";b:0;s:11:\"entity_type\";s:0:\"\";s:6:\"bundle\";s:0:\"\";}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:24:\"modules/contrib/addtoany\";s:8:\"template\";s:17:\"addtoany-standard\";s:4:\"path\";s:34:\"modules/contrib/addtoany/templates\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:15:\"addtoany_follow\";N;s:5:\"block\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:5:\"block\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:22:\"block_content_add_list\";N;s:26:\"ckeditor5_settings_toolbar\";N;s:7:\"comment\";N;s:14:\"field__comment\";N;s:14:\"field_ui_table\";N;s:9:\"file_link\";a:6:{s:9:\"variables\";a:3:{s:4:\"file\";N;s:11:\"description\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:9:\"file-link\";s:4:\"path\";s:27:\"core/modules/file/templates\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_file_link\";i:2;s:21:\"contextual_preprocess\";i:3;s:28:\"webform_preprocess_file_link\";i:4;s:35:\"notregrandblue_preprocess_file_link\";}}s:17:\"file_managed_file\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/file\";s:8:\"template\";s:17:\"file-managed-file\";s:4:\"path\";s:27:\"core/modules/file/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_file_managed_file\";i:2;s:21:\"contextual_preprocess\";i:3;s:36:\"webform_preprocess_file_managed_file\";}}s:10:\"file_audio\";N;s:10:\"file_video\";N;s:20:\"file_widget_multiple\";N;s:16:\"file_upload_help\";N;s:11:\"filter_tips\";N;s:19:\"text_format_wrapper\";N;s:17:\"filter_guidelines\";N;s:14:\"filter_caption\";N;s:17:\"page__user__login\";N;s:20:\"page__user__password\";N;s:20:\"page__user__register\";N;s:12:\"help_section\";N;s:11:\"image_style\";a:6:{s:9:\"variables\";a:7:{s:10:\"style_name\";N;s:3:\"uri\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/image\";s:8:\"template\";s:11:\"image-style\";s:4:\"path\";s:28:\"core/modules/image/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:31:\"template_preprocess_image_style\";i:2;s:21:\"contextual_preprocess\";}}s:19:\"image_style_preview\";N;s:12:\"image_anchor\";N;s:20:\"image_resize_summary\";N;s:19:\"image_scale_summary\";N;s:18:\"image_crop_summary\";N;s:28:\"image_scale_and_crop_summary\";N;s:20:\"image_rotate_summary\";N;s:12:\"image_widget\";N;s:15:\"image_formatter\";a:8:{s:9:\"variables\";a:4:{s:4:\"item\";N;s:15:\"item_attributes\";N;s:3:\"url\";N;s:11:\"image_style\";N;}s:4:\"file\";s:15:\"image.field.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/image\";s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/image/image.field.inc\";}s:8:\"template\";s:15:\"image-formatter\";s:4:\"path\";s:28:\"core/modules/image/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:35:\"template_preprocess_image_formatter\";i:2;s:21:\"contextual_preprocess\";}}s:35:\"language_negotiation_configure_form\";N;s:31:\"language_content_settings_table\";N;s:28:\"link_formatter_link_separate\";N;s:29:\"locale_translation_last_check\";N;s:30:\"locale_translation_update_info\";N;s:4:\"node\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:4:\"node\";s:4:\"path\";s:51:\"themes/custom/notregrandblue/templates/content/node\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:21:\"views_preprocess_node\";}}s:13:\"node_add_list\";N;s:14:\"node_edit_form\";N;s:18:\"field__node__title\";a:7:{s:9:\"base hook\";s:5:\"field\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/node\";s:8:\"template\";s:18:\"field--node--title\";s:4:\"path\";s:27:\"core/modules/node/templates\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";i:8;s:27:\"node_preprocess_field__node\";}s:14:\"render element\";s:7:\"element\";}s:16:\"field__node__uid\";a:7:{s:9:\"base hook\";s:5:\"field\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/node\";s:8:\"template\";s:16:\"field--node--uid\";s:4:\"path\";s:27:\"core/modules/node/templates\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";i:8;s:27:\"node_preprocess_field__node\";}s:14:\"render element\";s:7:\"element\";}s:20:\"field__node__created\";a:7:{s:9:\"base hook\";s:5:\"field\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/node\";s:8:\"template\";s:20:\"field--node--created\";s:4:\"path\";s:27:\"core/modules/node/templates\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";i:8;s:27:\"node_preprocess_field__node\";}s:14:\"render element\";s:7:\"element\";}s:26:\"paragraphs_browser_wrapper\";N;s:33:\"paragraphs_browser_paragraph_type\";N;s:16:\"responsive_image\";N;s:26:\"responsive_image_formatter\";N;s:13:\"search_result\";N;s:4:\"html\";a:6:{s:14:\"render element\";s:4:\"html\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:4:\"html\";s:4:\"path\";s:45:\"themes/custom/notregrandblue/templates/layout\";s:20:\"preprocess functions\";a:8:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_html\";i:2;s:35:\"admin_toolbar_tools_preprocess_html\";i:3;s:21:\"contextual_preprocess\";i:4;s:25:\"gin_login_preprocess_html\";i:5;s:23:\"metatag_preprocess_html\";i:6;s:20:\"node_preprocess_html\";i:7;s:23:\"toolbar_preprocess_html\";}}s:4:\"page\";a:6:{s:14:\"render element\";s:4:\"page\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:4:\"page\";s:4:\"path\";s:45:\"themes/custom/notregrandblue/templates/layout\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_page\";i:2;s:21:\"contextual_preprocess\";}}s:10:\"page_title\";a:6:{s:9:\"variables\";a:1:{s:5:\"title\";N;}s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:10:\"page-title\";s:4:\"path\";s:43:\"themes/custom/notregrandblue/templates/misc\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";i:2;s:30:\"shortcut_preprocess_page_title\";i:3;s:34:\"webform_node_preprocess_page_title\";i:4;s:35:\"webform_share_preprocess_page_title\";}}s:6:\"region\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:6:\"region\";s:4:\"path\";s:52:\"themes/custom/notregrandblue/templates/layout/region\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:26:\"template_preprocess_region\";i:2;s:21:\"contextual_preprocess\";}}s:4:\"time\";N;s:13:\"datetime_form\";N;s:16:\"datetime_wrapper\";N;s:15:\"status_messages\";N;s:5:\"links\";a:6:{s:9:\"variables\";a:4:{s:5:\"links\";a:0:{}s:10:\"attributes\";a:1:{s:5:\"class\";a:1:{i:0;s:5:\"links\";}}s:7:\"heading\";a:0:{}s:16:\"set_active_class\";b:0;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:5:\"links\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_links\";i:2;s:21:\"contextual_preprocess\";}}s:18:\"dropbutton_wrapper\";N;s:5:\"image\";a:6:{s:9:\"variables\";a:9:{s:3:\"uri\";N;s:5:\"width\";N;s:6:\"height\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";N;s:10:\"attributes\";a:0:{}s:5:\"sizes\";N;s:6:\"srcset\";a:0:{}s:10:\"style_name\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:5:\"image\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_image\";i:2;s:21:\"contextual_preprocess\";i:3;s:24:\"webform_preprocess_image\";}}s:10:\"breadcrumb\";N;s:5:\"table\";N;s:19:\"tablesort_indicator\";N;s:4:\"mark\";N;s:9:\"item_list\";N;s:9:\"feed_icon\";N;s:12:\"progress_bar\";N;s:11:\"indentation\";N;s:16:\"maintenance_page\";N;s:12:\"install_page\";N;s:21:\"maintenance_task_list\";N;s:16:\"authorize_report\";N;s:5:\"pager\";a:6:{s:14:\"render element\";s:5:\"pager\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:5:\"pager\";s:4:\"path\";s:43:\"themes/custom/notregrandblue/templates/misc\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_pager\";i:2;s:21:\"contextual_preprocess\";}}s:4:\"menu\";a:6:{s:9:\"variables\";a:3:{s:9:\"menu_name\";N;s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}}s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:4:\"menu\";s:4:\"path\";s:49:\"themes/custom/notregrandblue/templates/navigation\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";}}s:15:\"menu_local_task\";N;s:17:\"menu_local_action\";N;s:16:\"menu_local_tasks\";N;s:5:\"input\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:5:\"input\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_input\";i:2;s:21:\"contextual_preprocess\";}}s:6:\"select\";N;s:8:\"fieldset\";N;s:7:\"details\";N;s:6:\"radios\";N;s:10:\"checkboxes\";N;s:4:\"form\";N;s:8:\"textarea\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:8:\"textarea\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:28:\"template_preprocess_textarea\";i:2;s:21:\"contextual_preprocess\";}}s:12:\"form_element\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:12:\"form-element\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:32:\"template_preprocess_form_element\";i:2;s:21:\"contextual_preprocess\";i:3;s:31:\"webform_preprocess_form_element\";}}s:18:\"form_element_label\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:18:\"form-element-label\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:38:\"template_preprocess_form_element_label\";i:2;s:21:\"contextual_preprocess\";i:3;s:37:\"webform_preprocess_form_element_label\";}}s:13:\"vertical_tabs\";N;s:9:\"container\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:9:\"container\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_container\";i:2;s:21:\"contextual_preprocess\";}}s:5:\"field\";a:6:{s:14:\"render element\";s:7:\"element\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:5:\"field\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/field\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";}}s:25:\"field_multiple_value_form\";N;s:28:\"block__system_branding_block\";a:7:{s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:28:\"block--system-branding-block\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:28:\"block__system_messages_block\";a:7:{s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:28:\"block--system-messages-block\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}s:14:\"render element\";s:8:\"elements\";}s:24:\"block__system_menu_block\";a:7:{s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:24:\"block--system-menu-block\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:18:\"system_themes_page\";N;s:18:\"system_config_form\";N;s:12:\"confirm_form\";N;s:22:\"system_modules_details\";N;s:24:\"system_modules_uninstall\";N;s:18:\"status_report_page\";N;s:13:\"status_report\";N;s:21:\"status_report_grouped\";N;s:21:\"status_report_counter\";N;s:26:\"status_report_general_info\";N;s:10:\"admin_page\";N;s:11:\"admin_block\";N;s:19:\"admin_block_content\";N;s:18:\"system_admin_index\";N;s:15:\"entity_add_list\";N;s:23:\"off_canvas_page_wrapper\";a:6:{s:9:\"variables\";a:1:{s:8:\"children\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:19:\"core/modules/system\";s:8:\"template\";s:23:\"off-canvas-page-wrapper\";s:4:\"path\";s:29:\"core/modules/system/templates\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:46:\"system_security_advisories_fetch_error_message\";N;s:17:\"entity_page_title\";N;s:13:\"taxonomy_term\";N;s:15:\"token_tree_link\";N;s:7:\"toolbar\";N;s:13:\"menu__toolbar\";N;s:17:\"update_last_check\";N;s:13:\"update_report\";N;s:21:\"update_project_status\";N;s:14:\"update_version\";N;s:26:\"update_fetch_error_message\";N;s:4:\"user\";N;s:8:\"username\";a:6:{s:9:\"variables\";a:3:{s:7:\"account\";N;s:10:\"attributes\";a:0:{}s:12:\"link_options\";a:0:{}}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:17:\"core/modules/user\";s:8:\"template\";s:8:\"username\";s:4:\"path\";s:27:\"core/modules/user/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:28:\"template_preprocess_username\";i:2;s:21:\"contextual_preprocess\";}}s:28:\"views_ui_display_tab_setting\";N;s:27:\"views_ui_display_tab_bucket\";N;s:30:\"views_ui_rearrange_filter_form\";N;s:27:\"views_ui_expose_filter_form\";N;s:18:\"views_ui_view_info\";N;s:28:\"views_ui_views_listing_table\";N;s:27:\"views_ui_view_displays_list\";N;s:32:\"views_ui_build_group_filter_form\";N;s:27:\"views_ui_style_plugin_table\";N;s:29:\"views_ui_view_preview_section\";N;s:18:\"views_ui_container\";N;s:12:\"webform_help\";N;s:26:\"webform_help_video_youtube\";N;s:20:\"webform_help_support\";N;s:7:\"webform\";a:8:{s:14:\"render element\";s:7:\"element\";s:4:\"file\";s:35:\"includes/webform.theme.template.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:23:\"modules/contrib/webform\";s:8:\"includes\";a:1:{i:0;s:59:\"modules/contrib/webform/includes/webform.theme.template.inc\";}s:8:\"template\";s:7:\"webform\";s:4:\"path\";s:33:\"modules/contrib/webform/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:27:\"template_preprocess_webform\";i:2;s:21:\"contextual_preprocess\";}}s:15:\"webform_actions\";a:8:{s:14:\"render element\";s:7:\"element\";s:4:\"file\";s:35:\"includes/webform.theme.template.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:23:\"modules/contrib/webform\";s:8:\"includes\";a:1:{i:0;s:59:\"modules/contrib/webform/includes/webform.theme.template.inc\";}s:8:\"template\";s:15:\"webform-actions\";s:4:\"path\";s:33:\"modules/contrib/webform/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:35:\"template_preprocess_webform_actions\";i:2;s:21:\"contextual_preprocess\";}}s:21:\"webform_access_denied\";N;s:30:\"webform_handler_action_summary\";N;s:29:\"webform_handler_debug_summary\";N;s:29:\"webform_handler_email_summary\";N;s:35:\"webform_handler_remote_post_summary\";N;s:32:\"webform_handler_settings_summary\";N;s:32:\"webform_variant_override_summary\";N;s:20:\"webform_confirmation\";N;s:16:\"webform_required\";N;s:18:\"webform_submission\";N;s:23:\"webform_submission_form\";a:8:{s:14:\"render element\";s:4:\"form\";s:4:\"file\";s:35:\"includes/webform.theme.template.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:23:\"modules/contrib/webform\";s:8:\"includes\";a:1:{i:0;s:59:\"modules/contrib/webform/includes/webform.theme.template.inc\";}s:8:\"template\";s:23:\"webform-submission-form\";s:4:\"path\";s:33:\"modules/contrib/webform/templates\";s:20:\"preprocess functions\";a:2:{i:0;s:19:\"template_preprocess\";i:1;s:21:\"contextual_preprocess\";}}s:29:\"webform_submission_navigation\";N;s:30:\"webform_submission_information\";N;s:23:\"webform_submission_data\";N;s:25:\"webform_element_base_html\";N;s:25:\"webform_element_base_text\";N;s:27:\"webform_container_base_html\";N;s:27:\"webform_container_base_text\";N;s:20:\"webform_element_help\";N;s:20:\"webform_element_more\";a:8:{s:9:\"variables\";a:3:{s:4:\"more\";N;s:10:\"more_title\";s:0:\"\";s:10:\"attributes\";a:0:{}}s:4:\"file\";s:35:\"includes/webform.theme.template.inc\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:23:\"modules/contrib/webform\";s:8:\"includes\";a:1:{i:0;s:59:\"modules/contrib/webform/includes/webform.theme.template.inc\";}s:8:\"template\";s:20:\"webform-element-more\";s:4:\"path\";s:33:\"modules/contrib/webform/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:40:\"template_preprocess_webform_element_more\";i:2;s:21:\"contextual_preprocess\";}}s:28:\"webform_element_managed_file\";N;s:26:\"webform_element_audio_file\";N;s:29:\"webform_element_document_file\";N;s:26:\"webform_element_image_file\";N;s:26:\"webform_element_video_file\";N;s:18:\"webform_email_html\";N;s:26:\"webform_email_message_html\";N;s:26:\"webform_email_message_text\";N;s:26:\"webform_html_editor_markup\";N;s:23:\"webform_horizontal_rule\";N;s:15:\"webform_message\";N;s:15:\"webform_section\";N;s:25:\"webform_composite_address\";N;s:25:\"webform_composite_contact\";N;s:26:\"webform_composite_location\";N;s:22:\"webform_composite_link\";N;s:22:\"webform_composite_name\";N;s:27:\"webform_composite_telephone\";N;s:18:\"webform_codemirror\";N;s:16:\"webform_progress\";N;s:20:\"webform_progress_bar\";N;s:24:\"webform_progress_tracker\";N;s:39:\"webform_handler_scheduled_email_summary\";N;s:19:\"html__webform_share\";N;s:19:\"page__webform_share\";N;s:20:\"webform_share_iframe\";N;s:20:\"webform_share_script\";N;s:17:\"youtube_thumbnail\";N;s:13:\"youtube_video\";a:6:{s:9:\"variables\";a:5:{s:5:\"input\";N;s:8:\"video_id\";N;s:12:\"entity_title\";N;s:8:\"settings\";a:0:{}s:19:\"alternative_content\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:23:\"modules/contrib/youtube\";s:8:\"template\";s:13:\"youtube-video\";s:4:\"path\";s:33:\"modules/contrib/youtube/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:33:\"template_preprocess_youtube_video\";i:2;s:21:\"contextual_preprocess\";}}s:16:\"views_mini_pager\";a:7:{s:9:\"variables\";a:6:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"tags\";a:0:{}s:8:\"quantity\";i:9;s:7:\"element\";i:0;s:10:\"parameters\";a:0:{}}s:4:\"path\";s:28:\"core/modules/views/templates\";s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:16:\"views-mini-pager\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/views\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_views_mini_pager\";i:2;s:21:\"contextual_preprocess\";}}s:16:\"views_view_field\";a:8:{s:4:\"file\";s:15:\"views.theme.inc\";s:9:\"variables\";a:3:{s:4:\"view\";N;s:5:\"field\";N;s:3:\"row\";N;}s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/views\";s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:16:\"views-view-field\";s:4:\"path\";s:28:\"core/modules/views/templates\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:36:\"template_preprocess_views_view_field\";i:2;s:21:\"contextual_preprocess\";}}s:19:\"views_view_grouping\";N;s:10:\"views_view\";a:7:{s:9:\"variables\";a:13:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}}s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/views\";s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:10:\"views-view\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";}}s:17:\"views_view_fields\";a:7:{s:9:\"variables\";a:4:{s:4:\"view\";N;s:7:\"options\";N;s:3:\"row\";N;s:11:\"field_alias\";N;}s:4:\"path\";s:28:\"core/modules/views/templates\";s:8:\"includes\";a:1:{i:0;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:17:\"views-view-fields\";s:4:\"type\";s:6:\"module\";s:10:\"theme path\";s:18:\"core/modules/views\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:37:\"template_preprocess_views_view_fields\";i:2;s:21:\"contextual_preprocess\";}}s:19:\"views_view_row_opml\";N;s:18:\"views_view_row_rss\";N;s:22:\"views_view_unformatted\";a:7:{s:9:\"variables\";a:4:{s:4:\"view\";N;s:7:\"options\";N;s:4:\"rows\";N;s:5:\"title\";N;}s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/views\";s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}s:8:\"template\";s:22:\"views-view-unformatted\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:42:\"template_preprocess_views_view_unformatted\";i:2;s:21:\"contextual_preprocess\";}}s:18:\"views_view_summary\";N;s:15:\"views_view_grid\";N;s:15:\"views_view_list\";N;s:15:\"views_view_opml\";N;s:14:\"views_view_rss\";N;s:16:\"views_view_table\";N;s:30:\"views_view_summary_unformatted\";N;s:21:\"views_form_views_form\";N;s:18:\"views_exposed_form\";N;s:9:\"paragraph\";a:6:{s:14:\"render element\";s:8:\"elements\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:8:\"template\";s:9:\"paragraph\";s:4:\"path\";s:56:\"themes/custom/notregrandblue/templates/content/paragraph\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_paragraph\";i:2;s:21:\"contextual_preprocess\";}}s:29:\"paragraphs_dropbutton_wrapper\";N;s:20:\"paragraphs_info_icon\";N;s:21:\"paragraphs_add_dialog\";N;s:18:\"paragraphs_actions\";N;s:18:\"paragraphs_summary\";N;s:20:\"block__banneraccueil\";a:7:{s:8:\"template\";s:20:\"block--banneraccueil\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:20:\"block__block_content\";a:7:{s:8:\"template\";s:20:\"block--block-content\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:35:\"block__notregrandblue_reseausociaux\";a:7:{s:8:\"template\";s:35:\"block--notregrandblue-reseausociaux\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:36:\"block__views_block__articles_block_1\";a:7:{s:8:\"template\";s:36:\"block--views-block--articles-block-1\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:38:\"block__views_block__evenements_block_1\";a:7:{s:8:\"template\";s:38:\"block--views-block--evenements-block-1\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:38:\"block__views_block__evenements_block_2\";a:7:{s:8:\"template\";s:38:\"block--views-block--evenements-block-2\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:16:\"block__webform_2\";a:7:{s:8:\"template\";s:16:\"block--webform-2\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/block\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:5:\"block\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:12:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_block\";i:2;s:24:\"comment_preprocess_block\";i:3;s:21:\"contextual_preprocess\";i:4;s:21:\"help_preprocess_block\";i:5;s:25:\"language_preprocess_block\";i:6;s:24:\"menu_ui_preprocess_block\";i:7;s:21:\"node_preprocess_block\";i:8;s:23:\"search_preprocess_block\";i:9;s:25:\"shortcut_preprocess_block\";i:10;s:23:\"system_preprocess_block\";i:11;s:21:\"user_preprocess_block\";}}s:20:\"block__webform_block\";N;s:19:\"node__article__full\";N;s:21:\"node__formation__full\";a:7:{s:8:\"template\";s:21:\"node--formation--full\";s:4:\"path\";s:51:\"themes/custom/notregrandblue/templates/content/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:21:\"views_preprocess_node\";}}s:25:\"node__offres_emploi__full\";a:7:{s:8:\"template\";s:25:\"node--offres-emploi--full\";s:4:\"path\";s:51:\"themes/custom/notregrandblue/templates/content/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:21:\"views_preprocess_node\";}}s:27:\"node__offres_emploi__teaser\";N;s:22:\"node__partenaire__full\";a:7:{s:8:\"template\";s:22:\"node--partenaire--full\";s:4:\"path\";s:51:\"themes/custom/notregrandblue/templates/content/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:21:\"views_preprocess_node\";}}s:24:\"node__partenaire__teaser\";a:7:{s:8:\"template\";s:24:\"node--partenaire--teaser\";s:4:\"path\";s:51:\"themes/custom/notregrandblue/templates/content/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:21:\"views_preprocess_node\";}}s:19:\"node__webform__full\";a:7:{s:8:\"template\";s:19:\"node--webform--full\";s:4:\"path\";s:51:\"themes/custom/notregrandblue/templates/content/node\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:4:\"node\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:24:\"template_preprocess_node\";i:2;s:21:\"contextual_preprocess\";i:3;s:22:\"locale_preprocess_node\";i:4;s:21:\"views_preprocess_node\";}}s:10:\"menu__main\";a:7:{s:8:\"template\";s:10:\"menu--main\";s:4:\"path\";s:49:\"themes/custom/notregrandblue/templates/navigation\";s:9:\"variables\";a:3:{s:9:\"menu_name\";N;s:5:\"items\";a:0:{}s:10:\"attributes\";a:0:{}}s:9:\"base hook\";s:4:\"menu\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:49:\"admin_toolbar_links_access_filter_preprocess_menu\";i:2;s:21:\"contextual_preprocess\";}}s:25:\"field__node__field_images\";a:7:{s:8:\"template\";s:25:\"field--node--field-images\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/field\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:5:\"field\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:5:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";i:4;s:27:\"node_preprocess_field__node\";}}s:50:\"field__paragraph__field_lien_reseau_social__equipe\";a:7:{s:8:\"template\";s:50:\"field--paragraph--field-lien-reseau-social--equipe\";s:4:\"path\";s:44:\"themes/custom/notregrandblue/templates/field\";s:14:\"render element\";s:7:\"element\";s:9:\"base hook\";s:5:\"field\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:25:\"template_preprocess_field\";i:2;s:24:\"comment_preprocess_field\";i:3;s:21:\"contextual_preprocess\";}}s:31:\"views_view__partenaire__block_1\";a:8:{s:8:\"template\";s:31:\"views-view--partenaire--block-1\";s:4:\"path\";s:55:\"themes/custom/notregrandblue/templates/views/partenaire\";s:9:\"variables\";a:13:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}}s:9:\"base hook\";s:10:\"views_view\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";}s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}}s:30:\"views_view__partenaire__page_1\";a:8:{s:8:\"template\";s:30:\"views-view--partenaire--page-1\";s:4:\"path\";s:55:\"themes/custom/notregrandblue/templates/views/partenaire\";s:9:\"variables\";a:13:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}}s:9:\"base hook\";s:10:\"views_view\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";}s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}}s:29:\"views_view__articles__block_1\";a:8:{s:8:\"template\";s:29:\"views-view--articles--block-1\";s:4:\"path\";s:49:\"themes/custom/notregrandblue/templates/views/home\";s:9:\"variables\";a:13:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}}s:9:\"base hook\";s:10:\"views_view\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";}s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}}s:31:\"views_view__evenements__block_1\";a:8:{s:8:\"template\";s:31:\"views-view--evenements--block-1\";s:4:\"path\";s:49:\"themes/custom/notregrandblue/templates/views/home\";s:9:\"variables\";a:13:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}}s:9:\"base hook\";s:10:\"views_view\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";}s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}}s:31:\"views_view__evenements__block_2\";a:8:{s:8:\"template\";s:31:\"views-view--evenements--block-2\";s:4:\"path\";s:49:\"themes/custom/notregrandblue/templates/views/home\";s:9:\"variables\";a:13:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}}s:9:\"base hook\";s:10:\"views_view\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";}s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}}s:31:\"views_view__temoignage__block_1\";a:8:{s:8:\"template\";s:31:\"views-view--temoignage--block-1\";s:4:\"path\";s:49:\"themes/custom/notregrandblue/templates/views/home\";s:9:\"variables\";a:13:{s:10:\"view_array\";a:0:{}s:4:\"view\";N;s:4:\"rows\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:5:\"empty\";a:0:{}s:7:\"exposed\";a:0:{}s:4:\"more\";a:0:{}s:10:\"feed_icons\";a:0:{}s:5:\"pager\";a:0:{}s:5:\"title\";s:0:\"\";s:17:\"attachment_before\";a:0:{}s:16:\"attachment_after\";a:0:{}}s:9:\"base hook\";s:10:\"views_view\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:4:{i:0;s:19:\"template_preprocess\";i:1;s:30:\"template_preprocess_views_view\";i:2;s:21:\"contextual_preprocess\";i:3;s:30:\"views_ui_preprocess_views_view\";}s:8:\"includes\";a:2:{i:0;s:34:\"core/modules/views/views.theme.inc\";i:1;s:34:\"core/modules/views/views.theme.inc\";}}s:29:\"paragraph__block_cta__default\";a:7:{s:8:\"template\";s:29:\"paragraph--block-cta--default\";s:4:\"path\";s:56:\"themes/custom/notregrandblue/templates/content/paragraph\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:9:\"paragraph\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_paragraph\";i:2;s:21:\"contextual_preprocess\";}}s:36:\"paragraph__block_text_image__default\";a:7:{s:8:\"template\";s:36:\"paragraph--block-text-image--default\";s:4:\"path\";s:56:\"themes/custom/notregrandblue/templates/content/paragraph\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:9:\"paragraph\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_paragraph\";i:2;s:21:\"contextual_preprocess\";}}s:37:\"paragraph__composant_content__default\";a:7:{s:8:\"template\";s:37:\"paragraph--composant-content--default\";s:4:\"path\";s:56:\"themes/custom/notregrandblue/templates/content/paragraph\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:9:\"paragraph\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_paragraph\";i:2;s:21:\"contextual_preprocess\";}}s:34:\"paragraph__composant_text__default\";a:7:{s:8:\"template\";s:34:\"paragraph--composant-text--default\";s:4:\"path\";s:56:\"themes/custom/notregrandblue/templates/content/paragraph\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:9:\"paragraph\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_paragraph\";i:2;s:21:\"contextual_preprocess\";}}s:27:\"paragraph__content__default\";a:7:{s:8:\"template\";s:27:\"paragraph--content--default\";s:4:\"path\";s:56:\"themes/custom/notregrandblue/templates/content/paragraph\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:9:\"paragraph\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_paragraph\";i:2;s:21:\"contextual_preprocess\";}}s:26:\"paragraph__equipe__default\";a:7:{s:8:\"template\";s:26:\"paragraph--equipe--default\";s:4:\"path\";s:56:\"themes/custom/notregrandblue/templates/content/paragraph\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:9:\"paragraph\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_paragraph\";i:2;s:21:\"contextual_preprocess\";}}s:27:\"paragraph__equipes__default\";a:7:{s:8:\"template\";s:27:\"paragraph--equipes--default\";s:4:\"path\";s:56:\"themes/custom/notregrandblue/templates/content/paragraph\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:9:\"paragraph\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_paragraph\";i:2;s:21:\"contextual_preprocess\";}}s:34:\"paragraph__reseau_sociaux__default\";a:7:{s:8:\"template\";s:34:\"paragraph--reseau-sociaux--default\";s:4:\"path\";s:56:\"themes/custom/notregrandblue/templates/content/paragraph\";s:14:\"render element\";s:8:\"elements\";s:9:\"base hook\";s:9:\"paragraph\";s:4:\"type\";s:12:\"theme_engine\";s:10:\"theme path\";s:28:\"themes/custom/notregrandblue\";s:20:\"preprocess functions\";a:3:{i:0;s:19:\"template_preprocess\";i:1;s:29:\"template_preprocess_paragraph\";i:2;s:21:\"contextual_preprocess\";}}s:11:\"field__node\";N;}',-1,1680009178.865,1,'theme_registry','36'),('user_permissions_hash:anonymous',_binary '169403f2035bbdaef1f65931a0d5b4f52bdb36d44a8e86f35d821b6231f85437',-1,1680008715.885,0,'config:user.role.anonymous','17');
/*!40000 ALTER TABLE `cache_bootstrap` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Table structure for table `cache_config`
--

DROP TABLE IF EXISTS `cache_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_config` (
  `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',
  `data` longblob COMMENT 'A collection of data to cache.',
  `expire` int NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',
  `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',
  `serialized` smallint NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',
  `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',
  `checksum` varchar(255) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',
  PRIMARY KEY (`cid`),
  KEY `expire` (`expire`),
  KEY `created` (`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Storage for the cache API.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_config`
--

LOCK TABLES `cache_config` WRITE;
/*!40000 ALTER TABLE `cache_config` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `cache_config` VALUES ('addtoany.settings',_binary 'a:10:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QUZHrnAKd4ixgLLVtD3JrrBMlwbmJ6VU-qKcOMDKatw\";}s:8:\"langcode\";s:2:\"fr\";s:12:\"buttons_size\";i:32;s:15:\"additional_html\";s:300:\"<li><a class=\"a2a_button_facebook\"><i class=\"fa fa-facebook\"></i></a></li>\r\n<li><a class=\"a2a_button_twitter\"><i class=\"fa fa-twitter\"\"></i></a></li>\r\n<li><a class=\"a2a_button_linkedin\"><i class=\"fa fa-linkedin\"></i></a></li>\r\n<li><a class=\"a2a_button_copy_link\"><i class=\"fa fa-link\"></i></a></li>\r\n\";s:14:\"additional_css\";s:0:\"\";s:13:\"additional_js\";s:0:\"\";s:16:\"universal_button\";s:4:\"none\";s:23:\"custom_universal_button\";s:0:\"\";s:26:\"universal_button_placement\";s:6:\"before\";s:8:\"entities\";a:13:{s:5:\"media\";i:1;s:4:\"node\";i:1;s:7:\"comment\";i:0;s:13:\"block_content\";i:0;s:15:\"contact_message\";i:0;s:4:\"file\";i:0;s:17:\"menu_link_content\";i:0;s:10:\"path_alias\";i:0;s:8:\"shortcut\";i:0;s:13:\"taxonomy_term\";i:0;s:4:\"user\";i:0;s:18:\"webform_submission\";i:0;s:9:\"paragraph\";i:0;}}',-1,1680008721.680,1,'','0'),('admin_toolbar.settings',_binary 'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jvTSppzcgH5wnzBhX5xnAExcp2I1CzkQ_aky65XNfYI\";}s:8:\"langcode\";s:2:\"fr\";s:10:\"menu_depth\";i:4;}',-1,1680008723.434,1,'','0'),('admin_toolbar_search.settings',_binary 'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AAmWcgwzGYbXfR6wfEfMyoi3r5QZwlpxvq5dHbupnJo\";}s:8:\"langcode\";s:2:\"fr\";s:17:\"display_menu_item\";i:0;}',-1,1680008723.406,1,'','0'),('admin_toolbar_tools.settings',_binary 'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WgdZsrd_5w9jlmcHV4R9dD2tG9OZEkYo4I_O8h7Gq8Q\";}s:8:\"langcode\";s:2:\"fr\";s:17:\"max_bundle_number\";i:20;s:25:\"hoverintent_functionality\";b:1;s:16:\"show_local_tasks\";b:0;}',-1,1680008717.778,1,'','0'),('automated_cron.settings',_binary 'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs\";}s:8:\"langcode\";s:2:\"fr\";s:8:\"interval\";i:10800;}',-1,1680008719.027,1,'','0'),('block.block.banneraccueil',_binary 'a:12:{s:4:\"uuid\";s:36:\"5fc617bc-c668-4a09-86d6-f51c9ebdb4a9\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:7:\"content\";a:1:{i:0;s:57:\"block_content:banner:72662bc6-e2d2-46b0-a5b5-bd73ff536165\";}s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:2:\"id\";s:13:\"banneraccueil\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:6:\"banner\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:50:\"block_content:72662bc6-e2d2-46b0-a5b5-bd73ff536165\";s:8:\"settings\";a:7:{s:2:\"id\";s:50:\"block_content:72662bc6-e2d2-46b0-a5b5-bd73ff536165\";s:5:\"label\";s:14:\"Banner Accueil\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:13:\"block_content\";s:6:\"status\";b:1;s:4:\"info\";s:0:\"\";s:9:\"view_mode\";s:4:\"full\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:3:{s:2:\"id\";s:12:\"request_path\";s:6:\"negate\";b:0;s:5:\"pages\";s:7:\"<front>\";}}}',-1,1680008715.096,1,'','0'),('block.block.blockcontentaccueil',_binary 'a:12:{s:4:\"uuid\";s:36:\"6a5e1486-877a-4c04-9c2d-f6ecb14a476e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:7:\"content\";a:1:{i:0;s:64:\"block_content:block_content:6ee433a9-fdd6-4d88-b9be-b911c51c2791\";}s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:2:\"id\";s:19:\"blockcontentaccueil\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-6;s:8:\"provider\";N;s:6:\"plugin\";s:50:\"block_content:6ee433a9-fdd6-4d88-b9be-b911c51c2791\";s:8:\"settings\";a:7:{s:2:\"id\";s:50:\"block_content:6ee433a9-fdd6-4d88-b9be-b911c51c2791\";s:5:\"label\";s:21:\"Block Content accueil\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:13:\"block_content\";s:6:\"status\";b:1;s:4:\"info\";s:0:\"\";s:9:\"view_mode\";s:4:\"full\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:3:{s:2:\"id\";s:12:\"request_path\";s:6:\"negate\";b:0;s:5:\"pages\";s:7:\"<front>\";}}}',-1,1680008715.096,1,'','0'),('block.block.claro_breadcrumbs',_binary 'a:13:{s:4:\"uuid\";s:36:\"43d0b3b5-f59f-4b58-beeb-3f4b40e735df\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"NjcxOBrPOiK5-38t56DwFBDVY4yer7YSlbRWXFuHe7A\";}s:2:\"id\";s:17:\"claro_breadcrumbs\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:10:\"breadcrumb\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_breadcrumb_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_breadcrumb_block\";s:5:\"label\";s:11:\"Breadcrumbs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.059,1,'','0'),('block.block.claro_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"8df22d2f-a31f-46b4-81b3-88344c8adff7\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"a0Yyx1GeyKarZ4T_yXQBR_ZFKnXiFLtxAb6gWLd8nr0\";}s:2:\"id\";s:13:\"claro_content\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:17:\"Main page content\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.059,1,'','0'),('block.block.claro_help',_binary 'a:13:{s:4:\"uuid\";s:36:\"47d58709-abf3-40c1-98a1-10275c605197\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:4:\"help\";}s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jccFSSVqV0WCDb6NtML1VWAWTtDbZ-zn5YgTRMgMrIM\";}s:2:\"id\";s:10:\"claro_help\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:4:\"help\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:10:\"help_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:10:\"help_block\";s:5:\"label\";s:4:\"Help\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"help\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.059,1,'','0'),('block.block.claro_local_actions',_binary 'a:13:{s:4:\"uuid\";s:36:\"cfce0f84-2b2b-4aff-a79f-f0f111d435f3\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CdXfDmRgAvms7EQovxxWPdYi0GitxeRbVtScYK16ZH0\";}s:2:\"id\";s:19:\"claro_local_actions\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:21:\"Primary admin actions\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.059,1,'','0'),('block.block.claro_messages',_binary 'a:13:{s:4:\"uuid\";s:36:\"83d1c609-1836-4537-aa2a-1684ea489e83\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-Ac3ISpIT0PQ-whzD7_dw0SdKi6dAbRFNWdSjOiVDqg\";}s:2:\"id\";s:14:\"claro_messages\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:15:\"Status messages\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.059,1,'','0'),('block.block.claro_page_title',_binary 'a:13:{s:4:\"uuid\";s:36:\"ca49907f-7847-40b7-8683-e981d823a92b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fNwDdW063tk_ktzSWzZVeQS9wzvLooVO280BQ9WrsIs\";}s:2:\"id\";s:16:\"claro_page_title\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:-30;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:10:\"Page title\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.059,1,'','0'),('block.block.claro_primary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"a31baf10-d62b-42d1-a91f-65e2c3fd211c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ACjBZI5shAMiiUpsz-inLYVXDqNNXRnSzAWV3kV_8Hw\";}s:2:\"id\";s:25:\"claro_primary_local_tasks\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:12:\"Primary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:1;s:9:\"secondary\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.059,1,'','0'),('block.block.claro_secondary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"ad28a22a-e98f-4a22-8cc7-a8a7c8d119a8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:5:\"claro\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2L0geP-ixCbCkEpW6BVF6H7vDUZN4ea07_Y9CociQm4\";}s:2:\"id\";s:27:\"claro_secondary_local_tasks\";s:5:\"theme\";s:5:\"claro\";s:6:\"region\";s:11:\"pre_content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:14:\"Secondary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:0;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1680008715.059,1,'','0'),('block.block.gin_breadcrumbs',_binary 'a:13:{s:4:\"uuid\";s:36:\"507eaba8-0bdb-4ddc-8f9a-0fe7881e07ce\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:3:\"gin\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"y9X3xgCsO59pQyzNLzY1D3SDJJxCHILLWkpPnmuTJ2E\";}s:2:\"id\";s:15:\"gin_breadcrumbs\";s:5:\"theme\";s:3:\"gin\";s:6:\"region\";s:10:\"breadcrumb\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_breadcrumb_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_breadcrumb_block\";s:5:\"label\";s:11:\"Breadcrumbs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.128,1,'','0'),('block.block.gin_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"ad1b47d6-594b-4662-9adb-ff7fe09431cc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:3:\"gin\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hBHXB7hC05XU7pDYzETt-GUcpFlogK1gkjyAsg0Ym58\";}s:2:\"id\";s:11:\"gin_content\";s:5:\"theme\";s:3:\"gin\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:17:\"Main page content\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.128,1,'','0'),('block.block.gin_help',_binary 'a:13:{s:4:\"uuid\";s:36:\"5a82e839-1fc0-4168-af2d-ae23776dc365\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:4:\"help\";}s:5:\"theme\";a:1:{i:0;s:3:\"gin\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"8nOAry2oKqJOr0zbrlJ3sZHDFJLIO6j-0vT0K_TYca4\";}s:2:\"id\";s:8:\"gin_help\";s:5:\"theme\";s:3:\"gin\";s:6:\"region\";s:4:\"help\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:10:\"help_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:10:\"help_block\";s:5:\"label\";s:4:\"Help\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"help\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.128,1,'','0'),('block.block.gin_local_actions',_binary 'a:13:{s:4:\"uuid\";s:36:\"5e6c1c25-a329-4b04-a88e-20e2de969275\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:3:\"gin\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OQ9aJ-4qVwK1x00o9EOYK4eFDjQr_HLpbPiJaPSVZiQ\";}s:2:\"id\";s:17:\"gin_local_actions\";s:5:\"theme\";s:3:\"gin\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:21:\"Primary admin actions\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.128,1,'','0'),('block.block.gin_messages',_binary 'a:13:{s:4:\"uuid\";s:36:\"956ae5f5-f6f7-46e6-9669-d838309ab251\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:3:\"gin\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WvPhI8OwllG0gE69-F8qL3ai3nd5SbYD6JpmEuZcyok\";}s:2:\"id\";s:12:\"gin_messages\";s:5:\"theme\";s:3:\"gin\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:15:\"Status messages\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.128,1,'','0'),('block.block.gin_page_title',_binary 'a:13:{s:4:\"uuid\";s:36:\"25813f9b-808d-41f4-b7e5-5c5ba9ac1c8d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:3:\"gin\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HLQY2xgby8K3vN_98hiOSasOhm9pdCsH234-s0duJ8Q\";}s:2:\"id\";s:14:\"gin_page_title\";s:5:\"theme\";s:3:\"gin\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:-30;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:10:\"Page title\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.128,1,'','0'),('block.block.gin_primary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"7f754c19-8d1d-4162-b448-544feebd6057\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:3:\"gin\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Hh01DLj9k7UnNdPpOQXHZHW7GHf2OPNDQyCJF7_R9ac\";}s:2:\"id\";s:23:\"gin_primary_local_tasks\";s:5:\"theme\";s:3:\"gin\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:12:\"Primary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:1;s:9:\"secondary\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.128,1,'','0'),('block.block.gin_secondary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"d047e2b1-b291-453a-b9c7-a8a860344ebc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:3:\"gin\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BCWhood0xXFQYqxFgL1spXdb9KeIuXH1YvTdjIEedDg\";}s:2:\"id\";s:25:\"gin_secondary_local_tasks\";s:5:\"theme\";s:3:\"gin\";s:6:\"region\";s:11:\"pre_content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:14:\"Secondary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:0;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1680008715.128,1,'','0'),('block.block.notregrandblue_account_menu',_binary 'a:13:{s:4:\"uuid\";s:36:\"7c061b9e-6109-42a1-8996-fce9a084efec\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:19:\"system.menu.account\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"gmxYWWHmgbe0Pnv8y48ZLSLH5mEHejOjAP6RLxUfdzU\";}s:2:\"id\";s:27:\"notregrandblue_account_menu\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:8:\"disabled\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:25:\"system_menu_block:account\";s:8:\"settings\";a:7:{s:2:\"id\";s:25:\"system_menu_block:account\";s:5:\"label\";s:31:\"Menu du compte de l\'utilisateur\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:5:\"level\";i:1;s:5:\"depth\";i:1;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_breadcrumbs',_binary 'a:13:{s:4:\"uuid\";s:36:\"f23ce03c-d543-4ce7-8f5b-86700f66ac6e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VhBzWb7lMRtIOg9G7VSw_0uopi-7zXeHq4vXqqV1HFE\";}s:2:\"id\";s:26:\"notregrandblue_breadcrumbs\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:8:\"disabled\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_breadcrumb_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_breadcrumb_block\";s:5:\"label\";s:11:\"Breadcrumbs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"b69db18e-09e0-43c3-8a7c-3908b3a52893\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"erQSEZF2XUjNmgTl0uNRBzmg18ZGXwUcw2FhApoeuHk\";}s:2:\"id\";s:22:\"notregrandblue_content\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-8;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:17:\"Main page content\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_help',_binary 'a:13:{s:4:\"uuid\";s:36:\"eba2664d-9f2c-4eba-a29f-185bc5548a1c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:4:\"help\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VfPFqqxfkomud5CO8DUijw85QIl9GIxh_nIxLOYESxg\";}s:2:\"id\";s:19:\"notregrandblue_help\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:8:\"disabled\";s:6:\"weight\";i:-2;s:8:\"provider\";N;s:6:\"plugin\";s:10:\"help_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:10:\"help_block\";s:5:\"label\";s:4:\"Help\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"help\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_main_menu',_binary 'a:13:{s:4:\"uuid\";s:36:\"8075661e-7474-4d46-9292-fb6bc38a9b90\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:16:\"system.menu.main\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KWAiziL39uEzmOJEql_wbUP2RtqGceL3WM2CfxhMelE\";}s:2:\"id\";s:24:\"notregrandblue_main_menu\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:9:\"main_menu\";s:6:\"weight\";i:-7;s:8:\"provider\";N;s:6:\"plugin\";s:22:\"system_menu_block:main\";s:8:\"settings\";a:7:{s:2:\"id\";s:22:\"system_menu_block:main\";s:5:\"label\";s:21:\"Navigation principale\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:5:\"level\";i:1;s:5:\"depth\";i:2;s:16:\"expand_all_items\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_messages',_binary 'a:13:{s:4:\"uuid\";s:36:\"307a1ef6-681b-4607-8cbf-f335d98bd8b9\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BZ5tpW7H8X4PVGRm3MImTIHd2tN0eF7zOtp4SpRYUA0\";}s:2:\"id\";s:23:\"notregrandblue_messages\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:14:\"status_message\";s:6:\"weight\";i:-7;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:15:\"Status messages\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_page_title',_binary 'a:13:{s:4:\"uuid\";s:36:\"2ad2f134-fc66-4f13-9493-f5bf83af4ae2\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6aOgWsNTXjqrDm98TXSAjP6qd2nCijD1xw45MrnbK-Y\";}s:2:\"id\";s:25:\"notregrandblue_page_title\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:6:\"banner\";s:6:\"weight\";i:-7;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:10:\"Page title\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:3:{s:2:\"id\";s:12:\"request_path\";s:6:\"negate\";b:1;s:5:\"pages\";s:7:\"<front>\";}}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_powered',_binary 'a:13:{s:4:\"uuid\";s:36:\"2b92eed0-fc61-4d06-9639-b54b672457f5\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eYL19CLDyinGTWYQfBD1DswWzglEotE_kHnHx3AxTXM\";}s:2:\"id\";s:22:\"notregrandblue_powered\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:8:\"disabled\";s:6:\"weight\";i:-1;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_powered_by_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_powered_by_block\";s:5:\"label\";s:20:\"Propulsé par Drupal\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_primary_admin_actions',_binary 'a:13:{s:4:\"uuid\";s:36:\"c41da710-fb21-4261-8470-8506388920d9\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Q9_2whdOj1YIomfvsIfopROW4FT_X5pY0DjdOiOaQ5U\";}s:2:\"id\";s:36:\"notregrandblue_primary_admin_actions\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-11;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:21:\"Primary admin actions\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_primary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"5098b208-a490-4400-b1df-a4520447d80c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nGE3EoPQQaQCuqTUtZgw0-KIzmrqdKDzdNQf2JyPUt4\";}s:2:\"id\";s:34:\"notregrandblue_primary_local_tasks\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:12:\"Primary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:1;s:9:\"secondary\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_reseausociaux',_binary 'a:12:{s:4:\"uuid\";s:36:\"311f9a03-778c-4f8d-a78b-08f509b02e13\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:7:\"content\";a:1:{i:0;s:65:\"block_content:reseau_sociaux:bdccbeeb-1706-4265-887c-5d75a02a04d8\";}s:6:\"module\";a:1:{i:0;s:13:\"block_content\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:2:\"id\";s:28:\"notregrandblue_reseausociaux\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:6:\"footer\";s:6:\"weight\";i:-9;s:8:\"provider\";N;s:6:\"plugin\";s:50:\"block_content:bdccbeeb-1706-4265-887c-5d75a02a04d8\";s:8:\"settings\";a:7:{s:2:\"id\";s:50:\"block_content:bdccbeeb-1706-4265-887c-5d75a02a04d8\";s:5:\"label\";s:14:\"Reseau Sociaux\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:13:\"block_content\";s:6:\"status\";b:1;s:4:\"info\";s:0:\"\";s:9:\"view_mode\";s:4:\"full\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.096,1,'','0'),('block.block.notregrandblue_search_form_narrow',_binary 'a:13:{s:4:\"uuid\";s:36:\"25685796-3ff5-4f27-ba01-03edb9757788\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"search\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yEBET0cqDbk8dkWzaJw-8CKft0961VBflsISoSR6Lj8\";}s:2:\"id\";s:33:\"notregrandblue_search_form_narrow\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:8:\"disabled\";s:6:\"weight\";i:-6;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"search_form_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:17:\"search_form_block\";s:5:\"label\";s:33:\"Formulaire de recherche (étroit)\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"search\";s:7:\"page_id\";s:0:\"\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_search_form_wide',_binary 'a:13:{s:4:\"uuid\";s:36:\"25f0be38-06d8-4adf-a5e9-8969caef05dc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"search\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"imMyHD6LYci0gtXq56qr9ZKGHzbEG9uFydrN5EhKtSU\";}s:2:\"id\";s:31:\"notregrandblue_search_form_wide\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:8:\"disabled\";s:6:\"weight\";i:-7;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"search_form_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:17:\"search_form_block\";s:5:\"label\";s:31:\"Formulaire de recherche (large)\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"search\";s:7:\"page_id\";s:0:\"\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_secondary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"a04e1692-01c5-468d-88e0-6417e28810dc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ydSxdq7R66I8UMC460rOzlfzvlUL4VRbdwc6z9DWaUI\";}s:2:\"id\";s:36:\"notregrandblue_secondary_local_tasks\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-9;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:14:\"Secondary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:0;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_site_branding',_binary 'a:13:{s:4:\"uuid\";s:36:\"ce89b935-8807-4e75-90dd-3879eeeebd09\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"n_nlgjggHVfQt2H__zvLOKB2YtjPDbQ5tHijF9LE1aM\";}s:2:\"id\";s:28:\"notregrandblue_site_branding\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:15:\"system_branding\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_branding_block\";s:8:\"settings\";a:7:{s:2:\"id\";s:21:\"system_branding_block\";s:5:\"label\";s:17:\"Identité du site\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:13:\"use_site_logo\";b:1;s:13:\"use_site_name\";b:0;s:15:\"use_site_slogan\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.notregrandblue_syndicate',_binary 'a:13:{s:4:\"uuid\";s:36:\"702ba565-1e66-4b96-a162-c63b64c1a9cb\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0gq3VPg-_UM69FCCWurLFIrrnIjC2HLKhwo9iQNtcUo\";}s:2:\"id\";s:24:\"notregrandblue_syndicate\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:8:\"disabled\";s:6:\"weight\";i:-3;s:8:\"provider\";N;s:6:\"plugin\";s:20:\"node_syndicate_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:20:\"node_syndicate_block\";s:5:\"label\";s:8:\"Flux RSS\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"node\";s:11:\"block_count\";i:10;}s:10:\"visibility\";a:0:{}}',-1,1680008715.095,1,'','0'),('block.block.olivero_account_menu',_binary 'a:13:{s:4:\"uuid\";s:36:\"aeb41ffd-955f-4e2a-be62-1ef2f2837cc6\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:19:\"system.menu.account\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"gmxYWWHmgbe0Pnv8y48ZLSLH5mEHejOjAP6RLxUfdzU\";}s:2:\"id\";s:20:\"olivero_account_menu\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:14:\"secondary_menu\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:25:\"system_menu_block:account\";s:8:\"settings\";a:7:{s:2:\"id\";s:25:\"system_menu_block:account\";s:5:\"label\";s:31:\"Menu du compte de l\'utilisateur\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:5:\"level\";i:1;s:5:\"depth\";i:1;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_breadcrumbs',_binary 'a:13:{s:4:\"uuid\";s:36:\"eabe4a47-86d5-4b7c-8f56-18583a6f2550\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VhBzWb7lMRtIOg9G7VSw_0uopi-7zXeHq4vXqqV1HFE\";}s:2:\"id\";s:19:\"olivero_breadcrumbs\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:10:\"breadcrumb\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_breadcrumb_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_breadcrumb_block\";s:5:\"label\";s:11:\"Breadcrumbs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"7b424cf6-5f7c-4f81-b7a3-74d4f627bf37\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"erQSEZF2XUjNmgTl0uNRBzmg18ZGXwUcw2FhApoeuHk\";}s:2:\"id\";s:15:\"olivero_content\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"system_main_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:17:\"system_main_block\";s:5:\"label\";s:17:\"Main page content\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_help',_binary 'a:13:{s:4:\"uuid\";s:36:\"3734eec8-9a18-414b-ad7d-d39bd8dec65b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:4:\"help\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VfPFqqxfkomud5CO8DUijw85QIl9GIxh_nIxLOYESxg\";}s:2:\"id\";s:12:\"olivero_help\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:13:\"content_above\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:10:\"help_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:10:\"help_block\";s:5:\"label\";s:4:\"Help\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"help\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_main_menu',_binary 'a:13:{s:4:\"uuid\";s:36:\"164731c7-34d0-4160-8200-085973fb7c22\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:16:\"system.menu.main\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KWAiziL39uEzmOJEql_wbUP2RtqGceL3WM2CfxhMelE\";}s:2:\"id\";s:17:\"olivero_main_menu\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:12:\"primary_menu\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:22:\"system_menu_block:main\";s:8:\"settings\";a:7:{s:2:\"id\";s:22:\"system_menu_block:main\";s:5:\"label\";s:21:\"Navigation principale\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:5:\"level\";i:1;s:5:\"depth\";i:2;s:16:\"expand_all_items\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_messages',_binary 'a:13:{s:4:\"uuid\";s:36:\"cde83f82-479e-4aae-80a2-28d89bbfa99d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BZ5tpW7H8X4PVGRm3MImTIHd2tN0eF7zOtp4SpRYUA0\";}s:2:\"id\";s:16:\"olivero_messages\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_messages_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:21:\"system_messages_block\";s:5:\"label\";s:15:\"Status messages\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_page_title',_binary 'a:13:{s:4:\"uuid\";s:36:\"ef3af927-ae25-400f-9d04-380421511cab\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6aOgWsNTXjqrDm98TXSAjP6qd2nCijD1xw45MrnbK-Y\";}s:2:\"id\";s:18:\"olivero_page_title\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:13:\"content_above\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:16:\"page_title_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:16:\"page_title_block\";s:5:\"label\";s:10:\"Page title\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_powered',_binary 'a:13:{s:4:\"uuid\";s:36:\"3e620e55-3673-4f69-b666-aa4460d32a6b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eYL19CLDyinGTWYQfBD1DswWzglEotE_kHnHx3AxTXM\";}s:2:\"id\";s:15:\"olivero_powered\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:13:\"footer_bottom\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:23:\"system_powered_by_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:23:\"system_powered_by_block\";s:5:\"label\";s:20:\"Propulsé par Drupal\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_primary_admin_actions',_binary 'a:13:{s:4:\"uuid\";s:36:\"7811e90d-7ee5-42cd-828c-9f58d6ad8534\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Q9_2whdOj1YIomfvsIfopROW4FT_X5pY0DjdOiOaQ5U\";}s:2:\"id\";s:29:\"olivero_primary_admin_actions\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:19:\"local_actions_block\";s:8:\"settings\";a:4:{s:2:\"id\";s:19:\"local_actions_block\";s:5:\"label\";s:21:\"Primary admin actions\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_primary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"16f95099-8216-47e2-8763-0113ed134f59\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nGE3EoPQQaQCuqTUtZgw0-KIzmrqdKDzdNQf2JyPUt4\";}s:2:\"id\";s:27:\"olivero_primary_local_tasks\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:12:\"Primary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:1;s:9:\"secondary\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_search_form_narrow',_binary 'a:13:{s:4:\"uuid\";s:36:\"09ba6e8b-8efa-4d35-9dc3-1fa1d5d41cab\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"search\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yEBET0cqDbk8dkWzaJw-8CKft0961VBflsISoSR6Lj8\";}s:2:\"id\";s:26:\"olivero_search_form_narrow\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:12:\"primary_menu\";s:6:\"weight\";i:-4;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"search_form_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:17:\"search_form_block\";s:5:\"label\";s:33:\"Formulaire de recherche (étroit)\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"search\";s:7:\"page_id\";s:0:\"\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_search_form_wide',_binary 'a:13:{s:4:\"uuid\";s:36:\"8d618102-48e1-4864-9e17-91d0227d1a40\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"search\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"imMyHD6LYci0gtXq56qr9ZKGHzbEG9uFydrN5EhKtSU\";}s:2:\"id\";s:24:\"olivero_search_form_wide\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:14:\"secondary_menu\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"search_form_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:17:\"search_form_block\";s:5:\"label\";s:31:\"Formulaire de recherche (large)\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"search\";s:7:\"page_id\";s:0:\"\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_secondary_local_tasks',_binary 'a:13:{s:4:\"uuid\";s:36:\"8eca8bcd-cf3f-489a-9cdc-e6c6e3389cb2\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ydSxdq7R66I8UMC460rOzlfzvlUL4VRbdwc6z9DWaUI\";}s:2:\"id\";s:29:\"olivero_secondary_local_tasks\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:11:\"highlighted\";s:6:\"weight\";i:-2;s:8:\"provider\";N;s:6:\"plugin\";s:17:\"local_tasks_block\";s:8:\"settings\";a:6:{s:2:\"id\";s:17:\"local_tasks_block\";s:5:\"label\";s:14:\"Secondary tabs\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"core\";s:7:\"primary\";b:0;s:9:\"secondary\";b:1;}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_site_branding',_binary 'a:13:{s:4:\"uuid\";s:36:\"bf93241a-26f2-487c-9b37-4113b9ac3106\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"n_nlgjggHVfQt2H__zvLOKB2YtjPDbQ5tHijF9LE1aM\";}s:2:\"id\";s:21:\"olivero_site_branding\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:6:\"header\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:21:\"system_branding_block\";s:8:\"settings\";a:7:{s:2:\"id\";s:21:\"system_branding_block\";s:5:\"label\";s:17:\"Identité du site\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:13:\"use_site_logo\";b:1;s:13:\"use_site_name\";b:1;s:15:\"use_site_slogan\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.olivero_syndicate',_binary 'a:13:{s:4:\"uuid\";s:36:\"ae17fb02-8800-4f25-a56e-06c82913574a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0gq3VPg-_UM69FCCWurLFIrrnIjC2HLKhwo9iQNtcUo\";}s:2:\"id\";s:17:\"olivero_syndicate\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:6:\"social\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:20:\"node_syndicate_block\";s:8:\"settings\";a:5:{s:2:\"id\";s:20:\"node_syndicate_block\";s:5:\"label\";s:8:\"Flux RSS\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:4:\"node\";s:11:\"block_count\";i:10;}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.pieddepage',_binary 'a:12:{s:4:\"uuid\";s:36:\"9331c377-8e87-4fd0-92f4-93029c99534a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:18:\"system.menu.footer\";}s:6:\"module\";a:1:{i:0;s:6:\"system\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:2:\"id\";s:10:\"pieddepage\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:6:\"footer\";s:6:\"weight\";i:-10;s:8:\"provider\";N;s:6:\"plugin\";s:24:\"system_menu_block:footer\";s:8:\"settings\";a:7:{s:2:\"id\";s:24:\"system_menu_block:footer\";s:5:\"label\";s:12:\"Pied de page\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:6:\"system\";s:5:\"level\";i:1;s:5:\"depth\";i:0;s:16:\"expand_all_items\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.096,1,'','0'),('block.block.reseausociaux',_binary 'a:12:{s:4:\"uuid\";s:36:\"c2213a7f-8ff4-42a0-9a91-95ef7f748f47\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:7:\"content\";a:1:{i:0;s:65:\"block_content:reseau_sociaux:bdccbeeb-1706-4265-887c-5d75a02a04d8\";}s:6:\"module\";a:1:{i:0;s:13:\"block_content\";}s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}s:2:\"id\";s:13:\"reseausociaux\";s:5:\"theme\";s:7:\"olivero\";s:6:\"region\";s:10:\"footer_top\";s:6:\"weight\";i:0;s:8:\"provider\";N;s:6:\"plugin\";s:50:\"block_content:bdccbeeb-1706-4265-887c-5d75a02a04d8\";s:8:\"settings\";a:7:{s:2:\"id\";s:50:\"block_content:bdccbeeb-1706-4265-887c-5d75a02a04d8\";s:5:\"label\";s:14:\"Reseau Sociaux\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:13:\"block_content\";s:6:\"status\";b:1;s:4:\"info\";s:0:\"\";s:9:\"view_mode\";s:4:\"full\";}s:10:\"visibility\";a:0:{}}',-1,1680008715.074,1,'','0'),('block.block.views_block__partenaire_block_1',_binary 'a:12:{s:4:\"uuid\";s:36:\"c148bc88-f2d6-4185-b235-2b8ad02dec1f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:21:\"views.view.partenaire\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:2:\"id\";s:31:\"views_block__partenaire_block_1\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-5;s:8:\"provider\";N;s:6:\"plugin\";s:30:\"views_block:partenaire-block_1\";s:8:\"settings\";a:6:{s:2:\"id\";s:30:\"views_block:partenaire-block_1\";s:5:\"label\";s:0:\"\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:5:\"views\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:3:{s:2:\"id\";s:12:\"request_path\";s:6:\"negate\";b:1;s:5:\"pages\";s:12:\"/partenaires\";}}}',-1,1680008715.096,1,'','0'),('block.block.views_block__temoignage_block_1',_binary 'a:12:{s:4:\"uuid\";s:36:\"72bf04ce-bc3b-4d00-b3ec-2d859486faf9\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:21:\"views.view.temoignage\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:5:\"views\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:2:\"id\";s:31:\"views_block__temoignage_block_1\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:7:\"content\";s:6:\"weight\";i:-7;s:8:\"provider\";N;s:6:\"plugin\";s:30:\"views_block:temoignage-block_1\";s:8:\"settings\";a:6:{s:2:\"id\";s:30:\"views_block:temoignage-block_1\";s:5:\"label\";s:0:\"\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:5:\"views\";s:11:\"views_label\";s:0:\"\";s:14:\"items_per_page\";s:4:\"none\";}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:3:{s:2:\"id\";s:12:\"request_path\";s:6:\"negate\";b:0;s:5:\"pages\";s:7:\"<front>\";}}}',-1,1680008715.096,1,'','0'),('block.block.webform',_binary 'a:12:{s:4:\"uuid\";s:36:\"2e63ca9d-3c8d-4790-8c1a-fb8ac961b7ea\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:23:\"webform.webform.contact\";}s:6:\"module\";a:2:{i:0;s:6:\"system\";i:1;s:7:\"webform\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:2:\"id\";s:7:\"webform\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:14:\"content_bottom\";s:6:\"weight\";i:-9;s:8:\"provider\";N;s:6:\"plugin\";s:13:\"webform_block\";s:8:\"settings\";a:7:{s:2:\"id\";s:13:\"webform_block\";s:5:\"label\";s:7:\"Webform\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:7:\"webform\";s:10:\"webform_id\";s:7:\"contact\";s:12:\"default_data\";s:0:\"\";s:8:\"redirect\";b:0;}s:10:\"visibility\";a:1:{s:12:\"request_path\";a:3:{s:2:\"id\";s:12:\"request_path\";s:6:\"negate\";b:0;s:5:\"pages\";s:16:\"<front>\r\n/node/1\";}}}',-1,1680008715.096,1,'','0'),('block.block.webform_2',_binary 'a:12:{s:4:\"uuid\";s:36:\"897fa8a6-a012-4068-a321-df4775582465\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:1:{i:0;s:26:\"webform.webform.newsletter\";}s:6:\"module\";a:1:{i:0;s:7:\"webform\";}s:5:\"theme\";a:1:{i:0;s:14:\"notregrandblue\";}}s:2:\"id\";s:9:\"webform_2\";s:5:\"theme\";s:14:\"notregrandblue\";s:6:\"region\";s:14:\"content_bottom\";s:6:\"weight\";i:-8;s:8:\"provider\";N;s:6:\"plugin\";s:13:\"webform_block\";s:8:\"settings\";a:7:{s:2:\"id\";s:13:\"webform_block\";s:5:\"label\";s:7:\"Webform\";s:13:\"label_display\";s:1:\"0\";s:8:\"provider\";s:7:\"webform\";s:10:\"webform_id\";s:10:\"newsletter\";s:12:\"default_data\";s:0:\"\";s:8:\"redirect\";b:0;}s:10:\"visibility\";a:0:{}}',-1,1680008715.096,1,'','0'),('block_content.type.banner',_binary 'a:8:{s:4:\"uuid\";s:36:\"da8965e8-96c6-4698-accd-4dc405bd9982\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:6:\"banner\";s:5:\"label\";s:6:\"Banner\";s:8:\"revision\";i:0;s:11:\"description\";s:0:\"\";}',-1,1680008716.418,1,'','0'),('block_content.type.basic',_binary 'a:9:{s:4:\"uuid\";s:36:\"e1ab0d6d-e5d2-4cd8-82df-2c2bc0a5c228\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zglzjmYxi0G0ag9MZ02y0LSJOdpWRwJxyP_OvFojFyo\";}s:2:\"id\";s:5:\"basic\";s:5:\"label\";s:11:\"Bloc simple\";s:8:\"revision\";i:0;s:11:\"description\";s:45:\"Un bloc simple contient un titre et un corps.\";}',-1,1680008716.418,1,'','0'),('block_content.type.block_content',_binary 'a:8:{s:4:\"uuid\";s:36:\"ea6f1c3e-6e9a-4db6-96c0-9a88aa7418bd\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:13:\"block_content\";s:5:\"label\";s:13:\"Block Content\";s:8:\"revision\";i:0;s:11:\"description\";s:0:\"\";}',-1,1680008716.418,1,'','0'),('block_content.type.reseau_sociaux',_binary 'a:8:{s:4:\"uuid\";s:36:\"bb2cb6f0-209b-40c5-9be9-ed68a7147d89\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:14:\"reseau_sociaux\";s:5:\"label\";s:14:\"Reseau Sociaux\";s:8:\"revision\";i:0;s:11:\"description\";s:0:\"\";}',-1,1680008716.418,1,'','0'),('comment.type.comment',_binary 'a:9:{s:4:\"uuid\";s:36:\"876ac117-f0de-4b6f-900a-6d9d5f3cfaa8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"bqZsN31T2n0UjcbyCpOPi9D2iO0sAOHR7FnEs9qMvaA\";}s:2:\"id\";s:7:\"comment\";s:5:\"label\";s:24:\"Commentaires par défaut\";s:21:\"target_entity_type_id\";s:4:\"node\";s:11:\"description\";s:32:\"Autorise à commenter le contenu\";}',-1,1680008716.429,1,'','0'),('contact.form.feedback',_binary 'a:12:{s:4:\"uuid\";s:36:\"73baae7f-f8b8-44d2-a828-bef39effefb5\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vymHlgJy26BuI5GGj9-IXjwR3dRC5C0tij4BpWJnoqw\";}s:2:\"id\";s:8:\"feedback\";s:5:\"label\";s:36:\"Retours utilisateurs sur le site web\";s:10:\"recipients\";a:1:{i:0;s:23:\"ridha.rahmi13@gmail.com\";}s:5:\"reply\";s:0:\"\";s:6:\"weight\";i:0;s:7:\"message\";s:27:\"Your message has been sent.\";s:8:\"redirect\";s:0:\"\";}',-1,1680008716.443,1,'','0'),('contact.form.personal',_binary 'a:12:{s:4:\"uuid\";s:36:\"ed2e284a-0305-4016-943b-d14ccf634c78\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jonvgt3CkUM2eMLTFwWfHileWWDC4YtXCuIlCahTk_I\";}s:2:\"id\";s:8:\"personal\";s:5:\"label\";s:31:\"Formulaire de contact personnel\";s:10:\"recipients\";a:0:{}s:5:\"reply\";s:0:\"\";s:6:\"weight\";i:0;s:7:\"message\";s:27:\"Your message has been sent.\";s:8:\"redirect\";s:0:\"\";}',-1,1680008716.443,1,'','0'),('core.base_field_override.block_content.banner.changed',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.default_langcode',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.id',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.info',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.langcode',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.metatag',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.reusable',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.revision_created',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.revision_default',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.revision_id',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.revision_log',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.revision_translation_affected',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.revision_user',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.status',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.type',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.banner.uuid',_binary 'b:0;',-1,1680008717.396,1,'','0'),('core.base_field_override.block_content.basic.changed',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.default_langcode',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.id',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.info',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.langcode',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.metatag',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.reusable',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.revision_created',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.revision_default',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.revision_id',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.revision_log',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.revision_translation_affected',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.revision_user',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.status',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.type',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.basic.uuid',_binary 'b:0;',-1,1680008717.426,1,'','0'),('core.base_field_override.block_content.block_content.changed',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.default_langcode',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.id',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.info',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.langcode',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.metatag',_binary 'b:0;',-1,1680008717.453,1,'','0'),('core.base_field_override.block_content.block_content.reusable',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.revision_created',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.revision_default',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.revision_id',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.revision_log',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.revision_translation_affected',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.revision_user',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.status',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.type',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.block_content.uuid',_binary 'b:0;',-1,1680008717.452,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.changed',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.default_langcode',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.id',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.info',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.langcode',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.metatag',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.reusable',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.revision_created',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.revision_default',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.revision_id',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.revision_log',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.revision_translation_affected',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.revision_user',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.status',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.type',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.block_content.reseau_sociaux.uuid',_binary 'b:0;',-1,1680008717.489,1,'','0'),('core.base_field_override.comment.comment.changed',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.cid',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.comment_type',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.created',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.default_langcode',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.entity_id',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.entity_type',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.field_name',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.homepage',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.hostname',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.langcode',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.mail',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.name',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.pid',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.status',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.subject',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.thread',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.uid',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.comment.comment.uuid',_binary 'b:0;',-1,1680008717.566,1,'','0'),('core.base_field_override.contact_message.feedback.contact_form',_binary 'b:0;',-1,1680009095.453,1,'','0'),('core.base_field_override.contact_message.feedback.copy',_binary 'b:0;',-1,1680009095.453,1,'','0'),('core.base_field_override.contact_message.feedback.langcode',_binary 'b:0;',-1,1680009095.453,1,'','0'),('core.base_field_override.contact_message.feedback.mail',_binary 'b:0;',-1,1680009095.453,1,'','0'),('core.base_field_override.contact_message.feedback.message',_binary 'b:0;',-1,1680009095.453,1,'','0'),('core.base_field_override.contact_message.feedback.name',_binary 'b:0;',-1,1680009095.453,1,'','0'),('core.base_field_override.contact_message.feedback.recipient',_binary 'b:0;',-1,1680009095.453,1,'','0'),('core.base_field_override.contact_message.feedback.subject',_binary 'b:0;',-1,1680009095.453,1,'','0'),('core.base_field_override.contact_message.feedback.uuid',_binary 'b:0;',-1,1680009095.453,1,'','0'),('core.base_field_override.contact_message.personal.contact_form',_binary 'b:0;',-1,1680009095.468,1,'','0'),('core.base_field_override.contact_message.personal.copy',_binary 'b:0;',-1,1680009095.468,1,'','0'),('core.base_field_override.contact_message.personal.langcode',_binary 'b:0;',-1,1680009095.468,1,'','0'),('core.base_field_override.contact_message.personal.mail',_binary 'b:0;',-1,1680009095.468,1,'','0'),('core.base_field_override.contact_message.personal.message',_binary 'b:0;',-1,1680009095.468,1,'','0'),('core.base_field_override.contact_message.personal.name',_binary 'b:0;',-1,1680009095.468,1,'','0'),('core.base_field_override.contact_message.personal.recipient',_binary 'b:0;',-1,1680009095.468,1,'','0'),('core.base_field_override.contact_message.personal.subject',_binary 'b:0;',-1,1680009095.468,1,'','0'),('core.base_field_override.contact_message.personal.uuid',_binary 'b:0;',-1,1680009095.468,1,'','0'),('core.base_field_override.file.file.changed',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.created',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.fid',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.filemime',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.filename',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.filesize',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.langcode',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.status',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.uid',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.uri',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.file.file.uuid',_binary 'b:0;',-1,1680008719.735,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.bundle',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.changed',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.default_langcode',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.description',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.enabled',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.expanded',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.external',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.id',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.langcode',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.link',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.menu_name',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.metatag',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.parent',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.rediscover',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_created',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_default',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_id',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_log_message',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_translation_affected',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.revision_user',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.title',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.uuid',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.menu_link_content.menu_link_content.weight',_binary 'b:0;',-1,1680008717.932,1,'','0'),('core.base_field_override.node.article.changed',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.created',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.default_langcode',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.langcode',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.menu_link',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.metatag',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.nid',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.path',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.promote',_binary 'a:16:{s:4:\"uuid\";s:36:\"4f1b9ac5-1961-40f0-bc3a-d1261e5346a6\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:17:\"node.type.article\";}}s:2:\"id\";s:20:\"node.article.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:22:\"Promoted to front page\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.revision_default',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.revision_log',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.revision_timestamp',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.revision_translation_affected',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.revision_uid',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.status',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.sticky',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.title',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.type',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.uid',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.uuid',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.article.vid',_binary 'b:0;',-1,1680008717.677,1,'','0'),('core.base_field_override.node.formation.changed',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.created',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.default_langcode',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.langcode',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.menu_link',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.metatag',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.nid',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.path',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.promote',_binary 'a:16:{s:4:\"uuid\";s:36:\"64574ef1-69dc-424b-a3b4-2a9ea7e1087c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:19:\"node.type.formation\";}}s:2:\"id\";s:22:\"node.formation.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:5:\"label\";s:22:\"Promoted to front page\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.revision_default',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.revision_log',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.revision_timestamp',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.revision_translation_affected',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.revision_uid',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.status',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.sticky',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.title',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.type',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.uid',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.uuid',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.formation.vid',_binary 'b:0;',-1,1680008717.716,1,'','0'),('core.base_field_override.node.offres_emploi.changed',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.created',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.default_langcode',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.langcode',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.menu_link',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.metatag',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.nid',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.path',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.promote',_binary 'a:16:{s:4:\"uuid\";s:36:\"993a9f41-9248-4be5-afb6-28293558b3e8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:23:\"node.type.offres_emploi\";}}s:2:\"id\";s:26:\"node.offres_emploi.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:13:\"offres_emploi\";s:5:\"label\";s:22:\"Promoted to front page\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.revision_default',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.revision_log',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.revision_timestamp',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.revision_translation_affected',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.revision_uid',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.status',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.sticky',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.title',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.type',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.uid',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.uuid',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.offres_emploi.vid',_binary 'b:0;',-1,1680008717.755,1,'','0'),('core.base_field_override.node.page.changed',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.created',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.default_langcode',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.langcode',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.menu_link',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.metatag',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.nid',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.path',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.promote',_binary 'a:17:{s:4:\"uuid\";s:36:\"84b882d2-7416-4db2-9319-6b7853a52aef\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:14:\"node.type.page\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fPUEnm4T5zfZRr3ttDUqq7yCDd2uW3clWD-pvos4tlQ\";}s:2:\"id\";s:17:\"node.page.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:22:\"Promoted to front page\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.revision_default',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.revision_log',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.revision_timestamp',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.revision_translation_affected',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.revision_uid',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.status',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.sticky',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.title',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.type',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.uid',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.uuid',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.page.vid',_binary 'b:0;',-1,1680008717.790,1,'','0'),('core.base_field_override.node.partenaire.changed',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.created',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.default_langcode',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.langcode',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.menu_link',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.metatag',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.nid',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.path',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.promote',_binary 'a:16:{s:4:\"uuid\";s:36:\"31b39589-115a-4594-8dd2-ffc638f1ad34\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:20:\"node.type.partenaire\";}}s:2:\"id\";s:23:\"node.partenaire.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:10:\"partenaire\";s:5:\"label\";s:22:\"Promoted to front page\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.revision_default',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.revision_log',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.revision_timestamp',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.revision_translation_affected',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.revision_uid',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.status',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.sticky',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.title',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.type',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.uid',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.uuid',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.partenaire.vid',_binary 'b:0;',-1,1680008717.830,1,'','0'),('core.base_field_override.node.rapport.changed',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.created',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.default_langcode',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.langcode',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.menu_link',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.metatag',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.nid',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.path',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.promote',_binary 'a:16:{s:4:\"uuid\";s:36:\"1ba3a53f-4d45-48fe-9a98-7d8868c59801\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:17:\"node.type.rapport\";}}s:2:\"id\";s:20:\"node.rapport.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"rapport\";s:5:\"label\";s:22:\"Promoted to front page\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.revision_default',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.revision_log',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.revision_timestamp',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.revision_translation_affected',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.revision_uid',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.status',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.sticky',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.title',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.type',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.uid',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.uuid',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.rapport.vid',_binary 'b:0;',-1,1680008717.864,1,'','0'),('core.base_field_override.node.temoignage.changed',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.created',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.default_langcode',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.langcode',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.menu_link',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.metatag',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.nid',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.path',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.promote',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.revision_default',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.revision_log',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.revision_timestamp',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.revision_translation_affected',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.revision_uid',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.status',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.sticky',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.title',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.type',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.uid',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.uuid',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.temoignage.vid',_binary 'b:0;',-1,1680008717.901,1,'','0'),('core.base_field_override.node.webform.changed',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.created',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.default_langcode',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.langcode',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.menu_link',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.metatag',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.nid',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.path',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.promote',_binary 'a:17:{s:4:\"uuid\";s:36:\"bae1ab3e-eec6-4f0c-8097-6df5330c599c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:1:{i:0;s:17:\"node.type.webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FvXJkxryo6J_0TQRlb5Z77Ge-sim5GHzCI1Ft3kZu-4\";}s:2:\"id\";s:20:\"node.webform.promote\";s:10:\"field_name\";s:7:\"promote\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"webform\";s:5:\"label\";s:22:\"Promoted to front page\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:1:{s:5:\"value\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:8:\"on_label\";s:2:\"On\";s:9:\"off_label\";s:3:\"Off\";}s:10:\"field_type\";s:7:\"boolean\";}',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.revision_default',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.revision_log',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.revision_timestamp',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.revision_translation_affected',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.revision_uid',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.status',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.sticky',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.title',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.type',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.uid',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.uuid',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.node.webform.vid',_binary 'b:0;',-1,1680008717.941,1,'','0'),('core.base_field_override.paragraph.block_cta.behavior_settings',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.created',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.default_langcode',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.id',_binary 'b:0;',-1,1680008718.013,1,'','0'),('core.base_field_override.paragraph.block_cta.langcode',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.parent_field_name',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.parent_id',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.parent_type',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.revision_default',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.revision_id',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.revision_translation_affected',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.status',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.type',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_cta.uuid',_binary 'b:0;',-1,1680008718.014,1,'','0'),('core.base_field_override.paragraph.block_text_image.behavior_settings',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.created',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.default_langcode',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.id',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.langcode',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.parent_field_name',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.parent_id',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.parent_type',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.revision_default',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.revision_id',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.revision_translation_affected',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.status',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.type',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.block_text_image.uuid',_binary 'b:0;',-1,1680008718.042,1,'','0'),('core.base_field_override.paragraph.composant_content.behavior_settings',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.created',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.default_langcode',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.id',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.langcode',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.parent_field_name',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.parent_id',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.parent_type',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.revision_default',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.revision_id',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.revision_translation_affected',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.status',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.type',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_content.uuid',_binary 'b:0;',-1,1680008718.063,1,'','0'),('core.base_field_override.paragraph.composant_text.behavior_settings',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.created',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.default_langcode',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.id',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.langcode',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.parent_field_name',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.parent_id',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.parent_type',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.revision_default',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.revision_id',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.revision_translation_affected',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.status',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.type',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.composant_text.uuid',_binary 'b:0;',-1,1680008718.097,1,'','0'),('core.base_field_override.paragraph.content.behavior_settings',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.created',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.default_langcode',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.id',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.langcode',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.parent_field_name',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.parent_id',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.parent_type',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.revision_default',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.revision_id',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.revision_translation_affected',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.status',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.type',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.content.uuid',_binary 'b:0;',-1,1680008718.118,1,'','0'),('core.base_field_override.paragraph.equipe.behavior_settings',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.created',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.default_langcode',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.id',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.langcode',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.parent_field_name',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.parent_id',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.parent_type',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.revision_default',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.revision_id',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.revision_translation_affected',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.status',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.type',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipe.uuid',_binary 'b:0;',-1,1680008718.140,1,'','0'),('core.base_field_override.paragraph.equipes.behavior_settings',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.created',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.default_langcode',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.id',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.langcode',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.parent_field_name',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.parent_id',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.parent_type',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.revision_default',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.revision_id',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.revision_translation_affected',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.status',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.type',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.equipes.uuid',_binary 'b:0;',-1,1680008718.164,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.behavior_settings',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.created',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.default_langcode',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.id',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.langcode',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.parent_field_name',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.parent_id',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.parent_type',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.revision_default',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.revision_id',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.revision_translation_affected',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.status',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.type',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.paragraph.reseau_sociaux.uuid',_binary 'b:0;',-1,1680008718.185,1,'','0'),('core.base_field_override.path_alias.path_alias.alias',_binary 'b:0;',-1,1680009095.564,1,'','0'),('core.base_field_override.path_alias.path_alias.id',_binary 'b:0;',-1,1680009095.564,1,'','0'),('core.base_field_override.path_alias.path_alias.langcode',_binary 'b:0;',-1,1680009095.564,1,'','0'),('core.base_field_override.path_alias.path_alias.path',_binary 'b:0;',-1,1680009095.564,1,'','0'),('core.base_field_override.path_alias.path_alias.revision_default',_binary 'b:0;',-1,1680009095.564,1,'','0'),('core.base_field_override.path_alias.path_alias.revision_id',_binary 'b:0;',-1,1680009095.564,1,'','0'),('core.base_field_override.path_alias.path_alias.status',_binary 'b:0;',-1,1680009095.564,1,'','0'),('core.base_field_override.path_alias.path_alias.uuid',_binary 'b:0;',-1,1680009095.564,1,'','0'),('core.base_field_override.shortcut.default.default_langcode',_binary 'b:0;',-1,1680008724.438,1,'','0'),('core.base_field_override.shortcut.default.id',_binary 'b:0;',-1,1680008724.438,1,'','0'),('core.base_field_override.shortcut.default.langcode',_binary 'b:0;',-1,1680008724.438,1,'','0'),('core.base_field_override.shortcut.default.link',_binary 'b:0;',-1,1680008724.438,1,'','0'),('core.base_field_override.shortcut.default.metatag',_binary 'b:0;',-1,1680008724.438,1,'','0'),('core.base_field_override.shortcut.default.shortcut_set',_binary 'b:0;',-1,1680008724.438,1,'','0'),('core.base_field_override.shortcut.default.title',_binary 'b:0;',-1,1680008724.438,1,'','0'),('core.base_field_override.shortcut.default.uuid',_binary 'b:0;',-1,1680008724.438,1,'','0'),('core.base_field_override.shortcut.default.weight',_binary 'b:0;',-1,1680008724.438,1,'','0'),('core.base_field_override.taxonomy_term.categories.changed',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.default_langcode',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.description',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.langcode',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.metatag',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.name',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.parent',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.path',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.revision_created',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.revision_default',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.revision_id',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.revision_log_message',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.revision_translation_affected',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.revision_user',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.status',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.tid',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.uuid',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.vid',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.categories.weight',_binary 'b:0;',-1,1680009129.034,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.changed',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.default_langcode',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.description',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.langcode',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.metatag',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.name',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.parent',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.path',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.revision_created',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.revision_default',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.revision_id',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.revision_log_message',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.revision_translation_affected',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.revision_user',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.status',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.tid',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.uuid',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.vid',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.taxonomy_term.type_rapport.weight',_binary 'b:0;',-1,1680009139.883,1,'','0'),('core.base_field_override.user.user.access',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.changed',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.created',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.default_langcode',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.init',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.langcode',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.login',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.mail',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.metatag',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.name',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.pass',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.path',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.preferred_admin_langcode',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.preferred_langcode',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.roles',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.status',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.timezone',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.uid',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.user.user.uuid',_binary 'b:0;',-1,1680008718.223,1,'','0'),('core.base_field_override.webform_submission.adhesion.changed',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.completed',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.created',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.current_page',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.entity_id',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.entity_type',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.in_draft',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.langcode',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.locked',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.metatag',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.notes',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.remote_addr',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.serial',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.sid',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.sticky',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.token',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.uid',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.uri',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.uuid',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.adhesion.webform_id',_binary 'b:0;',-1,1680009161.962,1,'','0'),('core.base_field_override.webform_submission.contact.changed',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.completed',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.created',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.current_page',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.entity_id',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.entity_type',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.in_draft',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.langcode',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.locked',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.metatag',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.notes',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.remote_addr',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.serial',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.sid',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.sticky',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.token',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.uid',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.uri',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.uuid',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.contact.webform_id',_binary 'b:0;',-1,1680009186.371,1,'','0'),('core.base_field_override.webform_submission.newsletter.changed',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.completed',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.created',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.current_page',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.entity_id',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.entity_type',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.in_draft',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.langcode',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.locked',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.metatag',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.notes',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.remote_addr',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.serial',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.sid',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.sticky',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.token',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.uid',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.uri',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.uuid',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.newsletter.webform_id',_binary 'b:0;',-1,1680008723.791,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.changed',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.completed',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.created',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.current_page',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.entity_id',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.entity_type',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.in_draft',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.langcode',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.locked',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.metatag',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.notes',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.remote_addr',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.serial',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.sid',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.sticky',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.token',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.uid',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.uri',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.uuid',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.base_field_override.webform_submission.offre_d_emploi.webform_id',_binary 'b:0;',-1,1680009177.891,1,'','0'),('core.date_format.fallback',_binary 'a:9:{s:4:\"uuid\";s:36:\"ba327d83-a0d3-47d7-b45f-96cf9b5208e1\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE\";}s:2:\"id\";s:8:\"fallback\";s:5:\"label\";s:23:\"Format de date de repli\";s:6:\"locked\";b:1;s:7:\"pattern\";s:14:\"D, m/d/Y - H:i\";}',-1,1680009095.346,1,'','0'),('core.date_format.html_date',_binary 'a:9:{s:4:\"uuid\";s:36:\"b15aa521-4823-4481-b29a-612186eb569b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk\";}s:2:\"id\";s:9:\"html_date\";s:5:\"label\";s:9:\"Date HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:5:\"Y-m-d\";}',-1,1680008716.388,1,'','0'),('core.date_format.html_datetime',_binary 'a:9:{s:4:\"uuid\";s:36:\"19876f7d-a880-4c61-9380-5771f37992fc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE\";}s:2:\"id\";s:13:\"html_datetime\";s:5:\"label\";s:18:\"Date et heure HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:13:\"Y-m-d\\TH:i:sO\";}',-1,1680009095.346,1,'','0'),('core.date_format.html_month',_binary 'a:9:{s:4:\"uuid\";s:36:\"6024442c-686b-419b-b8c2-1ce8382a1cd5\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM\";}s:2:\"id\";s:10:\"html_month\";s:5:\"label\";s:9:\"Mois HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:3:\"Y-m\";}',-1,1680009095.347,1,'','0'),('core.date_format.html_time',_binary 'a:9:{s:4:\"uuid\";s:36:\"f60bdad0-c514-4c6d-ad5d-e9d4add83f57\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE\";}s:2:\"id\";s:9:\"html_time\";s:5:\"label\";s:10:\"Heure HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:5:\"H:i:s\";}',-1,1680008716.396,1,'','0'),('core.date_format.html_week',_binary 'a:9:{s:4:\"uuid\";s:36:\"ba5fa824-dd31-48e1-8c51-eb97e9071ca5\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY\";}s:2:\"id\";s:9:\"html_week\";s:5:\"label\";s:12:\"Semaine HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:5:\"Y-\\WW\";}',-1,1680009095.347,1,'','0'),('core.date_format.html_year',_binary 'a:9:{s:4:\"uuid\";s:36:\"cd1724c1-005f-4878-a8b4-def6a6dd5cab\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk\";}s:2:\"id\";s:9:\"html_year\";s:5:\"label\";s:11:\"Année HTML\";s:6:\"locked\";b:1;s:7:\"pattern\";s:1:\"Y\";}',-1,1680009095.347,1,'','0'),('core.date_format.html_yearless_date',_binary 'a:9:{s:4:\"uuid\";s:36:\"e6b9616b-fc2a-4823-8cd3-15e730ef0c32\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc\";}s:2:\"id\";s:18:\"html_yearless_date\";s:5:\"label\";s:21:\"Date HTML sans année\";s:6:\"locked\";b:1;s:7:\"pattern\";s:3:\"m-d\";}',-1,1680009095.347,1,'','0'),('core.date_format.long',_binary 'a:9:{s:4:\"uuid\";s:36:\"16688b33-540e-49ab-a3bd-2a96aea19800\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo\";}s:2:\"id\";s:4:\"long\";s:5:\"label\";s:23:\"Date longue par défaut\";s:6:\"locked\";b:0;s:7:\"pattern\";s:13:\"l j F Y - H:i\";}',-1,1680009095.046,1,'','0'),('core.date_format.medium',_binary 'a:9:{s:4:\"uuid\";s:36:\"bb20aaa6-e241-4363-957c-cbc63da12f01\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE\";}s:2:\"id\";s:6:\"medium\";s:5:\"label\";s:24:\"Date moyenne par défaut\";s:6:\"locked\";b:0;s:7:\"pattern\";s:13:\"D d/m/Y - H:i\";}',-1,1680008722.807,1,'','0'),('core.date_format.olivero_medium',_binary 'a:9:{s:4:\"uuid\";s:36:\"4c3f822a-a495-413e-9134-e65ce6bb4a6a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:5:\"theme\";a:1:{i:0;s:7:\"olivero\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Mt6cmxUbDZ9XxD6p25WQ8tj3_JcX8ylfcddwZc8gcAE\";}s:2:\"id\";s:14:\"olivero_medium\";s:5:\"label\";s:14:\"Olivero Medium\";s:6:\"locked\";b:0;s:7:\"pattern\";s:8:\"j  F,  Y\";}',-1,1680009095.347,1,'','0'),('core.date_format.short',_binary 'a:9:{s:4:\"uuid\";s:36:\"a1d5c4b2-d000-45f3-aad6-fc99be1887fb\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA\";}s:2:\"id\";s:5:\"short\";s:5:\"label\";s:23:\"Date courte par défaut\";s:6:\"locked\";b:0;s:7:\"pattern\";s:11:\"d/m/Y - H:i\";}',-1,1680009095.037,1,'','0'),('core.entity_form_display.webform_submission.adhesion.add',_binary 'b:0;',-1,1680009162.139,1,'','0'),('core.entity_form_display.webform_submission.adhesion.default',_binary 'b:0;',-1,1680009162.139,1,'','0'),('core.entity_form_display.webform_submission.contact.add',_binary 'b:0;',-1,1680009186.448,1,'','0'),('core.entity_form_display.webform_submission.contact.default',_binary 'b:0;',-1,1680009186.448,1,'','0'),('core.entity_form_display.webform_submission.newsletter.add',_binary 'b:0;',-1,1680008723.893,1,'','0'),('core.entity_form_display.webform_submission.newsletter.default',_binary 'b:0;',-1,1680008723.893,1,'','0'),('core.entity_form_display.webform_submission.offre_d_emploi.add',_binary 'b:0;',-1,1680009178.019,1,'','0'),('core.entity_form_display.webform_submission.offre_d_emploi.default',_binary 'b:0;',-1,1680009178.019,1,'','0'),('core.entity_form_mode.user.register',_binary 'a:9:{s:4:\"uuid\";s:36:\"54e052c3-42b3-4f11-b0bd-abf9cb45c95c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"flXhTcp55yLcyy7ZLOhPGKGZobZQJdkAFVWV3LseiuI\";}s:2:\"id\";s:13:\"user.register\";s:5:\"label\";s:10:\"S\'inscrire\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}',-1,1680008718.098,1,'','0'),('core.entity_view_display.block_content.banner.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"815dde9a-4912-4ed4-8cf4-9788f8b2157e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:25:\"block_content.type.banner\";i:1;s:37:\"field.field.block_content.banner.body\";i:2;s:44:\"field.field.block_content.banner.field_image\";i:3;s:43:\"field.field.block_content.banner.field_link\";}s:6:\"module\";a:3:{i:0;s:5:\"image\";i:1;s:4:\"link\";i:2;s:4:\"text\";}}s:2:\"id\";s:28:\"block_content.banner.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:6:\"banner\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:11:\"field_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:10:\"field_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:80;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:0:\"\";s:6:\"target\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1680009079.219,1,'','0'),('core.entity_view_display.block_content.banner.full',_binary 'b:0;',-1,1680009079.218,1,'','0'),('core.entity_view_display.block_content.block_content.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"d8bf28b6-2187-4581-9f82-5dce6c360415\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:32:\"block_content.type.block_content\";i:1;s:44:\"field.field.block_content.block_content.body\";i:2;s:53:\"field.field.block_content.block_content.field_content\";}s:6:\"module\";a:2:{i:0;s:26:\"entity_reference_revisions\";i:1;s:4:\"text\";}}s:2:\"id\";s:35:\"block_content.block_content.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"block_content\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:13:\"field_content\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1680009080.088,1,'','0'),('core.entity_view_display.block_content.block_content.full',_binary 'b:0;',-1,1680009080.088,1,'','0'),('core.entity_view_display.block_content.reseau_sociaux.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"66f45d0e-a53f-4888-b6c8-9cc97b8ed19b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:33:\"block_content.type.reseau_sociaux\";i:1;s:45:\"field.field.block_content.reseau_sociaux.body\";i:2;s:61:\"field.field.block_content.reseau_sociaux.field_reseau_sociaux\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:2:\"id\";s:36:\"block_content.reseau_sociaux.default\";s:16:\"targetEntityType\";s:13:\"block_content\";s:6:\"bundle\";s:14:\"reseau_sociaux\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:20:\"field_reseau_sociaux\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:2:{s:4:\"body\";b:1;s:8:\"langcode\";b:1;}}',-1,1680008724.180,1,'','0'),('core.entity_view_display.block_content.reseau_sociaux.full',_binary 'b:0;',-1,1680008724.180,1,'','0'),('core.entity_view_display.node.formation.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"64ecbef3-af56-4c72-ae66-d76941a50d91\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:8:{i:0;s:31:\"field.field.node.formation.body\";i:1;s:42:\"field.field.node.formation.field_categorie\";i:2;s:43:\"field.field.node.formation.field_date_debut\";i:3;s:41:\"field.field.node.formation.field_date_fin\";i:4;s:41:\"field.field.node.formation.field_document\";i:5;s:39:\"field.field.node.formation.field_images\";i:6;s:38:\"field.field.node.formation.field_video\";i:7;s:19:\"node.type.formation\";}s:6:\"module\";a:6:{i:0;s:8:\"datetime\";i:1;s:4:\"file\";i:2;s:5:\"image\";i:3;s:4:\"text\";i:4;s:4:\"user\";i:5;s:7:\"youtube\";}}s:2:\"id\";s:22:\"node.formation.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:9:{s:8:\"addtoany\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:7;s:6:\"region\";s:7:\"content\";}s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:15:\"field_categorie\";a:6:{s:4:\"type\";s:22:\"entity_reference_label\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:8;s:6:\"region\";s:7:\"content\";}s:16:\"field_date_debut\";a:6:{s:4:\"type\";s:16:\"datetime_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:17:\"timezone_override\";s:0:\"\";s:11:\"format_type\";s:6:\"medium\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:5;s:6:\"region\";s:7:\"content\";}s:14:\"field_date_fin\";a:6:{s:4:\"type\";s:16:\"datetime_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:17:\"timezone_override\";s:0:\"\";s:11:\"format_type\";s:6:\"medium\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:6;s:6:\"region\";s:7:\"content\";}s:14:\"field_document\";a:6:{s:4:\"type\";s:12:\"file_default\";s:5:\"label\";s:6:\"inline\";s:8:\"settings\";a:1:{s:28:\"use_description_as_link_text\";b:1;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";}s:12:\"field_images\";a:6:{s:4:\"type\";s:9:\"image_url\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:11:\"image_style\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:11:\"field_video\";a:6:{s:4:\"type\";s:13:\"youtube_video\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:9:{s:12:\"youtube_size\";s:10:\"responsive\";s:13:\"youtube_width\";s:0:\"\";s:14:\"youtube_height\";s:0:\"\";s:16:\"youtube_autoplay\";b:0;s:12:\"youtube_mute\";b:0;s:12:\"youtube_loop\";b:0;s:16:\"youtube_controls\";b:0;s:16:\"youtube_autohide\";b:0;s:22:\"youtube_iv_load_policy\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1680009128.763,1,'','0'),('core.entity_view_display.node.formation.full',_binary 'b:0;',-1,1680009128.763,1,'','0'),('core.entity_view_display.node.formation.teaser',_binary 'a:10:{s:4:\"uuid\";s:36:\"7d569051-0b0d-45c1-90ab-481001dc5b6f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:9:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:31:\"field.field.node.formation.body\";i:2;s:42:\"field.field.node.formation.field_categorie\";i:3;s:43:\"field.field.node.formation.field_date_debut\";i:4;s:41:\"field.field.node.formation.field_date_fin\";i:5;s:41:\"field.field.node.formation.field_document\";i:6;s:39:\"field.field.node.formation.field_images\";i:7;s:38:\"field.field.node.formation.field_video\";i:8;s:19:\"node.type.formation\";}s:6:\"module\";a:2:{i:0;s:4:\"text\";i:1;s:4:\"user\";}}s:2:\"id\";s:21:\"node.formation.teaser\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:4:\"mode\";s:6:\"teaser\";s:7:\"content\";a:2:{s:4:\"body\";a:6:{s:4:\"type\";s:23:\"text_summary_or_trimmed\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:11:\"trim_length\";i:600;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:101;s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:8:{s:8:\"addtoany\";b:1;s:15:\"field_categorie\";b:1;s:16:\"field_date_debut\";b:1;s:14:\"field_date_fin\";b:1;s:14:\"field_document\";b:1;s:12:\"field_images\";b:1;s:11:\"field_video\";b:1;s:8:\"langcode\";b:1;}}',-1,1680009129.306,1,'','0'),('core.entity_view_display.node.offres_emploi.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"9c3112e3-b781-4335-b54c-e395eda65b90\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:35:\"field.field.node.offres_emploi.body\";i:1;s:46:\"field.field.node.offres_emploi.field_meta_tags\";i:2;s:38:\"field.field.node.offres_emploi.webform\";i:3;s:23:\"node.type.offres_emploi\";}s:6:\"module\";a:4:{i:0;s:7:\"metatag\";i:1;s:4:\"text\";i:2;s:4:\"user\";i:3;s:7:\"webform\";}}s:2:\"id\";s:26:\"node.offres_emploi.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:13:\"offres_emploi\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:8:\"addtoany\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";}s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:15:\"field_meta_tags\";a:6:{s:4:\"type\";s:23:\"metatag_empty_formatter\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:7:\"webform\";a:6:{s:4:\"type\";s:36:\"webform_entity_reference_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:13:\"source_entity\";b:1;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1680009177.222,1,'','0'),('core.entity_view_display.node.offres_emploi.full',_binary 'b:0;',-1,1680009177.222,1,'','0'),('core.entity_view_display.node.offres_emploi.teaser',_binary 'a:10:{s:4:\"uuid\";s:36:\"a657d03f-6d77-43ca-bf5e-83fed93590da\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:35:\"field.field.node.offres_emploi.body\";i:2;s:46:\"field.field.node.offres_emploi.field_meta_tags\";i:3;s:38:\"field.field.node.offres_emploi.webform\";i:4;s:23:\"node.type.offres_emploi\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:25:\"node.offres_emploi.teaser\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:13:\"offres_emploi\";s:4:\"mode\";s:6:\"teaser\";s:7:\"content\";a:1:{s:5:\"links\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:5:{s:8:\"addtoany\";b:1;s:4:\"body\";b:1;s:15:\"field_meta_tags\";b:1;s:8:\"langcode\";b:1;s:7:\"webform\";b:1;}}',-1,1680009177.574,1,'','0'),('core.entity_view_display.node.page.default',_binary 'a:11:{s:4:\"uuid\";s:36:\"58e0dd97-4c1b-4840-b5a4-6f2194165d3a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:26:\"field.field.node.page.body\";i:1;s:35:\"field.field.node.page.field_content\";i:2;s:37:\"field.field.node.page.field_meta_tags\";i:3;s:14:\"node.type.page\";}s:6:\"module\";a:3:{i:0;s:26:\"entity_reference_revisions\";i:1;s:7:\"metatag\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"M_Y8L5tfmhx7DR143E05YyZSpvgil6VFvqcfBWykalg\";}s:2:\"id\";s:17:\"node.page.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:13:\"field_content\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:15:\"field_meta_tags\";a:6:{s:4:\"type\";s:23:\"metatag_empty_formatter\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:3:{s:8:\"addtoany\";b:1;s:4:\"body\";b:1;s:8:\"langcode\";b:1;}}',-1,1680009094.605,1,'','0'),('core.entity_view_display.node.page.full',_binary 'b:0;',-1,1680009094.605,1,'','0'),('core.entity_view_display.node.partenaire.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"08de287b-3a3c-400d-bc2d-514fddade6ef\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:32:\"field.field.node.partenaire.body\";i:1;s:39:\"field.field.node.partenaire.field_image\";i:2;s:38:\"field.field.node.partenaire.field_lien\";i:3;s:43:\"field.field.node.partenaire.field_meta_tags\";i:4;s:18:\"image.style.medium\";i:5;s:20:\"node.type.partenaire\";}s:6:\"module\";a:3:{i:0;s:5:\"image\";i:1;s:7:\"metatag\";i:2;s:4:\"user\";}}s:2:\"id\";s:23:\"node.partenaire.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:10:\"partenaire\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:11:\"field_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:6:\"medium\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:10:\"field_lien\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:15:\"field_meta_tags\";a:6:{s:4:\"type\";s:23:\"metatag_empty_formatter\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:3:{s:4:\"body\";b:1;s:8:\"langcode\";b:1;s:5:\"links\";b:1;}}',-1,1680008722.733,1,'','0'),('core.entity_view_display.node.partenaire.full',_binary 'a:10:{s:4:\"uuid\";s:36:\"d18f55df-1817-4f87-a9e0-d27351fde907\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:7:{i:0;s:31:\"core.entity_view_mode.node.full\";i:1;s:32:\"field.field.node.partenaire.body\";i:2;s:39:\"field.field.node.partenaire.field_image\";i:3;s:38:\"field.field.node.partenaire.field_lien\";i:4;s:43:\"field.field.node.partenaire.field_meta_tags\";i:5;s:21:\"image.style.thumbnail\";i:6;s:20:\"node.type.partenaire\";}s:6:\"module\";a:3:{i:0;s:5:\"image\";i:1;s:7:\"metatag\";i:2;s:4:\"user\";}}s:2:\"id\";s:20:\"node.partenaire.full\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:10:\"partenaire\";s:4:\"mode\";s:4:\"full\";s:7:\"content\";a:3:{s:11:\"field_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:9:\"thumbnail\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:10:\"field_lien\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:15:\"field_meta_tags\";a:6:{s:4:\"type\";s:23:\"metatag_empty_formatter\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:3:{s:4:\"body\";b:1;s:8:\"langcode\";b:1;s:5:\"links\";b:1;}}',-1,1680009154.981,1,'','0'),('core.entity_view_display.node.partenaire.teaser',_binary 'a:10:{s:4:\"uuid\";s:36:\"43f9d6b0-8ba7-4c30-8992-578bbc3be8f0\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:7:{i:0;s:33:\"core.entity_view_mode.node.teaser\";i:1;s:32:\"field.field.node.partenaire.body\";i:2;s:39:\"field.field.node.partenaire.field_image\";i:3;s:38:\"field.field.node.partenaire.field_lien\";i:4;s:43:\"field.field.node.partenaire.field_meta_tags\";i:5;s:21:\"image.style.thumbnail\";i:6;s:20:\"node.type.partenaire\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:2:\"id\";s:22:\"node.partenaire.teaser\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:10:\"partenaire\";s:4:\"mode\";s:6:\"teaser\";s:7:\"content\";a:2:{s:11:\"field_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:9:\"thumbnail\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:10:\"field_lien\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:4:{s:4:\"body\";b:1;s:15:\"field_meta_tags\";b:1;s:8:\"langcode\";b:1;s:5:\"links\";b:1;}}',-1,1680008722.733,1,'','0'),('core.entity_view_display.node.webform.default',_binary 'a:11:{s:4:\"uuid\";s:36:\"bd4b4320-2fbc-4a39-8d54-763a324af507\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:29:\"field.field.node.webform.body\";i:1;s:40:\"field.field.node.webform.field_meta_tags\";i:2;s:32:\"field.field.node.webform.webform\";i:3;s:17:\"node.type.webform\";}s:6:\"module\";a:4:{i:0;s:7:\"metatag\";i:1;s:4:\"text\";i:2;s:4:\"user\";i:3;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"3r1i0UMUbeNHhvmiqHDYznoS4G9XR1jq6lQ49r80lDE\";}s:2:\"id\";s:20:\"node.webform.default\";s:16:\"targetEntityType\";s:4:\"node\";s:6:\"bundle\";s:7:\"webform\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:4:\"body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:101;s:6:\"region\";s:7:\"content\";}s:15:\"field_meta_tags\";a:6:{s:4:\"type\";s:23:\"metatag_empty_formatter\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:103;s:6:\"region\";s:7:\"content\";}s:5:\"links\";a:4:{s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:100;s:6:\"region\";s:7:\"content\";}s:7:\"webform\";a:6:{s:4:\"type\";s:36:\"webform_entity_reference_entity_view\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:102;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:1:{s:8:\"langcode\";b:1;}}',-1,1680009161.391,1,'','0'),('core.entity_view_display.node.webform.full',_binary 'b:0;',-1,1680009161.391,1,'','0'),('core.entity_view_display.paragraph.block_cta.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"a71c61bd-49a4-4945-8048-1d4903813e51\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:42:\"field.field.paragraph.block_cta.field_body\";i:1;s:43:\"field.field.paragraph.block_cta.field_image\";i:2;s:42:\"field.field.paragraph.block_cta.field_link\";i:3;s:52:\"field.field.paragraph.block_cta.field_position_image\";i:4;s:36:\"paragraphs.paragraphs_type.block_cta\";}s:6:\"module\";a:4:{i:0;s:5:\"image\";i:1;s:4:\"link\";i:2;s:7:\"options\";i:3;s:4:\"text\";}}s:2:\"id\";s:27:\"paragraph.block_cta.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:9:\"block_cta\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:4:{s:10:\"field_body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:11:\"field_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:10:\"field_link\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:80;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:0:\"\";s:6:\"target\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:20:\"field_position_image\";a:6:{s:4:\"type\";s:12:\"list_default\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}',-1,1680009080.270,1,'','0'),('core.entity_view_display.paragraph.block_text_image.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"e35667b9-881c-4c89-b07e-1bcdbaced4b8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:49:\"field.field.paragraph.block_text_image.field_body\";i:1;s:50:\"field.field.paragraph.block_text_image.field_image\";i:2;s:59:\"field.field.paragraph.block_text_image.field_position_image\";i:3;s:43:\"paragraphs.paragraphs_type.block_text_image\";}s:6:\"module\";a:3:{i:0;s:5:\"image\";i:1;s:7:\"options\";i:2;s:4:\"text\";}}s:2:\"id\";s:34:\"paragraph.block_text_image.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"block_text_image\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:3:{s:10:\"field_body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:11:\"field_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:20:\"field_position_image\";a:6:{s:4:\"type\";s:12:\"list_default\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}',-1,1680009104.427,1,'','0'),('core.entity_view_display.paragraph.composant_content.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"34a1e723-5b18-42be-910e-66327937c254\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:50:\"field.field.paragraph.composant_content.field_body\";i:1;s:53:\"field.field.paragraph.composant_content.field_content\";i:2;s:44:\"paragraphs.paragraphs_type.composant_content\";}s:6:\"module\";a:2:{i:0;s:26:\"entity_reference_revisions\";i:1;s:4:\"text\";}}s:2:\"id\";s:35:\"paragraph.composant_content.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:17:\"composant_content\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:10:\"field_body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:13:\"field_content\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}',-1,1680009080.409,1,'','0'),('core.entity_view_display.paragraph.composant_text.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"764033ed-6195-4b7c-b03b-ba53893f1f7a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:47:\"field.field.paragraph.composant_text.field_body\";i:1;s:41:\"paragraphs.paragraphs_type.composant_text\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:32:\"paragraph.composant_text.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"composant_text\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:1:{s:10:\"field_body\";a:6:{s:4:\"type\";s:12:\"text_default\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}',-1,1680009110.607,1,'','0'),('core.entity_view_display.paragraph.content.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"22f70c30-f14d-4c7a-bb05-f9f05b00a478\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:46:\"field.field.paragraph.content.field_block_list\";i:1;s:41:\"field.field.paragraph.content.field_titre\";i:2;s:34:\"paragraphs.paragraphs_type.content\";}s:6:\"module\";a:1:{i:0;s:11:\"block_field\";}}s:2:\"id\";s:25:\"paragraph.content.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"content\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:16:\"field_block_list\";a:6:{s:4:\"type\";s:11:\"block_field\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:11:\"field_titre\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}',-1,1680009080.546,1,'','0'),('core.entity_view_display.paragraph.equipe.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"4f16e45f-e520-496c-8218-add010a307f4\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:46:\"field.field.paragraph.equipe.field_description\";i:1;s:40:\"field.field.paragraph.equipe.field_image\";i:2;s:53:\"field.field.paragraph.equipe.field_lien_reseau_social\";i:3;s:38:\"field.field.paragraph.equipe.field_nom\";i:4;s:40:\"field.field.paragraph.equipe.field_poste\";i:5;s:33:\"paragraphs.paragraphs_type.equipe\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"link\";}}s:2:\"id\";s:24:\"paragraph.equipe.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:6:\"equipe\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:5:{s:17:\"field_description\";a:6:{s:4:\"type\";s:12:\"basic_string\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:0:{}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:3;s:6:\"region\";s:7:\"content\";}s:11:\"field_image\";a:6:{s:4:\"type\";s:5:\"image\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:2;s:6:\"region\";s:7:\"content\";}s:24:\"field_lien_reseau_social\";a:6:{s:4:\"type\";s:4:\"link\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:5:{s:11:\"trim_length\";i:80;s:8:\"url_only\";b:0;s:9:\"url_plain\";b:0;s:3:\"rel\";s:8:\"nofollow\";s:6:\"target\";s:6:\"_blank\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:4;s:6:\"region\";s:7:\"content\";}s:9:\"field_nom\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}s:11:\"field_poste\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:6:\"hidden\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}',-1,1680009096.251,1,'','0'),('core.entity_view_display.paragraph.equipes.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"699c514d-89cf-456c-9b1a-c77f2242fcff\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:42:\"field.field.paragraph.equipes.field_membre\";i:1;s:41:\"field.field.paragraph.equipes.field_titre\";i:2;s:34:\"paragraphs.paragraphs_type.equipes\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:2:\"id\";s:25:\"paragraph.equipes.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"equipes\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:12:\"field_membre\";a:6:{s:4:\"type\";s:38:\"entity_reference_revisions_entity_view\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:2:{s:9:\"view_mode\";s:7:\"default\";s:4:\"link\";s:0:\"\";}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:11:\"field_titre\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}',-1,1680009096.085,1,'','0'),('core.entity_view_display.paragraph.reseau_sociaux.default',_binary 'a:10:{s:4:\"uuid\";s:36:\"b57431b6-624a-44a1-8828-d7eb37701b64\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:47:\"field.field.paragraph.reseau_sociaux.field_icon\";i:1;s:47:\"field.field.paragraph.reseau_sociaux.field_lien\";i:2;s:41:\"paragraphs.paragraphs_type.reseau_sociaux\";}}s:2:\"id\";s:32:\"paragraph.reseau_sociaux.default\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"reseau_sociaux\";s:4:\"mode\";s:7:\"default\";s:7:\"content\";a:2:{s:10:\"field_icon\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:1;s:6:\"region\";s:7:\"content\";}s:10:\"field_lien\";a:6:{s:4:\"type\";s:6:\"string\";s:5:\"label\";s:5:\"above\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:20:\"third_party_settings\";a:0:{}s:6:\"weight\";i:0;s:6:\"region\";s:7:\"content\";}}s:6:\"hidden\";a:0:{}}',-1,1680008724.310,1,'','0'),('core.entity_view_mode.block.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"e9f4bda3-372a-4d4a-9d26-50c13b94af11\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:5:\"block\";}}s:2:\"id\";s:11:\"block.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:5:\"block\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.block_content.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"5eb555ef-beec-44db-ac18-8b9210ba7123\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"block_content\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"4tedlMuvQjDOdvHdw86_e-2Rt78aR7TGFMfOK8Ejppg\";}s:2:\"id\";s:18:\"block_content.full\";s:5:\"label\";s:7:\"Complet\";s:16:\"targetEntityType\";s:13:\"block_content\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.block_content.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"e8aa4628-29c8-4a02-aee1-176d8d70c1cc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:13:\"block_content\";}}s:2:\"id\";s:19:\"block_content.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:13:\"block_content\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.comment.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"ec9ba151-e448-4e6e-a1b8-862f23dcdbfc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"K7eNlfU7NEUajz01wItywZklr2oaPgL6s1_97fmDXLA\";}s:2:\"id\";s:12:\"comment.full\";s:5:\"label\";s:19:\"Commentaire complet\";s:16:\"targetEntityType\";s:7:\"comment\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.comment.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"2ad1f242-cf42-444b-9446-02ce3ac431da\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:2:\"id\";s:13:\"comment.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:7:\"comment\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.contact_message.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"f57b71de-712f-4d5a-86c6-d2444db74dae\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"contact\";}}s:2:\"id\";s:21:\"contact_message.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:15:\"contact_message\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.file.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"eb2e314f-8ea0-4faf-9d32-0368ae9c2b17\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:2:\"id\";s:10:\"file.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:4:\"file\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.menu_link_content.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"74046a79-0fd9-4ae0-bed4-c9fb5605631c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:17:\"menu_link_content\";}}s:2:\"id\";s:23:\"menu_link_content.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:17:\"menu_link_content\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.node.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"ffac8764-d2a6-4079-b94a-6d47f1920779\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ElrtInxGjZd7GaapJ5O9n-ugi2hG2IxFivtgn0tHOsk\";}s:2:\"id\";s:9:\"node.full\";s:5:\"label\";s:15:\"Contenu complet\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.node.rss',_binary 'a:9:{s:4:\"uuid\";s:36:\"4b3f6174-7f3c-492e-91a4-77a86a1f1f54\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vlYzr-rp2f9NMp-Qlr4sFjlqRq-90mco5-afLNGwCrU\";}s:2:\"id\";s:8:\"node.rss\";s:5:\"label\";s:3:\"RSS\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.node.search_index',_binary 'a:9:{s:4:\"uuid\";s:36:\"e275b4ed-da59-4db7-9f91-057fd9289a38\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"fVFfJv_GzBRE-wpRHbfD5a3VjnhbEOXG6lvRd3uaccY\";}s:2:\"id\";s:17:\"node.search_index\";s:5:\"label\";s:18:\"Index de recherche\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.node.search_result',_binary 'a:9:{s:4:\"uuid\";s:36:\"bf38fcc1-876e-43d0-b83d-c8f8c7ece949\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6GCOQ-jP2RbdbHA5YWQ6bT8CfGbqrBYKOSC_XY4E3ZM\";}s:2:\"id\";s:18:\"node.search_result\";s:5:\"label\";s:53:\"Résultat de recherche mettant en évidence la saisie\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.node.teaser',_binary 'a:9:{s:4:\"uuid\";s:36:\"df828efb-bc12-46e4-bad2-a69babffa158\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Mz9qWr1kUYK0mjRAGDsr5XS6PvtZ24en_7ndt-pyWe4\";}s:2:\"id\";s:11:\"node.teaser\";s:5:\"label\";s:8:\"Accroche\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.node.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"ddb225a9-542a-4f90-9a74-8ea6fdddf3d4\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:2:\"id\";s:10:\"node.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:4:\"node\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.paragraph.preview',_binary 'a:9:{s:4:\"uuid\";s:36:\"910dd24b-ee5c-4bce-ae8a-ea0cae1b70e9\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"h3BeHVei4Lnyqbkao3YiF4KqoY-DhRvUNfEgKG8Rgjg\";}s:2:\"id\";s:17:\"paragraph.preview\";s:5:\"label\";s:7:\"Preview\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.paragraph.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"52bf5ca9-3638-4a47-b02b-39f6e66c022d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:2:\"id\";s:15:\"paragraph.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:9:\"paragraph\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.path_alias.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"90bcc778-83fa-4141-b73e-f23973e60498\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"path_alias\";}}s:2:\"id\";s:16:\"path_alias.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:10:\"path_alias\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.shortcut.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"b90d0657-2e57-4bbb-9e4c-9acec707836a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"shortcut\";}}s:2:\"id\";s:14:\"shortcut.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:8:\"shortcut\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.taxonomy_term.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"e430e961-9ec8-4701-81b6-ddcaf08566ff\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-PPKjsNQPvoIDjOuUAvlLocYD976MNjb9Zpgyz5_BWE\";}s:2:\"id\";s:18:\"taxonomy_term.full\";s:5:\"label\";s:28:\"Page d\'un terme de taxonomie\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.taxonomy_term.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"0304ecfe-5d3b-4a12-98be-61856171943f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:2:\"id\";s:19:\"taxonomy_term.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:13:\"taxonomy_term\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.tour.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"c67b68dd-7fdc-4755-a69b-45f9f79e699e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"tour\";}}s:2:\"id\";s:10:\"tour.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:4:\"tour\";s:5:\"cache\";b:1;}',-1,1680008718.105,1,'','0'),('core.entity_view_mode.user.compact',_binary 'a:9:{s:4:\"uuid\";s:36:\"4d1079c2-16e9-43d5-a8bd-e04144be1751\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"71CSAr_LNPcgu6D6jI4INl1KATkahmeyUFBETAWya8g\";}s:2:\"id\";s:12:\"user.compact\";s:5:\"label\";s:7:\"Compact\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}',-1,1680008718.106,1,'','0'),('core.entity_view_mode.user.full',_binary 'a:9:{s:4:\"uuid\";s:36:\"da3f82ee-ca47-4012-b823-2529634e0f72\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mQIF_foYjmnVSr9MpcD4CTaJE_FpO1AyDd_DskztGhM\";}s:2:\"id\";s:9:\"user.full\";s:5:\"label\";s:18:\"Compte utilisateur\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}',-1,1680008718.106,1,'','0'),('core.entity_view_mode.user.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"f4de1f81-981e-4e4e-b15f-9293a6a1f93f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:10:\"user.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:4:\"user\";s:5:\"cache\";b:1;}',-1,1680008718.106,1,'','0'),('core.entity_view_mode.webform.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"c406eb16-8a7c-49a7-8e3e-3131f17ae919\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:2:\"id\";s:13:\"webform.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:7:\"webform\";s:5:\"cache\";b:1;}',-1,1680008718.106,1,'','0'),('core.entity_view_mode.webform_submission.token',_binary 'a:8:{s:4:\"uuid\";s:36:\"338ace12-8149-48ee-907d-2a5a47afafef\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:2:\"id\";s:24:\"webform_submission.token\";s:5:\"label\";s:5:\"Token\";s:16:\"targetEntityType\";s:18:\"webform_submission\";s:5:\"cache\";b:1;}',-1,1680008718.106,1,'','0'),('core.extension',_binary 'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"R4IF-ClDHXxblLcG0L7MgsLvfBIMAvi_skumNFQwkDc\";}s:8:\"langcode\";s:2:\"fr\";s:6:\"module\";a:73:{s:8:\"addtoany\";i:0;s:13:\"admin_toolbar\";i:0;s:33:\"admin_toolbar_links_access_filter\";i:0;s:20:\"admin_toolbar_search\";i:0;s:19:\"admin_toolbar_tools\";i:0;s:14:\"automated_cron\";i:0;s:8:\"big_pipe\";i:0;s:5:\"block\";i:0;s:13:\"block_content\";i:0;s:11:\"block_field\";i:0;s:10:\"breakpoint\";i:0;s:9:\"ckeditor5\";i:0;s:7:\"comment\";i:0;s:6:\"config\";i:0;s:7:\"contact\";i:0;s:10:\"contextual\";i:0;s:8:\"datetime\";i:0;s:5:\"dblog\";i:0;s:18:\"dynamic_page_cache\";i:0;s:6:\"editor\";i:0;s:23:\"element_class_formatter\";i:0;s:40:\"element_class_formatter_responsive_image\";i:0;s:26:\"entity_reference_revisions\";i:0;s:5:\"field\";i:0;s:8:\"field_ui\";i:0;s:4:\"file\";i:0;s:6:\"filter\";i:0;s:9:\"gin_login\";i:0;s:4:\"help\";i:0;s:7:\"history\";i:0;s:5:\"image\";i:0;s:8:\"language\";i:0;s:4:\"link\";i:0;s:6:\"locale\";i:0;s:17:\"menu_link_content\";i:0;s:7:\"menu_ui\";i:0;s:7:\"metatag\";i:0;s:5:\"mysql\";i:0;s:4:\"node\";i:0;s:7:\"options\";i:0;s:10:\"page_cache\";i:0;s:18:\"paragraphs_browser\";i:0;s:4:\"path\";i:0;s:10:\"path_alias\";i:0;s:16:\"quick_node_clone\";i:0;s:16:\"responsive_image\";i:0;s:6:\"search\";i:0;s:8:\"shortcut\";i:0;s:14:\"simple_sitemap\";i:0;s:6:\"system\";i:0;s:8:\"taxonomy\";i:0;s:4:\"text\";i:0;s:5:\"token\";i:0;s:7:\"toolbar\";i:0;s:4:\"tour\";i:0;s:6:\"update\";i:0;s:4:\"user\";i:0;s:8:\"views_ui\";i:0;s:7:\"webform\";i:0;s:14:\"webform_access\";i:0;s:18:\"webform_attachment\";i:0;s:20:\"webform_image_select\";i:0;s:12:\"webform_node\";i:0;s:23:\"webform_scheduled_email\";i:0;s:13:\"webform_share\";i:0;s:32:\"webform_submission_export_import\";i:0;s:10:\"webform_ui\";i:0;s:7:\"youtube\";i:0;s:8:\"pathauto\";i:1;s:5:\"views\";i:10;s:10:\"paragraphs\";i:11;s:10:\"empty_page\";i:1000;s:8:\"standard\";i:1000;}s:5:\"theme\";a:4:{s:7:\"olivero\";i:0;s:5:\"claro\";i:0;s:3:\"gin\";i:0;s:14:\"notregrandblue\";i:0;}s:7:\"profile\";s:8:\"standard\";}',-1,1680008714.520,1,'','0'),('core.menu.static_menu_link_overrides',_binary 'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CXhei_vpaZk-3f_Mj2cH0YmpK-ZpKHoSzVA3yZrDq0g\";}s:8:\"langcode\";s:2:\"fr\";s:11:\"definitions\";a:2:{s:18:\"contact__site_page\";a:5:{s:9:\"menu_name\";s:6:\"footer\";s:6:\"parent\";s:0:\"\";s:6:\"weight\";i:0;s:8:\"expanded\";b:0;s:7:\"enabled\";b:1;}s:20:\"standard__front_page\";a:5:{s:6:\"weight\";i:-50;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:0:\"\";s:7:\"enabled\";b:1;s:8:\"expanded\";b:0;}}}',-1,1680008718.158,1,'','0'),('empty_page.settings',_binary 'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1qKVk03zhLAZj-W36dakmXWDO3mx28TRgx9iDzHpqMs\";}s:6:\"new_id\";i:2;s:8:\"langcode\";s:2:\"fr\";s:10:\"callback_1\";a:5:{s:7:\"created\";i:1678958518;s:3:\"cid\";i:1;s:7:\"updated\";i:1678958518;s:4:\"path\";s:8:\"/accueil\";s:10:\"page_title\";s:7:\"Accueil\";}}',-1,1680008716.237,1,'','0'),('field.field.block_content.banner.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"1854c4d7-0ce7-4b0d-8dc7-ced3ef5ce98e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:25:\"block_content.type.banner\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:25:\"block_content.banner.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:6:\"banner\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.370,1,'','0'),('field.field.block_content.banner.field_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"9b5cd096-075b-4b0b-850a-0363ee16647b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:25:\"block_content.type.banner\";i:1;s:39:\"field.storage.block_content.field_image\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:32:\"block_content.banner.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:6:\"banner\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}',-1,1680008717.407,1,'','0'),('field.field.block_content.banner.field_link',_binary 'a:16:{s:4:\"uuid\";s:36:\"7b7cfe72-541a-4c98-bca0-bd39debe769d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:25:\"block_content.type.banner\";i:1;s:38:\"field.storage.block_content.field_link\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:2:\"id\";s:31:\"block_content.banner.field_link\";s:10:\"field_name\";s:10:\"field_link\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:6:\"banner\";s:5:\"label\";s:4:\"Lien\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:1;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}',-1,1680008717.407,1,'','0'),('field.field.block_content.basic.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"c3f65cca-9c31-4d58-9ea3-56ed5110adb4\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:24:\"block_content.type.basic\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"foetbaMhlB6uLc2bn-PESvaPkbuDWj0MEjpQVwQiP-o\";}s:2:\"id\";s:24:\"block_content.basic.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:5:\"basic\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.347,1,'','0'),('field.field.block_content.block_content.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"ee8cf8bc-9458-4dbd-8b60-a2e7603ba14f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:32:\"block_content.type.block_content\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:32:\"block_content.block_content.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"block_content\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.382,1,'','0'),('field.field.block_content.block_content.field_content',_binary 'a:16:{s:4:\"uuid\";s:36:\"b4bf21ff-cf90-44fe-a0b2-d17b7c576bba\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:32:\"block_content.type.block_content\";i:1;s:41:\"field.storage.block_content.field_content\";i:2;s:36:\"paragraphs.paragraphs_type.block_cta\";i:3;s:44:\"paragraphs.paragraphs_type.composant_content\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:2:\"id\";s:41:\"block_content.block_content.field_content\";s:10:\"field_name\";s:13:\"field_content\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:13:\"block_content\";s:5:\"label\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:2:{s:9:\"block_cta\";s:9:\"block_cta\";s:17:\"composant_content\";s:17:\"composant_content\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:7:{s:9:\"block_cta\";a:2:{s:6:\"weight\";i:8;s:7:\"enabled\";b:1;}s:16:\"block_text_image\";a:2:{s:6:\"weight\";i:9;s:7:\"enabled\";b:0;}s:17:\"composant_content\";a:2:{s:6:\"weight\";i:10;s:7:\"enabled\";b:1;}s:7:\"content\";a:2:{s:6:\"weight\";i:11;s:7:\"enabled\";b:0;}s:6:\"equipe\";a:2:{s:6:\"weight\";i:12;s:7:\"enabled\";b:0;}s:7:\"equipes\";a:2:{s:6:\"weight\";i:13;s:7:\"enabled\";b:0;}s:14:\"reseau_sociaux\";a:2:{s:6:\"weight\";i:14;s:7:\"enabled\";b:0;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}',-1,1680008717.460,1,'','0'),('field.field.block_content.reseau_sociaux.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"b9059b21-eaf5-4810-a910-a28c9f86497f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:33:\"block_content.type.reseau_sociaux\";i:1;s:32:\"field.storage.block_content.body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:33:\"block_content.reseau_sociaux.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:14:\"reseau_sociaux\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.358,1,'','0'),('field.field.block_content.reseau_sociaux.field_reseau_sociaux',_binary 'a:16:{s:4:\"uuid\";s:36:\"fa7ece82-d9c4-40c2-a425-9b6e576bc029\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:33:\"block_content.type.reseau_sociaux\";i:1;s:48:\"field.storage.block_content.field_reseau_sociaux\";i:2;s:41:\"paragraphs.paragraphs_type.reseau_sociaux\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:2:\"id\";s:49:\"block_content.reseau_sociaux.field_reseau_sociaux\";s:10:\"field_name\";s:20:\"field_reseau_sociaux\";s:11:\"entity_type\";s:13:\"block_content\";s:6:\"bundle\";s:14:\"reseau_sociaux\";s:5:\"label\";s:14:\"Reseau Sociaux\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:14:\"reseau_sociaux\";s:14:\"reseau_sociaux\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:1:{s:14:\"reseau_sociaux\";a:2:{s:6:\"weight\";i:2;s:7:\"enabled\";b:1;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}',-1,1680008717.501,1,'','0'),('field.field.comment.comment.comment_body',_binary 'a:17:{s:4:\"uuid\";s:36:\"5724f5b1-f9f4-4a4a-b1d2-da78f0cf99bc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:20:\"comment.type.comment\";i:1;s:34:\"field.storage.comment.comment_body\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TmAKjNrJ7RR60YpqvJq_QqEewYe_S8Kd23n8VRCqiWs\";}s:2:\"id\";s:28:\"comment.comment.comment_body\";s:10:\"field_name\";s:12:\"comment_body\";s:11:\"entity_type\";s:7:\"comment\";s:6:\"bundle\";s:7:\"comment\";s:5:\"label\";s:11:\"Commentaire\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:9:\"text_long\";}',-1,1680008717.547,1,'','0'),('field.field.node.article.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"4125d2f8-eb8a-4312-be22-baebf86d9cbe\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"IjZnOLWk1Pjq3WRg2pLSA1ERh7Po7izCq_p6UztZr2c\";}s:2:\"id\";s:17:\"node.article.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.592,1,'','0'),('field.field.node.article.comment',_binary 'a:17:{s:4:\"uuid\";s:36:\"f50efcf4-35cf-459e-bf8a-454b0854aef1\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:26:\"field.storage.node.comment\";i:1;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"UqXlkKC4v2-bDfWx4zcXQrD5YIi3d5byENEmWv-G_Uc\";}s:2:\"id\";s:20:\"node.article.comment\";s:10:\"field_name\";s:7:\"comment\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:12:\"Commentaires\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:6:{s:6:\"status\";i:2;s:3:\"cid\";i:0;s:22:\"last_comment_timestamp\";i:0;s:17:\"last_comment_name\";N;s:16:\"last_comment_uid\";i:0;s:13:\"comment_count\";i:0;}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:5:{s:12:\"default_mode\";i:1;s:8:\"per_page\";i:50;s:9:\"anonymous\";i:0;s:13:\"form_location\";b:1;s:7:\"preview\";i:1;}s:10:\"field_type\";s:7:\"comment\";}',-1,1680008717.696,1,'','0'),('field.field.node.article.field_document',_binary 'a:16:{s:4:\"uuid\";s:36:\"74fb67f7-b938-42bb-96a5-dc71afe793e2\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:33:\"field.storage.node.field_document\";i:1;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:2:\"id\";s:27:\"node.article.field_document\";s:10:\"field_name\";s:14:\"field_document\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:9:\"Documents\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:6:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:3:\"pdf\";s:12:\"max_filesize\";s:0:\"\";s:17:\"description_field\";b:0;}s:10:\"field_type\";s:4:\"file\";}',-1,1680008717.696,1,'','0'),('field.field.node.article.field_images',_binary 'a:16:{s:4:\"uuid\";s:36:\"17a0bf97-e613-4ba3-a60a-ad2232d1f536\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:31:\"field.storage.node.field_images\";i:1;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:25:\"node.article.field_images\";s:10:\"field_name\";s:12:\"field_images\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:6:\"Images\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}',-1,1680008717.696,1,'','0'),('field.field.node.article.field_tags',_binary 'a:17:{s:4:\"uuid\";s:36:\"752f024c-f2d4-4a94-ac1c-1a4c46eab074\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:29:\"field.storage.node.field_tags\";i:1;s:17:\"node.type.article\";i:2;s:24:\"taxonomy.vocabulary.tags\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"QdUgf_beeoaPiyKorFv0q1fcJpWH_uZTqe_xoVJacrw\";}s:2:\"id\";s:23:\"node.article.field_tags\";s:10:\"field_name\";s:10:\"field_tags\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:11:\"Étiquettes\";s:11:\"description\";s:113:\"Saisir une liste en séparant les termes par une virgule. Par exemple : Amsterdam, Mexico City, \"Cleveland, Ohio\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:21:\"default:taxonomy_term\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:4:\"tags\";s:4:\"tags\";}s:4:\"sort\";a:1:{s:5:\"field\";s:5:\"_none\";}s:11:\"auto_create\";b:1;}}s:10:\"field_type\";s:16:\"entity_reference\";}',-1,1680008717.696,1,'','0'),('field.field.node.article.field_video',_binary 'a:16:{s:4:\"uuid\";s:36:\"4230d9f6-6117-4188-8869-1e274db7ec43\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"field.storage.node.field_video\";i:1;s:17:\"node.type.article\";}s:6:\"module\";a:1:{i:0;s:7:\"youtube\";}}s:2:\"id\";s:24:\"node.article.field_video\";s:10:\"field_name\";s:11:\"field_video\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"article\";s:5:\"label\";s:5:\"Video\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:7:\"youtube\";}',-1,1680008717.696,1,'','0'),('field.field.node.formation.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"27b77f5a-036c-46db-b3ad-0630db922463\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:19:\"node.type.formation\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:19:\"node.formation.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.666,1,'','0'),('field.field.node.formation.field_categorie',_binary 'a:16:{s:4:\"uuid\";s:36:\"ae601bf1-2e47-438e-ac2a-44bdac6243c4\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:34:\"field.storage.node.field_categorie\";i:1;s:19:\"node.type.formation\";i:2;s:30:\"taxonomy.vocabulary.categories\";}}s:2:\"id\";s:30:\"node.formation.field_categorie\";s:10:\"field_name\";s:15:\"field_categorie\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:5:\"label\";s:10:\"Catégorie\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:21:\"default:taxonomy_term\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:10:\"categories\";s:10:\"categories\";}s:4:\"sort\";a:2:{s:5:\"field\";s:4:\"name\";s:9:\"direction\";s:3:\"asc\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}',-1,1680008717.733,1,'','0'),('field.field.node.formation.field_date_debut',_binary 'a:16:{s:4:\"uuid\";s:36:\"7736359c-96b1-4aed-a729-086323b3c9ea\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:35:\"field.storage.node.field_date_debut\";i:1;s:19:\"node.type.formation\";}s:6:\"module\";a:1:{i:0;s:8:\"datetime\";}}s:2:\"id\";s:31:\"node.formation.field_date_debut\";s:10:\"field_name\";s:16:\"field_date_debut\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:5:\"label\";s:10:\"Date Debut\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:1:{i:0;a:2:{s:17:\"default_date_type\";s:3:\"now\";s:12:\"default_date\";s:3:\"now\";}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:8:\"datetime\";}',-1,1680008717.733,1,'','0'),('field.field.node.formation.field_date_fin',_binary 'a:16:{s:4:\"uuid\";s:36:\"672432b6-5744-45ce-bf19-cc24c60abf58\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:33:\"field.storage.node.field_date_fin\";i:1;s:19:\"node.type.formation\";}s:6:\"module\";a:1:{i:0;s:8:\"datetime\";}}s:2:\"id\";s:29:\"node.formation.field_date_fin\";s:10:\"field_name\";s:14:\"field_date_fin\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:5:\"label\";s:8:\"Date Fin\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:8:\"datetime\";}',-1,1680008717.733,1,'','0'),('field.field.node.formation.field_document',_binary 'a:16:{s:4:\"uuid\";s:36:\"e3f1a94c-42ac-4196-8793-ce2ce9be0b17\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:33:\"field.storage.node.field_document\";i:1;s:19:\"node.type.formation\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:2:\"id\";s:29:\"node.formation.field_document\";s:10:\"field_name\";s:14:\"field_document\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:5:\"label\";s:9:\"Documents\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:6:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:3:\"pdf\";s:12:\"max_filesize\";s:0:\"\";s:17:\"description_field\";b:0;}s:10:\"field_type\";s:4:\"file\";}',-1,1680008717.733,1,'','0'),('field.field.node.formation.field_images',_binary 'a:16:{s:4:\"uuid\";s:36:\"7f8be3f2-44f4-4147-9a49-1f4ca27e6ccf\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:31:\"field.storage.node.field_images\";i:1;s:19:\"node.type.formation\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:27:\"node.formation.field_images\";s:10:\"field_name\";s:12:\"field_images\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:5:\"label\";s:6:\"Images\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}',-1,1680008717.733,1,'','0'),('field.field.node.formation.field_video',_binary 'a:16:{s:4:\"uuid\";s:36:\"f785cb6c-50cc-4815-a723-a51dfeb9f920\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"field.storage.node.field_video\";i:1;s:19:\"node.type.formation\";}s:6:\"module\";a:1:{i:0;s:7:\"youtube\";}}s:2:\"id\";s:26:\"node.formation.field_video\";s:10:\"field_name\";s:11:\"field_video\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:9:\"formation\";s:5:\"label\";s:5:\"Video\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:7:\"youtube\";}',-1,1680008717.733,1,'','0'),('field.field.node.offres_emploi.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"1d7f48f6-3ad0-4d65-8fe4-a209a6032cae\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:23:\"node.type.offres_emploi\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:23:\"node.offres_emploi.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:13:\"offres_emploi\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.636,1,'','0'),('field.field.node.offres_emploi.field_meta_tags',_binary 'a:16:{s:4:\"uuid\";s:36:\"ce44dc75-fbc7-4b3f-bd4c-c8b0986f2625\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.node.field_meta_tags\";i:1;s:23:\"node.type.offres_emploi\";}s:6:\"module\";a:1:{i:0;s:7:\"metatag\";}}s:2:\"id\";s:34:\"node.offres_emploi.field_meta_tags\";s:10:\"field_name\";s:15:\"field_meta_tags\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:13:\"offres_emploi\";s:5:\"label\";s:9:\"Meta tags\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:7:\"metatag\";}',-1,1680008717.773,1,'','0'),('field.field.node.offres_emploi.webform',_binary 'a:16:{s:4:\"uuid\";s:36:\"f92d7cd2-86ff-489f-a158-a151a7f10611\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:26:\"field.storage.node.webform\";i:1;s:23:\"node.type.offres_emploi\";i:2;s:30:\"webform.webform.offre_d_emploi\";}s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:2:\"id\";s:26:\"node.offres_emploi.webform\";s:10:\"field_name\";s:7:\"webform\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:13:\"offres_emploi\";s:5:\"label\";s:7:\"Webform\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:1:{i:0;a:5:{s:11:\"target_uuid\";s:36:\"00dffe49-2f4d-4925-af08-464ec6f9a518\";s:12:\"default_data\";s:0:\"\";s:6:\"status\";s:4:\"open\";s:4:\"open\";s:0:\"\";s:5:\"close\";s:0:\"\";}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:15:\"default:webform\";s:16:\"handler_settings\";a:2:{s:14:\"target_bundles\";N;s:11:\"auto_create\";b:0;}}s:10:\"field_type\";s:7:\"webform\";}',-1,1680008717.773,1,'','0'),('field.field.node.page.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"f9e04db4-6fb6-4df0-bcb5-a4aabe07d7b0\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:14:\"node.type.page\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KgVkxLl_K3E3lvN6CEoWQIDT0V8J4Mv-fVYrAIc7-FE\";}s:2:\"id\";s:14:\"node.page.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.580,1,'','0'),('field.field.node.page.field_content',_binary 'a:16:{s:4:\"uuid\";s:36:\"10ae3af3-b6cf-4df8-98ed-423437a33331\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:6:{i:0;s:32:\"field.storage.node.field_content\";i:1;s:14:\"node.type.page\";i:2;s:36:\"paragraphs.paragraphs_type.block_cta\";i:3;s:43:\"paragraphs.paragraphs_type.block_text_image\";i:4;s:41:\"paragraphs.paragraphs_type.composant_text\";i:5;s:34:\"paragraphs.paragraphs_type.equipes\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:2:\"id\";s:23:\"node.page.field_content\";s:10:\"field_name\";s:13:\"field_content\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:4:{s:9:\"block_cta\";s:9:\"block_cta\";s:7:\"equipes\";s:7:\"equipes\";s:16:\"block_text_image\";s:16:\"block_text_image\";s:14:\"composant_text\";s:14:\"composant_text\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:8:{s:9:\"block_cta\";a:2:{s:6:\"weight\";i:5;s:7:\"enabled\";b:1;}s:16:\"block_text_image\";a:2:{s:6:\"weight\";i:7;s:7:\"enabled\";b:1;}s:17:\"composant_content\";a:2:{s:6:\"weight\";i:11;s:7:\"enabled\";b:0;}s:14:\"composant_text\";a:2:{s:6:\"weight\";i:12;s:7:\"enabled\";b:1;}s:7:\"content\";a:2:{s:6:\"weight\";i:13;s:7:\"enabled\";b:0;}s:6:\"equipe\";a:2:{s:6:\"weight\";i:4;s:7:\"enabled\";b:0;}s:7:\"equipes\";a:2:{s:6:\"weight\";i:5;s:7:\"enabled\";b:1;}s:14:\"reseau_sociaux\";a:2:{s:6:\"weight\";i:6;s:7:\"enabled\";b:0;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}',-1,1680008717.811,1,'','0'),('field.field.node.page.field_meta_tags',_binary 'a:16:{s:4:\"uuid\";s:36:\"677768a2-67f3-4202-81d5-794658366cb8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.node.field_meta_tags\";i:1;s:14:\"node.type.page\";}s:6:\"module\";a:1:{i:0;s:7:\"metatag\";}}s:2:\"id\";s:25:\"node.page.field_meta_tags\";s:10:\"field_name\";s:15:\"field_meta_tags\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:4:\"page\";s:5:\"label\";s:9:\"Meta tags\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:7:\"metatag\";}',-1,1680008717.811,1,'','0'),('field.field.node.partenaire.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"88d9a510-8e0d-414f-a686-e39a93ab7db8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:20:\"node.type.partenaire\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:20:\"node.partenaire.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:10:\"partenaire\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:1;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.625,1,'','0'),('field.field.node.partenaire.field_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"83f8cad0-8d47-429d-9a32-21a61635b2f2\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"field.storage.node.field_image\";i:1;s:20:\"node.type.partenaire\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:27:\"node.partenaire.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:10:\"partenaire\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}',-1,1680008717.845,1,'','0'),('field.field.node.partenaire.field_lien',_binary 'a:16:{s:4:\"uuid\";s:36:\"b94590a9-8aa0-4077-a0f3-a1ac9ab3b53d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:29:\"field.storage.node.field_lien\";i:1;s:20:\"node.type.partenaire\";}}s:2:\"id\";s:26:\"node.partenaire.field_lien\";s:10:\"field_name\";s:10:\"field_lien\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:10:\"partenaire\";s:5:\"label\";s:4:\"Lien\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1680008717.845,1,'','0'),('field.field.node.partenaire.field_meta_tags',_binary 'a:16:{s:4:\"uuid\";s:36:\"b00463dd-f301-46b8-a617-c6b4ca791060\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.node.field_meta_tags\";i:1;s:20:\"node.type.partenaire\";}s:6:\"module\";a:1:{i:0;s:7:\"metatag\";}}s:2:\"id\";s:31:\"node.partenaire.field_meta_tags\";s:10:\"field_name\";s:15:\"field_meta_tags\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:10:\"partenaire\";s:5:\"label\";s:9:\"Meta tags\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:7:\"metatag\";}',-1,1680008717.845,1,'','0'),('field.field.node.rapport.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"e6ba42e3-810d-4e5a-9a95-bfa622b8cbe1\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:17:\"node.type.rapport\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:17:\"node.rapport.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"rapport\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:1;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.647,1,'','0'),('field.field.node.rapport.field_document_pdf',_binary 'a:16:{s:4:\"uuid\";s:36:\"92059787-de34-4d97-80cf-1dce504bcfcd\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:37:\"field.storage.node.field_document_pdf\";i:1;s:17:\"node.type.rapport\";}s:6:\"module\";a:1:{i:0;s:4:\"file\";}}s:2:\"id\";s:31:\"node.rapport.field_document_pdf\";s:10:\"field_name\";s:18:\"field_document_pdf\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"rapport\";s:5:\"label\";s:8:\"Document\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:6:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:3:\"pdf\";s:12:\"max_filesize\";s:0:\"\";s:17:\"description_field\";b:0;}s:10:\"field_type\";s:4:\"file\";}',-1,1680008717.881,1,'','0'),('field.field.node.rapport.field_type',_binary 'a:16:{s:4:\"uuid\";s:36:\"9166450b-a033-45dd-b9de-664a9d239a69\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:3:{i:0;s:29:\"field.storage.node.field_type\";i:1;s:17:\"node.type.rapport\";i:2;s:32:\"taxonomy.vocabulary.type_rapport\";}}s:2:\"id\";s:23:\"node.rapport.field_type\";s:10:\"field_name\";s:10:\"field_type\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"rapport\";s:5:\"label\";s:4:\"Type\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:21:\"default:taxonomy_term\";s:16:\"handler_settings\";a:4:{s:14:\"target_bundles\";a:1:{s:12:\"type_rapport\";s:12:\"type_rapport\";}s:4:\"sort\";a:2:{s:5:\"field\";s:4:\"name\";s:9:\"direction\";s:3:\"asc\";}s:11:\"auto_create\";b:0;s:18:\"auto_create_bundle\";s:0:\"\";}}s:10:\"field_type\";s:16:\"entity_reference\";}',-1,1680008717.881,1,'','0'),('field.field.node.temoignage.body',_binary 'a:16:{s:4:\"uuid\";s:36:\"13eee719-4eb1-4c89-8f92-07f53d817f31\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:20:\"node.type.temoignage\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:20:\"node.temoignage.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:10:\"temoignage\";s:5:\"label\";s:4:\"Body\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.603,1,'','0'),('field.field.node.temoignage.field_description',_binary 'a:16:{s:4:\"uuid\";s:36:\"f70268b8-5048-496d-835a-332e506f95fb\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:36:\"field.storage.node.field_description\";i:1;s:20:\"node.type.temoignage\";}}s:2:\"id\";s:33:\"node.temoignage.field_description\";s:10:\"field_name\";s:17:\"field_description\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:10:\"temoignage\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:11:\"string_long\";}',-1,1680008717.917,1,'','0'),('field.field.node.temoignage.field_meta_tags',_binary 'a:16:{s:4:\"uuid\";s:36:\"d40beb90-95ab-4bfa-8c4a-44a8987afcbc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.node.field_meta_tags\";i:1;s:20:\"node.type.temoignage\";}s:6:\"module\";a:1:{i:0;s:7:\"metatag\";}}s:2:\"id\";s:31:\"node.temoignage.field_meta_tags\";s:10:\"field_name\";s:15:\"field_meta_tags\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:10:\"temoignage\";s:5:\"label\";s:9:\"Meta tags\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:7:\"metatag\";}',-1,1680008717.917,1,'','0'),('field.field.node.temoignage.field_poste',_binary 'a:16:{s:4:\"uuid\";s:36:\"80d5aba5-1a81-4dec-9983-574f240efc0b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:30:\"field.storage.node.field_poste\";i:1;s:20:\"node.type.temoignage\";}}s:2:\"id\";s:27:\"node.temoignage.field_poste\";s:10:\"field_name\";s:11:\"field_poste\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:10:\"temoignage\";s:5:\"label\";s:5:\"Poste\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1680008717.917,1,'','0'),('field.field.node.webform.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"e7597922-1a03-4bf9-8402-7cfe30a7a395\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"field.storage.node.body\";i:1;s:17:\"node.type.webform\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-Qu0UyzQ0jD4TDYq8fOasS-D-vGd3gSwzi15PzRJUD4\";}s:2:\"id\";s:17:\"node.webform.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"webform\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:15:\"display_summary\";b:0;s:16:\"required_summary\";b:0;}s:10:\"field_type\";s:17:\"text_with_summary\";}',-1,1680008717.615,1,'','0'),('field.field.node.webform.field_meta_tags',_binary 'a:16:{s:4:\"uuid\";s:36:\"be8f925a-91cc-432f-9c23-1ce0d41d2cdc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.node.field_meta_tags\";i:1;s:17:\"node.type.webform\";}s:6:\"module\";a:1:{i:0;s:7:\"metatag\";}}s:2:\"id\";s:28:\"node.webform.field_meta_tags\";s:10:\"field_name\";s:15:\"field_meta_tags\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"webform\";s:5:\"label\";s:9:\"Meta tags\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:7:\"metatag\";}',-1,1680008717.955,1,'','0'),('field.field.node.webform.webform',_binary 'a:17:{s:4:\"uuid\";s:36:\"a2270a46-776b-49c3-bac2-7b3931225b76\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:26:\"field.storage.node.webform\";i:1;s:17:\"node.type.webform\";}s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"w6hvTj8CaO8YVQDnlsD-jRBzMA_vNmx2cXLEKX13yT4\";}s:2:\"id\";s:20:\"node.webform.webform\";s:10:\"field_name\";s:7:\"webform\";s:11:\"entity_type\";s:4:\"node\";s:6:\"bundle\";s:7:\"webform\";s:5:\"label\";s:7:\"Webform\";s:11:\"description\";s:62:\"Select the webform that you would like to attach to this node.\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:1:{i:0;a:5:{s:11:\"target_uuid\";s:0:\"\";s:12:\"default_data\";s:0:\"\";s:6:\"status\";s:4:\"open\";s:4:\"open\";s:0:\"\";s:5:\"close\";s:0:\"\";}}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:15:\"default:webform\";s:16:\"handler_settings\";a:0:{}}s:10:\"field_type\";s:7:\"webform\";}',-1,1680008717.955,1,'','0'),('field.field.paragraph.block_cta.field_body',_binary 'a:16:{s:4:\"uuid\";s:36:\"2721eb96-fbcb-404c-b586-0b33acc5c29d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.paragraph.field_body\";i:1;s:36:\"paragraphs.paragraphs_type.block_cta\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:30:\"paragraph.block_cta.field_body\";s:10:\"field_name\";s:10:\"field_body\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:9:\"block_cta\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:9:\"text_long\";}',-1,1680008718.023,1,'','0'),('field.field.paragraph.block_cta.field_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"aa3b97bd-c90e-4b44-bd13-6ea114dfaa8e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:35:\"field.storage.paragraph.field_image\";i:1;s:36:\"paragraphs.paragraphs_type.block_cta\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:31:\"paragraph.block_cta.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:9:\"block_cta\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}',-1,1680008718.023,1,'','0'),('field.field.paragraph.block_cta.field_link',_binary 'a:16:{s:4:\"uuid\";s:36:\"a67abd2f-7b33-48a1-a5aa-9063a02c178b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.paragraph.field_link\";i:1;s:36:\"paragraphs.paragraphs_type.block_cta\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:2:\"id\";s:30:\"paragraph.block_cta.field_link\";s:10:\"field_name\";s:10:\"field_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:9:\"block_cta\";s:5:\"label\";s:4:\"Lien\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:1;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}',-1,1680008718.024,1,'','0'),('field.field.paragraph.block_cta.field_position_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"7882b382-314a-452f-8907-48129d1e10dc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:44:\"field.storage.paragraph.field_position_image\";i:1;s:36:\"paragraphs.paragraphs_type.block_cta\";}s:6:\"module\";a:1:{i:0;s:7:\"options\";}}s:2:\"id\";s:40:\"paragraph.block_cta.field_position_image\";s:10:\"field_name\";s:20:\"field_position_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:9:\"block_cta\";s:5:\"label\";s:14:\"Position Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:11:\"list_string\";}',-1,1680008718.024,1,'','0'),('field.field.paragraph.block_text_image.field_body',_binary 'a:16:{s:4:\"uuid\";s:36:\"74699d7c-ba8b-49bd-b8b8-3fa9a9e3f39d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.paragraph.field_body\";i:1;s:43:\"paragraphs.paragraphs_type.block_text_image\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:37:\"paragraph.block_text_image.field_body\";s:10:\"field_name\";s:10:\"field_body\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"block_text_image\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:9:\"text_long\";}',-1,1680008718.048,1,'','0'),('field.field.paragraph.block_text_image.field_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"229c3ce0-58dc-4e34-86af-158c718c29d4\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:35:\"field.storage.paragraph.field_image\";i:1;s:43:\"paragraphs.paragraphs_type.block_text_image\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:38:\"paragraph.block_text_image.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"block_text_image\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}',-1,1680008718.048,1,'','0'),('field.field.paragraph.block_text_image.field_position_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"743d2b89-82e5-41ef-96b1-5e863503dba5\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:44:\"field.storage.paragraph.field_position_image\";i:1;s:43:\"paragraphs.paragraphs_type.block_text_image\";}s:6:\"module\";a:1:{i:0;s:7:\"options\";}}s:2:\"id\";s:47:\"paragraph.block_text_image.field_position_image\";s:10:\"field_name\";s:20:\"field_position_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:16:\"block_text_image\";s:5:\"label\";s:14:\"Position Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:11:\"list_string\";}',-1,1680008718.048,1,'','0'),('field.field.paragraph.composant_content.field_body',_binary 'a:16:{s:4:\"uuid\";s:36:\"a60f7bd9-a21c-40ab-a324-99611569a7ad\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.paragraph.field_body\";i:1;s:44:\"paragraphs.paragraphs_type.composant_content\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:38:\"paragraph.composant_content.field_body\";s:10:\"field_name\";s:10:\"field_body\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:17:\"composant_content\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:9:\"text_long\";}',-1,1680008718.070,1,'','0'),('field.field.paragraph.composant_content.field_content',_binary 'a:16:{s:4:\"uuid\";s:36:\"d8ff7b9c-eec7-4b84-82d7-a4724381916a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:37:\"field.storage.paragraph.field_content\";i:1;s:44:\"paragraphs.paragraphs_type.composant_content\";i:2;s:34:\"paragraphs.paragraphs_type.content\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:2:\"id\";s:41:\"paragraph.composant_content.field_content\";s:10:\"field_name\";s:13:\"field_content\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:17:\"composant_content\";s:5:\"label\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:7:\"content\";s:7:\"content\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:7:{s:9:\"block_cta\";a:2:{s:6:\"weight\";i:8;s:7:\"enabled\";b:0;}s:16:\"block_text_image\";a:2:{s:6:\"weight\";i:9;s:7:\"enabled\";b:0;}s:17:\"composant_content\";a:2:{s:6:\"weight\";i:10;s:7:\"enabled\";b:0;}s:7:\"content\";a:2:{s:6:\"weight\";i:11;s:7:\"enabled\";b:1;}s:6:\"equipe\";a:2:{s:6:\"weight\";i:12;s:7:\"enabled\";b:0;}s:7:\"equipes\";a:2:{s:6:\"weight\";i:13;s:7:\"enabled\";b:0;}s:14:\"reseau_sociaux\";a:2:{s:6:\"weight\";i:14;s:7:\"enabled\";b:0;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}',-1,1680008718.070,1,'','0'),('field.field.paragraph.composant_text.field_body',_binary 'a:16:{s:4:\"uuid\";s:36:\"37cc8585-8847-4985-8527-0d880e2d2952\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.paragraph.field_body\";i:1;s:41:\"paragraphs.paragraphs_type.composant_text\";}s:6:\"module\";a:1:{i:0;s:4:\"text\";}}s:2:\"id\";s:35:\"paragraph.composant_text.field_body\";s:10:\"field_name\";s:10:\"field_body\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"composant_text\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:9:\"text_long\";}',-1,1680008718.102,1,'','0'),('field.field.paragraph.content.field_block_list',_binary 'a:16:{s:4:\"uuid\";s:36:\"23823564-2658-4e9e-b1e1-1ded1eb8a194\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:40:\"field.storage.paragraph.field_block_list\";i:1;s:34:\"paragraphs.paragraphs_type.content\";}s:6:\"module\";a:1:{i:0;s:11:\"block_field\";}}s:2:\"id\";s:34:\"paragraph.content.field_block_list\";s:10:\"field_name\";s:16:\"field_block_list\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"content\";s:5:\"label\";s:10:\"Block list\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:9:\"selection\";s:6:\"blocks\";s:18:\"selection_settings\";a:1:{s:10:\"plugin_ids\";a:3:{s:28:\"views_block:articles-block_1\";s:28:\"views_block:articles-block_1\";s:30:\"views_block:evenements-block_1\";s:30:\"views_block:evenements-block_1\";s:30:\"views_block:evenements-block_2\";s:30:\"views_block:evenements-block_2\";}}}s:10:\"field_type\";s:11:\"block_field\";}',-1,1680008717.999,1,'','0'),('field.field.paragraph.content.field_titre',_binary 'a:16:{s:4:\"uuid\";s:36:\"b600398c-b397-42c0-985e-dd90786d14bb\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:35:\"field.storage.paragraph.field_titre\";i:1;s:34:\"paragraphs.paragraphs_type.content\";}}s:2:\"id\";s:29:\"paragraph.content.field_titre\";s:10:\"field_name\";s:11:\"field_titre\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"content\";s:5:\"label\";s:5:\"Titre\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1680008718.124,1,'','0'),('field.field.paragraph.equipe.field_description',_binary 'a:16:{s:4:\"uuid\";s:36:\"c915364a-a6ba-428d-8efe-4a2a40860ede\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:41:\"field.storage.paragraph.field_description\";i:1;s:33:\"paragraphs.paragraphs_type.equipe\";}}s:2:\"id\";s:34:\"paragraph.equipe.field_description\";s:10:\"field_name\";s:17:\"field_description\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:6:\"equipe\";s:5:\"label\";s:11:\"Description\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:11:\"string_long\";}',-1,1680008718.147,1,'','0'),('field.field.paragraph.equipe.field_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"ead58570-3f37-418d-b3c2-8107a5046478\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:35:\"field.storage.paragraph.field_image\";i:1;s:33:\"paragraphs.paragraphs_type.equipe\";}s:6:\"module\";a:1:{i:0;s:5:\"image\";}}s:2:\"id\";s:28:\"paragraph.equipe.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:6:\"equipe\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:31:\"[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:1;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}',-1,1680008718.147,1,'','0'),('field.field.paragraph.equipe.field_lien_reseau_social',_binary 'a:16:{s:4:\"uuid\";s:36:\"5f76e835-76c5-413c-9121-9d6ca47273a4\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:48:\"field.storage.paragraph.field_lien_reseau_social\";i:1;s:33:\"paragraphs.paragraphs_type.equipe\";}s:6:\"module\";a:1:{i:0;s:4:\"link\";}}s:2:\"id\";s:41:\"paragraph.equipe.field_lien_reseau_social\";s:10:\"field_name\";s:24:\"field_lien_reseau_social\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:6:\"equipe\";s:5:\"label\";s:18:\"Lien reseau social\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:5:\"title\";i:1;s:9:\"link_type\";i:17;}s:10:\"field_type\";s:4:\"link\";}',-1,1680008718.147,1,'','0'),('field.field.paragraph.equipe.field_nom',_binary 'a:16:{s:4:\"uuid\";s:36:\"76b14455-cc10-491f-8e7b-18047b29f2af\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:33:\"field.storage.paragraph.field_nom\";i:1;s:33:\"paragraphs.paragraphs_type.equipe\";}}s:2:\"id\";s:26:\"paragraph.equipe.field_nom\";s:10:\"field_name\";s:9:\"field_nom\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:6:\"equipe\";s:5:\"label\";s:3:\"Nom\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1680008718.147,1,'','0'),('field.field.paragraph.equipe.field_poste',_binary 'a:16:{s:4:\"uuid\";s:36:\"bc75c010-cb8d-4c0f-86a2-1f1078242d42\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:35:\"field.storage.paragraph.field_poste\";i:1;s:33:\"paragraphs.paragraphs_type.equipe\";}}s:2:\"id\";s:28:\"paragraph.equipe.field_poste\";s:10:\"field_name\";s:11:\"field_poste\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:6:\"equipe\";s:5:\"label\";s:5:\"Poste\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1680008718.147,1,'','0'),('field.field.paragraph.equipes.field_membre',_binary 'a:16:{s:4:\"uuid\";s:36:\"14e5d4b2-01a4-4eb1-bfb1-dd0ab8ef2196\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:36:\"field.storage.paragraph.field_membre\";i:1;s:33:\"paragraphs.paragraphs_type.equipe\";i:2;s:34:\"paragraphs.paragraphs_type.equipes\";}s:6:\"module\";a:1:{i:0;s:26:\"entity_reference_revisions\";}}s:2:\"id\";s:30:\"paragraph.equipes.field_membre\";s:10:\"field_name\";s:12:\"field_membre\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"equipes\";s:5:\"label\";s:6:\"Membre\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:0;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:2:{s:7:\"handler\";s:17:\"default:paragraph\";s:16:\"handler_settings\";a:3:{s:14:\"target_bundles\";a:1:{s:6:\"equipe\";s:6:\"equipe\";}s:6:\"negate\";i:0;s:24:\"target_bundles_drag_drop\";a:3:{s:6:\"equipe\";a:2:{s:6:\"weight\";i:4;s:7:\"enabled\";b:1;}s:7:\"equipes\";a:2:{s:6:\"weight\";i:5;s:7:\"enabled\";b:0;}s:14:\"reseau_sociaux\";a:2:{s:6:\"weight\";i:6;s:7:\"enabled\";b:0;}}}}s:10:\"field_type\";s:26:\"entity_reference_revisions\";}',-1,1680008718.170,1,'','0'),('field.field.paragraph.equipes.field_titre',_binary 'a:16:{s:4:\"uuid\";s:36:\"775db676-279c-4306-a553-f52590b75296\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:35:\"field.storage.paragraph.field_titre\";i:1;s:34:\"paragraphs.paragraphs_type.equipes\";}}s:2:\"id\";s:29:\"paragraph.equipes.field_titre\";s:10:\"field_name\";s:11:\"field_titre\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:7:\"equipes\";s:5:\"label\";s:5:\"Titre\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1680008718.170,1,'','0'),('field.field.paragraph.reseau_sociaux.field_icon',_binary 'a:16:{s:4:\"uuid\";s:36:\"60f3c973-d6c1-43fc-9a88-5674edbeb407\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.paragraph.field_icon\";i:1;s:41:\"paragraphs.paragraphs_type.reseau_sociaux\";}}s:2:\"id\";s:35:\"paragraph.reseau_sociaux.field_icon\";s:10:\"field_name\";s:10:\"field_icon\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"reseau_sociaux\";s:5:\"label\";s:4:\"Icon\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1680008718.189,1,'','0'),('field.field.paragraph.reseau_sociaux.field_lien',_binary 'a:16:{s:4:\"uuid\";s:36:\"fe9d799d-6496-44ba-baea-74d82b3bcab3\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"config\";a:2:{i:0;s:34:\"field.storage.paragraph.field_lien\";i:1;s:41:\"paragraphs.paragraphs_type.reseau_sociaux\";}}s:2:\"id\";s:35:\"paragraph.reseau_sociaux.field_lien\";s:10:\"field_name\";s:10:\"field_lien\";s:11:\"entity_type\";s:9:\"paragraph\";s:6:\"bundle\";s:14:\"reseau_sociaux\";s:5:\"label\";s:4:\"Lien\";s:11:\"description\";s:0:\"\";s:8:\"required\";b:1;s:12:\"translatable\";b:0;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:0:{}s:10:\"field_type\";s:6:\"string\";}',-1,1680008718.189,1,'','0'),('field.field.user.user.user_picture',_binary 'a:17:{s:4:\"uuid\";s:36:\"7b864bcd-a364-44ad-bd28-c26b3678a87c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:31:\"field.storage.user.user_picture\";}s:6:\"module\";a:2:{i:0;s:5:\"image\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"twhm-ZOwSVkUjuLI_pQsaPo_pVLcqFfDmY-ojfqw0yk\";}s:2:\"id\";s:22:\"user.user.user_picture\";s:10:\"field_name\";s:12:\"user_picture\";s:11:\"entity_type\";s:4:\"user\";s:6:\"bundle\";s:4:\"user\";s:5:\"label\";s:5:\"Image\";s:11:\"description\";s:32:\"Votre visage ou image virtuelle.\";s:8:\"required\";b:0;s:12:\"translatable\";b:1;s:13:\"default_value\";a:0:{}s:22:\"default_value_callback\";s:0:\"\";s:8:\"settings\";a:12:{s:7:\"handler\";s:12:\"default:file\";s:16:\"handler_settings\";a:0:{}s:14:\"file_directory\";s:40:\"pictures/[date:custom:Y]-[date:custom:m]\";s:15:\"file_extensions\";s:16:\"png gif jpg jpeg\";s:12:\"max_filesize\";s:0:\"\";s:14:\"max_resolution\";s:0:\"\";s:14:\"min_resolution\";s:0:\"\";s:9:\"alt_field\";b:0;s:18:\"alt_field_required\";b:0;s:11:\"title_field\";b:0;s:20:\"title_field_required\";b:0;s:13:\"default_image\";a:5:{s:4:\"uuid\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:10:\"field_type\";s:5:\"image\";}',-1,1680008718.211,1,'','0'),('field.storage.block_content.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"448fef53-9ed9-480f-9808-fd4aa2abd935\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc\";}s:2:\"id\";s:18:\"block_content.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:17:\"text_with_summary\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:1;s:14:\"custom_storage\";b:0;}',-1,1680008716.869,1,'','0'),('field.storage.block_content.field_content',_binary 'a:16:{s:4:\"uuid\";s:36:\"69eb391a-c0d0-40f7-a282-df5ea0f7b22a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:2:\"id\";s:27:\"block_content.field_content\";s:10:\"field_name\";s:13:\"field_content\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008716.869,1,'','0'),('field.storage.block_content.field_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"317051fc-8fc0-4931-abda-fb43f4aa97f8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:4:\"file\";i:2;s:5:\"image\";}}s:2:\"id\";s:25:\"block_content.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008716.869,1,'','0'),('field.storage.block_content.field_link',_binary 'a:16:{s:4:\"uuid\";s:36:\"e4db2f0e-70f5-43b1-994a-907fcfaba93a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"link\";}}s:2:\"id\";s:24:\"block_content.field_link\";s:10:\"field_name\";s:10:\"field_link\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008716.869,1,'','0'),('field.storage.block_content.field_reseau_sociaux',_binary 'a:16:{s:4:\"uuid\";s:36:\"f9bde355-9745-4c98-8a48-f95ebba5c596\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:13:\"block_content\";i:1;s:26:\"entity_reference_revisions\";i:2;s:10:\"paragraphs\";}}s:2:\"id\";s:34:\"block_content.field_reseau_sociaux\";s:10:\"field_name\";s:20:\"field_reseau_sociaux\";s:11:\"entity_type\";s:13:\"block_content\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008716.869,1,'','0'),('field.storage.comment.comment_body',_binary 'a:17:{s:4:\"uuid\";s:36:\"442f2124-0736-438f-9809-9d79591c5248\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"comment\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw\";}s:2:\"id\";s:20:\"comment.comment_body\";s:10:\"field_name\";s:12:\"comment_body\";s:11:\"entity_type\";s:7:\"comment\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:1;s:14:\"custom_storage\";b:0;}',-1,1680008716.976,1,'','0'),('field.storage.node.body',_binary 'a:17:{s:4:\"uuid\";s:36:\"a49f6445-707a-4ba5-bd9f-50cb169e2324\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"text\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY\";}s:2:\"id\";s:9:\"node.body\";s:10:\"field_name\";s:4:\"body\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:17:\"text_with_summary\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:1;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.comment',_binary 'a:17:{s:4:\"uuid\";s:36:\"65611bb6-48b1-4c37-b75d-579c2c6451d0\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"comment\";i:1;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc\";}s:2:\"id\";s:12:\"node.comment\";s:10:\"field_name\";s:7:\"comment\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:7:\"comment\";s:8:\"settings\";a:1:{s:12:\"comment_type\";s:7:\"comment\";}s:6:\"module\";s:7:\"comment\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_categorie',_binary 'a:16:{s:4:\"uuid\";s:36:\"3ccf0887-24db-41a9-84d0-dd1a16496fdc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:8:\"taxonomy\";}}s:2:\"id\";s:20:\"node.field_categorie\";s:10:\"field_name\";s:15:\"field_categorie\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:13:\"taxonomy_term\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_content',_binary 'a:16:{s:4:\"uuid\";s:36:\"a4989aea-cf45-47ad-b184-3a6a719a449a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:26:\"entity_reference_revisions\";i:1;s:4:\"node\";i:2;s:10:\"paragraphs\";}}s:2:\"id\";s:18:\"node.field_content\";s:10:\"field_name\";s:13:\"field_content\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_date_debut',_binary 'a:16:{s:4:\"uuid\";s:36:\"e1193754-facf-4206-8de3-3bf9ad4e28c5\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:8:\"datetime\";i:1;s:4:\"node\";}}s:2:\"id\";s:21:\"node.field_date_debut\";s:10:\"field_name\";s:16:\"field_date_debut\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:8:\"datetime\";s:8:\"settings\";a:1:{s:13:\"datetime_type\";s:4:\"date\";}s:6:\"module\";s:8:\"datetime\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_date_fin',_binary 'a:16:{s:4:\"uuid\";s:36:\"89ce8883-b743-43b3-9524-60f37e71038c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:8:\"datetime\";i:1;s:4:\"node\";}}s:2:\"id\";s:19:\"node.field_date_fin\";s:10:\"field_name\";s:14:\"field_date_fin\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:8:\"datetime\";s:8:\"settings\";a:1:{s:13:\"datetime_type\";s:4:\"date\";}s:6:\"module\";s:8:\"datetime\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_description',_binary 'a:16:{s:4:\"uuid\";s:36:\"78d385f8-3827-40ad-bac0-0bac616b0bec\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:2:\"id\";s:22:\"node.field_description\";s:10:\"field_name\";s:17:\"field_description\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:11:\"string_long\";s:8:\"settings\";a:1:{s:14:\"case_sensitive\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_document',_binary 'a:16:{s:4:\"uuid\";s:36:\"1b40d18a-fab8-497b-b139-30f44675af49\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:4:\"node\";}}s:2:\"id\";s:19:\"node.field_document\";s:10:\"field_name\";s:14:\"field_document\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:4:\"file\";s:8:\"settings\";a:4:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";}s:6:\"module\";s:4:\"file\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_document_pdf',_binary 'a:16:{s:4:\"uuid\";s:36:\"5a76650b-62f5-49de-85b3-465f06d8778d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:4:\"node\";}}s:2:\"id\";s:23:\"node.field_document_pdf\";s:10:\"field_name\";s:18:\"field_document_pdf\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:4:\"file\";s:8:\"settings\";a:4:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";}s:6:\"module\";s:4:\"file\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_image',_binary 'a:17:{s:4:\"uuid\";s:36:\"9b7b42da-3c6f-4d48-bb59-b62dbbe10c49\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EymokncRIZ7SgQT2IdOQhQJicX4nNc0K89ik-LxmOHE\";}s:2:\"id\";s:16:\"node.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_images',_binary 'a:16:{s:4:\"uuid\";s:36:\"99e53b9a-c62e-4e2a-a3c2-a089d14c0fff\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:4:\"node\";}}s:2:\"id\";s:17:\"node.field_images\";s:10:\"field_name\";s:12:\"field_images\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_lien',_binary 'a:16:{s:4:\"uuid\";s:36:\"cd72d8a3-d701-4173-9cd7-54678bf9c36e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:2:\"id\";s:15:\"node.field_lien\";s:10:\"field_name\";s:10:\"field_lien\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:14:\"case_sensitive\";b:0;s:8:\"is_ascii\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_meta_tags',_binary 'a:16:{s:4:\"uuid\";s:36:\"db1e6c7b-5a5d-4970-8838-6b62a25e0e0b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"metatag\";i:1;s:4:\"node\";}}s:2:\"id\";s:20:\"node.field_meta_tags\";s:10:\"field_name\";s:15:\"field_meta_tags\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:7:\"metatag\";s:8:\"settings\";a:0:{}s:6:\"module\";s:7:\"metatag\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_poste',_binary 'a:16:{s:4:\"uuid\";s:36:\"f6166ce6-24a8-4212-9949-36a63f2a2d25\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:2:\"id\";s:16:\"node.field_poste\";s:10:\"field_name\";s:11:\"field_poste\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:14:\"case_sensitive\";b:0;s:8:\"is_ascii\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_tags',_binary 'a:17:{s:4:\"uuid\";s:36:\"f75233b9-cd90-4b39-9ae6-fd9400bbbd0f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:8:\"taxonomy\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs\";}s:2:\"id\";s:15:\"node.field_tags\";s:10:\"field_name\";s:10:\"field_tags\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:13:\"taxonomy_term\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_type',_binary 'a:16:{s:4:\"uuid\";s:36:\"f8262bb1-6a3a-46b0-aa5e-de9472004e43\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:8:\"taxonomy\";}}s:2:\"id\";s:15:\"node.field_type\";s:10:\"field_name\";s:10:\"field_type\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:16:\"entity_reference\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:13:\"taxonomy_term\";}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.field_video',_binary 'a:16:{s:4:\"uuid\";s:36:\"4b0de903-ab0e-4288-aca1-ecfa6dbcfd31\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:7:\"youtube\";}}s:2:\"id\";s:16:\"node.field_video\";s:10:\"field_name\";s:11:\"field_video\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:7:\"youtube\";s:8:\"settings\";a:0:{}s:6:\"module\";s:7:\"youtube\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.node.webform',_binary 'a:17:{s:4:\"uuid\";s:36:\"2bb66e2b-9f9e-436e-bbcc-70449674b898\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:7:\"webform\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:12:\"webform_node\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SJRNyZvo1lWcPLKxH_u6giTk1y51ymXvpKX65YUNd7w\";}s:2:\"id\";s:12:\"node.webform\";s:10:\"field_name\";s:7:\"webform\";s:11:\"entity_type\";s:4:\"node\";s:4:\"type\";s:7:\"webform\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:7:\"webform\";}s:6:\"module\";s:7:\"webform\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.144,1,'','0'),('field.storage.paragraph.field_block_list',_binary 'a:16:{s:4:\"uuid\";s:36:\"4f2c03a1-1b06-49d6-ac94-d8b49f124fec\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:11:\"block_field\";i:1;s:10:\"paragraphs\";}}s:2:\"id\";s:26:\"paragraph.field_block_list\";s:10:\"field_name\";s:16:\"field_block_list\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:11:\"block_field\";s:8:\"settings\";a:0:{}s:6:\"module\";s:11:\"block_field\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_body',_binary 'a:16:{s:4:\"uuid\";s:36:\"50b5db14-245a-490b-b721-02dd4be990d5\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:10:\"paragraphs\";i:1;s:4:\"text\";}}s:2:\"id\";s:20:\"paragraph.field_body\";s:10:\"field_name\";s:10:\"field_body\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:9:\"text_long\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"text\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_content',_binary 'a:16:{s:4:\"uuid\";s:36:\"dde55d7d-0ed8-4a65-a1d9-f69f00d655cb\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:26:\"entity_reference_revisions\";i:1;s:10:\"paragraphs\";}}s:2:\"id\";s:23:\"paragraph.field_content\";s:10:\"field_name\";s:13:\"field_content\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_description',_binary 'a:16:{s:4:\"uuid\";s:36:\"f404e885-ebc5-4795-8f8b-316cace8b81b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:2:\"id\";s:27:\"paragraph.field_description\";s:10:\"field_name\";s:17:\"field_description\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:11:\"string_long\";s:8:\"settings\";a:1:{s:14:\"case_sensitive\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_icon',_binary 'a:16:{s:4:\"uuid\";s:36:\"26fbeb98-65cf-471f-b7f3-35844fc1770a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:2:\"id\";s:20:\"paragraph.field_icon\";s:10:\"field_name\";s:10:\"field_icon\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:14:\"case_sensitive\";b:0;s:8:\"is_ascii\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"735c56c6-c58a-4666-a7c9-2304cae568eb\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:10:\"paragraphs\";}}s:2:\"id\";s:21:\"paragraph.field_image\";s:10:\"field_name\";s:11:\"field_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_lien',_binary 'a:16:{s:4:\"uuid\";s:36:\"8230c9e7-daa9-4265-9e59-6ffbbf470c87\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:2:\"id\";s:20:\"paragraph.field_lien\";s:10:\"field_name\";s:10:\"field_lien\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:14:\"case_sensitive\";b:0;s:8:\"is_ascii\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_lien_reseau_social',_binary 'a:16:{s:4:\"uuid\";s:36:\"74878fb2-32a5-4ab1-a97d-38edb000eea4\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:10:\"paragraphs\";}}s:2:\"id\";s:34:\"paragraph.field_lien_reseau_social\";s:10:\"field_name\";s:24:\"field_lien_reseau_social\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_link',_binary 'a:16:{s:4:\"uuid\";s:36:\"4f039d0c-98ce-4046-b814-07066f742c5f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"link\";i:1;s:10:\"paragraphs\";}}s:2:\"id\";s:20:\"paragraph.field_link\";s:10:\"field_name\";s:10:\"field_link\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:4:\"link\";s:8:\"settings\";a:0:{}s:6:\"module\";s:4:\"link\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_membre',_binary 'a:16:{s:4:\"uuid\";s:36:\"63798ddc-0a81-405d-8a2e-e3049fc61e85\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:26:\"entity_reference_revisions\";i:1;s:10:\"paragraphs\";}}s:2:\"id\";s:22:\"paragraph.field_membre\";s:10:\"field_name\";s:12:\"field_membre\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:26:\"entity_reference_revisions\";s:8:\"settings\";a:1:{s:11:\"target_type\";s:9:\"paragraph\";}s:6:\"module\";s:26:\"entity_reference_revisions\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:-1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_nom',_binary 'a:16:{s:4:\"uuid\";s:36:\"afb900b9-aeb0-4631-b286-c054ac107cf3\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:2:\"id\";s:19:\"paragraph.field_nom\";s:10:\"field_name\";s:9:\"field_nom\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:14:\"case_sensitive\";b:0;s:8:\"is_ascii\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_position_image',_binary 'a:16:{s:4:\"uuid\";s:36:\"0c2f50b7-4e44-4ede-a359-68381d817985\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"options\";i:1;s:10:\"paragraphs\";}}s:2:\"id\";s:30:\"paragraph.field_position_image\";s:10:\"field_name\";s:20:\"field_position_image\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:11:\"list_string\";s:8:\"settings\";a:2:{s:14:\"allowed_values\";a:2:{i:0;a:2:{s:5:\"value\";s:1:\"0\";s:5:\"label\";s:6:\"Gauche\";}i:1;a:2:{s:5:\"value\";s:1:\"1\";s:5:\"label\";s:6:\"Droite\";}}s:23:\"allowed_values_function\";s:0:\"\";}s:6:\"module\";s:7:\"options\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_poste',_binary 'a:16:{s:4:\"uuid\";s:36:\"57f1b5ba-c166-48ce-9829-6a7abc6e9297\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:2:\"id\";s:21:\"paragraph.field_poste\";s:10:\"field_name\";s:11:\"field_poste\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:14:\"case_sensitive\";b:0;s:8:\"is_ascii\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.paragraph.field_titre',_binary 'a:16:{s:4:\"uuid\";s:36:\"b40ba614-16f8-4394-9e02-6e6375309fe9\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:10:\"paragraphs\";}}s:2:\"id\";s:21:\"paragraph.field_titre\";s:10:\"field_name\";s:11:\"field_titre\";s:11:\"entity_type\";s:9:\"paragraph\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:3:{s:10:\"max_length\";i:255;s:14:\"case_sensitive\";b:0;s:8:\"is_ascii\";b:0;}s:6:\"module\";s:4:\"core\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:0:{}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.323,1,'','0'),('field.storage.user.user_picture',_binary 'a:17:{s:4:\"uuid\";s:36:\"5ab2b478-f4bf-400d-b47b-85df9a21f823\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:5:\"image\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"0q8-mw8y-Ls5I578sIPQFLp4ljpH7WvVYpzY-I9O-8E\";}s:2:\"id\";s:17:\"user.user_picture\";s:10:\"field_name\";s:12:\"user_picture\";s:11:\"entity_type\";s:4:\"user\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:5:{s:11:\"target_type\";s:4:\"file\";s:13:\"display_field\";b:0;s:15:\"display_default\";b:0;s:10:\"uri_scheme\";s:6:\"public\";s:13:\"default_image\";a:5:{s:4:\"uuid\";N;s:3:\"alt\";s:0:\"\";s:5:\"title\";s:0:\"\";s:5:\"width\";N;s:6:\"height\";N;}}s:6:\"module\";s:5:\"image\";s:6:\"locked\";b:0;s:11:\"cardinality\";i:1;s:12:\"translatable\";b:1;s:7:\"indexes\";a:1:{s:9:\"target_id\";a:1:{i:0;s:9:\"target_id\";}}s:22:\"persist_with_no_fields\";b:0;s:14:\"custom_storage\";b:0;}',-1,1680008717.251,1,'','0'),('filter.format.basic_html',_binary 'a:9:{s:4:\"uuid\";s:36:\"8e7d46f8-b94c-4742-afde-5a38d2f0c122\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:6:\"editor\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"RjoJPQLCAE8u1Ys_yCKubpkYlRz_Oy12a5qCVeNIHJ8\";}s:4:\"name\";s:11:\"HTML simple\";s:6:\"format\";s:10:\"basic_html\";s:6:\"weight\";i:-9;s:7:\"filters\";a:5:{s:11:\"filter_html\";a:5:{s:2:\"id\";s:11:\"filter_html\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:-10;s:8:\"settings\";a:3:{s:12:\"allowed_html\";s:243:\"<br> <p> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <cite> <dl> <dt> <dd> <a hreflang href> <blockquote cite> <ul type> <ol start type> <strong> <em> <code> <li> <img src alt data-entity-uuid data-entity-type height width data-caption data-align>\";s:16:\"filter_html_help\";b:0;s:20:\"filter_html_nofollow\";b:0;}}s:12:\"filter_align\";a:5:{s:2:\"id\";s:12:\"filter_align\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:7;s:8:\"settings\";a:0:{}}s:14:\"filter_caption\";a:5:{s:2:\"id\";s:14:\"filter_caption\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:8;s:8:\"settings\";a:0:{}}s:24:\"filter_html_image_secure\";a:5:{s:2:\"id\";s:24:\"filter_html_image_secure\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:9;s:8:\"settings\";a:0:{}}s:21:\"editor_file_reference\";a:5:{s:2:\"id\";s:21:\"editor_file_reference\";s:8:\"provider\";s:6:\"editor\";s:6:\"status\";b:1;s:6:\"weight\";i:11;s:8:\"settings\";a:0:{}}}}',-1,1680008723.729,1,'','0'),('filter.format.full_html',_binary 'a:9:{s:4:\"uuid\";s:36:\"49a1a84a-4fda-4dfa-87e2-89c717fd1701\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:6:\"editor\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"WNeK5FbcY8pXgEpbD_KgRzlF1-5PL3BJXwqaBctPTqw\";}s:4:\"name\";s:12:\"HTML complet\";s:6:\"format\";s:9:\"full_html\";s:6:\"weight\";i:-10;s:7:\"filters\";a:4:{s:12:\"filter_align\";a:5:{s:2:\"id\";s:12:\"filter_align\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:8;s:8:\"settings\";a:0:{}}s:14:\"filter_caption\";a:5:{s:2:\"id\";s:14:\"filter_caption\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:9;s:8:\"settings\";a:0:{}}s:20:\"filter_htmlcorrector\";a:5:{s:2:\"id\";s:20:\"filter_htmlcorrector\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:10;s:8:\"settings\";a:0:{}}s:21:\"editor_file_reference\";a:5:{s:2:\"id\";s:21:\"editor_file_reference\";s:8:\"provider\";s:6:\"editor\";s:6:\"status\";b:1;s:6:\"weight\";i:11;s:8:\"settings\";a:0:{}}}}',-1,1680008720.023,1,'','0'),('filter.format.plain_text',_binary 'a:9:{s:4:\"uuid\";s:36:\"a3d3ca70-f7ee-4113-81ac-e2c31fb497d3\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"NIKBt6kw_uPhNI0qtR2DnRf7mSOgAQdx7Q94SKMjXbQ\";}s:4:\"name\";s:10:\"Texte brut\";s:6:\"format\";s:10:\"plain_text\";s:6:\"weight\";i:-7;s:7:\"filters\";a:3:{s:18:\"filter_html_escape\";a:5:{s:2:\"id\";s:18:\"filter_html_escape\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:-10;s:8:\"settings\";a:0:{}}s:10:\"filter_url\";a:5:{s:2:\"id\";s:10:\"filter_url\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:17:\"filter_url_length\";i:72;}}s:12:\"filter_autop\";a:5:{s:2:\"id\";s:12:\"filter_autop\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}}}}',-1,1680008723.729,1,'','0'),('filter.format.restricted_html',_binary 'a:9:{s:4:\"uuid\";s:36:\"f4925fa7-6d28-446e-ae24-05e24e27d5eb\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"oz6NyPDAB4HB6N9hgH2LwNVtCd-sXbMG1fbn5KsRIDI\";}s:4:\"name\";s:14:\"HTML restreint\";s:6:\"format\";s:15:\"restricted_html\";s:6:\"weight\";i:-8;s:7:\"filters\";a:3:{s:11:\"filter_html\";a:5:{s:2:\"id\";s:11:\"filter_html\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:-10;s:8:\"settings\";a:3:{s:12:\"allowed_html\";s:149:\"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>\";s:16:\"filter_html_help\";b:1;s:20:\"filter_html_nofollow\";b:0;}}s:12:\"filter_autop\";a:5:{s:2:\"id\";s:12:\"filter_autop\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:0:{}}s:10:\"filter_url\";a:5:{s:2:\"id\";s:10:\"filter_url\";s:8:\"provider\";s:6:\"filter\";s:6:\"status\";b:1;s:6:\"weight\";i:0;s:8:\"settings\";a:1:{s:17:\"filter_url_length\";i:72;}}}}',-1,1680008723.729,1,'','0'),('filter.settings',_binary 'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA\";}s:8:\"langcode\";s:2:\"fr\";s:15:\"fallback_format\";s:10:\"plain_text\";s:27:\"always_show_fallback_choice\";b:0;}',-1,1680008723.757,1,'','0'),('gin.settings',_binary 'a:17:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"UvSCt3S_NldJPFzvhSNOy9vWoPPFhmsmTC12vtVss9s\";}s:8:\"langcode\";s:2:\"fr\";s:7:\"favicon\";a:1:{s:11:\"use_default\";b:1;}s:8:\"features\";a:4:{s:20:\"comment_user_picture\";b:1;s:25:\"comment_user_verification\";b:1;s:7:\"favicon\";b:1;s:17:\"node_user_picture\";b:1;}s:4:\"logo\";a:1:{s:11:\"use_default\";b:1;}s:20:\"third_party_settings\";a:1:{s:8:\"shortcut\";a:1:{s:11:\"module_link\";b:1;}}s:19:\"preset_accent_color\";s:4:\"blue\";s:18:\"preset_focus_color\";s:3:\"gin\";s:15:\"enable_darkmode\";s:1:\"0\";s:15:\"classic_toolbar\";s:10:\"horizontal\";s:26:\"secondary_toolbar_frontend\";b:1;s:18:\"high_contrast_mode\";b:0;s:12:\"accent_color\";s:0:\"\";s:11:\"focus_color\";s:0:\"\";s:14:\"layout_density\";s:7:\"default\";s:23:\"show_description_toggle\";b:0;s:24:\"show_user_theme_settings\";b:0;}',-1,1680008720.410,1,'','0'),('image.settings',_binary 'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw\";}s:8:\"langcode\";s:2:\"fr\";s:13:\"preview_image\";s:29:\"core/modules/image/sample.png\";s:26:\"allow_insecure_derivatives\";b:0;s:20:\"suppress_itok_output\";b:0;}',-1,1680008720.220,1,'','0'),('image.style.',_binary 'b:0;',-1,1680009129.218,1,'','0'),('image.style.large',_binary 'a:8:{s:4:\"uuid\";s:36:\"925448cc-6815-43c5-aa05-c8b34c49bcc4\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"J2n0RpFzS0-bgSyxjs6rSdgxB1rb-bTAgqywNx_964M\";}s:4:\"name\";s:5:\"large\";s:5:\"label\";s:16:\"Large (480×480)\";s:7:\"effects\";a:1:{s:36:\"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d\";a:4:{s:4:\"uuid\";s:36:\"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:480;s:6:\"height\";i:480;s:7:\"upscale\";b:0;}}}}',-1,1680008719.763,1,'','0'),('image.style.max_1300x1300',_binary 'a:8:{s:4:\"uuid\";s:36:\"0735904f-b656-4684-98bf-5f99abacf10d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:16:\"responsive_image\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TD595kkS8PAS0v5TKF6ylAqyG4uSO1y52SQqy7zdTIw\";}s:4:\"name\";s:13:\"max_1300x1300\";s:5:\"label\";s:13:\"Max 1300x1300\";s:7:\"effects\";a:1:{s:36:\"04caae9a-fa3e-4ea6-ae09-9c26aec7d308\";a:4:{s:4:\"uuid\";s:36:\"04caae9a-fa3e-4ea6-ae09-9c26aec7d308\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:1;s:4:\"data\";a:3:{s:5:\"width\";i:1300;s:6:\"height\";i:1300;s:7:\"upscale\";b:0;}}}}',-1,1680009095.415,1,'','0'),('image.style.max_2600x2600',_binary 'a:8:{s:4:\"uuid\";s:36:\"0ccebf1a-4d2b-429b-8db8-7305d23fb46c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:16:\"responsive_image\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"H3gjFlhgZXCVkzP_u0Nzo3HGVu2JtYEEoD4U6fUO6D0\";}s:4:\"name\";s:13:\"max_2600x2600\";s:5:\"label\";s:13:\"Max 2600x2600\";s:7:\"effects\";a:1:{s:36:\"9b311dd1-0351-45a1-9500-cd069e4670cb\";a:4:{s:4:\"uuid\";s:36:\"9b311dd1-0351-45a1-9500-cd069e4670cb\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:3;s:4:\"data\";a:3:{s:5:\"width\";i:2600;s:6:\"height\";i:2600;s:7:\"upscale\";b:0;}}}}',-1,1680009095.415,1,'','0'),('image.style.max_325x325',_binary 'a:8:{s:4:\"uuid\";s:36:\"d81d55fb-3f4a-49e6-9a53-21a123e4f897\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:16:\"responsive_image\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"HAJh3VFnKZmYvJF2Rsnc2HETYtffmXFcQr2FhVPmnSU\";}s:4:\"name\";s:11:\"max_325x325\";s:5:\"label\";s:11:\"Max 325x325\";s:7:\"effects\";a:1:{s:36:\"cb842cc8-682f-42a6-bd05-5a1ac726f0d8\";a:4:{s:4:\"uuid\";s:36:\"cb842cc8-682f-42a6-bd05-5a1ac726f0d8\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:1;s:4:\"data\";a:3:{s:5:\"width\";i:325;s:6:\"height\";i:325;s:7:\"upscale\";b:0;}}}}',-1,1680009095.415,1,'','0'),('image.style.max_650x650',_binary 'a:8:{s:4:\"uuid\";s:36:\"bc3c0483-bdb5-487c-a293-487a4d2b824a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:16:\"responsive_image\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"5_u-TI6Qt78YQWl3DxbMBYKuCScEXKSeXTm8Jyl3eds\";}s:4:\"name\";s:11:\"max_650x650\";s:5:\"label\";s:11:\"Max 650x650\";s:7:\"effects\";a:1:{s:36:\"949c201a-77f5-48f6-ba00-be91eb1aad47\";a:4:{s:4:\"uuid\";s:36:\"949c201a-77f5-48f6-ba00-be91eb1aad47\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:1;s:4:\"data\";a:3:{s:5:\"width\";i:650;s:6:\"height\";i:650;s:7:\"upscale\";b:0;}}}}',-1,1680009095.415,1,'','0'),('image.style.medium',_binary 'a:8:{s:4:\"uuid\";s:36:\"9b7a7d23-c8a7-45f6-b006-08c51530b5d3\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Y9NmnZHQq20ASSyTNA6JnwtWrJJiSajOehGDtmUFdM0\";}s:4:\"name\";s:6:\"medium\";s:5:\"label\";s:15:\"Moyen (220x220)\";s:7:\"effects\";a:1:{s:36:\"bddf0d06-42f9-4c75-a700-a33cafa25ea0\";a:4:{s:4:\"uuid\";s:36:\"bddf0d06-42f9-4c75-a700-a33cafa25ea0\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:220;s:6:\"height\";i:220;s:7:\"upscale\";b:0;}}}}',-1,1680009095.415,1,'','0'),('image.style.thumbnail',_binary 'a:8:{s:4:\"uuid\";s:36:\"caf960c2-4942-4d1f-a6d1-7dff94e673eb\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cCiWdBHgLwj5omG35lsKc4LkW4MBdmcctkVop4ol5x0\";}s:4:\"name\";s:9:\"thumbnail\";s:5:\"label\";s:18:\"Vignette (100x100)\";s:7:\"effects\";a:1:{s:36:\"1cfec298-8620-4749-b100-ccb6c4500779\";a:4:{s:4:\"uuid\";s:36:\"1cfec298-8620-4749-b100-ccb6c4500779\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:0;s:4:\"data\";a:3:{s:5:\"width\";i:100;s:6:\"height\";i:100;s:7:\"upscale\";b:0;}}}}',-1,1680008722.786,1,'','0'),('image.style.wide',_binary 'a:8:{s:4:\"uuid\";s:36:\"344c4e9d-1277-462e-8d5e-96808c21d753\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"LswCVLg8z4Zk1u6pV1Dpj1qUj5YY2CQ7_ojx7bJQ8qk\";}s:4:\"name\";s:4:\"wide\";s:5:\"label\";s:12:\"Large (1090)\";s:7:\"effects\";a:1:{s:36:\"09959c15-59ce-4f6d-90df-e2d7cf32bce5\";a:4:{s:4:\"uuid\";s:36:\"09959c15-59ce-4f6d-90df-e2d7cf32bce5\";s:2:\"id\";s:11:\"image_scale\";s:6:\"weight\";i:1;s:4:\"data\";a:3:{s:5:\"width\";i:1090;s:6:\"height\";N;s:7:\"upscale\";b:0;}}}}',-1,1680009095.415,1,'','0'),('language.entity.fr',_binary 'a:9:{s:4:\"uuid\";s:36:\"08d65952-31e5-48bf-a157-d950b47b08c0\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:2:\"fr\";s:5:\"label\";s:6:\"French\";s:9:\"direction\";s:3:\"ltr\";s:6:\"weight\";i:0;s:6:\"locked\";b:0;}',-1,1680008717.940,1,'','0'),('language.entity.und',_binary 'a:10:{s:4:\"uuid\";s:36:\"af7c4a51-e5cc-4dc7-9fb1-2143c366e08c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eNX6lLCKDaY83nCMh20My---y03KbiFlv802DKCCpvg\";}s:2:\"id\";s:3:\"und\";s:5:\"label\";s:14:\"Non spécifié\";s:9:\"direction\";s:3:\"ltr\";s:6:\"weight\";i:2;s:6:\"locked\";b:1;}',-1,1680008717.940,1,'','0'),('language.entity.zxx',_binary 'a:10:{s:4:\"uuid\";s:36:\"9155b8da-3d65-4510-8a5d-569ec43ec464\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"35CefWbnzaiytcg3acexxz_GTvuwIjYd_ZTcmmR-tXA\";}s:2:\"id\";s:3:\"zxx\";s:5:\"label\";s:14:\"Non applicable\";s:9:\"direction\";s:3:\"ltr\";s:6:\"weight\";i:3;s:6:\"locked\";b:1;}',-1,1680008717.940,1,'','0'),('language.fr:addtoany.settings',_binary 'b:0;',-1,1680008721.685,1,'','0'),('language.fr:admin_toolbar.settings',_binary 'b:0;',-1,1680008723.440,1,'','0'),('language.fr:admin_toolbar_search.settings',_binary 'b:0;',-1,1680008723.411,1,'','0'),('language.fr:admin_toolbar_tools.settings',_binary 'b:0;',-1,1680008717.780,1,'','0'),('language.fr:automated_cron.settings',_binary 'b:0;',-1,1680008719.031,1,'','0'),('language.fr:block.block.banneraccueil',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.blockcontentaccueil',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.claro_breadcrumbs',_binary 'b:0;',-1,1680008715.067,1,'','0'),('language.fr:block.block.claro_content',_binary 'b:0;',-1,1680008715.067,1,'','0'),('language.fr:block.block.claro_help',_binary 'b:0;',-1,1680008715.067,1,'','0'),('language.fr:block.block.claro_local_actions',_binary 'b:0;',-1,1680008715.067,1,'','0'),('language.fr:block.block.claro_messages',_binary 'b:0;',-1,1680008715.067,1,'','0'),('language.fr:block.block.claro_page_title',_binary 'b:0;',-1,1680008715.067,1,'','0'),('language.fr:block.block.claro_primary_local_tasks',_binary 'b:0;',-1,1680008715.067,1,'','0'),('language.fr:block.block.claro_secondary_local_tasks',_binary 'b:0;',-1,1680008715.067,1,'','0'),('language.fr:block.block.gin_breadcrumbs',_binary 'b:0;',-1,1680008715.140,1,'','0'),('language.fr:block.block.gin_content',_binary 'b:0;',-1,1680008715.140,1,'','0'),('language.fr:block.block.gin_help',_binary 'b:0;',-1,1680008715.140,1,'','0'),('language.fr:block.block.gin_local_actions',_binary 'b:0;',-1,1680008715.140,1,'','0'),('language.fr:block.block.gin_messages',_binary 'b:0;',-1,1680008715.140,1,'','0'),('language.fr:block.block.gin_page_title',_binary 'b:0;',-1,1680008715.140,1,'','0'),('language.fr:block.block.gin_primary_local_tasks',_binary 'b:0;',-1,1680008715.140,1,'','0'),('language.fr:block.block.gin_secondary_local_tasks',_binary 'b:0;',-1,1680008715.140,1,'','0'),('language.fr:block.block.notregrandblue_account_menu',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_breadcrumbs',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_content',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_help',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_main_menu',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_messages',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_page_title',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_powered',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_primary_admin_actions',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_primary_local_tasks',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_reseausociaux',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_search_form_narrow',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_search_form_wide',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_secondary_local_tasks',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_site_branding',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.notregrandblue_syndicate',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.olivero_account_menu',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_breadcrumbs',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_content',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_help',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_main_menu',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_messages',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_page_title',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_powered',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_primary_admin_actions',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_primary_local_tasks',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_search_form_narrow',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_search_form_wide',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_secondary_local_tasks',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_site_branding',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.olivero_syndicate',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.pieddepage',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.reseausociaux',_binary 'b:0;',-1,1680008715.085,1,'','0'),('language.fr:block.block.views_block__partenaire_block_1',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.views_block__temoignage_block_1',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.webform',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block.block.webform_2',_binary 'b:0;',-1,1680008715.117,1,'','0'),('language.fr:block_content.type.banner',_binary 'b:0;',-1,1680008716.423,1,'','0'),('language.fr:block_content.type.basic',_binary 'b:0;',-1,1680008716.423,1,'','0'),('language.fr:block_content.type.block_content',_binary 'b:0;',-1,1680008716.423,1,'','0'),('language.fr:block_content.type.reseau_sociaux',_binary 'b:0;',-1,1680008716.423,1,'','0'),('language.fr:comment.type.comment',_binary 'b:0;',-1,1680008716.435,1,'','0'),('language.fr:contact.form.feedback',_binary 'b:0;',-1,1680008716.457,1,'','0'),('language.fr:contact.form.personal',_binary 'b:0;',-1,1680008716.457,1,'','0'),('language.fr:core.base_field_override.node.article.changed',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.created',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.default_langcode',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.langcode',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.menu_link',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.metatag',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.nid',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.path',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.promote',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.revision_default',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.revision_log',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.revision_timestamp',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.revision_translation_affected',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.revision_uid',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.status',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.sticky',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.title',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.type',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.uid',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.uuid',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.article.vid',_binary 'b:0;',-1,1680008717.689,1,'','0'),('language.fr:core.base_field_override.node.formation.changed',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.created',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.default_langcode',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.langcode',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.menu_link',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.metatag',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.nid',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.path',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.promote',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.revision_default',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.revision_log',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.revision_timestamp',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.revision_translation_affected',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.revision_uid',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.status',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.sticky',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.title',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.type',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.uid',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.uuid',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.formation.vid',_binary 'b:0;',-1,1680008717.725,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.changed',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.created',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.default_langcode',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.langcode',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.menu_link',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.metatag',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.nid',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.path',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.promote',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.revision_default',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.revision_log',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.revision_timestamp',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.revision_translation_affected',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.revision_uid',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.status',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.sticky',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.title',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.type',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.uid',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.uuid',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.offres_emploi.vid',_binary 'b:0;',-1,1680008717.765,1,'','0'),('language.fr:core.base_field_override.node.page.changed',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.created',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.default_langcode',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.langcode',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.menu_link',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.metatag',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.nid',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.path',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.promote',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.revision_default',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.revision_log',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.revision_timestamp',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.revision_translation_affected',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.revision_uid',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.status',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.sticky',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.title',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.type',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.uid',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.uuid',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.page.vid',_binary 'b:0;',-1,1680008717.803,1,'','0'),('language.fr:core.base_field_override.node.partenaire.changed',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.created',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.default_langcode',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.langcode',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.menu_link',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.metatag',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.nid',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.path',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.promote',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.revision_default',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.revision_log',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.revision_timestamp',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.revision_translation_affected',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.revision_uid',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.status',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.sticky',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.title',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.type',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.uid',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.uuid',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.partenaire.vid',_binary 'b:0;',-1,1680008717.838,1,'','0'),('language.fr:core.base_field_override.node.rapport.changed',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.created',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.default_langcode',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.langcode',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.menu_link',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.metatag',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.nid',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.path',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.promote',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.revision_default',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.revision_log',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.revision_timestamp',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.revision_translation_affected',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.revision_uid',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.status',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.sticky',_binary 'b:0;',-1,1680008717.875,1,'','0'),('language.fr:core.base_field_override.node.rapport.title',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.type',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.uid',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.uuid',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.rapport.vid',_binary 'b:0;',-1,1680008717.874,1,'','0'),('language.fr:core.base_field_override.node.webform.changed',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.created',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.default_langcode',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.langcode',_binary 'b:0;',-1,1680008717.946,1,'','0'),('language.fr:core.base_field_override.node.webform.menu_link',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.metatag',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.nid',_binary 'b:0;',-1,1680008717.946,1,'','0'),('language.fr:core.base_field_override.node.webform.path',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.promote',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.revision_default',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.revision_log',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.revision_timestamp',_binary 'b:0;',-1,1680008717.946,1,'','0'),('language.fr:core.base_field_override.node.webform.revision_translation_affected',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.revision_uid',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.status',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.sticky',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.title',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.type',_binary 'b:0;',-1,1680008717.946,1,'','0'),('language.fr:core.base_field_override.node.webform.uid',_binary 'b:0;',-1,1680008717.947,1,'','0'),('language.fr:core.base_field_override.node.webform.uuid',_binary 'b:0;',-1,1680008717.946,1,'','0'),('language.fr:core.base_field_override.node.webform.vid',_binary 'b:0;',-1,1680008717.946,1,'','0'),('language.fr:core.date_format.fallback',_binary 'b:0;',-1,1680009095.353,1,'','0'),('language.fr:core.date_format.html_date',_binary 'b:0;',-1,1680008716.392,1,'','0'),('language.fr:core.date_format.html_datetime',_binary 'b:0;',-1,1680009095.353,1,'','0'),('language.fr:core.date_format.html_month',_binary 'b:0;',-1,1680009095.353,1,'','0'),('language.fr:core.date_format.html_time',_binary 'b:0;',-1,1680008716.400,1,'','0'),('language.fr:core.date_format.html_week',_binary 'b:0;',-1,1680009095.353,1,'','0'),('language.fr:core.date_format.html_year',_binary 'b:0;',-1,1680009095.353,1,'','0'),('language.fr:core.date_format.html_yearless_date',_binary 'b:0;',-1,1680009095.353,1,'','0'),('language.fr:core.date_format.long',_binary 'b:0;',-1,1680009095.050,1,'','0'),('language.fr:core.date_format.medium',_binary 'b:0;',-1,1680008722.811,1,'','0'),('language.fr:core.date_format.olivero_medium',_binary 'b:0;',-1,1680009095.353,1,'','0'),('language.fr:core.date_format.short',_binary 'b:0;',-1,1680009095.041,1,'','0'),('language.fr:core.entity_form_mode.user.register',_binary 'b:0;',-1,1680008718.099,1,'','0'),('language.fr:core.entity_view_display.block_content.banner.default',_binary 'b:0;',-1,1680009079.223,1,'','0'),('language.fr:core.entity_view_display.block_content.banner.full',_binary 'b:0;',-1,1680009079.223,1,'','0'),('language.fr:core.entity_view_display.block_content.block_content.default',_binary 'b:0;',-1,1680009080.095,1,'','0'),('language.fr:core.entity_view_display.block_content.block_content.full',_binary 'b:0;',-1,1680009080.095,1,'','0'),('language.fr:core.entity_view_display.block_content.reseau_sociaux.default',_binary 'b:0;',-1,1680008724.187,1,'','0'),('language.fr:core.entity_view_display.block_content.reseau_sociaux.full',_binary 'b:0;',-1,1680008724.187,1,'','0'),('language.fr:core.entity_view_display.node.formation.default',_binary 'b:0;',-1,1680009128.769,1,'','0'),('language.fr:core.entity_view_display.node.formation.full',_binary 'b:0;',-1,1680009128.769,1,'','0'),('language.fr:core.entity_view_display.node.formation.teaser',_binary 'b:0;',-1,1680009129.313,1,'','0'),('language.fr:core.entity_view_display.node.offres_emploi.default',_binary 'b:0;',-1,1680009177.267,1,'','0'),('language.fr:core.entity_view_display.node.offres_emploi.full',_binary 'b:0;',-1,1680009177.266,1,'','0'),('language.fr:core.entity_view_display.node.offres_emploi.teaser',_binary 'b:0;',-1,1680009177.581,1,'','0'),('language.fr:core.entity_view_display.node.page.default',_binary 'b:0;',-1,1680009094.610,1,'','0'),('language.fr:core.entity_view_display.node.page.full',_binary 'b:0;',-1,1680009094.610,1,'','0'),('language.fr:core.entity_view_display.node.partenaire.default',_binary 'b:0;',-1,1680008722.739,1,'','0'),('language.fr:core.entity_view_display.node.partenaire.full',_binary 'b:0;',-1,1680009154.987,1,'','0'),('language.fr:core.entity_view_display.node.partenaire.teaser',_binary 'b:0;',-1,1680008722.739,1,'','0'),('language.fr:core.entity_view_display.node.webform.default',_binary 'b:0;',-1,1680009161.398,1,'','0'),('language.fr:core.entity_view_display.node.webform.full',_binary 'b:0;',-1,1680009161.398,1,'','0'),('language.fr:core.entity_view_display.paragraph.block_cta.default',_binary 'b:0;',-1,1680009080.275,1,'','0'),('language.fr:core.entity_view_display.paragraph.block_text_image.default',_binary 'b:0;',-1,1680009104.433,1,'','0'),('language.fr:core.entity_view_display.paragraph.composant_content.default',_binary 'b:0;',-1,1680009080.413,1,'','0'),('language.fr:core.entity_view_display.paragraph.composant_text.default',_binary 'b:0;',-1,1680009110.649,1,'','0'),('language.fr:core.entity_view_display.paragraph.content.default',_binary 'b:0;',-1,1680009080.553,1,'','0'),('language.fr:core.entity_view_display.paragraph.equipe.default',_binary 'b:0;',-1,1680009096.259,1,'','0'),('language.fr:core.entity_view_display.paragraph.equipes.default',_binary 'b:0;',-1,1680009096.091,1,'','0'),('language.fr:core.entity_view_display.paragraph.reseau_sociaux.default',_binary 'b:0;',-1,1680008724.315,1,'','0'),('language.fr:core.entity_view_mode.block.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.block_content.full',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.block_content.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.comment.full',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.comment.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.contact_message.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.file.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.menu_link_content.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.node.full',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.node.rss',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.node.search_index',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.node.search_result',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.node.teaser',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.node.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.paragraph.preview',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.paragraph.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.path_alias.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.shortcut.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.taxonomy_term.full',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.taxonomy_term.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.tour.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.user.compact',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.user.full',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.user.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.webform.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.entity_view_mode.webform_submission.token',_binary 'b:0;',-1,1680008718.110,1,'','0'),('language.fr:core.extension',_binary 'b:0;',-1,1680008714.526,1,'','0'),('language.fr:empty_page.settings',_binary 'b:0;',-1,1680008716.242,1,'','0'),('language.fr:field.field.block_content.banner.body',_binary 'b:0;',-1,1680008717.376,1,'','0'),('language.fr:field.field.block_content.banner.field_image',_binary 'b:0;',-1,1680008717.413,1,'','0'),('language.fr:field.field.block_content.banner.field_link',_binary 'b:0;',-1,1680008717.413,1,'','0'),('language.fr:field.field.block_content.basic.body',_binary 'b:0;',-1,1680008717.352,1,'','0'),('language.fr:field.field.block_content.block_content.body',_binary 'b:0;',-1,1680008717.389,1,'','0'),('language.fr:field.field.block_content.block_content.field_content',_binary 'b:0;',-1,1680008717.471,1,'','0'),('language.fr:field.field.block_content.reseau_sociaux.body',_binary 'b:0;',-1,1680008717.363,1,'','0'),('language.fr:field.field.block_content.reseau_sociaux.field_reseau_sociaux',_binary 'b:0;',-1,1680008717.512,1,'','0'),('language.fr:field.field.comment.comment.comment_body',_binary 'b:0;',-1,1680008717.556,1,'','0'),('language.fr:field.field.node.article.body',_binary 'b:0;',-1,1680008717.597,1,'','0'),('language.fr:field.field.node.article.comment',_binary 'b:0;',-1,1680008717.702,1,'','0'),('language.fr:field.field.node.article.field_document',_binary 'b:0;',-1,1680008717.702,1,'','0'),('language.fr:field.field.node.article.field_images',_binary 'b:0;',-1,1680008717.702,1,'','0'),('language.fr:field.field.node.article.field_tags',_binary 'b:0;',-1,1680008717.702,1,'','0'),('language.fr:field.field.node.article.field_video',_binary 'b:0;',-1,1680008717.702,1,'','0'),('language.fr:field.field.node.formation.body',_binary 'b:0;',-1,1680008717.670,1,'','0'),('language.fr:field.field.node.formation.field_categorie',_binary 'b:0;',-1,1680008717.740,1,'','0'),('language.fr:field.field.node.formation.field_date_debut',_binary 'b:0;',-1,1680008717.740,1,'','0'),('language.fr:field.field.node.formation.field_date_fin',_binary 'b:0;',-1,1680008717.740,1,'','0'),('language.fr:field.field.node.formation.field_document',_binary 'b:0;',-1,1680008717.740,1,'','0'),('language.fr:field.field.node.formation.field_images',_binary 'b:0;',-1,1680008717.740,1,'','0'),('language.fr:field.field.node.formation.field_video',_binary 'b:0;',-1,1680008717.740,1,'','0'),('language.fr:field.field.node.offres_emploi.body',_binary 'b:0;',-1,1680008717.642,1,'','0'),('language.fr:field.field.node.offres_emploi.field_meta_tags',_binary 'b:0;',-1,1680008717.778,1,'','0'),('language.fr:field.field.node.offres_emploi.webform',_binary 'b:0;',-1,1680008717.778,1,'','0'),('language.fr:field.field.node.page.body',_binary 'b:0;',-1,1680008717.586,1,'','0'),('language.fr:field.field.node.page.field_content',_binary 'b:0;',-1,1680008717.818,1,'','0'),('language.fr:field.field.node.page.field_meta_tags',_binary 'b:0;',-1,1680008717.818,1,'','0'),('language.fr:field.field.node.partenaire.body',_binary 'b:0;',-1,1680008717.631,1,'','0'),('language.fr:field.field.node.partenaire.field_image',_binary 'b:0;',-1,1680008717.852,1,'','0'),('language.fr:field.field.node.partenaire.field_lien',_binary 'b:0;',-1,1680008717.852,1,'','0'),('language.fr:field.field.node.partenaire.field_meta_tags',_binary 'b:0;',-1,1680008717.852,1,'','0'),('language.fr:field.field.node.rapport.body',_binary 'b:0;',-1,1680008717.653,1,'','0'),('language.fr:field.field.node.rapport.field_document_pdf',_binary 'b:0;',-1,1680008717.888,1,'','0'),('language.fr:field.field.node.rapport.field_type',_binary 'b:0;',-1,1680008717.888,1,'','0'),('language.fr:field.field.node.temoignage.body',_binary 'b:0;',-1,1680008717.609,1,'','0'),('language.fr:field.field.node.temoignage.field_description',_binary 'b:0;',-1,1680008717.926,1,'','0'),('language.fr:field.field.node.temoignage.field_meta_tags',_binary 'b:0;',-1,1680008717.926,1,'','0'),('language.fr:field.field.node.temoignage.field_poste',_binary 'b:0;',-1,1680008717.926,1,'','0'),('language.fr:field.field.node.webform.body',_binary 'b:0;',-1,1680008717.620,1,'','0'),('language.fr:field.field.node.webform.field_meta_tags',_binary 'b:0;',-1,1680008717.962,1,'','0'),('language.fr:field.field.node.webform.webform',_binary 'b:0;',-1,1680008717.962,1,'','0'),('language.fr:field.field.paragraph.block_cta.field_body',_binary 'b:0;',-1,1680008718.029,1,'','0'),('language.fr:field.field.paragraph.block_cta.field_image',_binary 'b:0;',-1,1680008718.029,1,'','0'),('language.fr:field.field.paragraph.block_cta.field_link',_binary 'b:0;',-1,1680008718.029,1,'','0'),('language.fr:field.field.paragraph.block_cta.field_position_image',_binary 'b:0;',-1,1680008718.029,1,'','0'),('language.fr:field.field.paragraph.block_text_image.field_body',_binary 'b:0;',-1,1680008718.053,1,'','0'),('language.fr:field.field.paragraph.block_text_image.field_image',_binary 'b:0;',-1,1680008718.053,1,'','0'),('language.fr:field.field.paragraph.block_text_image.field_position_image',_binary 'b:0;',-1,1680008718.053,1,'','0'),('language.fr:field.field.paragraph.composant_content.field_body',_binary 'b:0;',-1,1680008718.084,1,'','0'),('language.fr:field.field.paragraph.composant_content.field_content',_binary 'b:0;',-1,1680008718.084,1,'','0'),('language.fr:field.field.paragraph.composant_text.field_body',_binary 'b:0;',-1,1680008718.107,1,'','0'),('language.fr:field.field.paragraph.content.field_block_list',_binary 'b:0;',-1,1680008718.005,1,'','0'),('language.fr:field.field.paragraph.content.field_titre',_binary 'b:0;',-1,1680008718.129,1,'','0'),('language.fr:field.field.paragraph.equipe.field_description',_binary 'b:0;',-1,1680008718.155,1,'','0'),('language.fr:field.field.paragraph.equipe.field_image',_binary 'b:0;',-1,1680008718.155,1,'','0'),('language.fr:field.field.paragraph.equipe.field_lien_reseau_social',_binary 'b:0;',-1,1680008718.155,1,'','0'),('language.fr:field.field.paragraph.equipe.field_nom',_binary 'b:0;',-1,1680008718.155,1,'','0'),('language.fr:field.field.paragraph.equipe.field_poste',_binary 'b:0;',-1,1680008718.155,1,'','0'),('language.fr:field.field.paragraph.equipes.field_membre',_binary 'b:0;',-1,1680008718.175,1,'','0'),('language.fr:field.field.paragraph.equipes.field_titre',_binary 'b:0;',-1,1680008718.175,1,'','0'),('language.fr:field.field.paragraph.reseau_sociaux.field_icon',_binary 'b:0;',-1,1680008718.193,1,'','0'),('language.fr:field.field.paragraph.reseau_sociaux.field_lien',_binary 'b:0;',-1,1680008718.193,1,'','0'),('language.fr:field.field.user.user.user_picture',_binary 'b:0;',-1,1680008718.216,1,'','0'),('language.fr:field.storage.block_content.body',_binary 'b:0;',-1,1680008716.876,1,'','0'),('language.fr:field.storage.block_content.field_content',_binary 'b:0;',-1,1680008716.876,1,'','0'),('language.fr:field.storage.block_content.field_image',_binary 'b:0;',-1,1680008716.876,1,'','0'),('language.fr:field.storage.block_content.field_link',_binary 'b:0;',-1,1680008716.876,1,'','0'),('language.fr:field.storage.block_content.field_reseau_sociaux',_binary 'b:0;',-1,1680008716.876,1,'','0'),('language.fr:field.storage.comment.comment_body',_binary 'b:0;',-1,1680008716.981,1,'','0'),('language.fr:field.storage.node.body',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.comment',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_categorie',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_content',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_date_debut',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_date_fin',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_description',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_document',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_document_pdf',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_image',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_images',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_lien',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_meta_tags',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_poste',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_tags',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_type',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.field_video',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.node.webform',_binary 'b:0;',-1,1680008717.153,1,'','0'),('language.fr:field.storage.paragraph.field_block_list',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_body',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_content',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_description',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_icon',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_image',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_lien',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_lien_reseau_social',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_link',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_membre',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_nom',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_position_image',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_poste',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.paragraph.field_titre',_binary 'b:0;',-1,1680008717.330,1,'','0'),('language.fr:field.storage.user.user_picture',_binary 'b:0;',-1,1680008717.257,1,'','0'),('language.fr:filter.format.basic_html',_binary 'b:0;',-1,1680008723.736,1,'','0'),('language.fr:filter.format.full_html',_binary 'b:0;',-1,1680008720.029,1,'','0'),('language.fr:filter.format.plain_text',_binary 'b:0;',-1,1680008723.736,1,'','0'),('language.fr:filter.format.restricted_html',_binary 'b:0;',-1,1680008723.736,1,'','0'),('language.fr:filter.settings',_binary 'b:0;',-1,1680008723.763,1,'','0'),('language.fr:gin.settings',_binary 'b:0;',-1,1680008720.415,1,'','0'),('language.fr:image.settings',_binary 'b:0;',-1,1680008720.225,1,'','0'),('language.fr:image.style.large',_binary 'b:0;',-1,1680008719.769,1,'','0'),('language.fr:image.style.max_1300x1300',_binary 'b:0;',-1,1680009095.423,1,'','0'),('language.fr:image.style.max_2600x2600',_binary 'b:0;',-1,1680009095.423,1,'','0'),('language.fr:image.style.max_325x325',_binary 'b:0;',-1,1680009095.423,1,'','0'),('language.fr:image.style.max_650x650',_binary 'b:0;',-1,1680009095.423,1,'','0'),('language.fr:image.style.medium',_binary 'b:0;',-1,1680009095.423,1,'','0'),('language.fr:image.style.thumbnail',_binary 'b:0;',-1,1680008722.793,1,'','0'),('language.fr:image.style.wide',_binary 'b:0;',-1,1680009095.423,1,'','0'),('language.fr:language.entity.fr',_binary 'b:0;',-1,1680008717.941,1,'','0'),('language.fr:language.entity.und',_binary 'b:0;',-1,1680008717.941,1,'','0'),('language.fr:language.entity.zxx',_binary 'b:0;',-1,1680008717.941,1,'','0'),('language.fr:language.mappings',_binary 'b:0;',-1,1680008724.451,1,'','0'),('language.fr:language.types',_binary 'b:0;',-1,1680008720.293,1,'','0'),('language.fr:locale.settings',_binary 'b:0;',-1,1680008716.819,1,'','0'),('language.fr:metatag.metatag_defaults.404',_binary 'b:0;',-1,1680008726.851,1,'','0'),('language.fr:metatag.metatag_defaults.front',_binary 'b:0;',-1,1680009079.029,1,'','0'),('language.fr:metatag.metatag_defaults.global',_binary 'b:0;',-1,1680008721.705,1,'','0'),('language.fr:metatag.metatag_defaults.node',_binary 'b:0;',-1,1680009094.837,1,'','0'),('language.fr:metatag.settings',_binary 'b:0;',-1,1680008721.825,1,'','0'),('language.fr:node.settings',_binary 'b:0;',-1,1680008716.834,1,'','0'),('language.fr:node.type.article',_binary 'b:0;',-1,1680008716.479,1,'','0'),('language.fr:node.type.formation',_binary 'b:0;',-1,1680008716.479,1,'','0'),('language.fr:node.type.offres_emploi',_binary 'b:0;',-1,1680008716.479,1,'','0'),('language.fr:node.type.page',_binary 'b:0;',-1,1680008716.480,1,'','0'),('language.fr:node.type.partenaire',_binary 'b:0;',-1,1680008716.480,1,'','0'),('language.fr:node.type.rapport',_binary 'b:0;',-1,1680008716.480,1,'','0'),('language.fr:node.type.temoignage',_binary 'b:0;',-1,1680008716.480,1,'','0'),('language.fr:node.type.webform',_binary 'b:0;',-1,1680008716.480,1,'','0'),('language.fr:notregrandblue.settings',_binary 'b:0;',-1,1680008721.837,1,'','0'),('language.fr:paragraphs.paragraphs_type.block_cta',_binary 'b:0;',-1,1680008716.604,1,'','0'),('language.fr:paragraphs.paragraphs_type.block_text_image',_binary 'b:0;',-1,1680008716.604,1,'','0'),('language.fr:paragraphs.paragraphs_type.composant_content',_binary 'b:0;',-1,1680008716.604,1,'','0'),('language.fr:paragraphs.paragraphs_type.composant_text',_binary 'b:0;',-1,1680008716.604,1,'','0'),('language.fr:paragraphs.paragraphs_type.content',_binary 'b:0;',-1,1680008716.604,1,'','0'),('language.fr:paragraphs.paragraphs_type.equipe',_binary 'b:0;',-1,1680008716.604,1,'','0'),('language.fr:paragraphs.paragraphs_type.equipes',_binary 'b:0;',-1,1680008716.604,1,'','0'),('language.fr:paragraphs.paragraphs_type.reseau_sociaux',_binary 'b:0;',-1,1680008716.604,1,'','0'),('language.fr:paragraphs.settings',_binary 'b:0;',-1,1680008724.238,1,'','0'),('language.fr:pathauto.settings',_binary 'b:0;',-1,1680008716.709,1,'','0'),('language.fr:search.page.node_search',_binary 'b:0;',-1,1680008715.492,1,'','0'),('language.fr:search.page.user_search',_binary 'b:0;',-1,1680008715.492,1,'','0'),('language.fr:search.settings',_binary 'b:0;',-1,1680008715.504,1,'','0'),('language.fr:shortcut.set.default',_binary 'b:0;',-1,1680008716.505,1,'','0'),('language.fr:simple_sitemap.settings',_binary 'b:0;',-1,1680008721.848,1,'','0'),('language.fr:system.action.comment_delete_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.comment_publish_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.comment_save_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.comment_unpublish_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.node_delete_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.node_make_sticky_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.node_make_unsticky_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.node_promote_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.node_publish_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.node_save_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.node_unpromote_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.node_unpublish_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.pathauto_update_alias_node',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.pathauto_update_alias_user',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.taxonomy_term_publish_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.taxonomy_term_unpublish_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.user_add_role_action.administrator',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.user_add_role_action.content_editor',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.user_block_user_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.user_cancel_user_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.user_remove_role_action.administrator',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.user_remove_role_action.content_editor',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.user_unblock_user_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_archive_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_close_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_delete_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_open_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_submission_delete_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_submission_make_lock_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_submission_make_sticky_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_submission_make_unlock_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_submission_make_unsticky_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.action.webform_unarchive_action',_binary 'b:0;',-1,1680008716.650,1,'','0'),('language.fr:system.advisories',_binary 'b:0;',-1,1680008722.608,1,'','0'),('language.fr:system.date',_binary 'b:0;',-1,1680008715.053,1,'','0'),('language.fr:system.file',_binary 'b:0;',-1,1680008719.004,1,'','0'),('language.fr:system.image',_binary 'b:0;',-1,1680008720.079,1,'','0'),('language.fr:system.mail',_binary 'b:0;',-1,1680008715.159,1,'','0'),('language.fr:system.menu.account',_binary 'b:0;',-1,1680008717.888,1,'','0'),('language.fr:system.menu.admin',_binary 'b:0;',-1,1680008717.888,1,'','0'),('language.fr:system.menu.footer',_binary 'b:0;',-1,1680008717.888,1,'','0'),('language.fr:system.menu.main',_binary 'b:0;',-1,1680008717.888,1,'','0'),('language.fr:system.menu.tools',_binary 'b:0;',-1,1680008717.888,1,'','0'),('language.fr:system.performance',_binary 'b:0;',-1,1680008715.120,1,'','0'),('language.fr:system.site',_binary 'b:0;',-1,1680008720.719,1,'','0'),('language.fr:system.theme',_binary 'b:0;',-1,1680008715.866,1,'','0'),('language.fr:system.theme.global',_binary 'b:0;',-1,1680008720.405,1,'','0'),('language.fr:taxonomy.vocabulary.categories',_binary 'b:0;',-1,1680008716.532,1,'','0'),('language.fr:taxonomy.vocabulary.tags',_binary 'b:0;',-1,1680008716.532,1,'','0'),('language.fr:taxonomy.vocabulary.type_rapport',_binary 'b:0;',-1,1680008716.532,1,'','0'),('language.fr:update.settings',_binary 'b:0;',-1,1680008722.671,1,'','0'),('language.fr:user.role.administrator',_binary 'b:0;',-1,1680008717.880,1,'','0'),('language.fr:user.role.anonymous',_binary 'b:0;',-1,1680008715.599,1,'','0'),('language.fr:user.role.authenticated',_binary 'b:0;',-1,1680008717.880,1,'','0'),('language.fr:user.role.content_editor',_binary 'b:0;',-1,1680008717.880,1,'','0'),('language.fr:user.settings',_binary 'b:0;',-1,1680008717.012,1,'','0'),('language.fr:views.settings',_binary 'b:0;',-1,1680008715.175,1,'','0'),('language.fr:views.view.archive',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.articles',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.block_content',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.comment',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.comments_recent',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.content',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.content_recent',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.evenements',_binary 'b:0;',-1,1680008715.827,1,'','0'),('language.fr:views.view.files',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.frontpage',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.glossary',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.offres_d_emploi',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.partenaire',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.rapports',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.taxonomy_term',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.temoignage',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.user_admin_people',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.watchdog',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.webform_submissions',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.who_s_new',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:views.view.who_s_online',_binary 'b:0;',-1,1680008715.822,1,'','0'),('language.fr:webform.settings',_binary 'b:0;',-1,1680008716.849,1,'','0'),('language.fr:webform.webform.adhesion',_binary 'b:0;',-1,1680008716.559,1,'','0'),('language.fr:webform.webform.contact',_binary 'b:0;',-1,1680008716.559,1,'','0'),('language.fr:webform.webform.newsletter',_binary 'b:0;',-1,1680008716.559,1,'','0'),('language.fr:webform.webform.offre_d_emploi',_binary 'b:0;',-1,1680008716.559,1,'','0'),('language.fr:youtube.settings',_binary 'b:0;',-1,1680009129.746,1,'','0'),('language.mappings',_binary 'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"EMWe7Yu4Q5eD-NUfNuQAWGBvYUNZPIinztEtONSmsDc\";}s:8:\"langcode\";s:2:\"fr\";s:3:\"map\";a:10:{s:2:\"no\";s:2:\"nb\";s:2:\"pt\";s:5:\"pt-pt\";s:2:\"zh\";s:7:\"zh-hans\";s:5:\"zh-tw\";s:7:\"zh-hant\";s:5:\"zh-hk\";s:7:\"zh-hant\";s:5:\"zh-mo\";s:7:\"zh-hant\";s:6:\"zh-cht\";s:7:\"zh-hant\";s:5:\"zh-cn\";s:7:\"zh-hans\";s:5:\"zh-sg\";s:7:\"zh-hans\";s:6:\"zh-chs\";s:7:\"zh-hans\";}}',-1,1680008724.446,1,'','0'),('language.types',_binary 'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"dqouFqVseNJNvEjsoYKxbinFOITuCxYhi4y2OTNQP_8\";}s:8:\"langcode\";s:2:\"fr\";s:3:\"all\";a:3:{i:0;s:18:\"language_interface\";i:1;s:16:\"language_content\";i:2;s:12:\"language_url\";}s:12:\"configurable\";a:1:{i:0;s:18:\"language_interface\";}s:11:\"negotiation\";a:3:{s:16:\"language_content\";a:1:{s:7:\"enabled\";a:1:{s:18:\"language-interface\";i:0;}}s:12:\"language_url\";a:1:{s:7:\"enabled\";a:2:{s:12:\"language-url\";i:0;s:21:\"language-url-fallback\";i:1;}}s:18:\"language_interface\";a:1:{s:7:\"enabled\";a:1:{s:12:\"language-url\";i:0;}}}}',-1,1680008720.288,1,'','0'),('locale.settings',_binary 'a:6:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"cSdYeE-_AQETCNZnl8BMFS9-sVn5--VzAYILkpPBUbM\";}s:8:\"langcode\";s:2:\"fr\";s:13:\"cache_strings\";b:1;s:17:\"translate_english\";b:0;s:10:\"javascript\";a:1:{s:9:\"directory\";s:9:\"languages\";}s:11:\"translation\";a:8:{s:10:\"use_source\";s:16:\"remote_and_local\";s:16:\"default_filename\";s:30:\"%project-%version.%language.po\";s:22:\"default_server_pattern\";s:87:\"https://ftp.drupal.org/files/translations/%core/%project/%project-%version.%language.po\";s:20:\"overwrite_customized\";b:0;s:24:\"overwrite_not_customized\";b:1;s:20:\"update_interval_days\";i:0;s:4:\"path\";s:32:\"sites/default/files/translations\";s:14:\"import_enabled\";b:1;}}',-1,1680008716.812,1,'','0'),('metatag.metatag_defaults.404',_binary 'a:8:{s:4:\"uuid\";s:36:\"e3f80e73-df26-4237-a63b-c91b113ff632\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"puBstSLDz8mbaWU357zaqQDBGMGsJzG0j-TQNQkjg20\";}s:2:\"id\";s:3:\"404\";s:5:\"label\";s:21:\"Page 404 non trouvée\";s:4:\"tags\";a:2:{s:13:\"canonical_url\";s:10:\"[site:url]\";s:9:\"shortlink\";s:10:\"[site:url]\";}}',-1,1680008726.841,1,'','0'),('metatag.metatag_defaults.front',_binary 'a:8:{s:4:\"uuid\";s:36:\"ae1bf9c3-b8a5-4ed0-96e8-3a84eaab4bfc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"1noCXlegCr5HFehQRF1ViXy1jhU1jZ_sNN99a8Sj5jo\";}s:2:\"id\";s:5:\"front\";s:5:\"label\";s:10:\"Front page\";s:4:\"tags\";a:2:{s:13:\"canonical_url\";s:10:\"[site:url]\";s:9:\"shortlink\";s:10:\"[site:url]\";}}',-1,1680009079.019,1,'','0'),('metatag.metatag_defaults.global',_binary 'a:8:{s:4:\"uuid\";s:36:\"2a0a621e-1e72-4d49-829c-1b035c0416bf\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sL588ui1E_8-2c_UupwyYxcqX2OVyMFp3HTLbbFqvPc\";}s:2:\"id\";s:6:\"global\";s:5:\"label\";s:6:\"Global\";s:4:\"tags\";a:2:{s:13:\"canonical_url\";s:18:\"[current-page:url]\";s:5:\"title\";s:34:\"[current-page:title] | [site:name]\";}}',-1,1680008721.698,1,'','0'),('metatag.metatag_defaults.node',_binary 'a:8:{s:4:\"uuid\";s:36:\"78885e7a-5ef0-4f07-8cb5-c574060b5c46\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rpwvgyEURXLz_JjgMCrkS1rUv-0k3L79BpO-ReN7fDI\";}s:2:\"id\";s:4:\"node\";s:5:\"label\";s:7:\"Content\";s:4:\"tags\";a:3:{s:5:\"title\";s:26:\"[node:title] | [site:name]\";s:11:\"description\";s:14:\"[node:summary]\";s:13:\"canonical_url\";s:10:\"[node:url]\";}}',-1,1680009094.830,1,'','0'),('metatag.metatag_defaults.node__formation',_binary 'b:0;',-1,1680009129.246,1,'','0'),('metatag.metatag_defaults.node__offres_emploi',_binary 'b:0;',-1,1680009177.459,1,'','0'),('metatag.metatag_defaults.node__page',_binary 'b:0;',-1,1680009094.844,1,'','0'),('metatag.metatag_defaults.node__webform',_binary 'b:0;',-1,1680009161.610,1,'','0'),('metatag.settings',_binary 'b:0;',-1,1680008721.820,1,'','0'),('node.settings',_binary 'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0\";}s:8:\"langcode\";s:2:\"fr\";s:15:\"use_admin_theme\";b:1;}',-1,1680008716.827,1,'','0'),('node.type.article',_binary 'a:13:{s:4:\"uuid\";s:36:\"4bd0e8ec-0cf2-41ed-9d71-f35fbeea300e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AeW1SEDgb1OTQACAWGhzvMknMYAJlcZu0jljfeU3oso\";}s:4:\"name\";s:7:\"Article\";s:4:\"type\";s:7:\"article\";s:11:\"description\";s:153:\"Utilisez les <em>articles</em> pour des contenus possédant une temporalité tels que des actualités, des communiqués de presse ou des billets de blog.\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}',-1,1680008716.468,1,'','0'),('node.type.formation',_binary 'a:12:{s:4:\"uuid\";s:36:\"b3c24149-b604-4f84-89e0-e669b9f71ce8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:4:\"name\";s:11:\"Évènement\";s:4:\"type\";s:9:\"formation\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}',-1,1680008716.468,1,'','0'),('node.type.offres_emploi',_binary 'a:12:{s:4:\"uuid\";s:36:\"088f9204-84d8-4e20-b021-da896a88a5e6\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:4:\"name\";s:15:\"Offres D\'emploi\";s:4:\"type\";s:13:\"offres_emploi\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}',-1,1680008716.468,1,'','0'),('node.type.page',_binary 'a:13:{s:4:\"uuid\";s:36:\"fc1b6b21-1c10-468f-9057-f077a410a2de\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"KuyA4NHPXcmKAjRtwa0vQc2ZcyrUJy6IlS2TAyMNRbc\";}s:4:\"name\";s:12:\"Page de base\";s:4:\"type\";s:4:\"page\";s:11:\"description\";s:99:\"Utilisez les <em>pages de base</em> pour votre contenu statique, tel que la page \'Qui sommes-nous\'.\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}',-1,1680008716.468,1,'','0'),('node.type.partenaire',_binary 'a:12:{s:4:\"uuid\";s:36:\"5ccc1456-e688-4a74-83ff-d99f389e8dfe\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:4:\"name\";s:10:\"Partenaire\";s:4:\"type\";s:10:\"partenaire\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}',-1,1680008716.468,1,'','0'),('node.type.rapport',_binary 'a:12:{s:4:\"uuid\";s:36:\"b9eda21a-1815-4e8d-9382-95279706207a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:4:\"name\";s:7:\"Rapport\";s:4:\"type\";s:7:\"rapport\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}',-1,1680008716.468,1,'','0'),('node.type.temoignage',_binary 'a:12:{s:4:\"uuid\";s:36:\"f41cc9b0-3d6d-4632-8413-fee7d8c1546b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:4:\"name\";s:11:\"Témoignage\";s:4:\"type\";s:10:\"temoignage\";s:11:\"description\";s:0:\"\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:1;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:1;}',-1,1680008716.468,1,'','0'),('node.type.webform',_binary 'a:13:{s:4:\"uuid\";s:36:\"464a0ae6-5ba3-40dc-a6d4-1ba900c57e74\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:7:\"menu_ui\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:12:\"webform_node\";}}}s:20:\"third_party_settings\";a:1:{s:7:\"menu_ui\";a:2:{s:15:\"available_menus\";a:1:{i:0;s:4:\"main\";}s:6:\"parent\";s:5:\"main:\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BuY_3PjmYtRTSuvyFORJZUe0-TQiNXEE6yYQ_dkjxW8\";}s:4:\"name\";s:7:\"Webform\";s:4:\"type\";s:7:\"webform\";s:11:\"description\";s:37:\"A basic page with a webform attached.\";s:4:\"help\";s:0:\"\";s:12:\"new_revision\";b:0;s:12:\"preview_mode\";i:1;s:17:\"display_submitted\";b:0;}',-1,1680008716.468,1,'','0'),('notregrandblue.settings',_binary 'a:3:{s:8:\"features\";a:4:{s:17:\"node_user_picture\";i:1;s:20:\"comment_user_picture\";i:1;s:25:\"comment_user_verification\";i:1;s:7:\"favicon\";i:1;}s:4:\"logo\";a:2:{s:11:\"use_default\";i:0;s:4:\"path\";s:21:\"public://logo-ngb.png\";}s:7:\"favicon\";a:3:{s:11:\"use_default\";i:0;s:4:\"path\";s:20:\"public://favicon.png\";s:8:\"mimetype\";s:9:\"image/png\";}}',-1,1680008721.833,1,'','0'),('paragraphs.paragraphs_type.block_cta',_binary 'a:10:{s:4:\"uuid\";s:36:\"4983f126-cab8-41cd-b58f-3019093ffb9f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:9:\"block_cta\";s:5:\"label\";s:9:\"Block CTA\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:0:\"\";s:16:\"behavior_plugins\";a:0:{}}',-1,1680008716.566,1,'','0'),('paragraphs.paragraphs_type.block_text_image',_binary 'a:10:{s:4:\"uuid\";s:36:\"097f52ba-5476-4d14-b888-c815f05d7294\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:16:\"block_text_image\";s:5:\"label\";s:18:\"Block text + Image\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:0:\"\";s:16:\"behavior_plugins\";a:0:{}}',-1,1680008716.566,1,'','0'),('paragraphs.paragraphs_type.composant_content',_binary 'a:10:{s:4:\"uuid\";s:36:\"3d265655-5e5d-4706-9e25-abf00be65b76\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:17:\"composant_content\";s:5:\"label\";s:17:\"Composant Content\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:0:\"\";s:16:\"behavior_plugins\";a:0:{}}',-1,1680008716.566,1,'','0'),('paragraphs.paragraphs_type.composant_text',_binary 'a:10:{s:4:\"uuid\";s:36:\"9a697cd3-802b-4a8d-a690-ce673b5b077f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:14:\"composant_text\";s:5:\"label\";s:14:\"Composant text\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:0:\"\";s:16:\"behavior_plugins\";a:0:{}}',-1,1680008716.566,1,'','0'),('paragraphs.paragraphs_type.content',_binary 'a:10:{s:4:\"uuid\";s:36:\"b00468be-185c-4742-98f3-fbd06f1322b9\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:7:\"content\";s:5:\"label\";s:7:\"Content\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:0:\"\";s:16:\"behavior_plugins\";a:0:{}}',-1,1680008716.566,1,'','0'),('paragraphs.paragraphs_type.equipe',_binary 'a:10:{s:4:\"uuid\";s:36:\"7c940095-2448-4025-91a0-ae340652d84e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:6:\"equipe\";s:5:\"label\";s:6:\"Equipe\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:0:\"\";s:16:\"behavior_plugins\";a:0:{}}',-1,1680008716.566,1,'','0'),('paragraphs.paragraphs_type.equipes',_binary 'a:10:{s:4:\"uuid\";s:36:\"8c814649-d39a-43e8-bf18-b36c3bd708d8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:7:\"equipes\";s:5:\"label\";s:7:\"Equipes\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:0:\"\";s:16:\"behavior_plugins\";a:0:{}}',-1,1680008716.566,1,'','0'),('paragraphs.paragraphs_type.reseau_sociaux',_binary 'a:10:{s:4:\"uuid\";s:36:\"d46dffa4-6e6b-4081-a169-133d012c617c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:2:\"id\";s:14:\"reseau_sociaux\";s:5:\"label\";s:14:\"Reseau Sociaux\";s:9:\"icon_uuid\";N;s:12:\"icon_default\";N;s:11:\"description\";s:0:\"\";s:16:\"behavior_plugins\";a:0:{}}',-1,1680008716.566,1,'','0'),('paragraphs.settings',_binary 'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7eR0sk71Eol86r_A7BMqn5_46wzenh5J1O5vZRCGKv8\";}s:8:\"langcode\";s:2:\"fr\";s:16:\"show_unpublished\";b:1;}',-1,1680008724.233,1,'','0'),('pathauto.settings',_binary 'a:14:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SwvLp8snyPEExF41CaJJYdPUVomofLqtXvwciHc4cPg\";}s:8:\"langcode\";s:2:\"fr\";s:20:\"enabled_entity_types\";a:1:{i:0;s:4:\"user\";}s:11:\"punctuation\";a:1:{s:6:\"hyphen\";i:1;}s:7:\"verbose\";b:0;s:9:\"separator\";s:1:\"-\";s:10:\"max_length\";i:100;s:20:\"max_component_length\";i:100;s:13:\"transliterate\";b:1;s:12:\"reduce_ascii\";b:0;s:4:\"case\";b:1;s:12:\"ignore_words\";s:134:\"a, an, as, at, before, but, by, for, from, is, in, into, like, of, off, on, onto, per, since, than, the, this, that, to, up, via, with\";s:13:\"update_action\";i:2;s:11:\"safe_tokens\";a:6:{i:0;s:5:\"alias\";i:1;s:4:\"path\";i:2;s:9:\"join-path\";i:3;s:9:\"login-url\";i:4;s:3:\"url\";i:5;s:9:\"url-brief\";}}',-1,1680008716.704,1,'','0'),('search.page.node_search',_binary 'a:11:{s:4:\"uuid\";s:36:\"f4451f50-7b73-49ca-b0d6-0b1994011eb2\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U\";}s:2:\"id\";s:11:\"node_search\";s:5:\"label\";s:7:\"Content\";s:4:\"path\";s:4:\"node\";s:6:\"weight\";i:-10;s:6:\"plugin\";s:11:\"node_search\";s:13:\"configuration\";a:1:{s:8:\"rankings\";a:0:{}}}',-1,1680008715.485,1,'','0'),('search.page.user_search',_binary 'a:11:{s:4:\"uuid\";s:36:\"28c65c0f-b199-4a2e-abfc-ad87a0b42854\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A\";}s:2:\"id\";s:11:\"user_search\";s:5:\"label\";s:12:\"Utilisateurs\";s:4:\"path\";s:4:\"user\";s:6:\"weight\";i:0;s:6:\"plugin\";s:11:\"user_search\";s:13:\"configuration\";a:0:{}}',-1,1680008715.485,1,'','0'),('search.settings',_binary 'a:6:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk\";}s:8:\"langcode\";s:2:\"fr\";s:12:\"and_or_limit\";i:7;s:12:\"default_page\";s:11:\"node_search\";s:5:\"index\";a:4:{s:10:\"cron_limit\";i:100;s:11:\"overlap_cjk\";b:1;s:17:\"minimum_word_size\";i:3;s:11:\"tag_weights\";a:12:{s:2:\"h1\";i:25;s:2:\"h2\";i:18;s:2:\"h3\";i:15;s:2:\"h4\";i:14;s:2:\"h5\";i:9;s:2:\"h6\";i:6;s:1:\"u\";i:3;s:1:\"b\";i:3;s:1:\"i\";i:3;s:6:\"strong\";i:3;s:2:\"em\";i:3;s:1:\"a\";i:10;}}s:7:\"logging\";b:0;}',-1,1680008715.499,1,'','0'),('shortcut.set.default',_binary 'a:7:{s:4:\"uuid\";s:36:\"f67037cb-a21b-4536-9360-34fcd02910db\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI\";}s:2:\"id\";s:7:\"default\";s:5:\"label\";s:7:\"Default\";}',-1,1680008716.494,1,'','0'),('simple_sitemap.settings',_binary 'a:17:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"MUpaAk1hn-0Ph4OFw3DD_6gUF9KbGwxja9Y0qmampzo\";}s:8:\"langcode\";s:2:\"fr\";s:9:\"max_links\";i:2000;s:13:\"cron_generate\";b:1;s:22:\"cron_generate_interval\";i:0;s:17:\"generate_duration\";i:10000;s:23:\"entities_per_queue_item\";i:50;s:17:\"remove_duplicates\";b:1;s:17:\"skip_untranslated\";b:1;s:3:\"xsl\";b:1;s:8:\"base_url\";s:29:\"http://dev.notregrandbleu.com\";s:15:\"default_variant\";s:7:\"default\";s:27:\"custom_links_include_images\";b:0;s:25:\"disable_language_hreflang\";b:0;s:13:\"hide_branding\";b:0;s:18:\"excluded_languages\";a:0:{}s:20:\"enabled_entity_types\";a:3:{i:0;s:4:\"node\";i:1;s:13:\"taxonomy_term\";i:2;s:17:\"menu_link_content\";}}',-1,1680008721.843,1,'','0'),('system.action.comment_delete_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"8d3d46c0-f42e-4493-9254-e19d582eda21\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vpBH8OmL4sdesCdeZLsW8KOutB5gkbreWJbfjhfFKaQ\";}s:2:\"id\";s:21:\"comment_delete_action\";s:5:\"label\";s:24:\"Supprimer le commentaire\";s:4:\"type\";s:7:\"comment\";s:6:\"plugin\";s:28:\"entity:delete_action:comment\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.comment_publish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"f5bb51b5-ffd4-48b2-b28d-7b16204264c6\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"C00dyL_W_5M0nFlgUB3lWUTUs96jn51Jw1MLHVEHZD0\";}s:2:\"id\";s:22:\"comment_publish_action\";s:5:\"label\";s:22:\"Publier un commentaire\";s:4:\"type\";s:7:\"comment\";s:6:\"plugin\";s:29:\"entity:publish_action:comment\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.comment_save_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"376de212-d13c-4be0-9bbe-a8f06cd39bd4\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lfyE_snmvfg_EQ3VDyhUtGAXgmqtEiqa46I3bTMg8DU\";}s:2:\"id\";s:19:\"comment_save_action\";s:5:\"label\";s:26:\"Enregistrer le commentaire\";s:4:\"type\";s:7:\"comment\";s:6:\"plugin\";s:26:\"entity:save_action:comment\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.comment_unpublish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"b9563879-5e52-4438-9760-ef62a4b1bdfe\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"comment\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"tWOIjSMobEWOFZddMkNqb9JySbOVwE1diC6NRqcfLTk\";}s:2:\"id\";s:24:\"comment_unpublish_action\";s:5:\"label\";s:25:\"Dépublier le commentaire\";s:4:\"type\";s:7:\"comment\";s:6:\"plugin\";s:31:\"entity:unpublish_action:comment\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.node_delete_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"7eb24fa0-4312-4e02-b62b-a7d0a0945b7d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg\";}s:2:\"id\";s:18:\"node_delete_action\";s:5:\"label\";s:20:\"Supprimer le contenu\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:25:\"entity:delete_action:node\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.node_make_sticky_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"0f01a5b1-fd2b-48f2-bc69-3304969a5a2d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0\";}s:2:\"id\";s:23:\"node_make_sticky_action\";s:5:\"label\";s:39:\"Épingler un contenu en haut des listes\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:23:\"node_make_sticky_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.node_make_unsticky_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"c9819574-88c1-4821-bf34-940e86efd167\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k\";}s:2:\"id\";s:25:\"node_make_unsticky_action\";s:5:\"label\";s:37:\"Retirer un contenu du haut des listes\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:25:\"node_make_unsticky_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.node_promote_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"a91fc677-b8ed-460b-ab3d-535dba6f0989\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U\";}s:2:\"id\";s:19:\"node_promote_action\";s:5:\"label\";s:39:\"Promouvoir le contenu en page d\'accueil\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:19:\"node_promote_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.node_publish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"f894ed44-4090-4ad9-b0ff-ca9faa342857\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0\";}s:2:\"id\";s:19:\"node_publish_action\";s:5:\"label\";s:18:\"Publier un contenu\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:26:\"entity:publish_action:node\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.node_save_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"e63e5b56-cee6-4b31-b591-78fdb050631c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM\";}s:2:\"id\";s:16:\"node_save_action\";s:5:\"label\";s:22:\"Enregistrer un contenu\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:23:\"entity:save_action:node\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.node_unpromote_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"7884222b-c4d7-47b5-90fe-608377101794\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0\";}s:2:\"id\";s:21:\"node_unpromote_action\";s:5:\"label\";s:39:\"Retirer un contenu de la page d\'accueil\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:21:\"node_unpromote_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.node_unpublish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"cb819756-ae94-4bbd-ad0a-4d242ab3afd9\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE\";}s:2:\"id\";s:21:\"node_unpublish_action\";s:5:\"label\";s:21:\"Dépublier un contenu\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:28:\"entity:unpublish_action:node\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.pathauto_update_alias_node',_binary 'a:10:{s:4:\"uuid\";s:36:\"9ec5a390-780d-4778-b401-2d117601e9e2\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:8:\"pathauto\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"node\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"lno8QThS348UX-kaUsagJtCnuPHKLXYnTQiF_9HSDWA\";}s:2:\"id\";s:26:\"pathauto_update_alias_node\";s:5:\"label\";s:28:\"Mettre à jour l\'alias d\'URL\";s:4:\"type\";s:4:\"node\";s:6:\"plugin\";s:21:\"pathauto_update_alias\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.pathauto_update_alias_user',_binary 'a:10:{s:4:\"uuid\";s:36:\"de9120d9-510f-4f1d-aff6-145965b952c7\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:1:{i:0;s:8:\"pathauto\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"x_ok_ZsfA4Xk4B_hVW3O4-3PcNoK57nXLz_Dlletidg\";}s:2:\"id\";s:26:\"pathauto_update_alias_user\";s:5:\"label\";s:28:\"Mettre à jour l\'alias d\'URL\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:21:\"pathauto_update_alias\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.taxonomy_term_publish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"438072a4-5748-4038-873d-440a77c7f45d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY\";}s:2:\"id\";s:28:\"taxonomy_term_publish_action\";s:5:\"label\";s:29:\"Publier le terme de taxonomie\";s:4:\"type\";s:13:\"taxonomy_term\";s:6:\"plugin\";s:35:\"entity:publish_action:taxonomy_term\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.taxonomy_term_unpublish_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"d0dc71f0-92b9-4aa2-b6ce-2c106a2f3ee8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:8:\"taxonomy\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI\";}s:2:\"id\";s:30:\"taxonomy_term_unpublish_action\";s:5:\"label\";s:32:\"Dépublier le terme de taxonomie\";s:4:\"type\";s:13:\"taxonomy_term\";s:6:\"plugin\";s:37:\"entity:unpublish_action:taxonomy_term\";s:13:\"configuration\";a:0:{}}',-1,1680008716.631,1,'','0'),('system.action.user_add_role_action.administrator',_binary 'a:9:{s:4:\"uuid\";s:36:\"66b9b12d-e4b4-444e-a949-df2ad225505a\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:23:\"user.role.administrator\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:34:\"user_add_role_action.administrator\";s:5:\"label\";s:50:\"Add the Administrator role to the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:20:\"user_add_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:13:\"administrator\";}}',-1,1680008716.631,1,'','0'),('system.action.user_add_role_action.content_editor',_binary 'a:9:{s:4:\"uuid\";s:36:\"f5a5d0b7-c0db-4c71-80eb-f2d6d5a39c26\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:24:\"user.role.content_editor\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:35:\"user_add_role_action.content_editor\";s:5:\"label\";s:51:\"Add the Content editor role to the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:20:\"user_add_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:14:\"content_editor\";}}',-1,1680008716.632,1,'','0'),('system.action.user_block_user_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"d5aeecfa-fbb8-4f68-b09c-9a4d0972ba60\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4\";}s:2:\"id\";s:22:\"user_block_user_action\";s:5:\"label\";s:45:\"Bloquer le(s) utilisateur(s) sélectionné(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:22:\"user_block_user_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.user_cancel_user_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"83e54b0b-fc56-4d83-80f2-87473c860060\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU\";}s:2:\"id\";s:23:\"user_cancel_user_action\";s:5:\"label\";s:47:\"Annuler l\'(les) utilisateur(s) sélectionné(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:23:\"user_cancel_user_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.user_remove_role_action.administrator',_binary 'a:9:{s:4:\"uuid\";s:36:\"f284a57e-1b3c-4a44-86c3-7fea0190e771\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:23:\"user.role.administrator\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:37:\"user_remove_role_action.administrator\";s:5:\"label\";s:55:\"Remove the Administrator role from the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:23:\"user_remove_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:13:\"administrator\";}}',-1,1680008716.632,1,'','0'),('system.action.user_remove_role_action.content_editor',_binary 'a:9:{s:4:\"uuid\";s:36:\"957db7c2-108c-494a-bcd7-b536a15b8d80\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:24:\"user.role.content_editor\";}s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:2:\"id\";s:38:\"user_remove_role_action.content_editor\";s:5:\"label\";s:56:\"Remove the Content editor role from the selected user(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:23:\"user_remove_role_action\";s:13:\"configuration\";a:1:{s:3:\"rid\";s:14:\"content_editor\";}}',-1,1680008716.632,1,'','0'),('system.action.user_unblock_user_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"9b59e123-ca3a-4e7f-8159-25d0f1c09a23\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0\";}s:2:\"id\";s:24:\"user_unblock_user_action\";s:5:\"label\";s:48:\"Débloquer le(s) utilisateur(s) sélectionné(s)\";s:4:\"type\";s:4:\"user\";s:6:\"plugin\";s:24:\"user_unblock_user_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_archive_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"ea0359a6-db96-4a6b-a91c-150561c8602e\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OmnschvBLb9ZJn0iVyBd2odf8U8Nt0INjRbRMixZw9U\";}s:2:\"id\";s:22:\"webform_archive_action\";s:5:\"label\";s:15:\"Archive webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:22:\"webform_archive_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_close_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"aafe5626-343e-4742-ba5b-42ea8f414bc8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Dl-1T9PDkraB7MyMUjTJAioPEx6UNvIB9gqmnB1CRkk\";}s:2:\"id\";s:20:\"webform_close_action\";s:5:\"label\";s:13:\"Close webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:20:\"webform_close_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_delete_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"257fe4fe-ea77-4b27-926c-6a033a186679\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"e1bCTp0ryXZZtnS9nlVAbtoWz3-8fmbNlqKY3GHzbsM\";}s:2:\"id\";s:21:\"webform_delete_action\";s:5:\"label\";s:20:\"Supprimer le webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:21:\"webform_delete_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_open_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"70dc6fe5-9580-4de6-a5b2-56522c2da043\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"AK83C-dOZEPruvi6GbkuhihWLnO4VtrbesqSC6izf4o\";}s:2:\"id\";s:19:\"webform_open_action\";s:5:\"label\";s:12:\"Open webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:19:\"webform_open_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_submission_delete_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"218432a8-27d2-46de-82e9-da6bc3d87306\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"TBnl4vapW7sy5bRi7TcF-ueJnvz7aZNLif95ifvhfTQ\";}s:2:\"id\";s:32:\"webform_submission_delete_action\";s:5:\"label\";s:23:\"Supprimer la soumission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:32:\"webform_submission_delete_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_submission_make_lock_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"b4de09d1-c638-4766-a33d-826b76ef17dc\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"MKmZlPRk3OJKNcYdYxSeZGQUh7LMah6MRShfkzch4bk\";}s:2:\"id\";s:35:\"webform_submission_make_lock_action\";s:5:\"label\";s:25:\"Verrouiller la soumission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:35:\"webform_submission_make_lock_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_submission_make_sticky_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"a97a754b-a24a-4d22-b207-962b7bb9ad28\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mPWBT52fKHyINRl9S3cCWFxY3rKbwkIRxaK6sIA26oo\";}s:2:\"id\";s:37:\"webform_submission_make_sticky_action\";s:5:\"label\";s:20:\"Star/flag submission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:37:\"webform_submission_make_sticky_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_submission_make_unlock_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"5fd85cce-8584-4a9c-9252-87c1784a89b0\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"begZ0-RmTzO_zDAwEKA2lKvtGYw1vbFOzbQOJzUbZX0\";}s:2:\"id\";s:37:\"webform_submission_make_unlock_action\";s:5:\"label\";s:28:\"Déverrouiller la soumission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:37:\"webform_submission_make_unlock_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_submission_make_unsticky_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"13e18165-fcfe-4c82-81b2-4e494ad2efe7\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"n4gTFiUsdp7gw6yWUlDbKFEasZLCgXWWCmm7eJejay0\";}s:2:\"id\";s:39:\"webform_submission_make_unsticky_action\";s:5:\"label\";s:44:\"Retirer des favoris/démarquer la soumission\";s:4:\"type\";s:18:\"webform_submission\";s:6:\"plugin\";s:39:\"webform_submission_make_unsticky_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.632,1,'','0'),('system.action.webform_unarchive_action',_binary 'a:10:{s:4:\"uuid\";s:36:\"76ff5b96-c36a-4a1b-a205-483c896e6681\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"aqi5Ftlnhe9KyOowpK7CanEvJMBBo8xAR1dA99bKOuc\";}s:2:\"id\";s:24:\"webform_unarchive_action\";s:5:\"label\";s:15:\"Restore webform\";s:4:\"type\";s:7:\"webform\";s:6:\"plugin\";s:24:\"webform_unarchive_action\";s:13:\"configuration\";a:0:{}}',-1,1680008716.634,1,'','0'),('system.advisories',_binary 'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"x0FuQ_7Cg81mSDQwG028_Z0CjH3R9ib5IDlHeV2BbAo\";}s:8:\"langcode\";s:2:\"fr\";s:7:\"enabled\";b:1;s:14:\"interval_hours\";i:6;}',-1,1680008722.604,1,'','0'),('system.date',_binary 'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"t7clj3mzmOGrXX0HuCH5usf0vEqRtnMTBFVBIEmZ5pc\";}s:8:\"langcode\";s:2:\"fr\";s:9:\"first_day\";i:0;s:7:\"country\";a:1:{s:7:\"default\";s:2:\"TN\";}s:8:\"timezone\";a:2:{s:7:\"default\";s:12:\"Africa/Tunis\";s:4:\"user\";a:3:{s:12:\"configurable\";b:1;s:7:\"default\";i:0;s:4:\"warn\";b:0;}}}',-1,1680008715.046,1,'','0'),('system.file',_binary 'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g\";}s:8:\"langcode\";s:2:\"fr\";s:22:\"allow_insecure_uploads\";b:0;s:14:\"default_scheme\";s:6:\"public\";s:21:\"temporary_maximum_age\";i:21600;}',-1,1680008718.997,1,'','0'),('system.image',_binary 'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24\";}s:8:\"langcode\";s:2:\"fr\";s:7:\"toolkit\";s:2:\"gd\";}',-1,1680008720.074,1,'','0'),('system.mail',_binary 'a:3:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"rYgt7uhPafP2ngaN_ZUPFuyI4KdE0zU868zLNSlzKoE\";}s:8:\"langcode\";s:2:\"fr\";s:9:\"interface\";a:2:{s:7:\"default\";s:8:\"php_mail\";s:7:\"webform\";s:16:\"webform_php_mail\";}}',-1,1680008715.153,1,'','0'),('system.menu.account',_binary 'a:9:{s:4:\"uuid\";s:36:\"a89e2f8e-0914-423e-b60c-d619fd8ec41d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw\";}s:2:\"id\";s:7:\"account\";s:5:\"label\";s:31:\"Menu du compte de l\'utilisateur\";s:11:\"description\";s:45:\"Liens associés au compte utilisateur courant\";s:6:\"locked\";b:1;}',-1,1680008717.885,1,'','0'),('system.menu.admin',_binary 'a:9:{s:4:\"uuid\";s:36:\"3b8889c1-d3c2-4b0c-b4d5-5e3b78196500\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0\";}s:2:\"id\";s:5:\"admin\";s:5:\"label\";s:14:\"Administration\";s:11:\"description\";s:34:\"Liens des tâches d\'administration\";s:6:\"locked\";b:1;}',-1,1680008717.885,1,'','0'),('system.menu.footer',_binary 'a:9:{s:4:\"uuid\";s:36:\"f46c049c-59c5-4fd4-b7ba-07340b58fbc8\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc\";}s:2:\"id\";s:6:\"footer\";s:5:\"label\";s:12:\"Pied de page\";s:11:\"description\";s:32:\"Liens d\'informations sur le site\";s:6:\"locked\";b:1;}',-1,1680008717.885,1,'','0'),('system.menu.main',_binary 'a:9:{s:4:\"uuid\";s:36:\"4d860aca-b176-4174-8d2f-c7015979a668\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8\";}s:2:\"id\";s:4:\"main\";s:5:\"label\";s:21:\"Navigation principale\";s:11:\"description\";s:24:\"Liens de section du site\";s:6:\"locked\";b:1;}',-1,1680008717.885,1,'','0'),('system.menu.tools',_binary 'a:9:{s:4:\"uuid\";s:36:\"35f22a49-c718-4251-b7b3-1cdd1029c130\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc\";}s:2:\"id\";s:5:\"tools\";s:5:\"label\";s:6:\"Outils\";s:11:\"description\";s:63:\"Liens outils de l\'utilisateur, souvent ajoutés par des modules\";s:6:\"locked\";b:1;}',-1,1680008717.885,1,'','0'),('system.performance',_binary 'a:7:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"b2cssrj-lOmATIbdehfCqfCFgVR0qCdxxWhwqa2KBVQ\";}s:8:\"langcode\";s:2:\"fr\";s:5:\"cache\";a:1:{s:4:\"page\";a:1:{s:7:\"max_age\";i:0;}}s:3:\"css\";a:2:{s:10:\"preprocess\";b:0;s:4:\"gzip\";b:1;}s:8:\"fast_404\";a:4:{s:7:\"enabled\";b:1;s:5:\"paths\";s:69:\"/\\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i\";s:13:\"exclude_paths\";s:27:\"/\\/(?:styles|imagecache)\\//\";s:4:\"html\";s:162:\"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL \"@path\" was not found on this server.</p></body></html>\";}s:2:\"js\";a:2:{s:10:\"preprocess\";b:0;s:4:\"gzip\";b:1;}s:20:\"stale_file_threshold\";i:2592000;}',-1,1680008715.105,1,'','0'),('system.site',_binary 'a:11:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"VDJxTZtQR21qB4lvOq8zszJZLvLKrSPQpdn2E3T71Ww\";}s:8:\"langcode\";s:2:\"fr\";s:4:\"uuid\";s:36:\"1f86f63c-9606-49f6-843e-6a10b18433c1\";s:4:\"name\";s:16:\"Notre Grand Bleu\";s:4:\"mail\";s:23:\"ridha.rahmi13@gmail.com\";s:6:\"slogan\";s:0:\"\";s:4:\"page\";a:3:{i:403;s:0:\"\";i:404;s:0:\"\";s:5:\"front\";s:8:\"/accueil\";}s:18:\"admin_compact_mode\";b:0;s:17:\"weight_select_max\";i:100;s:16:\"default_langcode\";s:2:\"fr\";s:17:\"mail_notification\";s:0:\"\";}',-1,1680008720.714,1,'','0'),('system.theme',_binary 'a:4:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"eJ529VM1gSIA_vgTy2PdiDvJuG0xhSxfQjCyl5WKlv4\";}s:8:\"langcode\";s:2:\"fr\";s:5:\"admin\";s:3:\"gin\";s:7:\"default\";s:14:\"notregrandblue\";}',-1,1680008715.862,1,'','0'),('system.theme.global',_binary 'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"9rAU4Pku7eMBQxauQqAgjzlcicFZ2As6zEa6zvTlCB8\";}s:8:\"langcode\";s:2:\"fr\";s:7:\"favicon\";a:4:{s:8:\"mimetype\";s:24:\"image/vnd.microsoft.icon\";s:4:\"path\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"use_default\";b:1;}s:8:\"features\";a:4:{s:20:\"comment_user_picture\";b:1;s:25:\"comment_user_verification\";b:1;s:7:\"favicon\";b:1;s:17:\"node_user_picture\";b:1;}s:4:\"logo\";a:3:{s:4:\"path\";s:0:\"\";s:3:\"url\";s:0:\"\";s:11:\"use_default\";b:1;}}',-1,1680008720.400,1,'','0'),('taxonomy.vocabulary.categories',_binary 'a:8:{s:4:\"uuid\";s:36:\"ea08e53b-c384-423c-973e-0dfe46db8b06\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:4:\"name\";s:11:\"Catégories\";s:3:\"vid\";s:10:\"categories\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;}',-1,1680008716.517,1,'','0'),('taxonomy.vocabulary.tags',_binary 'a:9:{s:4:\"uuid\";s:36:\"163acea9-279c-4bbf-9ad5-78d4d8bf113b\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"yoNVreoTdTZTY7GuE8fI9Jmxqdz8vlo4ZJKixMNSosw\";}s:4:\"name\";s:11:\"Étiquettes\";s:3:\"vid\";s:4:\"tags\";s:11:\"description\";s:100:\"Utilisez les étiquettes pour regrouper les articles sur des sujets similaires dans des catégories.\";s:6:\"weight\";i:0;}',-1,1680008716.517,1,'','0'),('taxonomy.vocabulary.type_rapport',_binary 'a:8:{s:4:\"uuid\";s:36:\"7edb498a-533f-4382-b405-15bb927d3dc5\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:4:\"name\";s:12:\"Type rapport\";s:3:\"vid\";s:12:\"type_rapport\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;}',-1,1680008716.517,1,'','0'),('update.settings',_binary 'a:5:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"2QzULf0zovJQx3J06Y9rufzzfi-CY2CTTlEfJJh2Qyw\";}s:8:\"langcode\";s:2:\"fr\";s:5:\"check\";a:2:{s:19:\"disabled_extensions\";b:0;s:13:\"interval_days\";i:1;}s:5:\"fetch\";a:3:{s:3:\"url\";s:0:\"\";s:12:\"max_attempts\";i:2;s:7:\"timeout\";i:30;}s:12:\"notification\";a:2:{s:6:\"emails\";a:1:{i:0;s:23:\"ridha.rahmi13@gmail.com\";}s:9:\"threshold\";s:3:\"all\";}}',-1,1680008722.667,1,'','0'),('user.role.administrator',_binary 'a:10:{s:4:\"uuid\";s:36:\"5e2352b8-a164-4dc5-b74e-40a6ff454218\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:0:{}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"OeKGIkmZA_c-t6QLH81WNQx8gDCc1MRmxaTuQgxBByU\";}s:2:\"id\";s:13:\"administrator\";s:5:\"label\";s:14:\"Administrateur\";s:6:\"weight\";i:3;s:8:\"is_admin\";b:1;s:11:\"permissions\";a:0:{}}',-1,1680008717.879,1,'','0'),('user.role.anonymous',_binary 'a:10:{s:4:\"uuid\";s:36:\"191872fa-3ed7-4ca7-a073-055f543dffd0\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:29:\"filter.format.restricted_html\";}s:6:\"module\";a:6:{i:0;s:7:\"comment\";i:1;s:7:\"contact\";i:2;s:10:\"empty_page\";i:3;s:6:\"filter\";i:4;s:6:\"search\";i:5;s:6:\"system\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6WavjUYXIegP9AAg2zXGx54MWIVoomC3SZhNiqe-Dyk\";}s:2:\"id\";s:9:\"anonymous\";s:5:\"label\";s:19:\"Utilisateur anonyme\";s:6:\"weight\";i:0;s:8:\"is_admin\";b:0;s:11:\"permissions\";a:6:{i:0;s:15:\"access comments\";i:1;s:14:\"access content\";i:2;s:29:\"access site-wide contact form\";i:3;s:14:\"search content\";i:4;s:31:\"use text format restricted_html\";i:5;s:16:\"view empty pages\";}}',-1,1680008715.592,1,'','0'),('user.role.authenticated',_binary 'a:10:{s:4:\"uuid\";s:36:\"7270cdfb-531e-47d1-9f77-f03925b330e9\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:24:\"filter.format.basic_html\";}s:6:\"module\";a:7:{i:0;s:7:\"comment\";i:1;s:7:\"contact\";i:2;s:10:\"empty_page\";i:3;s:6:\"filter\";i:4;s:6:\"search\";i:5;s:8:\"shortcut\";i:6;s:6:\"system\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"I44QAB4es39lNzMQWiJLq2dfjX7VRSOzT_5KzAcUq_M\";}s:2:\"id\";s:13:\"authenticated\";s:5:\"label\";s:24:\"Utilisateur authentifié\";s:6:\"weight\";i:1;s:8:\"is_admin\";b:0;s:11:\"permissions\";a:9:{i:0;s:15:\"access comments\";i:1;s:14:\"access content\";i:2;s:16:\"access shortcuts\";i:3;s:29:\"access site-wide contact form\";i:4;s:13:\"post comments\";i:5;s:14:\"search content\";i:6;s:21:\"skip comment approval\";i:7;s:26:\"use text format basic_html\";i:8;s:16:\"view empty pages\";}}',-1,1680008717.879,1,'','0'),('user.role.content_editor',_binary 'a:10:{s:4:\"uuid\";s:36:\"2df64bd6-ff13-4aba-9d51-51f1fb9a0035\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:3:{i:0;s:17:\"node.type.article\";i:1;s:14:\"node.type.page\";i:2;s:24:\"taxonomy.vocabulary.tags\";}s:6:\"module\";a:9:{i:0;s:7:\"comment\";i:1;s:10:\"contextual\";i:2;s:4:\"file\";i:3;s:4:\"node\";i:4;s:4:\"path\";i:5;s:6:\"system\";i:6;s:8:\"taxonomy\";i:7;s:7:\"toolbar\";i:8;s:4:\"tour\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"Wur9kcEOwY1Jal81NssKnz3RhVJxAvBwyWQBGcA_1Go\";}s:2:\"id\";s:14:\"content_editor\";s:5:\"label\";s:19:\"Éditeur de contenu\";s:6:\"weight\";i:2;s:8:\"is_admin\";b:0;s:11:\"permissions\";a:23:{i:0;s:27:\"access administration pages\";i:1;s:23:\"access content overview\";i:2;s:23:\"access contextual links\";i:3;s:21:\"access files overview\";i:4;s:14:\"access toolbar\";i:5;s:11:\"access tour\";i:6;s:22:\"administer url aliases\";i:7;s:22:\"create article content\";i:8;s:19:\"create page content\";i:9;s:20:\"create terms in tags\";i:10;s:18:\"create url aliases\";i:11;s:24:\"delete article revisions\";i:12;s:26:\"delete own article content\";i:13;s:23:\"delete own page content\";i:14;s:21:\"delete page revisions\";i:15;s:24:\"edit own article content\";i:16;s:17:\"edit own comments\";i:17;s:21:\"edit own page content\";i:18;s:18:\"edit terms in tags\";i:19;s:20:\"revert all revisions\";i:20;s:18:\"view all revisions\";i:21;s:28:\"view own unpublished content\";i:22;s:29:\"view the administration theme\";}}',-1,1680008717.879,1,'','0'),('user.settings',_binary 'a:9:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"-htDFWUv1S4OlJMzta2nhFl4QbhJvu0D9xsJ-clxo-M\";}s:8:\"langcode\";s:2:\"fr\";s:9:\"anonymous\";s:7:\"Anonyme\";s:11:\"verify_mail\";b:1;s:6:\"notify\";a:8:{s:14:\"cancel_confirm\";b:1;s:14:\"password_reset\";b:1;s:16:\"status_activated\";b:1;s:14:\"status_blocked\";b:0;s:15:\"status_canceled\";b:0;s:22:\"register_admin_created\";b:1;s:29:\"register_no_approval_required\";b:1;s:25:\"register_pending_approval\";b:1;}s:8:\"register\";s:10:\"admin_only\";s:13:\"cancel_method\";s:17:\"user_cancel_block\";s:22:\"password_reset_timeout\";i:86400;s:17:\"password_strength\";b:1;}',-1,1680008717.007,1,'','0'),('views.settings',_binary 'a:7:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"uZHsLrDp1ThO0RvupHKcPzLOyVvWexm58JTTHNDo7yc\";}s:8:\"langcode\";s:2:\"fr\";s:17:\"display_extenders\";a:0:{}s:10:\"skip_cache\";b:0;s:13:\"sql_signature\";b:0;s:2:\"ui\";a:3:{s:4:\"show\";a:7:{s:18:\"additional_queries\";b:0;s:15:\"advanced_column\";b:0;s:15:\"default_display\";b:0;s:22:\"performance_statistics\";b:0;s:19:\"preview_information\";b:1;s:9:\"sql_query\";a:2:{s:7:\"enabled\";b:0;s:5:\"where\";s:5:\"above\";}s:13:\"display_embed\";b:0;}s:19:\"always_live_preview\";b:1;s:24:\"exposed_filter_any_label\";s:7:\"old_any\";}s:22:\"field_rewrite_elements\";a:29:{s:3:\"div\";s:3:\"DIV\";s:4:\"span\";s:4:\"SPAN\";s:2:\"h1\";s:2:\"H1\";s:2:\"h2\";s:2:\"H2\";s:2:\"h3\";s:2:\"H3\";s:2:\"h4\";s:2:\"H4\";s:2:\"h5\";s:2:\"H5\";s:2:\"h6\";s:2:\"H6\";s:1:\"p\";s:1:\"P\";s:6:\"header\";s:6:\"HEADER\";s:6:\"footer\";s:6:\"FOOTER\";s:7:\"article\";s:7:\"ARTICLE\";s:7:\"section\";s:7:\"SECTION\";s:5:\"aside\";s:5:\"ASIDE\";s:7:\"details\";s:7:\"DETAILS\";s:10:\"blockquote\";s:10:\"BLOCKQUOTE\";s:6:\"figure\";s:6:\"FIGURE\";s:7:\"address\";s:7:\"ADDRESS\";s:4:\"code\";s:4:\"CODE\";s:3:\"pre\";s:3:\"PRE\";s:3:\"var\";s:3:\"VAR\";s:4:\"samp\";s:4:\"SAMP\";s:3:\"kbd\";s:3:\"KBD\";s:6:\"strong\";s:6:\"STRONG\";s:2:\"em\";s:2:\"EM\";s:3:\"del\";s:3:\"DEL\";s:3:\"ins\";s:3:\"INS\";s:1:\"q\";s:1:\"Q\";s:1:\"s\";s:1:\"S\";}}',-1,1680008715.169,1,'','0'),('views.view.archive',_binary 'a:13:{s:4:\"uuid\";s:36:\"683a7443-c717-4bb9-94ae-836a548027a0\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:33:\"core.entity_view_mode.node.teaser\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"ko9GznzNBXHkuz09OCaBQ1YOSJYYjTY0TBpNV3WKnog\";}s:2:\"id\";s:7:\"archive\";s:5:\"label\";s:8:\"Archiver\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:35:\"Tous les contenus, triés par mois.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:17:\"Archive mensuelle\";s:6:\"fields\";a:0:{}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:1:{s:18:\"created_year_month\";a:13:{s:2:\"id\";s:18:\"created_year_month\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:18:\"created_year_month\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:15:\"date_year_month\";s:14:\"default_action\";s:7:\"summary\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:1;s:5:\"title\";s:34:\"{{ arguments.created_year_month }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:15:\"summary_options\";a:2:{s:8:\"override\";b:1;s:14:\"items_per_page\";i:30;}s:7:\"summary\";a:2:{s:10:\"sort_order\";s:4:\"desc\";s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:0;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:4:\"Bloc\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:9:\"arguments\";a:1:{s:18:\"created_year_month\";a:13:{s:2:\"id\";s:18:\"created_year_month\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:18:\"created_year_month\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:15:\"date_year_month\";s:14:\"default_action\";s:7:\"summary\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:1;s:5:\"title\";s:34:\"{{ arguments.created_year_month }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:15:\"summary_options\";a:1:{s:14:\"items_per_page\";i:30;}s:7:\"summary\";a:1:{s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:8:\"defaults\";a:1:{s:9:\"arguments\";b:0;}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:2;s:15:\"display_options\";a:3:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:7:\"archive\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.articles',_binary 'a:12:{s:4:\"uuid\";s:36:\"aa9c28b5-d378-418d-89dc-f6191b41d94c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:5:{i:0;s:23:\"field.storage.node.body\";i:1;s:31:\"field.storage.node.field_images\";i:2;s:17:\"image.style.large\";i:3;s:17:\"node.type.article\";i:4;s:16:\"system.menu.main\";}s:6:\"module\";a:5:{i:0;s:23:\"element_class_formatter\";i:1;s:5:\"image\";i:2;s:4:\"node\";i:3;s:4:\"text\";i:4;s:4:\"user\";}}s:2:\"id\";s:8:\"articles\";s:5:\"label\";s:8:\"Articles\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:8:\"Articles\";s:6:\"fields\";a:5:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"body\";a:35:{s:2:\"id\";s:4:\"body\";s:5:\"table\";s:10:\"node__body\";s:5:\"field\";s:4:\"body\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:120;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:12:\"field_images\";a:35:{s:2:\"id\";s:12:\"field_images\";s:5:\"table\";s:18:\"node__field_images\";s:5:\"field\";s:12:\"field_images\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:11:\"image_class\";s:8:\"settings\";a:4:{s:10:\"image_link\";s:7:\"content\";s:11:\"image_style\";s:0:\"\";s:5:\"class\";s:9:\"img-fluid\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:1;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:0:\"\";s:17:\"field_api_classes\";b:0;}s:9:\"view_node\";a:26:{s:2:\"id\";s:9:\"view_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"view_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:170:\"<div class=\"col-md-4 item-single\">\r\n<div class=\"panel\">\r\n<div class=\"img\">{{ field_images }}</div>\r\n<div class=\"content\">\r\n{{ title }}\r\n{{ body }}\r\n</div>\r\n</div>\r\n</div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:12;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";s:5:\"first\";s:2:\"«\";s:4:\"last\";s:3:\" »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:0:\"\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:4:\"type\";a:8:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:5:\"value\";a:1:{s:7:\"article\";s:7:\"article\";}s:6:\"expose\";a:2:{s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:0;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:30:\"config:field.storage.node.body\";i:1;s:38:\"config:field.storage.node.field_images\";}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:4:\"Bloc\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:6:\"fields\";a:6:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"body\";a:35:{s:2:\"id\";s:4:\"body\";s:5:\"table\";s:10:\"node__body\";s:5:\"field\";s:4:\"body\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:250;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:12:\"field_images\";a:35:{s:2:\"id\";s:12:\"field_images\";s:5:\"table\";s:18:\"node__field_images\";s:5:\"field\";s:12:\"field_images\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:1;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:0:\"\";s:17:\"field_api_classes\";b:0;}s:9:\"view_node\";a:26:{s:2:\"id\";s:9:\"view_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"view_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:0;}s:7:\"created\";a:37:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"custom\";s:18:\"custom_date_format\";s:10:\"d m <br> Y\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:521:\"           <div class=\"row\">\r\n             <div class=\"col-md-5 left-image\">\r\n                          {{ field_images }}\r\n                        </div>\r\n                        <div class=\"col-md-7 right-content\">\r\n                          <h4>{{ title }}</h4>\r\n                          {{ body }}\r\n                          <div class=\"text-button\">\r\n                            <a href=\"{{ view_node }}\">Lire Plus</a>\r\n                          </div>\r\n                        </div>\r\n                       </div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:1;}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:0;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:8:\"defaults\";a:4:{s:5:\"pager\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"fields\";b:0;}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:30:\"config:field.storage.node.body\";i:1;s:38:\"config:field.storage.node.field_images\";}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:5:{s:6:\"fields\";a:5:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"body\";a:35:{s:2:\"id\";s:4:\"body\";s:5:\"table\";s:10:\"node__body\";s:5:\"field\";s:4:\"body\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:150;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:12:\"field_images\";a:35:{s:2:\"id\";s:12:\"field_images\";s:5:\"table\";s:18:\"node__field_images\";s:5:\"field\";s:12:\"field_images\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:11:\"image_class\";s:8:\"settings\";a:4:{s:10:\"image_link\";s:7:\"content\";s:11:\"image_style\";s:5:\"large\";s:5:\"class\";s:9:\"img-fluid\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:1;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:0:\"\";s:17:\"field_api_classes\";b:0;}s:9:\"view_node\";a:26:{s:2:\"id\";s:9:\"view_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"view_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:170:\"<div class=\"col-md-4 item-single\">\r\n<div class=\"panel\">\r\n<div class=\"img\">{{ field_images }}</div>\r\n<div class=\"content\">\r\n{{ title }}\r\n{{ body }}\r\n</div>\r\n</div>\r\n</div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:8:\"defaults\";a:1:{s:6:\"fields\";b:0;}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:8:\"articles\";s:4:\"menu\";a:8:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:8:\"Articles\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:-49;s:8:\"expanded\";b:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:54:\"menu_link_content:a3e3daa6-cdf9-46be-8abb-cc8db6046ce6\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:30:\"config:field.storage.node.body\";i:1;s:38:\"config:field.storage.node.field_images\";}}}}}',-1,1680008715.595,1,'','0'),('views.view.block_content',_binary 'a:13:{s:4:\"uuid\";s:36:\"f4a458f0-d4f1-4a6b-8695-b1252ce3024c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:13:\"block_content\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jvd5Pu6jy-lra4oMr-mR7zuY6CVDv9CaNeoj0Y70gV4\";}s:2:\"id\";s:13:\"block_content\";s:5:\"label\";s:37:\"Bibliothèque de blocs personnalisés\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:43:\"Trouver et gérer les blocs personnalisés.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:24:\"block_content_field_data\";s:10:\"base_field\";s:2:\"id\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:37:\"Bibliothèque de blocs personnalisés\";s:6:\"fields\";a:4:{s:4:\"info\";a:37:{s:2:\"id\";s:4:\"info\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"info\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";N;s:12:\"entity_field\";s:4:\"info\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:19:\"Description du bloc\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"type\";a:37:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:12:\"Type de bloc\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:0;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:11:\"Mis à jour\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:13:\"block_content\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:50;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:11:\"Suivant ›\";s:8:\"previous\";s:15:\"‹ Précédent\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:17:\"administer blocks\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:2:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:46:\"Il n\'y a pas de bloc personnalisé disponible.\";s:8:\"tokenize\";b:0;}s:27:\"block_content_listing_empty\";a:10:{s:2:\"id\";s:27:\"block_content_listing_empty\";s:5:\"table\";s:13:\"block_content\";s:5:\"field\";s:27:\"block_content_listing_empty\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:9:\"plugin_id\";s:27:\"block_content_listing_empty\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;}}s:5:\"sorts\";a:0:{}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:3:{s:4:\"info\";a:16:{s:2:\"id\";s:4:\"info\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"info\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:4:\"info\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:7:\"info_op\";s:5:\"label\";s:19:\"Description du bloc\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"info_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"info\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:7:\"type_op\";s:5:\"label\";s:12:\"Type de bloc\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"type_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"reusable\";a:16:{s:2:\"id\";s:8:\"reusable\";s:5:\"table\";s:24:\"block_content_field_data\";s:5:\"field\";s:8:\"reusable\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:13:\"block_content\";s:12:\"entity_field\";s:8:\"reusable\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:4:{s:4:\"info\";s:4:\"info\";s:4:\"type\";s:4:\"type\";s:7:\"changed\";s:7:\"changed\";s:10:\"operations\";s:10:\"operations\";}s:7:\"default\";s:7:\"changed\";s:4:\"info\";a:4:{s:4:\"info\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:10:\"operations\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:35:\"admin/structure/block/block-content\";s:4:\"menu\";a:7:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:37:\"Bibliothèque de blocs personnalisés\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:5:\"admin\";s:6:\"parent\";s:19:\"block.admin_display\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.comment',_binary 'a:13:{s:4:\"uuid\";s:36:\"28833fc3-bf45-4e58-a9fe-87097c517a47\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:7:\"comment\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CgXkKY33fd-yaHz89du2hSw6MJOoIeNUJ-VHE5BiSdQ\";}s:2:\"id\";s:7:\"comment\";s:5:\"label\";s:12:\"Commentaires\";s:6:\"module\";s:7:\"comment\";s:11:\"description\";s:35:\"Trouver et gérer les commentaires.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:18:\"comment_field_data\";s:10:\"base_field\";s:3:\"cid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:26:{s:5:\"title\";s:12:\"Commentaires\";s:6:\"fields\";a:8:{s:17:\"comment_bulk_form\";a:26:{s:2:\"id\";s:17:\"comment_bulk_form\";s:5:\"table\";s:7:\"comment\";s:5:\"field\";s:17:\"comment_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:9:\"plugin_id\";s:17:\"comment_bulk_form\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"include\";s:16:\"selected_actions\";a:2:{i:0;s:21:\"comment_delete_action\";i:1;s:24:\"comment_unpublish_action\";}}s:7:\"subject\";a:37:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Objet\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:17:\"comment_permalink\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:3:\"uid\";a:37:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"name\";a:37:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Auteur\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:9:\"{{ uid }}\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:16:\"comment_username\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:9:\"entity_id\";a:37:{s:2:\"id\";s:9:\"entity_id\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:9:\"entity_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:9:\"entity_id\";s:9:\"plugin_id\";s:16:\"commented_entity\";s:5:\"label\";s:10:\"Posté sur\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"changed\";a:37:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:11:\"Mis à jour\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:7:\"comment\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}s:6:\"name_1\";a:37:{s:2:\"id\";s:6:\"name_1\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"user_name\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:50;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:12:\"suivant ›\";s:8:\"previous\";s:16:\"‹ précédent\";s:5:\"first\";s:11:\"« premier\";s:4:\"last\";s:11:\"dernier »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:7:\"Filtrer\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:19:\"administer comments\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:29:\"Aucun commentaire disponible.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:7:\"changed\";a:13:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"changed\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:4:{s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:7:\"subject\";a:16:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:10:\"subject_op\";s:5:\"label\";s:5:\"Objet\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"subject_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:7:\"subject\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:7:\"combine\";a:15:{s:2:\"id\";s:7:\"combine\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"combine\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"combine\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:10:\"combine_op\";s:5:\"label\";s:15:\"Nom de l\'auteur\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"combine_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:11:\"author_name\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:6:\"fields\";a:2:{s:4:\"name\";s:4:\"name\";s:6:\"name_1\";s:6:\"name_1\";}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:11:\"langcode_op\";s:5:\"label\";s:8:\"Language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"langcode_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"langcode\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:6:{s:17:\"comment_bulk_form\";s:17:\"comment_bulk_form\";s:7:\"subject\";s:7:\"subject\";s:3:\"uid\";s:3:\"uid\";s:9:\"entity_id\";s:9:\"entity_id\";s:7:\"changed\";s:7:\"changed\";s:10:\"operations\";s:10:\"operations\";}s:7:\"default\";s:7:\"changed\";s:4:\"info\";a:6:{s:17:\"comment_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"subject\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:3:\"uid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"entity_id\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:10:\"operations\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:1;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:10:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:6:\"author\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:0;}}s:9:\"css_class\";s:0:\"\";s:8:\"use_ajax\";b:0;s:8:\"group_by\";b:0;s:16:\"show_admin_links\";b:1;s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:1;s:13:\"use_more_text\";s:4:\"plus\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:23:\"hide_attachment_summary\";b:0;s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:4:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}s:9:\"cacheable\";b:0;}}s:14:\"page_published\";a:6:{s:2:\"id\";s:14:\"page_published\";s:13:\"display_title\";s:21:\"Commentaires publiés\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:19:\"display_description\";s:37:\"La liste des commentaires approuvés.\";s:15:\"display_comment\";s:0:\"\";s:13:\"exposed_block\";b:0;s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:21:\"admin/content/comment\";s:4:\"menu\";a:7:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:12:\"Commentaires\";s:11:\"description\";s:21:\"Commentaires publiés\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:5:\"admin\";s:6:\"parent\";s:0:\"\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:4:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}s:9:\"cacheable\";b:0;}}s:15:\"page_unapproved\";a:6:{s:2:\"id\";s:15:\"page_unapproved\";s:13:\"display_title\";s:27:\"Commentaires non approuvés\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:2;s:15:\"display_options\";a:8:{s:6:\"fields\";a:8:{s:17:\"comment_bulk_form\";a:26:{s:2:\"id\";s:17:\"comment_bulk_form\";s:5:\"table\";s:7:\"comment\";s:5:\"field\";s:17:\"comment_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:9:\"plugin_id\";s:17:\"comment_bulk_form\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"include\";s:16:\"selected_actions\";a:2:{i:0;s:21:\"comment_delete_action\";i:1;s:22:\"comment_publish_action\";}}s:7:\"subject\";a:37:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Objet\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:17:\"comment_permalink\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:3:\"uid\";a:37:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"name\";a:37:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Auteur\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:9:\"{{ uid }}\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:16:\"comment_username\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:9:\"entity_id\";a:37:{s:2:\"id\";s:9:\"entity_id\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:9:\"entity_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:9:\"entity_id\";s:9:\"plugin_id\";s:16:\"commented_entity\";s:5:\"label\";s:10:\"Posté sur\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:1;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"changed\";a:37:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:11:\"Mis à jour\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:7:\"comment\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}s:6:\"name_1\";a:37:{s:2:\"id\";s:6:\"name_1\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"user_name\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:7:\"filters\";a:4:{s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:7:\"subject\";a:16:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:10:\"subject_op\";s:5:\"label\";s:5:\"Objet\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"subject_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:7:\"subject\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:7:\"combine\";a:15:{s:2:\"id\";s:7:\"combine\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"combine\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"combine\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:10:\"combine_op\";s:5:\"label\";s:15:\"Nom de l\'auteur\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"combine_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:11:\"author_name\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:6:\"fields\";a:2:{s:4:\"name\";s:4:\"name\";s:6:\"name_1\";s:6:\"name_1\";}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:11:\"langcode_op\";s:5:\"label\";s:8:\"Language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"langcode_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"langcode\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:8:\"defaults\";a:3:{s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:19:\"display_description\";s:41:\"La liste des commentaires non-approuvés.\";s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:30:\"admin/content/comment/approval\";s:4:\"menu\";a:7:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:27:\"Commentaires non approuvés\";s:11:\"description\";s:27:\"Commentaires non-approuvés\";s:6:\"weight\";i:1;s:9:\"menu_name\";s:5:\"admin\";s:6:\"parent\";s:0:\"\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:4:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}s:9:\"cacheable\";b:0;}}}}',-1,1680008715.595,1,'','0'),('views.view.comments_recent',_binary 'a:13:{s:4:\"uuid\";s:36:\"d1f046e2-4d8d-4e49-85fb-304934c71e26\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:3:{i:0;s:7:\"comment\";i:1;s:4:\"node\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"S_NN2ubd_NovTfgzbHVlZMmIJJQS-3h9h3inzbaFUMY\";}s:2:\"id\";s:15:\"comments_recent\";s:5:\"label\";s:21:\"Commentaires récents\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:22:\"Commentaires récents.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:18:\"comment_field_data\";s:10:\"base_field\";s:3:\"cid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:14:{s:5:\"title\";s:21:\"Commentaires récents\";s:6:\"fields\";a:2:{s:7:\"subject\";a:26:{s:2:\"id\";s:7:\"subject\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"subject\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"subject\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:3:{s:13:\"future_format\";s:14:\"Dans @interval\";s:11:\"past_format\";s:16:\"Il y a @interval\";s:11:\"granularity\";i:2;}}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:12:\"exposed_form\";a:1:{s:4:\"type\";s:5:\"basic\";}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:15:\"access comments\";}}s:5:\"cache\";a:1:{s:4:\"type\";s:3:\"tag\";}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:11:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;s:7:\"content\";s:29:\"Aucun commentaire disponible.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:2:{s:7:\"created\";a:12:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;}s:3:\"cid\";a:12:{s:2:\"id\";s:3:\"cid\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:3:\"cid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:3:\"cid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:3:\"cid\";}s:7:\"exposed\";b:0;}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:7:\"comment\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:11:\"status_node\";a:10:{s:2:\"id\";s:11:\"status_node\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"node\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:2:{s:22:\"default_field_elements\";b:1;s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:1:{s:4:\"type\";s:11:\"views_query\";}s:13:\"relationships\";a:1:{s:4:\"node\";a:5:{s:2:\"id\";s:4:\"node\";s:5:\"table\";s:18:\"comment_field_data\";s:5:\"field\";s:4:\"node\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:1;}}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:4:\"Bloc\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:21:\"Commentaires récents\";s:14:\"block_category\";s:14:\"Listes (Views)\";s:5:\"allow\";a:1:{s:14:\"items_per_page\";b:1;}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.content',_binary 'a:13:{s:4:\"uuid\";s:36:\"2bb08b68-a1fb-42b9-a37a-a7e9298e37a2\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"vBKWYGGDoAX-tFd1JErB8tZLSxx3lJ0foouVsgpcbB4\";}s:2:\"id\";s:7:\"content\";s:5:\"label\";s:7:\"Content\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:29:\"Trouver et gérer le contenu.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:7:\"Content\";s:6:\"fields\";a:7:{s:14:\"node_bulk_form\";a:14:{s:2:\"id\";s:14:\"node_bulk_form\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:14:\"node_bulk_form\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:14:\"node_bulk_form\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:5:\"title\";a:17:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Titre\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}}s:4:\"type\";a:37:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:15:\"Type de contenu\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:0;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"name\";a:17:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Auteur\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}s:6:\"status\";a:17:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"État\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:19:\"format_custom_false\";s:11:\"Non publié\";s:18:\"format_custom_true\";s:7:\"Publié\";}}s:7:\"changed\";a:17:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:11:\"Mis à jour\";s:7:\"exclude\";b:0;s:5:\"alter\";a:1:{s:10:\"alter_text\";b:0;}s:13:\"element_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}}s:10:\"operations\";a:23:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:2:{s:14:\"items_per_page\";i:50;s:4:\"tags\";a:4:{s:4:\"next\";s:11:\"Suivant ›\";s:8:\"previous\";s:15:\"‹ Précédent\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:7:\"Filtrer\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:23:\"access content overview\";}}s:5:\"cache\";a:1:{s:4:\"type\";s:3:\"tag\";}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:6:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:25:\"Aucun contenu disponible.\";}}s:5:\"sorts\";a:0:{}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:5:{s:5:\"title\";a:16:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:8:\"title_op\";s:5:\"label\";s:5:\"Titre\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:8:\"title_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:5:\"title\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:7:\"type_op\";s:5:\"label\";s:15:\"Type de contenu\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"type_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:5:\"État\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:1;s:10:\"group_info\";a:10:{s:5:\"label\";s:21:\"Statut de publication\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:6:\"status\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:2:{i:1;a:3:{s:5:\"title\";s:7:\"Publié\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:11:\"Non publié\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:11:\"langcode_op\";s:5:\"label\";s:8:\"Language\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"langcode_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"langcode\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:12:\"status_extra\";a:9:{s:2:\"id\";s:12:\"status_extra\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:12:\"status_extra\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"node_status\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";b:0;s:5:\"group\";i:1;s:6:\"expose\";a:2:{s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:10:{s:14:\"node_bulk_form\";s:14:\"node_bulk_form\";s:5:\"title\";s:5:\"title\";s:4:\"type\";s:4:\"type\";s:4:\"name\";s:4:\"name\";s:6:\"status\";s:6:\"status\";s:7:\"changed\";s:7:\"changed\";s:9:\"edit_node\";s:9:\"edit_node\";s:11:\"delete_node\";s:11:\"delete_node\";s:10:\"dropbutton\";s:10:\"dropbutton\";s:9:\"timestamp\";s:5:\"title\";}s:7:\"default\";s:7:\"changed\";s:4:\"info\";a:10:{s:14:\"node_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:5:\"title\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"name\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:9:\"edit_node\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"delete_node\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:10:\"dropbutton\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"timestamp\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:1;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:1:{s:4:\"type\";s:11:\"views_query\";}s:13:\"relationships\";a:1:{s:3:\"uid\";a:6:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"uid\";s:11:\"admin_label\";s:6:\"author\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:1;}}s:16:\"show_admin_links\";b:0;s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:7:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:21:\"user.node_grants:view\";i:6;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:18:\"admin/content/node\";s:4:\"menu\";a:6:{s:4:\"type\";s:11:\"default tab\";s:5:\"title\";s:7:\"Content\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:-10;s:9:\"menu_name\";s:5:\"admin\";s:7:\"context\";s:0:\"\";}s:11:\"tab_options\";a:5:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:7:\"Content\";s:11:\"description\";s:28:\"Trouver et gérer le contenu\";s:6:\"weight\";i:-10;s:9:\"menu_name\";s:5:\"admin\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:7:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:21:\"user.node_grants:view\";i:6;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.content_recent',_binary 'a:13:{s:4:\"uuid\";s:36:\"516e9c86-3cde-47bc-b50d-f551eb382872\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"YqZN5rc7XDQcFcInc8wkzuaHJmC5YvirhTmDcrarT6M\";}s:2:\"id\";s:14:\"content_recent\";s:5:\"label\";s:15:\"Contenu récent\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:16:\"Contenu récent.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:22:{s:5:\"title\";s:15:\"Contenu récent\";s:6:\"fields\";a:2:{s:5:\"title\";a:26:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}}s:7:\"changed\";a:37:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:25:\"Aucun contenu disponible.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:7:\"changed\";a:13:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"changed\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:12:\"status_extra\";a:15:{s:2:\"id\";s:12:\"status_extra\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:12:\"status_extra\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"node_status\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";b:0;s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:10:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:6:\"author\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:1;}}s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:0;s:13:\"use_more_text\";s:4:\"More\";s:12:\"link_display\";s:1:\"0\";s:8:\"link_url\";s:0:\"\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:4:\"user\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:4:\"Bloc\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:1:{s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:4:\"user\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.evenements',_binary 'a:12:{s:4:\"uuid\";s:36:\"b73bb86a-3e12-4cc8-9d31-d242dc08ab5f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:3:{s:6:\"config\";a:6:{i:0;s:23:\"field.storage.node.body\";i:1;s:31:\"field.storage.node.field_images\";i:2;s:17:\"image.style.large\";i:3;s:19:\"node.type.formation\";i:4;s:16:\"system.menu.main\";i:5;s:30:\"taxonomy.vocabulary.categories\";}s:7:\"content\";a:2:{i:0;s:61:\"taxonomy_term:categories:74b13984-2f05-4012-985e-a56be0f77fb5\";i:1;s:61:\"taxonomy_term:categories:dba08bec-3fc6-4d3a-99db-3e14f1b1fef6\";}s:6:\"module\";a:6:{i:0;s:23:\"element_class_formatter\";i:1;s:5:\"image\";i:2;s:4:\"node\";i:3;s:8:\"taxonomy\";i:4;s:4:\"text\";i:5;s:4:\"user\";}}s:2:\"id\";s:10:\"evenements\";s:5:\"label\";s:12:\"Évènements\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:4:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:12:\"Évènements\";s:6:\"fields\";a:5:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"body\";a:35:{s:2:\"id\";s:4:\"body\";s:5:\"table\";s:10:\"node__body\";s:5:\"field\";s:4:\"body\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:120;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:12:\"field_images\";a:35:{s:2:\"id\";s:12:\"field_images\";s:5:\"table\";s:18:\"node__field_images\";s:5:\"field\";s:12:\"field_images\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:11:\"image_class\";s:8:\"settings\";a:4:{s:10:\"image_link\";s:7:\"content\";s:11:\"image_style\";s:0:\"\";s:5:\"class\";s:9:\"img-fluid\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:1;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:0:\"\";s:17:\"field_api_classes\";b:0;}s:9:\"view_node\";a:26:{s:2:\"id\";s:9:\"view_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"view_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:170:\"<div class=\"col-md-4 item-single\">\r\n<div class=\"panel\">\r\n<div class=\"img\">{{ field_images }}</div>\r\n<div class=\"content\">\r\n{{ title }}\r\n{{ body }}\r\n</div>\r\n</div>\r\n</div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:12;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";s:5:\"first\";s:2:\"«\";s:4:\"last\";s:3:\" »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:0:\"\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:9:\"formation\";s:9:\"formation\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:0;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:30:\"config:field.storage.node.body\";i:1;s:38:\"config:field.storage.node.field_images\";}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:4:\"Bloc\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:6:\"fields\";a:5:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"body\";a:35:{s:2:\"id\";s:4:\"body\";s:5:\"table\";s:10:\"node__body\";s:5:\"field\";s:4:\"body\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:250;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:12:\"field_images\";a:35:{s:2:\"id\";s:12:\"field_images\";s:5:\"table\";s:18:\"node__field_images\";s:5:\"field\";s:12:\"field_images\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:1;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:0:\"\";s:17:\"field_api_classes\";b:0;}s:9:\"view_node\";a:26:{s:2:\"id\";s:9:\"view_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"view_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:521:\"           <div class=\"row\">\r\n             <div class=\"col-md-5 left-image\">\r\n                          {{ field_images }}\r\n                        </div>\r\n                        <div class=\"col-md-7 right-content\">\r\n                          <h4>{{ title }}</h4>\r\n                          {{ body }}\r\n                          <div class=\"text-button\">\r\n                            <a href=\"{{ view_node }}\">Lire Plus</a>\r\n                          </div>\r\n                        </div>\r\n                       </div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:1;}}s:7:\"filters\";a:3:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:9:\"formation\";s:9:\"formation\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:25:\"field_categorie_target_id\";a:20:{s:2:\"id\";s:25:\"field_categorie_target_id\";s:5:\"table\";s:21:\"node__field_categorie\";s:5:\"field\";s:25:\"field_categorie_target_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:18:\"taxonomy_index_tid\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";a:1:{i:3;i:3;}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:17:\"reduce_duplicates\";b:0;s:3:\"vid\";s:10:\"categories\";s:4:\"type\";s:6:\"select\";s:9:\"hierarchy\";b:0;s:5:\"limit\";b:1;s:13:\"error_message\";b:1;}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:8:\"defaults\";a:4:{s:5:\"pager\";b:0;s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:4:\"user\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:30:\"config:field.storage.node.body\";i:1;s:38:\"config:field.storage.node.field_images\";}}}s:7:\"block_2\";a:6:{s:2:\"id\";s:7:\"block_2\";s:13:\"display_title\";s:10:\"Formations\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:8:{s:5:\"title\";s:10:\"Formations\";s:6:\"fields\";a:5:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"body\";a:35:{s:2:\"id\";s:4:\"body\";s:5:\"table\";s:10:\"node__body\";s:5:\"field\";s:4:\"body\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:250;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:12:\"field_images\";a:35:{s:2:\"id\";s:12:\"field_images\";s:5:\"table\";s:18:\"node__field_images\";s:5:\"field\";s:12:\"field_images\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:5:\"image\";s:8:\"settings\";a:3:{s:10:\"image_link\";s:0:\"\";s:11:\"image_style\";s:0:\"\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:1;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:0:\"\";s:17:\"field_api_classes\";b:0;}s:9:\"view_node\";a:26:{s:2:\"id\";s:9:\"view_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"view_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:521:\"           <div class=\"row\">\r\n             <div class=\"col-md-5 left-image\">\r\n                          {{ field_images }}\r\n                        </div>\r\n                        <div class=\"col-md-7 right-content\">\r\n                          <h4>{{ title }}</h4>\r\n                          {{ body }}\r\n                          <div class=\"text-button\">\r\n                            <a href=\"{{ view_node }}\">Lire Plus</a>\r\n                          </div>\r\n                        </div>\r\n                       </div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:1;}}s:7:\"filters\";a:3:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:9:\"formation\";s:9:\"formation\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:25:\"field_categorie_target_id\";a:20:{s:2:\"id\";s:25:\"field_categorie_target_id\";s:5:\"table\";s:21:\"node__field_categorie\";s:5:\"field\";s:25:\"field_categorie_target_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:18:\"taxonomy_index_tid\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";a:1:{i:4;i:4;}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:17:\"reduce_duplicates\";b:0;s:3:\"vid\";s:10:\"categories\";s:4:\"type\";s:6:\"select\";s:9:\"hierarchy\";b:0;s:5:\"limit\";b:1;s:13:\"error_message\";b:1;}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:8:\"defaults\";a:5:{s:5:\"title\";b:0;s:5:\"pager\";b:0;s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:19:\"display_description\";s:0:\"\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:4:\"user\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:30:\"config:field.storage.node.body\";i:1;s:38:\"config:field.storage.node.field_images\";}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:5:{s:6:\"fields\";a:5:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"body\";a:35:{s:2:\"id\";s:4:\"body\";s:5:\"table\";s:10:\"node__body\";s:5:\"field\";s:4:\"body\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:150;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"text_default\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:12:\"field_images\";a:35:{s:2:\"id\";s:12:\"field_images\";s:5:\"table\";s:18:\"node__field_images\";s:5:\"field\";s:12:\"field_images\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:11:\"image_class\";s:8:\"settings\";a:4:{s:10:\"image_link\";s:7:\"content\";s:11:\"image_style\";s:5:\"large\";s:5:\"class\";s:9:\"img-fluid\";s:13:\"image_loading\";a:1:{s:9:\"attribute\";s:4:\"lazy\";}}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:1;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:0:\"\";s:17:\"field_api_classes\";b:0;}s:9:\"view_node\";a:26:{s:2:\"id\";s:9:\"view_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"view_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:170:\"<div class=\"col-md-4 item-single\">\r\n<div class=\"panel\">\r\n<div class=\"img\">{{ field_images }}</div>\r\n<div class=\"content\">\r\n{{ title }}\r\n{{ body }}\r\n</div>\r\n</div>\r\n</div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:8:\"defaults\";a:1:{s:6:\"fields\";b:0;}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:10:\"evenements\";s:4:\"menu\";a:8:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:13:\"Évènements \";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:-48;s:8:\"expanded\";b:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:0:\"\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:30:\"config:field.storage.node.body\";i:1;s:38:\"config:field.storage.node.field_images\";}}}}}',-1,1680008715.815,1,'','0'),('views.view.files',_binary 'a:13:{s:4:\"uuid\";s:36:\"1678a922-3559-4d24-a249-30773a580ea7\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:4:\"file\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"DaGeEDJMcbbQtgV96AuPeZ-0irMc_Oa6Zzh2U3Kmul8\";}s:2:\"id\";s:5:\"files\";s:5:\"label\";s:8:\"Fichiers\";s:6:\"module\";s:4:\"file\";s:11:\"description\";s:31:\"Trouver et gérer les fichiers.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:12:\"file_managed\";s:10:\"base_field\";s:3:\"fid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:19:{s:5:\"title\";s:8:\"Fichiers\";s:6:\"fields\";a:8:{s:3:\"fid\";a:24:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:3:\"fid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:17:\"Identifiant (FID)\";s:7:\"exclude\";b:1;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:8:\"filename\";a:36:{s:2:\"id\";s:8:\"filename\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filename\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filename\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:3:\"Nom\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"file_link\";s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:8:\"filemime\";a:25:{s:2:\"id\";s:8:\"filemime\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filemime\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filemime\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:9:\"Type MIME\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"file_filemime\";}s:8:\"filesize\";a:25:{s:2:\"id\";s:8:\"filesize\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filesize\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filesize\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:4:\"Size\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"file_size\";}s:6:\"status\";a:26:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"État\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:19:\"format_custom_false\";s:10:\"Temporaire\";s:18:\"format_custom_true\";s:9:\"Permanent\";}}s:7:\"created\";a:26:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:17:\"Date de transfert\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:20:\"Date de modification\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}}s:5:\"count\";a:30:{s:2:\"id\";s:5:\"count\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:5:\"count\";s:12:\"relationship\";s:3:\"fid\";s:10:\"group_type\";s:3:\"sum\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"numeric\";s:5:\"label\";s:13:\"Utilisé dans\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:1;s:4:\"path\";s:35:\"admin/content/files/usage/{{ fid }}\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:13:\"set_precision\";b:0;s:9:\"precision\";i:0;s:7:\"decimal\";s:1:\".\";s:9:\"separator\";s:1:\",\";s:13:\"format_plural\";b:1;s:20:\"format_plural_string\";s:21:\"1 place@count places\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:50;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:11:\"Suivant ›\";s:8:\"previous\";s:15:\"‹ Précédent\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:7:\"Filtrer\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:21:\"access files overview\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:6:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:25:\"Aucun fichier disponible.\";}}s:5:\"sorts\";a:0:{}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:3:{s:8:\"filename\";a:16:{s:2:\"id\";s:8:\"filename\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filename\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filename\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:4:\"word\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:11:\"filemime_op\";s:5:\"label\";s:14:\"Nom du fichier\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"filename_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"filename\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"filemime\";a:16:{s:2:\"id\";s:8:\"filemime\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:8:\"filemime\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:8:\"filemime\";s:9:\"plugin_id\";s:6:\"string\";s:8:\"operator\";s:4:\"word\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:11:\"filemime_op\";s:5:\"label\";s:9:\"Type MIME\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"filemime_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"filemime\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:11:\"file_status\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:9:\"status_op\";s:5:\"label\";s:5:\"État\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:8:{s:3:\"fid\";s:3:\"fid\";s:8:\"filename\";s:8:\"filename\";s:8:\"filemime\";s:8:\"filemime\";s:8:\"filesize\";s:8:\"filesize\";s:6:\"status\";s:6:\"status\";s:7:\"created\";s:7:\"created\";s:7:\"changed\";s:7:\"changed\";s:5:\"count\";s:5:\"count\";}s:7:\"default\";s:7:\"changed\";s:4:\"info\";a:8:{s:3:\"fid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"filename\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"filemime\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:8:\"filesize\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"changed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:5:\"count\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:1:{s:3:\"fid\";a:7:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:10:\"File usage\";s:8:\"required\";b:1;}}s:8:\"group_by\";b:1;s:16:\"show_admin_links\";b:1;s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:27:\"Vue d\'ensemble des fichiers\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:8:\"defaults\";a:2:{s:5:\"pager\";b:1;s:13:\"relationships\";b:0;}s:13:\"relationships\";a:1:{s:3:\"fid\";a:7:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:10:\"File usage\";s:8:\"required\";b:0;}}s:19:\"display_description\";s:0:\"\";s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:19:\"admin/content/files\";s:4:\"menu\";a:6:{s:4:\"type\";s:3:\"tab\";s:5:\"title\";s:8:\"Fichiers\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:5:\"admin\";s:7:\"context\";s:0:\"\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_2\";a:6:{s:2:\"id\";s:6:\"page_2\";s:13:\"display_title\";s:22:\"Utilisation du fichier\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:2;s:15:\"display_options\";a:15:{s:5:\"title\";s:22:\"Utilisation du fichier\";s:6:\"fields\";a:4:{s:12:\"entity_label\";a:23:{s:2:\"id\";s:12:\"entity_label\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:12:\"entity_label\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:12:\"entity_label\";s:5:\"label\";s:7:\"Entité\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:14:\"link_to_entity\";b:1;}s:4:\"type\";a:22:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"label\";s:14:\"Type d\'entité\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:6:\"module\";a:22:{s:2:\"id\";s:6:\"module\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:6:\"module\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"label\";s:24:\"Enregistrement du module\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:5:\"count\";a:30:{s:2:\"id\";s:5:\"count\";s:5:\"table\";s:10:\"file_usage\";s:5:\"field\";s:5:\"count\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"numeric\";s:5:\"label\";s:21:\"Nombre d\'utilisations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:13:\"set_precision\";b:0;s:9:\"precision\";i:0;s:7:\"decimal\";s:1:\".\";s:9:\"separator\";s:1:\",\";s:13:\"format_plural\";b:0;s:20:\"format_plural_string\";s:8:\"1@count\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:11:\"Suivant ›\";s:8:\"previous\";s:15:\"‹ Précédent\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:5:\"empty\";a:0:{}s:9:\"arguments\";a:1:{s:3:\"fid\";a:23:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"file\";s:12:\"entity_field\";s:3:\"fid\";s:9:\"plugin_id\";s:8:\"file_fid\";s:14:\"default_action\";s:9:\"not found\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:1;s:5:\"title\";s:56:\"Information d\'utilisation du fichier {{ arguments.fid }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:8:\"override\";b:0;s:14:\"items_per_page\";i:25;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:3:\"not\";b:0;}}s:7:\"filters\";a:0:{}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:0:{}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:4:{s:12:\"entity_label\";s:12:\"entity_label\";s:4:\"type\";s:4:\"type\";s:6:\"module\";s:6:\"module\";s:5:\"count\";s:5:\"count\";}s:7:\"default\";s:12:\"entity_label\";s:4:\"info\";a:4:{s:12:\"entity_label\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:6:\"module\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:5:\"count\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:0:{}}s:8:\"defaults\";a:11:{s:5:\"empty\";b:0;s:5:\"title\";b:0;s:5:\"pager\";b:0;s:8:\"group_by\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:13:\"relationships\";b:0;s:6:\"fields\";b:0;s:9:\"arguments\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:13:\"relationships\";a:1:{s:3:\"fid\";a:7:{s:2:\"id\";s:3:\"fid\";s:5:\"table\";s:12:\"file_managed\";s:5:\"field\";s:3:\"fid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:10:\"File usage\";s:8:\"required\";b:1;}}s:8:\"group_by\";b:0;s:19:\"display_description\";s:0:\"\";s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:27:\"admin/content/files/usage/%\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.frontpage',_binary 'a:13:{s:4:\"uuid\";s:36:\"8dc49737-d0a8-4f61-b81a-5fca8ed296fb\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:30:\"core.entity_view_mode.node.rss\";i:1;s:33:\"core.entity_view_mode.node.teaser\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"6eeliKIydPjqyv5V__QqTfahvJMWkHjOVUUuUIdB1ik\";}s:2:\"id\";s:9:\"frontpage\";s:5:\"label\";s:14:\"Page d\'accueil\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:40:\"Tout le contenu promu en page d\'accueil.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:0:\"\";s:6:\"fields\";a:0:{}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:11:\"Suivant ›\";s:8:\"previous\";s:15:\"‹ Précédent\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:3:{s:16:\"area_text_custom\";a:11:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;s:7:\"content\";s:208:\"Aucun contenu de page d\'accueil n\'a été créé pour l\'instant. Suivre le <a href=\"https://www.drupal.org/fr/docs/user_guide/fr/index.html\">Guide utilisateur</a> pour démarrer la construction de votre site.\";s:8:\"tokenize\";b:0;}s:18:\"node_listing_empty\";a:10:{s:2:\"id\";s:18:\"node_listing_empty\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:18:\"node_listing_empty\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:18:\"node_listing_empty\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;}s:5:\"title\";a:10:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"title\";s:5:\"label\";s:0:\"\";s:5:\"empty\";b:1;s:5:\"title\";s:11:\"Bienvenue !\";}}s:5:\"sorts\";a:2:{s:6:\"sticky\";a:12:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:6:\"sticky\";}s:7:\"exposed\";b:0;}s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:3:{s:7:\"promote\";a:16:{s:2:\"id\";s:7:\"promote\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"promote\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"promote\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:14:\"url.query_args\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"feed_1\";a:6:{s:2:\"id\";s:6:\"feed_1\";s:13:\"display_title\";s:4:\"Flux\";s:14:\"display_plugin\";s:4:\"feed\";s:8:\"position\";i:2;s:15:\"display_options\";a:7:{s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:5:\"style\";a:2:{s:4:\"type\";s:3:\"rss\";s:7:\"options\";a:3:{s:8:\"grouping\";a:0:{}s:11:\"uses_fields\";b:0;s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:8:\"node_rss\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:3:\"rss\";}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:7:\"rss.xml\";s:14:\"sitename_title\";b:1;s:8:\"displays\";a:2:{s:6:\"page_1\";s:6:\"page_1\";s:7:\"default\";s:0:\"\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:28:\"languages:language_interface\";i:1;s:21:\"user.node_grants:view\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:2:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:4:\"node\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:14:\"url.query_args\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.glossary',_binary 'a:13:{s:4:\"uuid\";s:36:\"3e2c6062-f183-4bca-a885-cfcd96943338\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:0;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:16:\"system.menu.main\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sz_FoMz5aClG4jFy4UDlkenXQtgTUXohEDjWVBuHaro\";}s:2:\"id\";s:8:\"glossary\";s:5:\"label\";s:8:\"Glossary\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:37:\"Tous les contenus, triés par lettre.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:6:\"fields\";a:3:{s:5:\"title\";a:24:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Titre\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Auteur\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}s:7:\"changed\";a:26:{s:2:\"id\";s:7:\"changed\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"changed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"changed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:22:\"Dernière mise à jour\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:4:\"long\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:36;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:0:{}s:9:\"arguments\";a:1:{s:5:\"title\";a:27:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:6:\"string\";s:14:\"default_action\";s:7:\"default\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:1:\"a\";}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:0:{}s:7:\"summary\";a:1:{s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:8:\"glossary\";b:1;s:5:\"limit\";i:1;s:4:\"case\";s:5:\"upper\";s:9:\"path_case\";s:5:\"lower\";s:14:\"transform_dash\";b:0;s:12:\"break_phrase\";b:0;}}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;s:7:\"columns\";a:3:{s:5:\"title\";s:5:\"title\";s:4:\"name\";s:4:\"name\";s:7:\"changed\";s:7:\"changed\";}s:7:\"default\";s:5:\"title\";s:4:\"info\";a:3:{s:5:\"title\";a:2:{s:8:\"sortable\";b:1;s:9:\"separator\";s:0:\"\";}s:4:\"name\";a:2:{s:8:\"sortable\";b:1;s:9:\"separator\";s:0:\"\";}s:7:\"changed\";a:2:{s:8:\"sortable\";b:1;s:9:\"separator\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:5:\"order\";s:3:\"asc\";s:11:\"empty_table\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:8:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:6:\"author\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:0;}}s:8:\"use_ajax\";b:1;s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:12:\"attachment_1\";a:6:{s:2:\"id\";s:12:\"attachment_1\";s:13:\"display_title\";s:15:\"Élément joint\";s:14:\"display_plugin\";s:10:\"attachment\";s:8:\"position\";i:2;s:15:\"display_options\";a:7:{s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:0;}}s:9:\"arguments\";a:1:{s:5:\"title\";a:27:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:6:\"string\";s:14:\"default_action\";s:7:\"summary\";s:9:\"exception\";a:1:{s:12:\"title_enable\";b:1;}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:1:\"a\";}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:3:{s:14:\"items_per_page\";i:25;s:6:\"inline\";b:1;s:9:\"separator\";s:3:\" | \";}s:7:\"summary\";a:1:{s:6:\"format\";s:19:\"unformatted_summary\";}s:18:\"specify_validation\";b:1;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:8:\"glossary\";b:1;s:5:\"limit\";i:1;s:4:\"case\";s:5:\"upper\";s:9:\"path_case\";s:5:\"lower\";s:14:\"transform_dash\";b:0;s:12:\"break_phrase\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:8:\"defaults\";a:1:{s:9:\"arguments\";b:0;}s:17:\"display_extenders\";a:0:{}s:8:\"displays\";a:2:{s:7:\"default\";s:7:\"default\";s:6:\"page_1\";s:6:\"page_1\";}s:17:\"inherit_arguments\";b:0;}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:8:\"glossary\";s:4:\"menu\";a:5:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:8:\"Glossary\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:0:\"\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:21:\"user.node_grants:view\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.offres_d_emploi',_binary 'a:12:{s:4:\"uuid\";s:36:\"6dc13173-8b01-4739-9939-a7cae096ba5c\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:2:{i:0;s:23:\"node.type.offres_emploi\";i:1;s:16:\"system.menu.main\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:2:\"id\";s:15:\"offres_d_emploi\";s:5:\"label\";s:15:\"Offres D\'emploi\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:5:\"title\";s:15:\"Offres D\'emploi\";s:6:\"fields\";a:3:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:9:\"view_node\";a:26:{s:2:\"id\";s:9:\"view_node\";s:5:\"table\";s:4:\"node\";s:5:\"field\";s:9:\"view_node\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:114:\"<a href=\"{{ view_node }}\" class=\"btn btn-outline-danger pill\"><i class=\"fa fa-arrow-right\"></i> En savoir plus</a>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:1;s:8:\"absolute\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:164:\"<div class=\"col-12 listin_single\">\r\n   <div class=\"listin_single_title\"><h4>{{ title }}</h4></div>\r\n   <div class=\"listin_single_btn\">{{ view_node }}</div>\r\n </div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:0:\"\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:4:\"type\";a:8:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:5:\"value\";a:1:{s:13:\"offres_emploi\";s:13:\"offres_emploi\";}s:6:\"expose\";a:2:{s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}}s:5:\"style\";a:1:{s:4:\"type\";s:7:\"default\";}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:9:\"css_class\";s:11:\"list-offres\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:13:\"offres-emploi\";s:4:\"menu\";a:8:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:15:\"Offres D\'emploi\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:-45;s:8:\"expanded\";b:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:0:\"\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.partenaire',_binary 'a:12:{s:4:\"uuid\";s:36:\"549f2f33-b43b-47d5-8fc4-cce8a9960135\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:31:\"core.entity_view_mode.node.full\";i:1;s:33:\"core.entity_view_mode.node.teaser\";i:2;s:20:\"node.type.partenaire\";i:3;s:16:\"system.menu.main\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:2:\"id\";s:10:\"partenaire\";s:5:\"label\";s:10:\"partenaire\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:5:\"title\";s:10:\"partenaire\";s:6:\"fields\";a:1:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:1:{s:6:\"offset\";i:0;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:0:\"\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:4:\"type\";a:8:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:5:\"value\";a:1:{s:10:\"partenaire\";s:10:\"partenaire\";}s:6:\"expose\";a:2:{s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:0;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:7:\"default\";}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:9:\"css_class\";s:16:\"block_partenaire\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:0;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:6:\"teaser\";}}s:8:\"defaults\";a:2:{s:5:\"style\";b:0;s:3:\"row\";b:0;}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:8:{s:5:\"title\";s:10:\"Partenaire\";s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:24;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:4:\" ›\";s:8:\"previous\";s:3:\"‹\";s:5:\"first\";s:2:\"«\";s:4:\"last\";s:2:\"»\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:0;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:4:\"full\";}}s:8:\"defaults\";a:4:{s:5:\"title\";b:0;s:5:\"pager\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:11:\"partenaires\";s:4:\"menu\";a:8:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:11:\"Partenaires\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;s:8:\"expanded\";b:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:54:\"menu_link_content:a3e3daa6-cdf9-46be-8abb-cc8db6046ce6\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.rapports',_binary 'a:12:{s:4:\"uuid\";s:36:\"55d61943-765f-44dd-8d40-427ab5d18027\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:37:\"field.storage.node.field_document_pdf\";i:1;s:29:\"field.storage.node.field_type\";i:2;s:17:\"node.type.rapport\";i:3;s:16:\"system.menu.main\";}s:6:\"module\";a:3:{i:0;s:4:\"file\";i:1;s:4:\"node\";i:2;s:4:\"user\";}}s:2:\"id\";s:8:\"rapports\";s:5:\"label\";s:8:\"Rapports\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:5:\"title\";s:8:\"Rapports\";s:6:\"fields\";a:4:{s:5:\"title\";a:37:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:5:\"title\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:18:\"field_document_pdf\";a:35:{s:2:\"id\";s:18:\"field_document_pdf\";s:5:\"table\";s:24:\"node__field_document_pdf\";s:5:\"field\";s:18:\"field_document_pdf\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:137:\"<a href=\"{{ field_document_pdf }}\" class=\"btn btn-outline-danger pill\" target=\"_blank\"><i class=\"fa fa-file-pdf-o\"></i> Voir Document</a>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:14:\"file_url_plain\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:0:\"\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:10:\"field_type\";a:35:{s:2:\"id\";s:10:\"field_type\";s:5:\"table\";s:16:\"node__field_type\";s:5:\"field\";s:10:\"field_type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:73:\"<div class=\"type type-{{ field_type__target_id }}\">{{ field_type }}</div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:9:\"target_id\";s:4:\"type\";s:22:\"entity_reference_label\";s:8:\"settings\";a:1:{s:4:\"link\";b:0;}s:12:\"group_column\";s:9:\"target_id\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:189:\"<div class=\"col-12 listin_single\">\r\n   <div class=\"listin_single_title\">{{ field_type }}<h4>{{ title }}</h4></div>\r\n   <div class=\"listin_single_btn\">{{ field_document_pdf }}</div>\r\n </div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:0:\"\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:4:\"type\";a:16:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:7:\"rapport\";s:7:\"rapport\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:1:{s:4:\"type\";s:7:\"default\";}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:9:\"css_class\";s:24:\"list-offres list-rapport\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:44:\"config:field.storage.node.field_document_pdf\";i:1;s:36:\"config:field.storage.node.field_type\";}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:8:\"rapports\";s:4:\"menu\";a:8:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:8:\"Rapports\";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:-50;s:8:\"expanded\";b:0;s:9:\"menu_name\";s:4:\"main\";s:6:\"parent\";s:54:\"menu_link_content:a3e3daa6-cdf9-46be-8abb-cc8db6046ce6\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:44:\"config:field.storage.node.field_document_pdf\";i:1;s:36:\"config:field.storage.node.field_type\";}}}}}',-1,1680008715.595,1,'','0'),('views.view.taxonomy_term',_binary 'a:13:{s:4:\"uuid\";s:36:\"5e60abfb-5284-4a98-9a40-fa17b0badea2\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:1:{i:0;s:33:\"core.entity_view_mode.node.teaser\";}s:6:\"module\";a:3:{i:0;s:4:\"node\";i:1;s:8:\"taxonomy\";i:2;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"YKgw0f77GEmCu6_6Om9Mbig0mON9JdfVuMxTtd0WQaI\";}s:2:\"id\";s:13:\"taxonomy_term\";s:5:\"label\";s:13:\"Taxonomy term\";s:6:\"module\";s:8:\"taxonomy\";s:11:\"description\";s:49:\"Contenu associé à un terme de taxonomie donné.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:6:\"fields\";a:0:{}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:2:{s:6:\"sticky\";a:10:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:6:\"sticky\";}s:7:\"exposed\";b:0;}s:7:\"created\";a:11:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:1:{s:3:\"tid\";a:23:{s:2:\"id\";s:3:\"tid\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:3:\"tid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:18:\"taxonomy_index_tid\";s:14:\"default_action\";s:9:\"not found\";s:9:\"exception\";a:3:{s:5:\"value\";s:0:\"\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:1;s:5:\"title\";s:19:\"{{ arguments.tid }}\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:8:\"override\";b:0;s:14:\"items_per_page\";i:25;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:1;s:8:\"validate\";a:2:{s:4:\"type\";s:20:\"entity:taxonomy_term\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:4:{s:7:\"bundles\";a:0:{}s:6:\"access\";b:1;s:9:\"operation\";s:4:\"view\";s:8:\"multiple\";i:0;}s:12:\"break_phrase\";b:0;s:9:\"add_table\";b:0;s:13:\"require_value\";b:0;s:17:\"reduce_duplicates\";b:0;}}s:7:\"filters\";a:2:{s:8:\"langcode\";a:16:{s:2:\"id\";s:8:\"langcode\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:8:\"langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:8:\"langcode\";s:9:\"plugin_id\";s:8:\"language\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:1:{s:31:\"***LANGUAGE_language_content***\";s:31:\"***LANGUAGE_language_content***\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"status\";a:14:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:14:\"taxonomy_index\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:4:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:11:\"uses_fields\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:11:\"entity:node\";s:7:\"options\";a:1:{s:9:\"view_mode\";s:6:\"teaser\";}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:12:\"link_display\";s:6:\"page_1\";s:8:\"link_url\";s:0:\"\";s:6:\"header\";a:1:{s:20:\"entity_taxonomy_term\";a:12:{s:2:\"id\";s:20:\"entity_taxonomy_term\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:20:\"entity_taxonomy_term\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"entity\";s:5:\"empty\";b:1;s:6:\"target\";s:23:\"{{ raw_arguments.tid }}\";s:9:\"view_mode\";s:4:\"full\";s:8:\"tokenize\";b:1;s:13:\"bypass_access\";b:0;}}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"feed_1\";a:6:{s:2:\"id\";s:6:\"feed_1\";s:13:\"display_title\";s:4:\"Flux\";s:14:\"display_plugin\";s:4:\"feed\";s:8:\"position\";i:2;s:15:\"display_options\";a:7:{s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:5:\"style\";a:2:{s:4:\"type\";s:3:\"rss\";s:7:\"options\";a:3:{s:8:\"grouping\";a:0:{}s:11:\"uses_fields\";b:0;s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:8:\"node_rss\";s:7:\"options\";a:2:{s:12:\"relationship\";s:4:\"none\";s:9:\"view_mode\";s:7:\"default\";}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:20:\"taxonomy/term/%/feed\";s:8:\"displays\";a:2:{s:6:\"page_1\";s:6:\"page_1\";s:7:\"default\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:0:{}}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:15:\"taxonomy/term/%\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:28:\"languages:language_interface\";i:1;s:3:\"url\";i:2;s:14:\"url.query_args\";i:3;s:21:\"user.node_grants:view\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.595,1,'','0'),('views.view.temoignage',_binary 'a:12:{s:4:\"uuid\";s:36:\"3eef6102-c7f9-4ebb-981d-181e524a50c6\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"config\";a:4:{i:0;s:36:\"field.storage.node.field_description\";i:1;s:30:\"field.storage.node.field_poste\";i:2;s:20:\"node.type.temoignage\";i:3;s:18:\"system.menu.footer\";}s:6:\"module\";a:2:{i:0;s:4:\"node\";i:1;s:4:\"user\";}}s:2:\"id\";s:10:\"temoignage\";s:5:\"label\";s:11:\"Témoignage\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:0:\"\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:15:\"node_field_data\";s:10:\"base_field\";s:3:\"nid\";s:7:\"display\";a:3:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:11:\"Témoignage\";s:6:\"fields\";a:4:{s:5:\"title\";a:35:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:17:\"field_description\";a:35:{s:2:\"id\";s:17:\"field_description\";s:5:\"table\";s:23:\"node__field_description\";s:5:\"field\";s:17:\"field_description\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"basic_string\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:11:\"field_poste\";a:35:{s:2:\"id\";s:11:\"field_poste\";s:5:\"table\";s:17:\"node__field_poste\";s:5:\"field\";s:11:\"field_poste\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:283:\"<div class=\"item\">\r\n              <p>“{{ field_description }}”</p>\r\n                <h4>{{ title }} </h4>\r\n                <span>{{ field_poste }}</span>\r\n                <img src=\"/themes/custom/notregrandblue/assets/images/quote-blue.png\" alt=\"{{ title }}\">\r\n            </div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:6;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:0:\"\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:4:\"type\";a:8:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:4:\"type\";s:11:\"entity_type\";s:4:\"node\";s:12:\"entity_field\";s:4:\"type\";s:9:\"plugin_id\";s:6:\"bundle\";s:5:\"value\";a:1:{s:10:\"temoignage\";s:10:\"temoignage\";}s:6:\"expose\";a:2:{s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:7:\"default\";s:7:\"options\";a:3:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:0;}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:0;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:43:\"config:field.storage.node.field_description\";i:1;s:37:\"config:field.storage.node.field_poste\";}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:5:\"Block\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:1:{s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:43:\"config:field.storage.node.field_description\";i:1;s:37:\"config:field.storage.node.field_poste\";}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:5:{s:6:\"fields\";a:4:{s:5:\"title\";a:35:{s:2:\"id\";s:5:\"title\";s:5:\"table\";s:15:\"node_field_data\";s:5:\"field\";s:5:\"title\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:17:\"field_description\";a:35:{s:2:\"id\";s:17:\"field_description\";s:5:\"table\";s:23:\"node__field_description\";s:5:\"field\";s:17:\"field_description\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"basic_string\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:11:\"field_poste\";a:35:{s:2:\"id\";s:11:\"field_poste\";s:5:\"table\";s:17:\"node__field_poste\";s:5:\"field\";s:11:\"field_poste\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:292:\"<div class=\"col-md-4 item\">\r\n              <p>“{{ field_description }}”</p>\r\n                <h4>{{ title }} </h4>\r\n                <span>{{ field_poste }}</span>\r\n                <img src=\"/themes/custom/notregrandblue/assets/images/quote-blue.png\" alt=\"{{ title }}\">\r\n            </div>\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}}s:8:\"defaults\";a:1:{s:6:\"fields\";b:0;}s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:10:\"temoignage\";s:4:\"menu\";a:8:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:12:\"Témoignage \";s:11:\"description\";s:0:\"\";s:6:\"weight\";i:0;s:8:\"expanded\";b:0;s:9:\"menu_name\";s:6:\"footer\";s:6:\"parent\";s:0:\"\";s:7:\"context\";s:1:\"0\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:4:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:21:\"user.node_grants:view\";i:3;s:16:\"user.permissions\";}s:4:\"tags\";a:2:{i:0;s:43:\"config:field.storage.node.field_description\";i:1;s:37:\"config:field.storage.node.field_poste\";}}}}}',-1,1680008715.595,1,'','0'),('views.view.user_admin_people',_binary 'a:13:{s:4:\"uuid\";s:36:\"f110449d-262f-4cbf-a1b3-14859515184d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"njaZigMvB4ap21Fg_tQcJhWgYJCGNi49Z5rRL_N6RI0\";}s:2:\"id\";s:17:\"user_admin_people\";s:5:\"label\";s:9:\"Personnes\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:62:\"Trouver et gérer les personnes interagissant avec votre site.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:25:{s:5:\"title\";s:9:\"Personnes\";s:6:\"fields\";a:8:{s:14:\"user_bulk_form\";a:23:{s:2:\"id\";s:14:\"user_bulk_form\";s:5:\"table\";s:5:\"users\";s:5:\"field\";s:14:\"user_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:9:\"plugin_id\";s:14:\"user_bulk_form\";s:5:\"label\";s:21:\"Mise à jour en masse\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:17:\"Nom d\'utilisateur\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}s:6:\"status\";a:26:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"État\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"custom\";s:19:\"format_custom_false\";s:7:\"Bloqué\";s:18:\"format_custom_true\";s:5:\"Actif\";}}s:15:\"roles_target_id\";a:24:{s:2:\"id\";s:15:\"roles_target_id\";s:5:\"table\";s:11:\"user__roles\";s:5:\"field\";s:15:\"roles_target_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:10:\"user_roles\";s:5:\"label\";s:6:\"Rôles\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:2:\"ul\";s:9:\"separator\";s:2:\", \";}s:7:\"created\";a:26:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:13:\"Membre depuis\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:3:{s:13:\"future_format\";s:9:\"@interval\";s:11:\"past_format\";s:9:\"@interval\";s:11:\"granularity\";i:2;}}s:6:\"access\";a:26:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:14:\"Dernier accès\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:13:\"timestamp_ago\";s:8:\"settings\";a:3:{s:13:\"future_format\";s:14:\"Dans @interval\";s:11:\"past_format\";s:16:\"Il y a @interval\";s:11:\"granularity\";i:2;}}s:10:\"operations\";a:24:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:5:\"users\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}s:4:\"mail\";a:37:{s:2:\"id\";s:4:\"mail\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"mail\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"mail\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:12:\"basic_string\";s:8:\"settings\";a:0:{}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:50;s:11:\"total_pages\";i:0;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:11:\"Suivant ›\";s:8:\"previous\";s:15:\"‹ Précédent\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:7:\"Filtrer\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:16:\"administer users\";}}s:5:\"cache\";a:1:{s:4:\"type\";s:3:\"tag\";}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:26:\"Personne n\'est disponible.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:7:\"filters\";a:6:{s:7:\"combine\";a:15:{s:2:\"id\";s:7:\"combine\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"combine\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:7:\"combine\";s:8:\"operator\";s:8:\"contains\";s:5:\"value\";s:0:\"\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:10:\"combine_op\";s:5:\"label\";s:25:\"Nom ou courriel contenant\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:10:\"combine_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"user\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:6:\"fields\";a:2:{s:4:\"name\";s:4:\"name\";s:4:\"mail\";s:4:\"mail\";}}s:6:\"status\";a:16:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"status_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"status\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:1;s:10:\"group_info\";a:10:{s:5:\"label\";s:5:\"État\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:6:\"status\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:2:{i:1;a:3:{s:5:\"title\";s:5:\"Actif\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";}i:2;a:3:{s:5:\"title\";s:7:\"Bloqué\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}}}}s:15:\"roles_target_id\";a:15:{s:2:\"id\";s:15:\"roles_target_id\";s:5:\"table\";s:11:\"user__roles\";s:5:\"field\";s:15:\"roles_target_id\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:10:\"user_roles\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:18:\"roles_target_id_op\";s:5:\"label\";s:5:\"Rôle\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:18:\"roles_target_id_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"role\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:17:\"reduce_duplicates\";b:0;}s:10:\"permission\";a:15:{s:2:\"id\";s:10:\"permission\";s:5:\"table\";s:11:\"user__roles\";s:5:\"field\";s:10:\"permission\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:16:\"user_permissions\";s:8:\"operator\";s:2:\"or\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:13:\"permission_op\";s:5:\"label\";s:5:\"Droit\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:13:\"permission_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:10:\"permission\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}s:17:\"reduce_duplicates\";b:0;}s:16:\"default_langcode\";a:16:{s:2:\"id\";s:16:\"default_langcode\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:16:\"default_langcode\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:16:\"default_langcode\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:7:\"uid_raw\";a:15:{s:2:\"id\";s:7:\"uid_raw\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"uid_raw\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:9:\"plugin_id\";s:7:\"numeric\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";a:3:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:1:\"0\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:1:\"0\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:10:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:8:{s:14:\"user_bulk_form\";s:14:\"user_bulk_form\";s:4:\"name\";s:4:\"name\";s:6:\"status\";s:6:\"status\";s:3:\"rid\";s:3:\"rid\";s:7:\"created\";s:7:\"created\";s:6:\"access\";s:6:\"access\";s:9:\"edit_node\";s:9:\"edit_node\";s:10:\"dropbutton\";s:10:\"dropbutton\";}s:7:\"default\";s:7:\"created\";s:4:\"info\";a:8:{s:14:\"user_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"name\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"status\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:3:\"rid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:6:\"access\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:9:\"edit_node\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:10:\"dropbutton\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:1;}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:9:\"css_class\";s:0:\"\";s:8:\"use_ajax\";b:0;s:8:\"group_by\";b:0;s:16:\"show_admin_links\";b:1;s:8:\"use_more\";b:0;s:15:\"use_more_always\";b:0;s:13:\"use_more_text\";s:4:\"plus\";s:12:\"link_display\";s:6:\"page_1\";s:8:\"link_url\";s:0:\"\";s:15:\"display_comment\";s:0:\"\";s:23:\"hide_attachment_summary\";b:0;s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:6:\"page_1\";a:6:{s:2:\"id\";s:6:\"page_1\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:6:{s:8:\"defaults\";a:1:{s:16:\"show_admin_links\";b:0;}s:16:\"show_admin_links\";b:0;s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:17:\"admin/people/list\";s:4:\"menu\";a:6:{s:4:\"type\";s:11:\"default tab\";s:5:\"title\";s:6:\"Lister\";s:11:\"description\";s:62:\"Trouver et gérer les personnes interagissant avec votre site.\";s:6:\"weight\";i:-10;s:9:\"menu_name\";s:5:\"admin\";s:7:\"context\";s:0:\"\";}s:11:\"tab_options\";a:5:{s:4:\"type\";s:6:\"normal\";s:5:\"title\";s:9:\"Personnes\";s:11:\"description\";s:58:\"Gérer les comptes utilisateurs, les rôles et les droits.\";s:6:\"weight\";i:0;s:9:\"menu_name\";s:5:\"admin\";}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.596,1,'','0'),('views.view.watchdog',_binary 'a:13:{s:4:\"uuid\";s:36:\"f3210158-9ac3-4020-a152-23b4d5ce891f\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:2:{i:0;s:5:\"dblog\";i:1;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"j0txIxY4nkJT_dscmXckM-1vanygDkJAeHPawZKfyH0\";}s:2:\"id\";s:8:\"watchdog\";s:5:\"label\";s:8:\"Watchdog\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:29:\"Entrées récentes du journal\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:8:\"watchdog\";s:10:\"base_field\";s:3:\"wid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:19:{s:5:\"title\";s:29:\"Entrées récentes du journal\";s:6:\"fields\";a:8:{s:7:\"nothing\";a:22:{s:2:\"id\";s:7:\"nothing\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:7:\"nothing\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:6:\"Icône\";s:9:\"plugin_id\";s:6:\"custom\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:1;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:4:\"icon\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:0;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:0;}s:3:\"wid\";a:22:{s:2:\"id\";s:3:\"wid\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:3:\"wid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"label\";s:3:\"WID\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:8:\"severity\";a:23:{s:2:\"id\";s:8:\"severity\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:8:\"severity\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:12:\"machine_name\";s:5:\"label\";s:10:\"Importance\";s:7:\"exclude\";b:1;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"machine_name\";b:0;}s:4:\"type\";a:22:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"label\";s:4:\"Type\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}s:9:\"timestamp\";a:25:{s:2:\"id\";s:9:\"timestamp\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:9:\"timestamp\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"label\";s:4:\"Date\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"date_format\";s:5:\"short\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:7:\"message\";a:23:{s:2:\"id\";s:7:\"message\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:7:\"message\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:13:\"dblog_message\";s:5:\"label\";s:7:\"Message\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:1;s:4:\"path\";s:35:\"admin/reports/dblog/event/{{ wid }}\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:13:\"{{ message }}\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:56;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:1;s:4:\"trim\";b:1;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:1;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"replace_variables\";b:1;}s:4:\"name\";a:37:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:3:\"uid\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:4:\"User\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"user_name\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:4:\"link\";a:22:{s:2:\"id\";s:4:\"link\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:4:\"link\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:16:\"dblog_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"mini\";s:7:\"options\";a:6:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:50;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:2:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:13:\"5, 10, 25, 50\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:7:\"Filtrer\";s:12:\"reset_button\";b:1;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:0;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:19:\"access site reports\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:4:\"area\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:43:\"Aucune entrée du journal n\'est disponible.\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:43:\"Aucune entrée du journal n\'est disponible.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:3:\"wid\";a:10:{s:2:\"id\";s:3:\"wid\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:3:\"wid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:8:\"standard\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:3:\"wid\";}s:7:\"exposed\";b:0;}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:4:\"type\";a:14:{s:2:\"id\";s:4:\"type\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:4:\"type\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"dblog_types\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:7:\"type_op\";s:5:\"label\";s:4:\"Type\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:7:\"type_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:4:\"type\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:1;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:8:\"severity\";a:14:{s:2:\"id\";s:8:\"severity\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:8:\"severity\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"in_operator\";s:8:\"operator\";s:2:\"in\";s:5:\"value\";a:0:{}s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:13:{s:11:\"operator_id\";s:11:\"severity_op\";s:5:\"label\";s:10:\"Importance\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"severity_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"severity\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:1;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:6:\"reduce\";b:0;}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:25:\"{{ type }} {{ severity }}\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:8:{s:7:\"nothing\";s:7:\"nothing\";s:3:\"wid\";s:3:\"wid\";s:8:\"severity\";s:8:\"severity\";s:4:\"type\";s:4:\"type\";s:9:\"timestamp\";s:9:\"timestamp\";s:7:\"message\";s:7:\"message\";s:4:\"name\";s:4:\"name\";s:4:\"link\";s:4:\"link\";}s:7:\"default\";s:3:\"wid\";s:4:\"info\";a:8:{s:7:\"nothing\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:3:\"wid\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:8:\"severity\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:4:\"type\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:9:\"timestamp\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}s:7:\"message\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:4:\"name\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:15:\"priority-medium\";}s:4:\"link\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:12:\"priority-low\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:0;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:1:{s:3:\"uid\";a:8:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:8:\"watchdog\";s:5:\"field\";s:3:\"uid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:4:\"User\";s:9:\"plugin_id\";s:8:\"standard\";s:8:\"required\";b:0;}}s:9:\"css_class\";s:11:\"admin-dblog\";s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:4:\"page\";a:6:{s:2:\"id\";s:4:\"page\";s:13:\"display_title\";s:4:\"Page\";s:14:\"display_plugin\";s:4:\"page\";s:8:\"position\";i:1;s:15:\"display_options\";a:2:{s:17:\"display_extenders\";a:0:{}s:4:\"path\";s:19:\"admin/reports/dblog\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.596,1,'','0'),('views.view.webform_submissions',_binary 'a:13:{s:4:\"uuid\";s:36:\"6af06fe8-70e0-4b3a-98ca-046d4015c68d\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:2:{s:6:\"module\";a:2:{i:0;s:4:\"user\";i:1;s:7:\"webform\";}s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"YPgxGC8TmLtfCOLGCCHJcdH2llA7QksUkdi1abhB7Ro\";}s:2:\"id\";s:19:\"webform_submissions\";s:5:\"label\";s:19:\"Webform submissions\";s:6:\"module\";s:5:\"views\";s:11:\"description\";s:34:\"Default webform submissions views.\";s:3:\"tag\";s:0:\"\";s:10:\"base_table\";s:18:\"webform_submission\";s:10:\"base_field\";s:3:\"sid\";s:7:\"display\";a:5:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:6:\"Master\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:18:{s:5:\"title\";s:19:\"Webform submissions\";s:6:\"fields\";a:5:{s:3:\"sid\";a:37:{s:2:\"id\";s:3:\"sid\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:3:\"sid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:3:\"sid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:1:\"#\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:14:\"number_integer\";s:8:\"settings\";a:2:{s:18:\"thousand_separator\";s:0:\"\";s:13:\"prefix_suffix\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:8:\"in_draft\";a:37:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Draft\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"created\";a:37:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:7:\"Created\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:11:\"remote_addr\";a:37:{s:2:\"id\";s:11:\"remote_addr\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:11:\"remote_addr\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:11:\"remote_addr\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:10:\"IP address\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:23:\"view_webform_submission\";a:26:{s:2:\"id\";s:23:\"view_webform_submission\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:23:\"view_webform_submission\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"full\";s:7:\"options\";a:7:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:25;s:11:\"total_pages\";N;s:2:\"id\";i:0;s:4:\"tags\";a:4:{s:4:\"next\";s:6:\"››\";s:8:\"previous\";s:6:\"‹‹\";s:5:\"first\";s:8:\"« First\";s:4:\"last\";s:7:\"Last »\";}s:6:\"expose\";a:7:{s:14:\"items_per_page\";b:0;s:20:\"items_per_page_label\";s:14:\"Items per page\";s:22:\"items_per_page_options\";s:23:\"5, 10, 25, 50, 100, 200\";s:26:\"items_per_page_options_all\";b:0;s:32:\"items_per_page_options_all_label\";s:7:\"- All -\";s:6:\"offset\";b:0;s:12:\"offset_label\";s:6:\"Offset\";}s:8:\"quantity\";i:9;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"none\";s:7:\"options\";a:0:{}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:25:\"No submissions available.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:0:{}s:9:\"arguments\";a:5:{s:10:\"webform_id\";a:6:{s:2:\"id\";s:10:\"webform_id\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:10:\"webform_id\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:10:\"webform_id\";s:9:\"plugin_id\";s:6:\"string\";}s:11:\"entity_type\";a:6:{s:2:\"id\";s:11:\"entity_type\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:11:\"entity_type\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:11:\"entity_type\";s:9:\"plugin_id\";s:6:\"string\";}s:9:\"entity_id\";a:6:{s:2:\"id\";s:9:\"entity_id\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:9:\"entity_id\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:9:\"entity_id\";s:9:\"plugin_id\";s:6:\"string\";}s:3:\"uid\";a:6:{s:2:\"id\";s:3:\"uid\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:3:\"uid\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:3:\"uid\";s:9:\"plugin_id\";s:7:\"numeric\";}s:8:\"in_draft\";a:23:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:7:\"numeric\";s:14:\"default_action\";s:6:\"ignore\";s:9:\"exception\";a:3:{s:5:\"value\";s:3:\"all\";s:12:\"title_enable\";b:0;s:5:\"title\";s:3:\"All\";}s:12:\"title_enable\";b:0;s:5:\"title\";s:0:\"\";s:21:\"default_argument_type\";s:5:\"fixed\";s:24:\"default_argument_options\";a:1:{s:8:\"argument\";s:0:\"\";}s:25:\"default_argument_skip_url\";b:0;s:15:\"summary_options\";a:4:{s:9:\"base_path\";s:0:\"\";s:5:\"count\";b:1;s:8:\"override\";b:0;s:14:\"items_per_page\";i:25;}s:7:\"summary\";a:3:{s:10:\"sort_order\";s:3:\"asc\";s:17:\"number_of_records\";i:0;s:6:\"format\";s:15:\"default_summary\";}s:18:\"specify_validation\";b:0;s:8:\"validate\";a:2:{s:4:\"type\";s:4:\"none\";s:4:\"fail\";s:9:\"not found\";}s:16:\"validate_options\";a:0:{}s:12:\"break_phrase\";b:0;s:3:\"not\";b:0;}}s:7:\"filters\";a:0:{}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:0:{}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:10:{s:28:\"webform_submission_bulk_form\";s:28:\"webform_submission_bulk_form\";s:3:\"sid\";s:3:\"sid\";s:8:\"in_draft\";s:8:\"in_draft\";s:6:\"sticky\";s:6:\"sticky\";s:6:\"locked\";s:6:\"locked\";s:7:\"created\";s:7:\"created\";s:9:\"completed\";s:9:\"completed\";s:11:\"remote_addr\";s:11:\"remote_addr\";s:23:\"view_webform_submission\";s:23:\"view_webform_submission\";s:23:\"edit_webform_submission\";s:23:\"view_webform_submission\";}s:7:\"default\";s:7:\"created\";s:4:\"info\";a:10:{s:28:\"webform_submission_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:3:\"sid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"in_draft\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"sticky\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"locked\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"completed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"remote_addr\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"view_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:1:\" \";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"edit_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:0;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:1:{s:6:\"result\";a:9:{s:2:\"id\";s:6:\"result\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:6:\"result\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"result\";s:5:\"empty\";b:0;s:7:\"content\";s:34:\"Displaying @start - @end of @total\";}}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";}s:4:\"tags\";a:0:{}}}s:16:\"embed_administer\";a:6:{s:2:\"id\";s:16:\"embed_administer\";s:13:\"display_title\";s:17:\"Embed: Administer\";s:14:\"display_plugin\";s:5:\"embed\";s:8:\"position\";i:2;s:15:\"display_options\";a:9:{s:6:\"fields\";a:9:{s:28:\"webform_submission_bulk_form\";a:26:{s:2:\"id\";s:28:\"webform_submission_bulk_form\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:28:\"webform_submission_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:9:\"plugin_id\";s:28:\"webform_submission_bulk_form\";s:5:\"label\";s:39:\"Webform submission operations bulk form\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"exclude\";s:16:\"selected_actions\";a:0:{}}s:3:\"sid\";a:37:{s:2:\"id\";s:3:\"sid\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:3:\"sid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:3:\"sid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:1:\"#\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:14:\"number_integer\";s:8:\"settings\";a:2:{s:18:\"thousand_separator\";s:0:\"\";s:13:\"prefix_suffix\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:8:\"in_draft\";a:37:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Draft\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:6:\"sticky\";a:37:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Sticky\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:6:\"locked\";a:37:{s:2:\"id\";s:6:\"locked\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"locked\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"locked\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Locked\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"created\";a:37:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:7:\"Created\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:9:\"completed\";a:37:{s:2:\"id\";s:9:\"completed\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:9:\"completed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:9:\"completed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:9:\"Completed\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:11:\"remote_addr\";a:37:{s:2:\"id\";s:11:\"remote_addr\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:11:\"remote_addr\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:11:\"remote_addr\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:10:\"IP address\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:10:\"operations\";a:25:{s:2:\"id\";s:10:\"operations\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:10:\"operations\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";N;s:12:\"entity_field\";N;s:9:\"plugin_id\";s:17:\"entity_operations\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:11:\"destination\";b:1;}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:29:\"administer webform submission\";}}s:7:\"filters\";a:3:{s:8:\"in_draft\";a:16:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:8:\"Is draft\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"in_draft_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"in_draft\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"sticky\";a:16:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Sticky\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"sticky_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"sticky\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"locked\";a:16:{s:2:\"id\";s:6:\"locked\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"locked\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"locked\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Locked\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"locked_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"locked\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:4:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";s:11:\"demo_region\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:10:{s:28:\"webform_submission_bulk_form\";s:28:\"webform_submission_bulk_form\";s:3:\"sid\";s:3:\"sid\";s:8:\"in_draft\";s:8:\"in_draft\";s:6:\"sticky\";s:6:\"sticky\";s:6:\"locked\";s:6:\"locked\";s:7:\"created\";s:7:\"created\";s:9:\"completed\";s:9:\"completed\";s:11:\"remote_addr\";s:11:\"remote_addr\";s:23:\"view_webform_submission\";s:23:\"view_webform_submission\";s:23:\"edit_webform_submission\";s:23:\"view_webform_submission\";}s:7:\"default\";s:7:\"created\";s:4:\"info\";a:10:{s:28:\"webform_submission_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:3:\"sid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"in_draft\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"sticky\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"locked\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"completed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"remote_addr\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"view_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:1:\" \";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"edit_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:0;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:8:\"defaults\";a:6:{s:6:\"access\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:19:\"display_description\";s:23:\"Administer submissions.\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:13:\"embed_default\";a:6:{s:2:\"id\";s:13:\"embed_default\";s:13:\"display_title\";s:14:\"Embed: Default\";s:14:\"display_plugin\";s:5:\"embed\";s:8:\"position\";i:1;s:15:\"display_options\";a:5:{s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:5:{s:3:\"sid\";s:3:\"sid\";s:8:\"in_draft\";s:8:\"in_draft\";s:7:\"created\";s:7:\"created\";s:11:\"remote_addr\";s:11:\"remote_addr\";s:23:\"view_webform_submission\";s:23:\"view_webform_submission\";}s:7:\"default\";s:7:\"created\";s:4:\"info\";a:5:{s:3:\"sid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"in_draft\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"remote_addr\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"view_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:1:\" \";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:0;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:8:\"defaults\";a:5:{s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"fields\";b:1;s:7:\"filters\";b:1;s:13:\"filter_groups\";b:1;}s:19:\"display_description\";s:20:\"Display submissions.\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:5:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";}s:4:\"tags\";a:0:{}}}s:12:\"embed_manage\";a:6:{s:2:\"id\";s:12:\"embed_manage\";s:13:\"display_title\";s:13:\"Embed: Manage\";s:14:\"display_plugin\";s:5:\"embed\";s:8:\"position\";i:3;s:15:\"display_options\";a:9:{s:6:\"fields\";a:10:{s:28:\"webform_submission_bulk_form\";a:26:{s:2:\"id\";s:28:\"webform_submission_bulk_form\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:28:\"webform_submission_bulk_form\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:9:\"plugin_id\";s:28:\"webform_submission_bulk_form\";s:5:\"label\";s:39:\"Webform submission operations bulk form\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:12:\"action_title\";s:6:\"Action\";s:15:\"include_exclude\";s:7:\"include\";s:16:\"selected_actions\";a:4:{i:0;s:35:\"webform_submission_make_lock_action\";i:1;s:37:\"webform_submission_make_sticky_action\";i:2;s:37:\"webform_submission_make_unlock_action\";i:3;s:39:\"webform_submission_make_unsticky_action\";}}s:3:\"sid\";a:37:{s:2:\"id\";s:3:\"sid\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:3:\"sid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:3:\"sid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:1:\"#\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:14:\"number_integer\";s:8:\"settings\";a:2:{s:18:\"thousand_separator\";s:0:\"\";s:13:\"prefix_suffix\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:8:\"in_draft\";a:37:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Draft\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:6:\"sticky\";a:37:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Sticky\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:6:\"locked\";a:37:{s:2:\"id\";s:6:\"locked\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"locked\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"locked\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Locked\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"created\";a:37:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:7:\"Created\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:9:\"completed\";a:37:{s:2:\"id\";s:9:\"completed\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:9:\"completed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:9:\"completed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:9:\"Completed\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:11:\"remote_addr\";a:37:{s:2:\"id\";s:11:\"remote_addr\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:11:\"remote_addr\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:11:\"remote_addr\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:10:\"IP address\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:23:\"view_webform_submission\";a:26:{s:2:\"id\";s:23:\"view_webform_submission\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:23:\"view_webform_submission\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;}s:23:\"edit_webform_submission\";a:26:{s:2:\"id\";s:23:\"edit_webform_submission\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:23:\"edit_webform_submission\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:9:\"plugin_id\";s:16:\"entity_link_edit\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"edit\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:27:\"edit any webform submission\";}}s:7:\"filters\";a:3:{s:8:\"in_draft\";a:16:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:8:\"Is draft\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"in_draft_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"in_draft\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"sticky\";a:16:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Sticky\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"sticky_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"sticky\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"locked\";a:16:{s:2:\"id\";s:6:\"locked\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"locked\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"locked\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Locked\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"locked_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"locked\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:4:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";s:11:\"demo_region\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:10:{s:28:\"webform_submission_bulk_form\";s:28:\"webform_submission_bulk_form\";s:3:\"sid\";s:3:\"sid\";s:8:\"in_draft\";s:8:\"in_draft\";s:6:\"sticky\";s:6:\"sticky\";s:6:\"locked\";s:6:\"locked\";s:7:\"created\";s:7:\"created\";s:9:\"completed\";s:9:\"completed\";s:11:\"remote_addr\";s:11:\"remote_addr\";s:23:\"view_webform_submission\";s:23:\"view_webform_submission\";s:23:\"edit_webform_submission\";s:23:\"view_webform_submission\";}s:7:\"default\";s:7:\"created\";s:4:\"info\";a:10:{s:28:\"webform_submission_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:3:\"sid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"in_draft\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"sticky\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"locked\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"completed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"remote_addr\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"view_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:1:\" \";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"edit_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:0;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:8:\"defaults\";a:6:{s:6:\"access\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:19:\"display_description\";s:19:\"Manage submissions.\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:0;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:12:\"embed_review\";a:6:{s:2:\"id\";s:12:\"embed_review\";s:13:\"display_title\";s:13:\"Embed: Review\";s:14:\"display_plugin\";s:5:\"embed\";s:8:\"position\";i:4;s:15:\"display_options\";a:9:{s:6:\"fields\";a:8:{s:3:\"sid\";a:37:{s:2:\"id\";s:3:\"sid\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:3:\"sid\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:3:\"sid\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:1:\"#\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:14:\"number_integer\";s:8:\"settings\";a:2:{s:18:\"thousand_separator\";s:0:\"\";s:13:\"prefix_suffix\";b:1;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:8:\"in_draft\";a:37:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:5:\"Draft\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:6:\"sticky\";a:37:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Sticky\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:6:\"locked\";a:37:{s:2:\"id\";s:6:\"locked\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"locked\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"locked\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:6:\"Locked\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:7:\"boolean\";s:8:\"settings\";a:3:{s:6:\"format\";s:6:\"yes-no\";s:19:\"format_custom_false\";s:0:\"\";s:18:\"format_custom_true\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:7:\"created\";a:37:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:7:\"Created\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:0;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:9:\"completed\";a:37:{s:2:\"id\";s:9:\"completed\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:9:\"completed\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:9:\"completed\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:9:\"Completed\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:9:\"timestamp\";s:8:\"settings\";a:3:{s:11:\"date_format\";s:6:\"medium\";s:18:\"custom_date_format\";s:0:\"\";s:8:\"timezone\";s:0:\"\";}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:11:\"remote_addr\";a:37:{s:2:\"id\";s:11:\"remote_addr\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:11:\"remote_addr\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:11:\"remote_addr\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:10:\"IP address\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:17:\"click_sort_column\";s:5:\"value\";s:4:\"type\";s:6:\"string\";s:8:\"settings\";a:1:{s:14:\"link_to_entity\";b:0;}s:12:\"group_column\";s:5:\"value\";s:13:\"group_columns\";a:0:{}s:10:\"group_rows\";b:1;s:11:\"delta_limit\";i:0;s:12:\"delta_offset\";i:0;s:14:\"delta_reversed\";b:0;s:16:\"delta_first_last\";b:0;s:10:\"multi_type\";s:9:\"separator\";s:9:\"separator\";s:2:\", \";s:17:\"field_api_classes\";b:0;}s:23:\"view_webform_submission\";a:26:{s:2:\"id\";s:23:\"view_webform_submission\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:23:\"view_webform_submission\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:9:\"plugin_id\";s:11:\"entity_link\";s:5:\"label\";s:10:\"Operations\";s:7:\"exclude\";b:0;s:5:\"alter\";a:26:{s:10:\"alter_text\";b:0;s:4:\"text\";s:0:\"\";s:9:\"make_link\";b:0;s:4:\"path\";s:0:\"\";s:8:\"absolute\";b:0;s:8:\"external\";b:0;s:14:\"replace_spaces\";b:0;s:9:\"path_case\";s:4:\"none\";s:15:\"trim_whitespace\";b:0;s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:10:\"link_class\";s:0:\"\";s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:6:\"target\";s:0:\"\";s:5:\"nl2br\";b:0;s:10:\"max_length\";i:0;s:13:\"word_boundary\";b:1;s:8:\"ellipsis\";b:1;s:9:\"more_link\";b:0;s:14:\"more_link_text\";s:0:\"\";s:14:\"more_link_path\";s:0:\"\";s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:13:\"preserve_tags\";s:0:\"\";s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"text\";s:4:\"view\";s:18:\"output_url_as_text\";b:0;s:8:\"absolute\";b:0;}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:27:\"view any webform submission\";}}s:7:\"filters\";a:3:{s:8:\"in_draft\";a:16:{s:2:\"id\";s:8:\"in_draft\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:8:\"in_draft\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:8:\"in_draft\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:8:\"Is draft\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:11:\"in_draft_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:8:\"in_draft\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"sticky\";a:16:{s:2:\"id\";s:6:\"sticky\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"sticky\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"sticky\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Sticky\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"sticky_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"sticky\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}s:6:\"locked\";a:16:{s:2:\"id\";s:6:\"locked\";s:5:\"table\";s:18:\"webform_submission\";s:5:\"field\";s:6:\"locked\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:18:\"webform_submission\";s:12:\"entity_field\";s:6:\"locked\";s:9:\"plugin_id\";s:7:\"boolean\";s:8:\"operator\";s:1:\"=\";s:5:\"value\";s:3:\"All\";s:5:\"group\";i:1;s:7:\"exposed\";b:1;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:0:\"\";s:5:\"label\";s:6:\"Locked\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"locked_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"locked\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:4:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";s:11:\"demo_region\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:13:\"filter_groups\";a:2:{s:8:\"operator\";s:3:\"AND\";s:6:\"groups\";a:1:{i:1;s:3:\"AND\";}}s:5:\"style\";a:2:{s:4:\"type\";s:5:\"table\";s:7:\"options\";a:12:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:7:\"columns\";a:10:{s:28:\"webform_submission_bulk_form\";s:28:\"webform_submission_bulk_form\";s:3:\"sid\";s:3:\"sid\";s:8:\"in_draft\";s:8:\"in_draft\";s:6:\"sticky\";s:6:\"sticky\";s:6:\"locked\";s:6:\"locked\";s:7:\"created\";s:7:\"created\";s:9:\"completed\";s:9:\"completed\";s:11:\"remote_addr\";s:11:\"remote_addr\";s:23:\"view_webform_submission\";s:23:\"view_webform_submission\";s:23:\"edit_webform_submission\";s:23:\"view_webform_submission\";}s:7:\"default\";s:7:\"created\";s:4:\"info\";a:10:{s:28:\"webform_submission_bulk_form\";a:4:{s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:3:\"sid\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:8:\"in_draft\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"sticky\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:6:\"locked\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:7:\"created\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:4:\"desc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:9:\"completed\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:11:\"remote_addr\";a:6:{s:8:\"sortable\";b:1;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"view_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:1:\" \";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}s:23:\"edit_webform_submission\";a:6:{s:8:\"sortable\";b:0;s:18:\"default_sort_order\";s:3:\"asc\";s:5:\"align\";s:0:\"\";s:9:\"separator\";s:0:\"\";s:12:\"empty_column\";b:0;s:10:\"responsive\";s:0:\"\";}}s:8:\"override\";b:1;s:6:\"sticky\";b:0;s:7:\"summary\";s:0:\"\";s:11:\"empty_table\";b:0;s:7:\"caption\";s:0:\"\";s:11:\"description\";s:0:\"\";}}s:3:\"row\";a:2:{s:4:\"type\";s:6:\"fields\";s:7:\"options\";a:4:{s:22:\"default_field_elements\";b:1;s:6:\"inline\";a:0:{}s:9:\"separator\";s:0:\"\";s:10:\"hide_empty\";b:0;}}s:8:\"defaults\";a:6:{s:6:\"access\";b:0;s:5:\"style\";b:0;s:3:\"row\";b:0;s:6:\"fields\";b:0;s:7:\"filters\";b:0;s:13:\"filter_groups\";b:0;}s:19:\"display_description\";s:19:\"Review submissions.\";s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:6:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:3:\"url\";i:3;s:14:\"url.query_args\";i:4;s:4:\"user\";i:5;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.596,1,'','0'),('views.view.who_s_new',_binary 'a:13:{s:4:\"uuid\";s:36:\"d0b3d53f-7f59-4b03-b0ae-2e7e89f10254\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"zji0_13MyVGK7Bn1lUMDeZyyOIZedWvqpYUeM_SioPI\";}s:2:\"id\";s:9:\"who_s_new\";s:5:\"label\";s:16:\"Nouveaux membres\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:64:\"Affiche la liste des utilisateurs les plus récents sur le site.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:16:\"Nouveaux membres\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:5;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:14:\"access content\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:0:{}s:5:\"sorts\";a:1:{s:7:\"created\";a:13:{s:2:\"id\";s:7:\"created\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:7:\"created\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:7:\"created\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:7:\"created\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:1:\">\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:10:\"1970-01-01\";s:4:\"type\";s:4:\"date\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:1:\"0\";s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:0:\"\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:0:\"\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:1:{s:13:\"authenticated\";s:13:\"authenticated\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:1:{s:4:\"type\";s:9:\"html_list\";}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:0:{}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:7:\"block_1\";a:6:{s:2:\"id\";s:7:\"block_1\";s:13:\"display_title\";s:16:\"Nouveaux membres\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:4:{s:19:\"display_description\";s:35:\"Une liste des nouveaux utilisateurs\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:16:\"Nouveaux membres\";s:14:\"block_category\";s:4:\"User\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.596,1,'','0'),('views.view.who_s_online',_binary 'a:13:{s:4:\"uuid\";s:36:\"4f6bd7cd-f6b0-4240-af1f-121d463df864\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";b:1;s:12:\"dependencies\";a:1:{s:6:\"module\";a:1:{i:0;s:4:\"user\";}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"suDsVMgawXoQt4rfmdfpr05EVX3z3KyfDDTYgeSM898\";}s:2:\"id\";s:12:\"who_s_online\";s:5:\"label\";s:24:\"Bloc \"Qui est connecté\"\";s:6:\"module\";s:4:\"user\";s:11:\"description\";s:102:\"Affiche les noms des utilisateurs les plus actifs récemment et le nombre total d\'utilisateurs actifs.\";s:3:\"tag\";s:7:\"default\";s:10:\"base_table\";s:16:\"users_field_data\";s:10:\"base_field\";s:3:\"uid\";s:7:\"display\";a:2:{s:7:\"default\";a:6:{s:2:\"id\";s:7:\"default\";s:13:\"display_title\";s:7:\"Default\";s:14:\"display_plugin\";s:7:\"default\";s:8:\"position\";i:0;s:15:\"display_options\";a:17:{s:5:\"title\";s:21:\"Utilisateurs en ligne\";s:6:\"fields\";a:1:{s:4:\"name\";a:25:{s:2:\"id\";s:4:\"name\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:4:\"name\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:4:\"name\";s:9:\"plugin_id\";s:5:\"field\";s:5:\"label\";s:0:\"\";s:7:\"exclude\";b:0;s:5:\"alter\";a:8:{s:10:\"alter_text\";b:0;s:9:\"make_link\";b:0;s:8:\"absolute\";b:0;s:13:\"word_boundary\";b:0;s:8:\"ellipsis\";b:0;s:10:\"strip_tags\";b:0;s:4:\"trim\";b:0;s:4:\"html\";b:0;}s:12:\"element_type\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:18:\"element_label_type\";s:0:\"\";s:19:\"element_label_class\";s:0:\"\";s:19:\"element_label_colon\";b:1;s:20:\"element_wrapper_type\";s:0:\"\";s:21:\"element_wrapper_class\";s:0:\"\";s:23:\"element_default_classes\";b:1;s:5:\"empty\";s:0:\"\";s:10:\"hide_empty\";b:0;s:10:\"empty_zero\";b:0;s:16:\"hide_alter_empty\";b:1;s:4:\"type\";s:9:\"user_name\";}}s:5:\"pager\";a:2:{s:4:\"type\";s:4:\"some\";s:7:\"options\";a:2:{s:6:\"offset\";i:0;s:14:\"items_per_page\";i:10;}}s:12:\"exposed_form\";a:2:{s:4:\"type\";s:5:\"basic\";s:7:\"options\";a:7:{s:13:\"submit_button\";s:5:\"Apply\";s:12:\"reset_button\";b:0;s:18:\"reset_button_label\";s:5:\"Reset\";s:19:\"exposed_sorts_label\";s:7:\"Sort by\";s:17:\"expose_sort_order\";b:1;s:14:\"sort_asc_label\";s:3:\"Asc\";s:15:\"sort_desc_label\";s:4:\"Desc\";}}s:6:\"access\";a:2:{s:4:\"type\";s:4:\"perm\";s:7:\"options\";a:1:{s:4:\"perm\";s:20:\"access user profiles\";}}s:5:\"cache\";a:2:{s:4:\"type\";s:3:\"tag\";s:7:\"options\";a:0:{}}s:5:\"empty\";a:1:{s:16:\"area_text_custom\";a:10:{s:2:\"id\";s:16:\"area_text_custom\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:16:\"area_text_custom\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:11:\"text_custom\";s:5:\"empty\";b:1;s:7:\"content\";s:44:\"Il y a actuellement 0 utilisateurs en ligne.\";s:8:\"tokenize\";b:0;}}s:5:\"sorts\";a:1:{s:6:\"access\";a:13:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:5:\"order\";s:4:\"DESC\";s:6:\"expose\";a:2:{s:5:\"label\";s:0:\"\";s:16:\"field_identifier\";s:6:\"access\";}s:7:\"exposed\";b:0;s:11:\"granularity\";s:6:\"second\";}}s:9:\"arguments\";a:0:{}s:7:\"filters\";a:2:{s:6:\"status\";a:9:{s:2:\"id\";s:6:\"status\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"status\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"status\";s:9:\"plugin_id\";s:7:\"boolean\";s:5:\"value\";s:1:\"1\";s:5:\"group\";i:1;s:6:\"expose\";a:3:{s:8:\"operator\";s:1:\"0\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}}}s:6:\"access\";a:16:{s:2:\"id\";s:6:\"access\";s:5:\"table\";s:16:\"users_field_data\";s:5:\"field\";s:6:\"access\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:11:\"entity_type\";s:4:\"user\";s:12:\"entity_field\";s:6:\"access\";s:9:\"plugin_id\";s:4:\"date\";s:8:\"operator\";s:2:\">=\";s:5:\"value\";a:4:{s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:5:\"value\";s:11:\"-15 minutes\";s:4:\"type\";s:6:\"offset\";}s:5:\"group\";i:1;s:7:\"exposed\";b:0;s:6:\"expose\";a:12:{s:11:\"operator_id\";s:9:\"access_op\";s:5:\"label\";s:14:\"Dernier accès\";s:11:\"description\";s:121:\"Durée pendant laquelle on considère qu\'un utilisateur est en ligne après qu\'il ait vu une page pour la dernière fois.\";s:12:\"use_operator\";b:0;s:8:\"operator\";s:9:\"access_op\";s:24:\"operator_limit_selection\";b:0;s:13:\"operator_list\";a:0:{}s:10:\"identifier\";s:6:\"access\";s:8:\"required\";b:0;s:8:\"remember\";b:0;s:8:\"multiple\";b:0;s:14:\"remember_roles\";a:3:{s:13:\"authenticated\";s:13:\"authenticated\";s:9:\"anonymous\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}}s:10:\"is_grouped\";b:0;s:10:\"group_info\";a:10:{s:5:\"label\";s:0:\"\";s:11:\"description\";s:0:\"\";s:10:\"identifier\";s:0:\"\";s:8:\"optional\";b:1;s:6:\"widget\";s:6:\"select\";s:8:\"multiple\";b:0;s:8:\"remember\";b:0;s:13:\"default_group\";s:3:\"All\";s:22:\"default_group_multiple\";a:0:{}s:11:\"group_items\";a:0:{}}}}s:5:\"style\";a:2:{s:4:\"type\";s:9:\"html_list\";s:7:\"options\";a:6:{s:8:\"grouping\";a:0:{}s:9:\"row_class\";s:0:\"\";s:17:\"default_row_class\";b:1;s:4:\"type\";s:2:\"ul\";s:13:\"wrapper_class\";s:9:\"item-list\";s:5:\"class\";s:0:\"\";}}s:3:\"row\";a:1:{s:4:\"type\";s:6:\"fields\";}s:5:\"query\";a:2:{s:4:\"type\";s:11:\"views_query\";s:7:\"options\";a:5:{s:13:\"query_comment\";s:0:\"\";s:19:\"disable_sql_rewrite\";b:0;s:8:\"distinct\";b:0;s:7:\"replica\";b:0;s:10:\"query_tags\";a:0:{}}}s:13:\"relationships\";a:0:{}s:6:\"header\";a:1:{s:6:\"result\";a:9:{s:2:\"id\";s:6:\"result\";s:5:\"table\";s:5:\"views\";s:5:\"field\";s:6:\"result\";s:12:\"relationship\";s:4:\"none\";s:10:\"group_type\";s:5:\"group\";s:11:\"admin_label\";s:0:\"\";s:9:\"plugin_id\";s:6:\"result\";s:5:\"empty\";b:0;s:7:\"content\";s:49:\"Il y a actuellement @total utilisateurs en ligne.\";}}s:6:\"footer\";a:0:{}s:17:\"display_extenders\";a:0:{}}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}s:18:\"who_s_online_block\";a:6:{s:2:\"id\";s:18:\"who_s_online_block\";s:13:\"display_title\";s:21:\"Utilisateurs en ligne\";s:14:\"display_plugin\";s:5:\"block\";s:8:\"position\";i:1;s:15:\"display_options\";a:3:{s:19:\"display_description\";s:49:\"Une liste d\'utilisateurs actuellement connectés.\";s:17:\"display_extenders\";a:0:{}s:17:\"block_description\";s:21:\"Utilisateurs en ligne\";}s:14:\"cache_metadata\";a:3:{s:7:\"max-age\";i:-1;s:8:\"contexts\";a:3:{i:0;s:26:\"languages:language_content\";i:1;s:28:\"languages:language_interface\";i:2;s:16:\"user.permissions\";}s:4:\"tags\";a:0:{}}}}}',-1,1680008715.596,1,'','0'),('webform.settings',_binary 'a:20:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"jTF0_vM4UaYuf_KscJfzul_pbZRuyQ6qUArFXQtM9JQ\";}s:8:\"langcode\";s:2:\"fr\";s:8:\"settings\";a:71:{s:14:\"default_status\";s:4:\"open\";s:12:\"default_page\";b:1;s:22:\"default_page_base_path\";s:5:\"/form\";s:12:\"default_ajax\";b:0;s:26:\"default_ajax_progress_type\";s:8:\"throbber\";s:19:\"default_ajax_effect\";s:4:\"fade\";s:18:\"default_ajax_speed\";i:500;s:27:\"default_submit_button_label\";s:6:\"Submit\";s:26:\"default_reset_button_label\";s:5:\"Reset\";s:27:\"default_delete_button_label\";s:6:\"Delete\";s:24:\"default_form_submit_once\";b:0;s:25:\"default_form_open_message\";s:49:\"This form has not yet been opened to submissions.\";s:26:\"default_form_close_message\";s:48:\"Sorry… This form is closed to new submissions.\";s:30:\"default_form_exception_message\";s:70:\"Unable to display this webform. Please contact the site administrator.\";s:33:\"default_form_confidential_message\";s:135:\"This form is confidential. You must <a href=\"[site:login-url]/logout?destination=[current-page:url:relative]\">Log out</a> to submit it.\";s:34:\"default_form_access_denied_message\";s:33:\"Please login to access this form.\";s:32:\"default_form_disable_remote_addr\";b:0;s:23:\"default_form_novalidate\";b:0;s:34:\"default_form_disable_inline_errors\";b:0;s:21:\"default_form_required\";b:0;s:27:\"default_form_required_label\";s:24:\"Indicates required field\";s:20:\"default_form_unsaved\";b:0;s:25:\"default_form_disable_back\";b:0;s:24:\"default_form_submit_back\";b:0;s:27:\"default_form_details_toggle\";b:1;s:23:\"default_form_file_limit\";s:0:\"\";s:32:\"default_wizard_prev_button_label\";s:10:\"< Previous\";s:32:\"default_wizard_next_button_label\";s:6:\"Next >\";s:26:\"default_wizard_start_label\";s:5:\"Start\";s:33:\"default_wizard_confirmation_label\";s:8:\"Complete\";s:32:\"default_wizard_toggle_show_label\";s:8:\"Show all\";s:32:\"default_wizard_toggle_hide_label\";s:8:\"Hide all\";s:33:\"default_preview_next_button_label\";s:7:\"Preview\";s:33:\"default_preview_prev_button_label\";s:10:\"< Previous\";s:21:\"default_preview_label\";s:7:\"Preview\";s:21:\"default_preview_title\";s:24:\"[webform:title]: Preview\";s:23:\"default_preview_message\";s:99:\"Please review your submission. Your submission is not complete until you press the \"Submit\" button!\";s:26:\"default_draft_button_label\";s:10:\"Save Draft\";s:27:\"default_draft_saved_message\";s:91:\"Submission saved. You may return to this form later and it will restore the current values.\";s:28:\"default_draft_loaded_message\";s:77:\"A partially-completed form was found. Please complete the remaining portions.\";s:36:\"default_draft_pending_single_message\";s:83:\"You have a pending draft for this webform. <a href=\"#\">Load your pending draft</a>.\";s:38:\"default_draft_pending_multiple_message\";s:83:\"You have pending drafts for this webform. <a href=\"#\">View your pending drafts</a>.\";s:28:\"default_confirmation_message\";s:40:\"New submission added to [webform:title].\";s:31:\"default_confirmation_back_label\";s:12:\"Back to form\";s:27:\"default_limit_total_message\";s:34:\"No more submissions are permitted.\";s:26:\"default_limit_user_message\";s:34:\"No more submissions are permitted.\";s:24:\"default_submission_label\";s:74:\"[webform_submission:submitted-to]: Submission #[webform_submission:serial]\";s:22:\"default_submission_log\";b:0;s:24:\"default_submission_views\";a:0:{}s:32:\"default_submission_views_replace\";a:3:{s:13:\"global_routes\";a:2:{i:0;s:36:\"entity.webform_submission.collection\";i:1;s:30:\"entity.webform_submission.user\";}s:14:\"webform_routes\";a:3:{i:0;s:34:\"entity.webform.results_submissions\";i:1;s:26:\"entity.webform.user.drafts\";i:2;s:31:\"entity.webform.user.submissions\";}s:11:\"node_routes\";a:3:{i:0;s:39:\"entity.node.webform.results_submissions\";i:1;s:31:\"entity.node.webform.user.drafts\";i:2;s:36:\"entity.node.webform.user.submissions\";}}s:25:\"default_results_customize\";b:0;s:40:\"default_submission_access_denied_message\";s:39:\"Please login to access this submission.\";s:36:\"default_submission_exception_message\";s:73:\"Unable to process this submission. Please contact the site administrator.\";s:33:\"default_submission_locked_message\";s:32:\"This submission has been locked.\";s:35:\"default_previous_submission_message\";s:87:\"You have already submitted this webform. <a href=\"#\">View your previous submission</a>.\";s:36:\"default_previous_submissions_message\";s:88:\"You have already submitted this webform. <a href=\"#\">View your previous submissions</a>.\";s:24:\"default_autofill_message\";s:66:\"This submission has been autofilled with your previous submission.\";s:12:\"form_classes\";s:126:\"container-inline clearfix\nform--inline clearfix\nmessages messages--error\nmessages messages--warning\nmessages messages--status\n\";s:14:\"button_classes\";s:0:\"\";s:15:\"preview_classes\";s:78:\"messages messages--error\nmessages messages--warning\nmessages messages--status\n\";s:20:\"confirmation_classes\";s:78:\"messages messages--error\nmessages messages--warning\nmessages messages--status\n\";s:25:\"confirmation_back_classes\";s:7:\"button\n\";s:13:\"default_share\";b:0;s:18:\"default_share_node\";b:0;s:24:\"default_share_theme_name\";s:0:\"\";s:17:\"webform_bulk_form\";b:1;s:25:\"webform_bulk_form_actions\";a:5:{i:0;s:19:\"webform_open_action\";i:1;s:20:\"webform_close_action\";i:2;s:22:\"webform_archive_action\";i:3;s:24:\"webform_unarchive_action\";i:4;s:21:\"webform_delete_action\";}s:28:\"webform_submission_bulk_form\";b:1;s:36:\"webform_submission_bulk_form_actions\";a:5:{i:0;s:37:\"webform_submission_make_sticky_action\";i:1;s:39:\"webform_submission_make_unsticky_action\";i:2;s:35:\"webform_submission_make_lock_action\";i:3;s:37:\"webform_submission_make_unlock_action\";i:4;s:32:\"webform_submission_delete_action\";}s:6:\"dialog\";b:0;s:14:\"dialog_options\";a:3:{s:6:\"narrow\";a:2:{s:5:\"title\";s:6:\"Narrow\";s:5:\"width\";i:600;}s:6:\"normal\";a:2:{s:5:\"title\";s:6:\"Normal\";s:5:\"width\";i:800;}s:4:\"wide\";a:2:{s:5:\"title\";s:4:\"Wide\";s:5:\"width\";i:1000;}}}s:6:\"assets\";a:2:{s:3:\"css\";s:0:\"\";s:10:\"javascript\";s:0:\"\";}s:4:\"form\";a:3:{s:5:\"limit\";i:50;s:15:\"filter_category\";s:0:\"\";s:12:\"filter_state\";s:0:\"\";}s:7:\"element\";a:15:{s:20:\"machine_name_pattern\";s:7:\"a-z0-9_\";s:13:\"empty_message\";s:7:\"{Empty}\";s:12:\"allowed_tags\";s:5:\"admin\";s:15:\"wrapper_classes\";s:126:\"container-inline clearfix\nform--inline clearfix\nmessages messages--error\nmessages messages--warning\nmessages messages--status\n\";s:7:\"classes\";s:126:\"container-inline clearfix\nform--inline clearfix\nmessages messages--error\nmessages messages--warning\nmessages messages--status\n\";s:23:\"horizontal_rule_classes\";s:286:\"webform-horizontal-rule--solid\nwebform-horizontal-rule--dashed\nwebform-horizontal-rule--dotted\nwebform-horizontal-rule--gradient\nwebform-horizontal-rule--thin\nwebform-horizontal-rule--medium\nwebform-horizontal-rule--thick\nwebform-horizontal-rule--flaired\nwebform-horizontal-rule--glyph\n\";s:27:\"default_description_display\";s:0:\"\";s:18:\"default_more_title\";s:4:\"More\";s:25:\"default_section_title_tag\";s:2:\"h2\";s:20:\"default_empty_option\";b:1;s:29:\"default_empty_option_required\";s:0:\"\";s:29:\"default_empty_option_optional\";s:0:\"\";s:29:\"default_algolia_places_app_id\";s:0:\"\";s:30:\"default_algolia_places_api_key\";s:0:\"\";s:17:\"excluded_elements\";a:2:{s:8:\"password\";s:8:\"password\";s:16:\"password_confirm\";s:16:\"password_confirm\";}}s:11:\"html_editor\";a:5:{s:8:\"disabled\";b:0;s:14:\"element_format\";s:0:\"\";s:11:\"mail_format\";s:0:\"\";s:4:\"tidy\";b:1;s:35:\"make_unused_managed_files_temporary\";b:1;}s:4:\"file\";a:11:{s:11:\"file_public\";b:1;s:21:\"file_private_redirect\";b:1;s:29:\"file_private_redirect_message\";s:41:\"Please login to access the uploaded file.\";s:20:\"default_max_filesize\";s:0:\"\";s:31:\"default_managed_file_extensions\";s:148:\"gif jpg jpeg png bmp eps tif pict psd txt rtf html odf pdf doc docx ppt pptx xls xlsx xml avi mov mp3 mp4 ogg wav bz2 dmg gz jar rar sit svg tar zip\";s:29:\"default_image_file_extensions\";s:16:\"gif jpg jpeg png\";s:29:\"default_video_file_extensions\";s:24:\"avi mov mp4 ogg wav webm\";s:29:\"default_audio_file_extensions\";s:11:\"mp3 ogg wav\";s:32:\"default_document_file_extensions\";s:50:\"txt rtf pdf doc docx odt ppt pptx odp xls xlsx ods\";s:35:\"make_unused_managed_files_temporary\";b:1;s:30:\"delete_temporary_managed_files\";b:1;}s:6:\"format\";a:0:{}s:4:\"mail\";a:11:{s:15:\"default_to_mail\";s:11:\"[site:mail]\";s:17:\"default_from_mail\";s:11:\"[site:mail]\";s:17:\"default_from_name\";s:11:\"[site:name]\";s:16:\"default_reply_to\";s:0:\"\";s:19:\"default_return_path\";s:0:\"\";s:19:\"default_sender_mail\";s:0:\"\";s:19:\"default_sender_name\";s:0:\"\";s:15:\"default_subject\";s:58:\"Webform submission from: [webform_submission:source-title]\";s:17:\"default_body_text\";s:133:\"Submitted on [webform_submission:created]\nSubmitted by: [webform_submission:user]\n\nSubmitted values are:\n[webform_submission:values]\n\";s:17:\"default_body_html\";s:153:\"<p>Submitted on [webform_submission:created]</p>\n<p>Submitted by: [webform_submission:user]</p>\n<p>Submitted values are:</p>\n[webform_submission:values]\n\";s:5:\"roles\";a:0:{}}s:6:\"export\";a:18:{s:14:\"temp_directory\";s:0:\"\";s:8:\"exporter\";s:9:\"delimited\";s:9:\"delimiter\";s:1:\",\";s:18:\"multiple_delimiter\";s:1:\";\";s:5:\"excel\";b:0;s:12:\"archive_type\";s:3:\"tar\";s:13:\"header_format\";s:5:\"label\";s:13:\"header_prefix\";b:1;s:27:\"header_prefix_key_delimiter\";s:2:\"__\";s:29:\"header_prefix_label_delimiter\";s:2:\": \";s:22:\"entity_reference_items\";a:3:{i:0;s:2:\"id\";i:1;s:5:\"title\";i:2;s:3:\"url\";}s:21:\"options_single_format\";s:7:\"compact\";s:23:\"options_multiple_format\";s:7:\"compact\";s:19:\"options_item_format\";s:5:\"label\";s:21:\"likert_answers_format\";s:5:\"label\";s:16:\"signature_format\";s:6:\"status\";s:29:\"composite_element_item_format\";s:5:\"label\";s:18:\"excluded_exporters\";a:0:{}}s:7:\"handler\";a:1:{s:17:\"excluded_handlers\";a:0:{}}s:7:\"variant\";a:1:{s:17:\"excluded_variants\";a:0:{}}s:5:\"batch\";a:5:{s:25:\"default_batch_export_size\";i:500;s:25:\"default_batch_import_size\";i:100;s:25:\"default_batch_update_size\";i:500;s:25:\"default_batch_delete_size\";i:500;s:24:\"default_batch_email_size\";i:500;}s:5:\"purge\";a:1:{s:9:\"cron_size\";i:100;}s:4:\"test\";a:2:{s:5:\"types\";s:3347:\"checkbox:\n  - true\ncolor:\n  - \'#ffffcc\'\n  - \'#ffffcc\'\n  - \'#ccffff\'\nemail:\n  - \'example@example.com\'\n  - \'test@test.com\'\n  - \'random@random.com\'\nlanguage_select:\n  - en\nmachine_name:\n  - \'loremipsum\'\n  - \'oratione\'\n  - \'dixisset\'\ntel:\n  - \'123-456-7890\'\n  - \'098-765-4321\'\ntextarea:\n  - \'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Negat esse eam, inquit, propter se expetendam. Primum Theophrasti, Strato, physicum se voluit; Id mihi magnum videtur. Itaque mihi non satis videmini considerare quod iter sit naturae quaeque progressio. Quare hoc videndum est, possitne nobis hoc ratio philosophorum dare. Est enim tanti philosophi tamque nobilis audacter sua decreta defendere.\'\n  - \'Huius, Lyco, oratione locuples, rebus ipsis ielunior. Duo Reges: constructio interrete. Sed haec in pueris; Sed utrum hortandus es nobis, Luci, inquit, an etiam tua sponte propensus es? Sapiens autem semper beatus est et est aliquando in dolore; Immo videri fortasse. Paulum, cum regem Persem captum adduceret, eodem flumine invectio? Et ille ridens: Video, inquit, quid agas;\'\n  - \'Quae cum dixisset, finem ille. Quamquam non negatis nos intellegere quid sit voluptas, sed quid ille dicat. Progredientibus autem aetatibus sensim tardeve potius quasi nosmet ipsos cognoscimus. Gloriosa ostentatio in constituendo summo bono. Qui-vere falsone, quaerere mittimus-dicitur oculis se privasse; Duarum enim vitarum nobis erunt instituta capienda. Comprehensum, quod cognitum non habet? Qui enim existimabit posse se miserum esse beatus non erit. Causa autem fuit huc veniendi ut quosdam hinc libros promerem. Nunc omni virtuti vitium contrario nomine opponitur.\'\ntext_format:\n  - value: \'<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Negat esse eam, inquit, propter se expetendam. Primum Theophrasti, Strato, physicum se voluit; Id mihi magnum videtur. Itaque mihi non satis videmini considerare quod iter sit naturae quaeque progressio. Quare hoc videndum est, possitne nobis hoc ratio philosophorum dare. Est enim tanti philosophi tamque nobilis audacter sua decreta defendere.</p>\'\n  - value: \'<p>Huius, Lyco, oratione locuples, rebus ipsis ielunior. Duo Reges: constructio interrete. Sed haec in pueris; Sed utrum hortandus es nobis, Luci, inquit, an etiam tua sponte propensus es? Sapiens autem semper beatus est et est aliquando in dolore; Immo videri fortasse. Paulum, cum regem Persem captum adduceret, eodem flumine invectio? Et ille ridens: Video, inquit, quid agas;</p>\'\n  - value: \'<p>Quae cum dixisset, finem ille. Quamquam non negatis nos intellegere quid sit voluptas, sed quid ille dicat. Progredientibus autem aetatibus sensim tardeve potius quasi nosmet ipsos cognoscimus. Gloriosa ostentatio in constituendo summo bono. Qui-vere falsone, quaerere mittimus-dicitur oculis se privasse; Duarum enim vitarum nobis erunt instituta capienda. Comprehensum, quod cognitum non habet? Qui enim existimabit posse se miserum esse beatus non erit. Causa autem fuit huc veniendi ut quosdam hinc libros promerem. Nunc omni virtuti vitium contrario nomine opponitur.</p>\'\nurl:\n  - \'http://example.com\'\n  - \'http://test.com\'\nwebform_email_confirm:\n  - \'example@example.com\'\n  - \'test@test.com\'\n  - \'random@random.com\'\nwebform_email_multiple:\n  - \'example@example.com, test@test.com, random@random.com\'\nwebform_time:\n  - \'09:00\'\n  - \'17:00\'\n\";s:5:\"names\";s:547:\"first_name:\n  - \'John\'\n  - \'Paul\'\n  - \'Ringo\'\n  - \'George\'\nlast_name:\n  - \'Lennon\'\n  - \'McCartney\'\n  - \'Starr\'\n  - \'Harrison\'\naddress:\n  - \'10 Main Street\'\n  - \'11 Brook Alley Road. APT 1\'\nzip:\n  - \'11111\'\n  - \'12345\'\n  - \'12345-6789\'\npostal_code:\n  - \'11111\'\n  - \'12345\'\n  - \'12345-6789\'\nphone:\n  - \'123-456-7890\'\n  - \'098-765-4321\'\nfax:\n  - \'123-456-7890\'\n  - \'098-765-4321\'\ncity:\n  - \'Springfield\'\n  - \'Pleasantville\'\n  - \'Hill Valley\'\nurl:\n  - \'http://example.com\'\n  - \'http://test.com\'\ndefault:\n  - \'Loremipsum\'\n  - \'Oratione\'\n  - \'Dixisset\'\n\";}s:2:\"ui\";a:9:{s:13:\"video_display\";s:6:\"dialog\";s:13:\"help_disabled\";b:0;s:15:\"dialog_disabled\";b:0;s:18:\"offcanvas_disabled\";b:0;s:19:\"promotions_disabled\";b:0;s:16:\"support_disabled\";b:0;s:12:\"details_save\";b:1;s:16:\"description_help\";b:1;s:12:\"toolbar_item\";b:0;}s:9:\"libraries\";a:1:{s:18:\"excluded_libraries\";a:2:{i:0;s:7:\"choices\";i:1;s:13:\"jquery.chosen\";}}s:12:\"requirements\";a:4:{s:3:\"cdn\";b:1;s:21:\"clientside_validation\";b:1;s:9:\"bootstrap\";b:1;s:4:\"spam\";b:1;}s:20:\"third_party_settings\";a:1:{s:7:\"captcha\";a:1:{s:27:\"replace_administration_mode\";b:1;}}}',-1,1680008716.841,1,'','0'),('webform.webform.adhesion',_binary 'a:22:{s:4:\"uuid\";s:36:\"6bba6522-2481-40ba-9542-7f6f486cea95\";s:8:\"langcode\";s:2:\"fr\";s:6:\"status\";s:4:\"open\";s:12:\"dependencies\";a:1:{s:8:\"enforced\";a:1:{s:6:\"module\";a:1:{i:0;s:7:\"webform\";}}}s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"CJr5U2B4if_Ff1SZfnNp_csPKwXIynmbUlBC-SmSOAE\";}s:6:\"weight\";i:0;s:4:\"open\";N;s:5:\"close\";N;s:3:\"uid\";i:1;s:8:\"template\";b:0;s:7:\"archive\";b:0;s:2:\"id\";s:8:\"adhesion\";s:5:\"title\";s:9:\"Adhésion\";s:11:\"description\";s:36:\"Basic email adh&eacute;sion webform.\";s:8:\"category\";s:0:\"\";s:8:\"elements\";s:1299:\"name:\n  \'#type\': textfield\n  \'#title\': \'Nom & prénom\'\n  \'#title_display\': invisible\n  \'#placeholder\': \'Nom & prénom\'\n  \'#required\': true\n  \'#default_value\': \'[current-user:display-name]\'\n  \'#wrapper_attributes\':\n    class:\n      - col-lg-12\nemail:\n  \'#type\': email\n  \'#title\': Email\n  \'#title_display\': invisible\n  \'#placeholder\': Email\n  \'#required\': true\n  \'#default_value\': \'[current-user:mail]\'\n  \'#wrapper_attributes\':\n    class:\n      - col-lg-12\nphone:\n  \'#type\': tel\n  \'#title\': Téléphone\n  \'#title_display\': invisible\n  \'#placeholder\': Téléphone\n  \'#required\': true\n  \'#wrapper_attributes\':\n    class:\n      - col-lg-12\nsubject:\n  \'#type\': textfield\n  \'#title\': Sujet\n  \'#title_display\': invisible\n  \'#placeholder\': Sujet\n  \'#required\': true\n  \'#wrapper_attributes\':\n    class:\n      - col-lg-12\n  \'#test\': \'Testing contact webform from [site:name]\'\nmessage:\n  \'#type\': textarea\n  \'#title\': Message\n  \'#title_display\': invisible\n  \'#placeholder\': Message\n  \'#required\': true\n  \'#wrapper_attributes\':\n    class:\n      - col-lg-12\n  \'#test\': \'Please ignore this email.\'\nactions:\n  \'#type\': webform_actions\n  \'#title\': \'Submit button(s)\'\n  \'#attributes\':\n    class:\n      - col-lg-12\n  \'#submit__label\': \'Envoyez Message \'\n  \'#submit__attributes\':\n    class:\n      - main-gradient-button\";s:3:\"css\";s:0:\"\";s:10:\"javascript\";s:0:\"\";s:8:\"settings\";a:133:{s:4:\"ajax\";b:0;s:15:\"ajax_scroll_top\";s:4:\"form\";s:18:\"ajax_progress_type\";s:0:\"\";s:11:\"ajax_effect\";s:0:\"\";s:10:\"ajax_speed\";N;s:4:\"page\";b:1;s:16:\"page_submit_path\";s:0:\"\";s:17:\"page_confirm_path\";s:0:\"\";s:15:\"page_theme_name\";s:0:\"\";s:10:\"form_title\";s:21:\"source_entity_webform\";s:16:\"form_submit_once\";b:0;s:17:\"form_open_message\";s:0:\"\";s:18:\"form_close_message\";s:0:\"\";s:22:\"form_exception_message\";s:0:\"\";s:25:\"form_previous_submissions\";b:1;s:17:\"form_confidential\";b:0;s:25:\"form_confidential_message\";s:0:\"\";s:24:\"form_disable_remote_addr\";b:0;s:22:\"form_convert_anonymous\";b:0;s:16:\"form_prepopulate\";b:0;s:30:\"form_prepopulate_source_entity\";b:0;s:39:\"form_prepopulate_source_entity_required\";b:0;s:35:\"form_prepopulate_source_entity_type\";s:0:\"\";s:12:\"form_unsaved\";b:0;s:17:\"form_disable_back\";b:0;s:16:\"form_submit_back\";b:0;s:25:\"form_disable_autocomplete\";b:0;s:15:\"form_novalidate\";b:0;s:26:\"form_disable_inline_errors\";b:0;s:13:\"form_required\";b:0;s:14:\"form_autofocus\";b:0;s:19:\"form_details_toggle\";b:0;s:10:\"form_reset\";b:0;s:18:\"form_access_denied\";s:7:\"default\";s:24:\"form_access_denied_title\";s:0:\"\";s:26:\"form_access_denied_message\";s:0:\"\";s:29:\"form_access_denied_attributes\";a:0:{}s:15:\"form_file_limit\";s:0:\"\";s:15:\"form_attributes\";a:0:{}s:11:\"form_method\";s:0:\"\";s:11:\"form_action\";s:0:\"\";s:5:\"share\";b:0;s:10:\"share_node\";b:0;s:16:\"share_theme_name\";s:0:\"\";s:11:\"share_title\";b:1;s:26:\"share_page_body_attributes\";a:0:{}s:16:\"submission_label\";s:0:\"\";s:28:\"submission_exception_message\";s:0:\"\";s:25:\"submission_locked_message\";s:0:\"\";s:14:\"submission_log\";b:0;s:28:\"submission_excluded_elements\";a:0:{}s:24:\"submission_exclude_empty\";b:0;s:33:\"submission_exclude_empty_checkbox\";b:0;s:16:\"submission_views\";a:0:{}s:24:\"submission_views_replace\";a:0:{}s:23:\"submission_user_columns\";a:0:{}s:25:\"submission_user_duplicate\";b:0;s:24:\"submission_access_denied\";s:7:\"default\";s:30:\"submission_access_denied_title\";s:0:\"\";s:32:\"submission_access_denied_message\";s:0:\"\";s:35:\"submission_access_denied_attributes\";a:0:{}s:27:\"previous_submission_message\";s:0:\"\";s:28:\"previous_submissions_message\";s:0:\"\";s:8:\"autofill\";b:0;s:16:\"autofill_message\";s:0:\"\";s:26:\"autofill_excluded_elements\";a:0:{}s:19:\"wizard_progress_bar\";b:1;s:21:\"wizard_progress_pages\";b:0;s:26:\"wizard_progress_percentage\";b:0;s:20:\"wizard_progress_link\";b:0;s:22:\"wizard_progress_states\";b:0;s:18:\"wizard_start_label\";s:0:\"\";s:19:\"wizard_preview_link\";b:0;s:19:\"wizard_confirmation\";b:1;s:25:\"wizard_confirmation_label\";s:0:\"\";s:19:\"wizard_auto_forward\";b:1;s:36:\"wizard_auto_forward_hide_next_button\";b:0;s:15:\"wizard_keyboard\";b:1;s:12:\"wizard_track\";s:0:\"\";s:24:\"wizard_prev_button_label\";s:0:\"\";s:24:\"wizard_next_button_label\";s:0:\"\";s:13:\"wizard_toggle\";b:0;s:24:\"wizard_toggle_show_label\";s:0:\"\";s:24:\"wizard_toggle_hide_label\";s:0:\"\";s:16:\"wizard_page_type\";s:9:\"container\";s:21:\"wizard_page_title_tag\";s:2:\"h2\";s:7:\"preview\";i:0;s:13:\"preview_label\";s:0:\"\";s:13:\"preview_title\";s:0:\"\";s:15:\"preview_message\";s:0:\"\";s:18:\"preview_attributes\";a:0:{}s:25:\"preview_excluded_elements\";a:0:{}s:21:\"preview_exclude_empty\";b:1;s:30:\"preview_exclude_empty_checkbox\";b:0;s:5:\"draft\";s:4:\"none\";s:14:\"draft_multiple\";b:0;s:15:\"draft_auto_save\";b:0;s:19:\"draft_saved_message\";s:0:\"\";s:20:\"draft_loaded_message\";s:0:\"\";s:28:\"draft_pending_single_message\";s:0:\"\";s:30:\"draft_pending_multiple_message\";s:0:\"\";s:17:\"confirmation_type\";s:11:\"url_message\";s:16:\"confirmation_url\";s:7:\"<front>\";s:18:\"confirmation_title\";s:0:\"\";s:20:\"confirmation_message\";s:27:\"Your message has been sent.\";s:23:\"confirmation_attributes\";a:0:{}s:17:\"confirmation_back\";b:1;s:23:\"confirmation_back_label\";s:0:\"\";s:28:\"confirmation_back_attributes\";a:0:{}s:26:\"confirmation_exclude_query\";b:0;s:26:\"confirmation_exclude_token\";b:0;s:19:\"confirmation_update\";b:0;s:11:\"limit_total\";N;s:20:\"limit_total_interval\";N;s:19:\"limit_total_message\";s:0:\"\";s:18:\"limit_total_unique\";b:0;s:10:\"limit_user\";N;s:19:\"limit_user_interval\";N;s:18:\"limit_user_message\";s:0:\"\";s:17:\"limit_user_unique\";b:0;s:18:\"entity_limit_total\";N;s:27:\"entity_limit_total_interval\";N;s:17:\"entity_limit_user\";N;s:26:\"entity_limit_user_interval\";N;s:5:\"purge\";s:4:\"none\";s:10:\"purge_days\";N;s:16:\"results_disabled\";b:0;s:23:\"results_disabled_ignore\";b:0;s:17:\"results_customize\";b:0;s:10:\"token_view\";b:0;s:12:\"token_update\";b:0;s:12:\"token_delete\";b:0;s:15:\"serial_disabled\";b:0;}s:6:\"access\";a:11:{s:6:\"create\";a:3:{s:5:\"roles\";a:2:{i:0;s:9:\"anonymous\";i:1;s:13:\"authenticated\";}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:8:\"view_any\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:10:\"update_any\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:10:\"delete_any\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:9:\"purge_any\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:8:\"view_own\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:10:\"update_own\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:10:\"delete_own\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:10:\"administer\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:4:\"test\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}s:13:\"configuration\";a:3:{s:5:\"roles\";a:0:{}s:5:\"users\";a:0:{}s:11:\"permissions\";a:0:{}}}s:8:\"handlers\";a:2:{s:18:\"email_confirmation\";a:8:{s:2:\"id\";s:5:\"email\";s:10:\"handler_id\";s:18:\"email_confirmation\";s:5:\"label\";s:18:\"Email confirmation\";s:5:\"notes\";s:0:\"\";s:6:\"status\";b:1;s:10:\"conditions\";a:0:{}s:6:\"weight\";i:1;s:8:\"settings\";a:27:{s:6:\"states\";a:1:{i:0;s:9:\"completed\";}s:7:\"to_mail\";s:19:\"[current-user:mail]\";s:10:\"to_options\";a:0:{}s:8:\"bcc_mail\";s:0:\"\";s:11:\"bcc_options\";a:0:{}s:7:\"cc_mail\";s:0:\"\";s:10:\"cc_options\";a:0:{}s:9:\"from_mail\";s:8:\"_default\";s:12:\"from_options\";a:0:{}s:9:\"from_name\";s:8:\"_default\";s:8:\"reply_to\";s:0:\"\";s:11:\"return_path\";s:0:\"\";s:11:\"sender_mail\";s:0:\"\";s:11:\"sender_name\";s:0:\"\";s:7:\"subject\";s:39:\"[webform_submission:values:subject:raw]\";s:4:\"body\";s:41:\"[webform_submission:values:message:value]\";s:17:\"excluded_elements\";a:0:{}s:13:\"ignore_access\";b:0;s:13:\"exclude_empty\";b:1;s:22:\"exclude_empty_checkbox\";b:0;s:19:\"exclude_attachments\";b:0;s:4:\"html\";b:1;s:11:\"attachments\";b:0;s:4:\"twig\";b:0;s:10:\"theme_name\";s:0:\"\";s:10:\"parameters\";a:0:{}s:5:\"debug\";b:0;}}s:18:\"email_notification\";a:8:{s:2:\"id\";s:5:\"email\";s:10:\"handler_id\";s:18:\"email_notification\";s:5:\"label\";s:18:\"Email notification\";s:5:\"notes\";s:0:\"\";s:6:\"status\";b:1;s:10:\"conditions\";a:0:{}s:6:\"weight\";i:2;s:8:\"settings\";a:27:{s:6:\"states\";a:1:{i:0;s:9:\"completed\";}s:7:\"to_mail\";s:8:\"_default\";s:10:\"to_options\";a:0:{}s:8:\"bcc_mail\";s:0:\"\";s:11:\"bcc_options\";a:0:{}s:7:\"cc_mail\";s:0:\"\";s:10:\"cc_options\";a:0:{}s:9:\"from_mail\";s:37:\"[webform_submission:values:email:raw]\";s:12:\"from_options\";a:0:{}s:9:\"from_name\";s:36:\"[webform_submission:values:name:raw]\";s:8:\"reply_to\";s:0:\"\";s:11:\"return_path\";s:0:\"\";s:11:\"sender_mail\";s:0:\"\";s:11:\"sender_name\";s:0:\"\";s:7:\"subject\";s:39:\"[webform_submission:values:subject:raw]\";s:4:\"body\";s:41:\"[webform_submission:values:message:value]\";s:17:\"excluded_elemen